#include <xvinclude.h>

/*
 * This example displays a pseudocolor object and an image object, both working
 * off the information in the "image:ball" file.  
 * 
 * An event handler is installed which allows you to select various pixels 
 * from the image by pressing the button on the desired pixels;  after the 
 * desired pixels have been selected, the pseudocolor scrollbars of the
 * can be used to change the color of the selected pixels as desired.
 *
 * Alternatively, the pseudocolor palette can be used (as in example
 * 1.pseudo_display) to choose a range of pixels which can then be colored
 * with the red, green, and blue scrollbars.
 */

void  image_handler   PROTO((xvobject, kaddr, XEvent *, Boolean *));

void main(
  int argc,
  char **argv,
  char **envp)
{
        xvobject image, pseudo;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* create a psuedocolor object to work on "image:ball" information */
        pseudo = xvw_create_pseudo(NULL, "pseudo");
        xvw_set_attribute(pseudo, XVW_COLOR_COLORFILE, "image:ball");

	/* create an image object to display "image:ball" information */
	image = xvw_create_image(NULL, "image");
	xvw_set_attribute(image, XVW_IMAGE_IMAGEFILE, "image:ball");

	/* install event handler on image object for button press events */
	xvw_add_event(image, ButtonPressMask, image_handler, pseudo);

	/* display and run program */
        xvf_run_form();
}

/*
 * when the user does a button press in the image, this event handler
 * will get the pixel value at that location, and add it to the pseudocolor
 * list.  Since the pseudocolor widget makes all pixels in its list the
 * same color, this will have the effect of changing each pixel to the color
 * of the first pixel that was selected.
 */
void  image_handler(
    xvobject image,
    kaddr    client_data,
    XEvent   *event,
    Boolean  *dispatch)
{
	double indx;
	xvobject pseudo = (xvobject) client_data;


	xvw_get_attribute(image, XVW_IMAGE_VALUE, &indx);
	xvw_set_attribute(pseudo, XVW_PSEUDO_ADD, (int) indx);
}
