#include <xvinclude.h>

/*
 *  This example program creates a palette object.
 *  A palette object simply displays a rectangular area in which each pixel
 *  value from the image appears in the color that is displayed on the image.
 *  Pixel values are sorted in increasing order starting at zero. 
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	kobject  object;
	xvobject palette;
	char *filename = "image:ball";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* support cmd line specification of another input file */ 
	if (argc > 1)
	   filename = argv[1];

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* get the data object associated with the input image */
	object = kpds_open_input_object(filename);

	/*
         *  create the palette object, and associate it with the data object
         *  representing the input file
	 */
	palette = xvw_create_palette(NULL, "palette");
	xvw_set_attribute(palette, XVW_COLOR_COLOROBJ, object);

	/* display the palette's internal menuform automatically */
	xvw_activate_menu(palette);

	/* display and run */
	xvf_run_form();
}
