#include <xvinclude.h>

/*
 * This program creates a window with a single date annotation in it.
 * The date annotation displays the current time and date.  
 * 
 * The date object may be selected and moved by holding down the shift key and 
 * using the left mouse button; it may be resized by holding down the shift key 
 * and holding the left mouse button while the mouse is on one of the boxes 
 * around the bounds of the text.  
 *
 * The internal menuform for the date annotation is popped up explicitly in this
 * example, but it may also be brought up by holding down the meta key and using
 * the middle mouse button.
 */

void main(int  argc,
   char *argv[],
   char *envp[])
{
        xvobject date;
	xvobject manager;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/*
	 *  create a manager backplane
	 */
	manager = xvw_create_manager(NULL, "backplane");
	xvw_set_attributes(manager,
		 XVW_CHAR_WIDTH,  50.0,
	         XVW_CHAR_HEIGHT,  2.0,
		 XVW_MENUABLE,    TRUE,
	         XVW_SELECTABLE,  TRUE,
		 NULL);

	/*
	 *  create a date annotation object; set the string placement,
         *  the format for printing the date, and the update time.
	 */
        date = xvw_create_date(manager, "date");
        xvw_set_attributes(date,
		XVW_STRING_XPLACEMENT, 0.5,
		XVW_STRING_XPLACEMENT, 0.5,
		XVW_DATE_FORMAT,	 "%h %d, 19%y %H:%M:%S", 
		XVW_DATE_UPDATETIME,	 1,
		NULL);

	/*
	 *  activate the internal menuform for the date object so the
         *  user doesn't have to meta-click to bring it up.
	 */
	xvw_activate_menu(date);

	/* display & run the program */
        xvf_run_form();
}
