#include <xvinclude.h>

/*
 *
 * This example creates a window with a stringvalue annotation; the stringvalue 
 * visual object is used to display a floating point number in a particular 
 * format.  
 *
 * After the manager object parent is put into edit mode (hold down
 * shift key and click the left mouse button), the stringvalue object can be
 * interactively moved by "grabbing" it in the middle with the left mouse
 * button; grabbing it near an end will cause the stringvalue object to resize.
 *
 * In this example, the internal menuform for the stringvalue object 
 * is displayed automatically.
 */

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject parent;
        xvobject stringvalue;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

        /* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

        /*
         *  create a manager backplane. make it selectable so the user 
         *  can put it in edit mode & move the stringvalue object around.
         */
        parent = xvw_create_manager(NULL, "parent");
        xvw_set_attributes(parent,
                           XVW_WIDTH,      300,
                           XVW_HEIGHT,     300,
                           XVW_SELECTABLE, TRUE,
                           NULL);

        /*
         *  create the stringvalue object.  specify placement in 
         *  world coordinates, give justification, set the value to be 
         *  displayed, and make it menuable so user has access to its 
         *  internal menuform.
         */
        stringvalue = xvw_create_stringvalue(parent, "stringvalue");
        xvw_set_attributes(stringvalue,
		XVW_STRING_VALUE,	 10.2,
		XVW_STRING_XPLACEMENT,	  0.5,
		XVW_STRING_YPLACEMENT,	  0.5,
		XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_CENTER,
		NULL);

        /*
         *  activate the internal menuform so user doesn't
         *  have to bring it up.
         */
        xvw_activate_menu(stringvalue);

        /* display & run the program */
        xvf_run_form();
}
