#include <xvinclude.h>

/*
 *
 * This example creates a window with a single rectangle annotation in it.
 *
 * After the manager object parent is put into edit mode (hold down
 * shift key and click the left mouse button), the rectangle can be
 * interactively moved by "grabbing" it in the middle with the left mouse
 * button; grabbing it near an end will cause the rectangle to resize.
 *
 * In this example, the internal menuform for the rectangle is displayed
 * automatically.
 */

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject parent;
        xvobject rectangle;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

        /* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

        /*
         *  create a manager backplane. make it selectable so
         *  the user can put it in edit mode & move the rectangle around.
         */
        parent = xvw_create_manager(NULL, "parent");
        xvw_set_attributes(parent,
                           XVW_WIDTH,      500,
                           XVW_HEIGHT,     500,
                           XVW_SELECTABLE, TRUE,
                           NULL);
        /*
         *  create the rectangle object.  specify dimensions in world 
         *  coordinates, make it menuable so user has access to its 
         *  internal menuform.
         */
        rectangle = xvw_create_rectangle(parent, "rectangle");
        xvw_set_attributes(rectangle,
		           XVW_RECTANGLE_XCORNER,   0.5,
		           XVW_RECTANGLE_YCORNER,   0.5,
		           XVW_RECTANGLE_XDIAGONAL, 0.15,
		           XVW_RECTANGLE_YDIAGONAL, 0.15,
                           XVW_MENUABLE, TRUE,
		           NULL);
        /*
         *  activate the internal menuform so user doesn't
         *  have to bring it up.
         */
        xvw_activate_menu(rectangle);

        /* display & run the program */
        xvf_run_form();
}
