#include <xvinclude.h>

/*
 * This program demonstrates the use of the marker visual object;
 * it creates several markers using different foreground colors.
 *
 * The marker object may be selected and moved by holding down the shift key and
 * using the left mouse button; it may be resized by holding down the shift key
 * and holding the left mouse button while the mouse is on one of the boxes 
 * around the bounds of the text.
 *
 * The internal menuform for the marker annotation may be brought up by 
 * holding down the meta key and clicking the middle mouse button.
 */

void main(int  argc,
   char *argv[],
   char *envp[])
{
	int    i;
        xvobject marker;
        xvobject parent;
	static char *list[] = {"yellow", "orange", "red", "violet", 
			       "purple", "blue", "green", "yellowgreen"}; 

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets library */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* 
	 * create a manager object to be the parent of all the markers 
	 * make manager selectable so user can put it in edit mode &
         * move markers around.
         */
	parent = xvw_create_manager(NULL, "parent");
	xvw_set_attributes(parent, 
			   XVW_WIDTH,      512, 
			   XVW_HEIGHT,     512, 
			   XVW_SELECTABLE, TRUE, 
			   XVW_RESIZABLE, TRUE, 
			   NULL);
	
	/* 
	 * create one marker for each color in the list; set its 
         * placement and its color; make it menuable so the user can
         * bring up its internal menuform.
	 */
	for (i = 0; i < knumber(list); i++)
	{
            marker = xvw_create_marker(parent, "marker");
            xvw_set_attributes(marker,
                               XVW_MARKER_XPLACEMENT, (i+1) * 0.1,
                               XVW_MARKER_YPLACEMENT, (i+1) * 0.1,
                               XVW_FOREGROUND_COLOR, list[i],
			       XVW_MENUABLE,   TRUE, 
                               NULL);
	}

	/* display & run the program */
        xvf_run_form();
}

