 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for khelp
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "khelp.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Display online help (or ascii text files)
|
|       Purpose: main program for khelp
|
|         Input:
|		char *clui_info->i_file; {input file (or dir)}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		int clui_info->x_int; {x location of GUI}
|		int clui_info->x_flag; {TRUE if -x specified}
|
|		int clui_info->width_int; {The window width}
|		int clui_info->width_flag; {TRUE if -width specified}
|
|		int clui_info->y_int; {y location of GUI}
|		int clui_info->y_flag; {TRUE if -y specified}
|
|		int clui_info->height_int; {The window height}
|		int clui_info->height_flag; {TRUE if -height specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	Display *display;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DESIGN");
	kexit_handler(khelp_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DESIGN", "khelp",
		khelp_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	khelp_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

/* -main_before_lib_call */
/* -main_before_lib_call_end */

/* -main_library_call */
	display = xvw_initialize(XVW_MENUS_XVFORMS);
        if (display == NULL)
        {
             kfprintf(kstderr, "Could not open connection to server");
             kexit(KEXIT_FAILURE);
        }

        xvu_online_help_wait(clui_info->i_file, "khelp");
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: khelp_usage_additions
| 
|       Purpose: Prints usage additions in khelp_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname khelp
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void khelp_usage_additions(void)
{
	kfprintf(kstderr, "\tDisplay online help (or ascii text files)\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: khelp_free_args
| 
|       Purpose: Frees CLUI struct allocated in khelp_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname khelp
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
khelp_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
