/*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>         Initialization for guise
   >>>>
   >>>>  Private:
   >>>>         guise_initialize()
   >>>>         put_gui_in_edit_mode()
   >>>>
   >>>>   Static:
   >>>>         init_w_program_object()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "guise.h"

static char *init_w_program_object PROTO((void));

/*-----------------------------------------------------------
|
|  Routine Name: guise_initialize
|
|       Purpose: Starts up guise correctly, with input file,
|                or with tb/object/uis.  Updates GUI accordingly. 
|
|         Input: None
|        Output: None
|    Written By: Danielle Argiro
|          Date: Sept 21, 1993
| Modifications: 
|
------------------------------------------------------------*/

void guise_initialize(void)
{
	char           *uis_filename = NULL;
	options_create *create_info;

	create_info = gui_info->options->create;

	/*
	 *  general & sundry initializations of global variables
	 */
	output_filename   = ktempnam(NULL, "guise");
        display_form      = NULL;
	display_toolbox   = NULL;
	display_program   = NULL;
        editor_up         = FALSE;
        save_control_dest = create_info->control_dest_val;

	/*
	 *  set global force flag & on GUI
	 */
	force_output = clui_info->force_flag;
	xvf_set_attribute(create_info->force_struct, XVF_LOGIC_VAL, 
			  force_output);
	create_info->force = force_output;

        /*
         * if they provided an initial UIS file, update selection on form to
         * reflect the initial UIS filename and map the demo form
         */
        if ((clui_info->i_flag) && (clui_info->i_file != NULL))
        {
            xvf_set_attribute(create_info->i_struct,
                              XVF_FILE_NAME, clui_info->i_file);
	    kfree(create_info->i);
	    create_info->i = kstrdup(clui_info->i_file);
            display_form = xvf_create_form(clui_info->i_file, NONE, run_display,
                                           gui_info, -1, -1, XVF_FULL_EDIT);
            kcopyfile(clui_info->i_file, output_filename);

	    put_gui_in_edit_mode();

	    adjust_gui_from_infile(clui_info->i_file, create_info);

	    if ((display_form != NULL) && (display_form->master != NULL))
	        xvf_set_attribute(create_info->subform_button_struct, 
		                  XVF_TITLE, "Create Master");


        }

	/*
	 *   if they provided a toolbox, oname and uis type, input 
         *   UIS file for that object
	 */
	else if ((clui_info->tb_string != NULL) && 
                 (clui_info->oname_string != NULL))
	{
	    if ((uis_filename = init_w_program_object()) == NULL)
	        display_empty_form(clui_info->o_file);
	    else adjust_gui_from_infile(uis_filename, create_info);
	}

	/*
	 *  default: display an empty form to begin prototyping procedure
	 */
        else
        {
            display_empty_form(output_filename);
        }

        /*
         *  need to detect change on the output file
         */

        if ((clui_info->o_flag) && clui_info->o_file != NULL)
        {
            xvf_set_attribute(create_info->o_struct, XVF_FILE_NAME, 
			      clui_info->o_file);
	    kfree(create_info->o);
	    create_info->o = kstrdup(clui_info->o_file);
	    set_uis_directory(clui_info->o_file);
        }
        else if ((clui_info->i_flag) && (clui_info->i_file != NULL))
        {
            xvf_set_attribute(create_info->o_struct, XVF_FILE_NAME, 
			      clui_info->i_file);
	    kfree(create_info->o);
            create_info->o = kstrdup(clui_info->i_file);
	    set_uis_directory(clui_info->i_file);
        }
	else if (uis_filename != NULL)
	{
            xvf_set_attribute(create_info->o_struct, XVF_FILE_NAME, 
			      uis_filename);
	    kfree(create_info->o);
            create_info->o = kstrdup(uis_filename);
	    set_uis_directory(uis_filename);
	}
        else 
        {
            xvf_set_attribute(create_info->o_struct, XVF_FILE_NAME, 
			      "new.form");
	    kfree(create_info->o);
            create_info->o = kstrdup("new.form");
        }

	if (display_form != NULL)
	{
            install_gui_attribute_callbacks();

	    if (display_form->master != NULL)
	    {
		xvf_set_attribute(create_info->subform_button_struct, 
			          XVF_TITLE, "New Subform");
		xvf_set_attribute(create_info->control_dest_struct, 
			          XVF_TOGGLE_NUM, 3);
		create_info->control_dest_val = KMASTER;
		
	    }
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: init_w_program_object
|
|       Purpose: Attempts to starts up guise with tb/object/uis given
|                by user.
|
|         Input: None
|        Output: None
|       Returns: Pointer to path of UIS file on success, NULL on failure
|    Written By: Danielle Argiro
|          Date: Sept 21, 1993
| Modifications: 
|
------------------------------------------------------------*/

static char *init_w_program_object(void)
{
	char           *pane_filename = NULL;
	char           *uis_filename = NULL;
 	char            uis_path[KLENGTH];
 	char            temp[KLENGTH];
	options_create *create_info;
	kobject         file_object;

	create_info = gui_info->options->create;

	display_toolbox = kcms_open_toolbox(clui_info->tb_string);
	if (display_toolbox == NULL)
        {
            kerror(NULL, "init_w_program_object", 
		  "Cannot open toolbox object '%s'\n", clui_info->tb_string);
	    return(NULL);
        }
	display_program = kcms_open_cmobj(display_toolbox, 
				          clui_info->oname_string);
	if (display_program == NULL)
	{
	    kerror(NULL, "init_w_program_object", 
		   "Cannot open program object '%s'\n",clui_info->oname_string);
	    return(NULL);
	}
	
	if (!kcms_get_attribute(display_program, KCMS_CMOBJ_UIS_PANE,
				    &file_object)
		|| file_object == NULL
		|| !kcms_get_attribute(file_object, KCMS_PATH, &pane_filename))
	{
	    kerror(NULL, "guise_initialize",
		   "No *.pane file associated with program object %s.",
		   clui_info->oname_string);
	    return(NULL);
	}
	(void) kdirname(pane_filename, uis_path);
	ksprintf(temp, "%s/%s", uis_path, clui_info->uis_string);

	if (kaccess(temp, R_OK) == -1)
	{
	    kerror(NULL, "guise_initialize",
	           "Input UIS file %s not found", temp);
	    kfree(create_info->o);
	    create_info->o = kstrdup(temp);
	    xvf_set_attribute(create_info->o_struct, XVF_FILE_NAME,
                              uis_filename);
	    return(NULL);
	}
	uis_filename = kstrdup(temp);

	/*
	 * successful input of *.pane, or *.form
	 */
	if (uis_filename != NULL)
	{
	    kfree(create_info->i);
	    create_info->i = kstrdup(uis_filename);
	    xvf_set_attribute(create_info->i_struct, XVF_FILE_NAME, 
			      uis_filename);
	    kfree(create_info->i);
	    create_info->i = kstrdup(uis_filename);
	    display_form = xvf_create_form(create_info->i, NONE, run_display, 
					   gui_info, -1, -1, XVF_FULL_EDIT);
	    put_gui_in_edit_mode();
            kcopyfile(create_info->i, output_filename);
	    if (display_form->master != NULL)
		xvf_set_attribute(create_info->subform_button_struct, 
			          XVF_TITLE, "New Subform");
	}

	return(uis_filename);
}


/*-----------------------------------------------------------
|
|  Routine Name: put_gui_in_edit_mode
|
|       Purpose: When we display the GUI from a pre-existing UIS file,
|                need to bring it up in "selected" mode.  First, we
|                need to figure out which control (master, guidepane,
|                or pane) is displayed, and then get the first selection
|                off the control.
|
|         Input: None
|        Output: None
|       Returns: Pointer to path of UIS file on success, NULL on failure
|    Written By: Danielle Argiro
|          Date: Sept 21, 1993
| Modifications:
|
------------------------------------------------------------*/

void put_gui_in_edit_mode(void)
{

	ksubform       *subform;
	kguide         *guide;
	kcontrol       *pane, *display_control = NULL;

	/* don't do anything if there is no displayed form */
	if (display_form == NULL) 
	    return;

	/* are we displaying a master form? */
        display_control = find_displayed_control(NULL, NULL, KMASTER,
                                                    &subform, &guide, &pane);
	/* are we displaying a subform? */
        if (display_control == NULL)
            display_control = find_displayed_control(NULL, NULL, KGUIDEPANE,
                                                    &subform, &guide, &pane);
	/* are we displaying a pane? */
        if (display_control == NULL)
            display_control = find_displayed_control(NULL, NULL, KPANE,
                                                    &subform, &guide, &pane);
        if (display_control != NULL)
        {
	    xvw_set_attribute(display_control->back, XVW_EDIT_MODE_ON, TRUE);
        }
}


/*-----------------------------------------------------------
|
|  Routine Name: set_uis_directory
|
|       Purpose: Uses the XVF_UIS_LOCATION attribute to set where
|                UIS files are to be written.  Although the path
|                for a *.pane or *.form is specified by the output file
|                path, additional *.subform or *.pane files written out using 
|                the internal menuforms of subforms or panes will be written
|                to the current working directory, unless the XVF_UIS_LOCATION
|                attribute is set properly.
|
|         Input: uis_filename - name associated with output file
|        Output: None
|       Returns: None 
|    Written By: Danielle Argiro
|          Date: June 15, 1994
| Modifications:
|
------------------------------------------------------------*/

void set_uis_directory(
    char *uis_filename)
{
	char dirname[KLENGTH];
	char path[KLENGTH];

	(void) kdirname(uis_filename, dirname);
	if (!(ktbpath(dirname, path)))
	    (void) kexpandpath(dirname, NULL, path);

	if (display_form != NULL)
	{
	/*
	    xvf_set_attribute(display_form->back_kformstruct,
		              XVF_UIS_LOCATION, path);
	*/
	    ksprintf(dirname, "%s/", path);
	    display_form->uis_location = kstrdup(dirname);
	}
}

