/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>         Utility routines for Composer
   >>>> 
   >>>>  Private: 
   >>>>         log_command()
   >>>>         reload_object()
   >>>> 
   >>>>   Static:
   >>>>
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "composer.h"

static kstring  *keylist_to_array PROTO((klist *, int *));


/*-----------------------------------------------------------
| Routine Name:	log_command - run a command and log the output
| 
| Purpose:	This function takes a string which represents a command
|		which could be xvw_system()'d, for example.
|		kpopen() is used to run the command and grab the output.
|
|		The log_append() macro is used to update the log.
| 
| Input:	command	- the command string to invoke
| 
| Output:	None
| Written By:	Neil Bowers
| Date:		Jun 23, 1993
------------------------------------------------------------*/
int
log_command(
   kstring  command,
   int      lib_command)
{
   kstring  routine = "log_command()";
   char     srcpath[KLENGTH];
   char     buffer[KLENGTH + 1];
   char     message[KLENGTH];
   kstring  dir;


   ksprintf(srcpath, "%s/src", cmobj_opath);
   dir = lib_command ? &strLibSrc[0] : &srcpath[0];

   if (kchdir(dir) == -1)
   {
      kerror(NULL, routine, "Unable to move into the src directory: %s", dir);
      return FALSE;
   }

   if (lib_command)
      ksprintf(message, "%s\n[library: %s]", command, strLibrary);
   else
      kstrcpy(message, command);

   xvw_set_attributes(xvoNotifier,
		      XVW_NOTIFYWINDOW_LABEL, "See \"Commands\" window "
		      "for output of command.",
		      XVW_NOTIFYWINDOW_TITLE, "Running command...",
		      XVW_NOTIFYWINDOW_MESSAGE, message,
		      XVW_NOTIFYWINDOW_VISIBLE, TRUE,
		      NULL);

   if (lib_command)
      log_append("-----------------------[ library ]-----------\n");
   else
   {
      ksprintf(buffer, "-----------------------[ %s ]-----------\n",
               kcms_attr_int2string(KCMS_CMOBJ_TYPE, obj_type));
      log_append(buffer);
   }
   log_append(command);
   log_append("---------------------------------------------\n");

   /*-- the console widget grabs standard I/O channels ----------------*/
   xvw_system(command);

   if (strCwd != NULL)
      kchdir(strCwd);
   xvw_set_attributes(xvoNotifier,
		      XVW_NOTIFYWINDOW_VISIBLE, FALSE,
		      XVW_NOTIFYWINDOW_TITLE, "Working . . .",
		      XVW_NOTIFYWINDOW_LABEL, "Please Wait",
		      NULL);
   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	reload_object - reload object, update state and tables
| 
| Purpose:	This routine is called if the object has changed.  It is
|		assumed that the object had already been closed.
| 
| Written By:	Neil Bowers
| Date:		Jun 23, 1993
------------------------------------------------------------*/
int
reload_object(void)
{
   kstring  routine   = "reload_object()";
   int      file_type = cur_file_info->file_type;
   kstring  opath;


   if (cmsObject != NULL)
      kcms_close(cmsObject);
   if (cmsToolbox != NULL)
      kcms_close(cmsToolbox);

   /*-- re-open the toolbox object ------------------------------------*/
   if ((cmsToolbox = kcms_open_toolbox(clui_info->tb_string)) == NULL)
   {
      kerror(NULL, routine, "Couldn't re-open toolbox.");
      return FALSE;
   }

   /*-- re-open the software object -----------------------------------*/
   cmsObject = kcms_open_cmobj(cmsToolbox, clui_info->oname_string);
   if (cmsObject == NULL)
   {
      kcms_close(cmsToolbox);
      kerror(NULL, routine, "Couldn't re-open object.");
      return FALSE;
   }

   kcms_get_attribute(cmsObject, KCMS_CMOBJ_OPATH, &opath);
   if (cmobj_opath != NULL)
      kfree(cmobj_opath);
   cmobj_opath = kstrdup(opath);

   /*-- re-initialize the file info table -----------------------------*/
   clear_file_table();
   cur_fileobj = NULL;

   /*-- force reload of currently installed list context --------------*/
   /*-- do something here --*/
   cur_file_info = get_file_info(file_type);

   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	update_categories() - Update category and subcategory lists
|
| Purpose:	This routine is called to gather the category and subcategory
|		lists.  This is done by querying kcms for existing
|		category/subcategory information.
|
| Written By:	Becky Bishop & Neil Bowers
| Date:		Jun  3, 1993
------------------------------------------------------------*/
void
update_categories(void)
{
   char  **cat_list;
   int    *otypes;
   char  **subcat_list;
   char  **programs;
   char  **panefile;
   char  **tmp_cat;
   char  **tmp_subcat;
   char  **icons;
   int    *incantata;
   char  **short_descriptions;
   char  **workspaces;
   int     num_programs;
   int     i;
   int     j;
   int     tmp_cnt;
   int     num_cat;
   int     num_subcat;


   cat_list = NULL;
   subcat_list = NULL;

   kcms_get_attribute(cmsToolbox, KCMS_TB_CATEGORYINFO,
		      &programs, &otypes, &icons, &tmp_cat, &tmp_subcat,
		      &panefile, &workspaces, &incantata, &short_descriptions,
		      &num_programs);

   if (num_programs == 0)
      return;

   num_cat = num_programs;
   num_subcat = num_programs;

   cat_list = karray_add(NULL, tmp_cat[0], 0);
   tmp_cnt = 0;
   for (i = 0; i < num_cat; i++)
   {
      if (tmp_cat[i] == NULL || !kstrcmp(tmp_cat[i], ""))
	 continue;
      j = 0;
      while (j < tmp_cnt && kstrcmp(cat_list[j], tmp_cat[i]))
	 j++;
      if (j == tmp_cnt)
      {
	 cat_list = karray_add(cat_list, tmp_cat[i], tmp_cnt);
	 tmp_cnt++;
      }
   }
   num_cat = tmp_cnt;
   xvf_set_attributes(paneAttributes->category_struct,
		      XVF_LIST_SIZE, num_cat,
		      XVF_LIST_CONTENTS, cat_list,
		      NULL);

   subcat_list = karray_add(NULL, tmp_subcat[0], 0);
   tmp_cnt = 0;
   for (i = 0; i < num_subcat; i++)
   {
      if (tmp_subcat[i] == NULL || !kstrcmp(tmp_subcat[i], ""))
	 continue;
      j = 0;
      while (j < tmp_cnt && kstrcmp(subcat_list[j], tmp_subcat[i]))
	 j++;
      if (j == tmp_cnt)
      {
	 subcat_list = karray_add(subcat_list,
				  tmp_subcat[i], tmp_cnt);
	 tmp_cnt++;
      }
   }
   num_subcat = tmp_cnt;
   xvf_set_attributes(paneAttributes->subcategory_struct,
		      XVF_LIST_SIZE, num_subcat,
		      XVF_LIST_CONTENTS, subcat_list,
		      NULL);
}

/*-----------------------------------------------------------
| Routine Name: update_file_info - update selected file info in interface
|
| Purpose:	This routine is called whenever a new file is selected.
|		It updates all parts of the user interface which change
|		according to the selected file, such as text selections
|		which display the name and path of the selected file.
|
| Written By:	Becky Bishop & Neil Bowers
| Date:		Jun  3, 1993
------------------------------------------------------------*/
void
update_file_info(
   kobject fobj)
{
   kstring  filename;
   char     basename[KLENGTH];


   if (!kcms_get_attribute(fobj, KCMS_FOBJ_FULLNAME, &filename))
      return;

   kbasename(filename, basename);

   xvf_set_attribute(gui_info->renamefile->rename_pane->filename_struct,
		     XVF_TITLE, basename);

   /*-- Utilities subform, Print pane ---------------------------*/
   xvf_set_attribute(gui_info->printfile->printpane->basename_struct,
		     XVF_TITLE, basename);
   xvf_set_attribute(gui_info->printfile->printpane->fullpath_struct,
		     XVF_TITLE, filename);
}

/*-----------------------------------------------------------
| Routine Name:	our_announce_handler - handler for announces
|
| Purpose:	This routine catches any strings displayed using kannounce()
|		and displays them in the notify-window popup.
|		This means the user will see messages from the code
|		generation library and similar.
|
| Input:	message	- the message to display
| Returns:	TRUE if successful, FALSE otherwise.
| Written By:	Neil Bowers
| Date:		17-mar-94
------------------------------------------------------------*/
/* ARGSUSED */
int
our_announce_handler(
   kstring  toolbox,
   kstring  object,
   kstring  library,
   kstring  routine,
   kstring  message)
{
   char  buffer[KLENGTH];

   if (kstring_cat(message, "\n", buffer) != NULL)
      log_append(buffer);

   return xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_MESSAGE, message);
}

/*-----------------------------------------------------------
| Routine Name: update_keywords - update UI to match keywords in object
|
| Purpose:	This routine should be called whenever the object's keywords
|		have been modified.  Eventually this will be a callback on
|		the keywords attribute of the software object.
|
| Written By:	Neil Bowers
| Date:		3-oct-94
------------------------------------------------------------*/
void
update_keywords(
   kobject  object,
   kstring  selected)
{
   klist         *list;
   kstring       *keywords;
   int            nkeys;
   kform_struct  *list_struct;
   int            i;


   if (!kcms_get_attribute(object, KCMS_CMOBJ_KEYWORDS, &list))
      return;
   list_struct = gui_info->obj_attributes->obj_keywords->keylist_struct;

   if (list == NULL)
      xvf_set_attributes(list_struct,
			 XVF_LIST_SIZE,     0,
			 XVF_LIST_CONTENTS, NULL,
			 NULL);
   else if ((keywords = keylist_to_array(list, &nkeys)) != NULL)
   {
      keywords = karray_sort(keywords, nkeys, TRUE);
      xvf_set_attributes(list_struct,
			 XVF_LIST_SIZE,     nkeys,
			 XVF_LIST_CONTENTS, keywords,
			 NULL);

      /*-- was a default selection specified? -------------------------*/
      if (selected != NULL)
      {
	 i=0;
	 while (i < nkeys && kstrcmp(selected, keywords[i]) != 0)
	    i++;
	 if (i < nkeys)
	    xvf_set_attribute(
	       gui_info->obj_attributes->obj_keywords->keylist_struct,
			      XVF_LIST_INDEX, i);
      }
   }
}

/*-----------------------------------------------------------
| Routine Name: update_file_info - update selected file info in interface
|
| Purpose:	This routine is called whenever a new file is selected.
|		It updates all parts of the user interface which change
|		according to the selected file, such as text selections
|		which display the name and path of the selected file.
|
| Written By:	Becky Bishop & Neil Bowers
| Date:		Jun  3, 1993
------------------------------------------------------------*/
static kstring *
keylist_to_array(
   klist  *keylist,
   int    *count)
{
   int       i;
   kstring  *array;
   klist    *list;
   kstring   keyword;


   *count = klist_size(keylist);
   array = (kstring *)kmalloc(*count * sizeof(kstring));
   if (array == NULL)
      return NULL;

   for (i=0, list = keylist; list != NULL; list = klist_next(list))
   {
      keyword  = (kstring)klist_clientdata(list);
      array[i] = kstrdup(keyword);
      i++;
   }

   return array;
}

/*-----------------------------------------------------------
| Routine Name: composer_grep_object - grep for text in object's files
|
| Purpose:	This routine builds up a list of all the files in a
|		software object and runs grep on them.
|
| Written By:	Neil Bowers
| Date:		13-mar-1995
------------------------------------------------------------*/
void
composer_grep_object(
   kobject  object,
   kstring  search_string)
{
   klist   *files;
   kobject  fobj;
   kstring  opath;
   kstring  path;
   int      ftype;
   int      fsubtype;
   kstring  cmdbuffer = NULL;
   kstring  tmp;
   char     fullpath[KLENGTH];
   char     fullpathsl[KLENGTH];
   char     fpath[KLENGTH];
   char     tbuf[KLENGTH];


   if (!kcms_get_attributes(object,
			    KCMS_PATH,            &opath,
			    KCMS_CMOBJ_ALL_FILES, &files,
			    KCMS_END)
      || kfullpath(opath, NULL, fullpath) == NULL)
      return;

   kstring_cat(fullpath, "/", fullpathsl);
   kfprintf(kstderr, "---------------------------------------------\n");
   kfprintf(kstderr, " Grep: searching for \"%s\"\n", search_string);
   kfprintf(kstderr, "---------------------------------------------\n");
   ksprintf(tbuf, "cd %s; grep %s", fullpath, search_string);
   cmdbuffer = kstrdup(tbuf);
   for (; files != NULL; files = klist_next(files))
   {
      fobj = (kobject)klist_clientdata(files);
      if (fobj == NULL)
	 continue;

      if (!kcms_get_attributes(fobj,
			       KCMS_PATH,         &path,
			       KCMS_FOBJ_TYPE,    &ftype,
			       KCMS_FOBJ_SUBTYPE, &fsubtype,
			       KCMS_END)
	  || ftype == KCMS_FOBJ_TYPE_DBM)
	 continue;

      if (kfullpath(path, NULL, fpath) == NULL)
	 continue;

      if (kstring_replace(fpath, fullpathsl, NULL, tbuf) == NULL)
	 continue;

      tmp = kstring_3cat(cmdbuffer, " ", tbuf, NULL);
      kfree(cmdbuffer);
      cmdbuffer = tmp;
   }
   xvw_system(cmdbuffer);
   kfprintf(kstderr, "-------- end of grep ------------------------\n\n");
   kfree(cmdbuffer);
}
