 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Form Info Structure for composer Form
   >>>> 
   >>>>    Written By: conductor -name composer -l 3
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _form_info_h_
#define _form_info_h_

#include <xvinclude.h>

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

/*
 * Pane Info Struct for 'add_pane' Pane
 */
typedef struct _addfile_add_pane{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *add_file;         /* string for 'add_file'*/
kform_struct *add_file_struct;  /* pass to xvf_set_attributes() */
int          add_file_selected; /* TRUE on <cr> for 'add_file' */

int          add;          /* TRUE when user clicks on 'add'*/
kform_struct *add_struct;  /* pass to xvf_set_attributes() */

} addfile_add_pane;

/*
 * Subform Info Struct for 'addfile' Subform
 */
typedef struct _composer_addfile {

addfile_add_pane  *add_pane;          /* ptr to Pane Info struct for pane 'add_pane' */
int              add_pane_selected;          /* TRUE if input was from pane 'add_pane' */
kform_struct     *add_pane_struct;          /* pass to xvf_set_attributes() */

}  composer_addfile;

/*
 * Pane Info Struct for 'rename_pane' Pane
 */
typedef struct _renamefile_rename_pane{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *rename_to;         /* string for 'rename_to'*/
kform_struct *rename_to_struct;  /* pass to xvf_set_attributes() */
int          rename_to_selected; /* TRUE on <cr> for 'rename_to' */

int          rename;          /* TRUE when user clicks on 'rename'*/
kform_struct *rename_struct;  /* pass to xvf_set_attributes() */

kform_struct *fileblank_struct; /* pass to xvf_set_attributes() */

kform_struct *filename_struct; /* pass to xvf_set_attributes() */

} renamefile_rename_pane;

/*
 * Subform Info Struct for 'renamefile' Subform
 */
typedef struct _composer_renamefile {

renamefile_rename_pane  *rename_pane;          /* ptr to Pane Info struct for pane 'rename_pane' */
int                    rename_pane_selected;          /* TRUE if input was from pane 'rename_pane' */
kform_struct           *rename_pane_struct;          /* pass to xvf_set_attributes() */

}  composer_renamefile;

/*
 * Pane Info Struct for 'printpane' Pane
 */
typedef struct _printfile_printpane{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *printer;         /* string for 'printer'*/
kform_struct *printer_struct;  /* pass to xvf_set_attributes() */

char         *printcmd;         /* string for 'printcmd'*/
kform_struct *printcmd_struct;  /* pass to xvf_set_attributes() */
int          printcmd_optsel;   /* TRUE if optional box of 'printcmd' is ON */

int          print;          /* TRUE when user clicks on 'print'*/
kform_struct *print_struct;  /* pass to xvf_set_attributes() */

kform_struct *baselabel_struct; /* pass to xvf_set_attributes() */

kform_struct *pathlabel_struct; /* pass to xvf_set_attributes() */

kform_struct *basename_struct; /* pass to xvf_set_attributes() */

kform_struct *fullpath_struct; /* pass to xvf_set_attributes() */

} printfile_printpane;

/*
 * Subform Info Struct for 'printfile' Subform
 */
typedef struct _composer_printfile {

printfile_printpane  *printpane;          /* ptr to Pane Info struct for pane 'printpane' */
int                 printpane_selected;          /* TRUE if input was from pane 'printpane' */
kform_struct        *printpane_struct;          /* pass to xvf_set_attributes() */

}  composer_printfile;

/*
 * Pane Info Struct for 'obj_attrs' Pane
 */
typedef struct _obj_attributes_obj_attrs{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

char         *description;         /* string for 'description'*/
kform_struct *description_struct;  /* pass to xvf_set_attributes() */

char         *category;         /* string for 'category'*/
kform_struct *category_struct;  /* pass to xvf_set_attributes() */

char         *subcategory;         /* string for 'subcategory'*/
kform_struct *subcategory_struct;  /* pass to xvf_set_attributes() */

char         *icon_name;         /* string for 'icon_name'*/
kform_struct *icon_name_struct;  /* pass to xvf_set_attributes() */

char         *name;         /* string for 'name'*/
kform_struct *name_struct;  /* pass to xvf_set_attributes() */

char         *email;         /* string for 'email'*/
kform_struct *email_struct;  /* pass to xvf_set_attributes() */

int          install_in_cantata_val;      /* value of toggle 'install_in_cantata'*/
int          install_in_cantata_num;      /* number of toggle member selected (1-N) */
kform_struct *install_in_cantata_struct;  /* pass to xvf_set_attributes() */

int          apply;          /* TRUE when user clicks on 'apply'*/
kform_struct *apply_struct;  /* pass to xvf_set_attributes() */

kform_struct *tblabel_struct; /* pass to xvf_set_attributes() */

kform_struct *onamelabel_struct; /* pass to xvf_set_attributes() */

kform_struct *tb_struct; /* pass to xvf_set_attributes() */

kform_struct *oname_struct; /* pass to xvf_set_attributes() */

kform_struct *authlabel_struct; /* pass to xvf_set_attributes() */

kform_struct *otypelabel_struct; /* pass to xvf_set_attributes() */

kform_struct *otype_struct; /* pass to xvf_set_attributes() */

kform_struct *descblank_struct; /* pass to xvf_set_attributes() */

} obj_attributes_obj_attrs;

/*
 * Pane Info Struct for 'obj_keywords' Pane
 */
typedef struct _obj_attributes_obj_keywords{

int          keylist;          /* int value of 'keylist'*/
char         *keylist_label;   /* label representing int value of 'keylist'*/
kform_struct *keylist_struct;  /* pass to xvf_set_attributes() */
int          keylist_selected; /* TRUE on <cr> for 'keylist' */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          delete;          /* TRUE when user clicks on 'delete'*/
kform_struct *delete_struct;  /* pass to xvf_set_attributes() */

char         *addkey;         /* string for 'addkey'*/
kform_struct *addkey_struct;  /* pass to xvf_set_attributes() */
int          addkey_selected; /* TRUE on <cr> for 'addkey' */

char         *chkey;         /* string for 'chkey'*/
kform_struct *chkey_struct;  /* pass to xvf_set_attributes() */
int          chkey_selected; /* TRUE on <cr> for 'chkey' */

} obj_attributes_obj_keywords;

/*
 * Pane Info Struct for 'paneattrs' Pane
 */
typedef struct _obj_attributes_paneattrs{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

char         *tbname;         /* string for 'tbname'*/
kform_struct *tbname_struct;  /* pass to xvf_set_attributes() */

char         *oname;         /* string for 'oname'*/
kform_struct *oname_struct;  /* pass to xvf_set_attributes() */

char         *args;         /* string for 'args'*/
kform_struct *args_struct;  /* pass to xvf_set_attributes() */

int          genexec_val;      /* value of toggle 'genexec'*/
int          genexec_num;      /* number of toggle member selected (1-N) */
kform_struct *genexec_struct;  /* pass to xvf_set_attributes() */

int          apply;          /* TRUE when user clicks on 'apply'*/
kform_struct *apply_struct;  /* pass to xvf_set_attributes() */

kform_struct *assoclabel_struct; /* pass to xvf_set_attributes() */

} obj_attributes_paneattrs;

/*
 * Subform Info Struct for 'obj_attributes' Subform
 */
typedef struct _composer_obj_attributes {

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

obj_attributes_obj_attrs  *obj_attrs;          /* ptr to Pane Info struct for pane 'obj_attrs' */
int                      obj_attrs_selected;          /* TRUE if input was from pane 'obj_attrs' */
kform_struct             *obj_attrs_struct;          /* pass to xvf_set_attributes() */

obj_attributes_obj_keywords  *obj_keywords;          /* ptr to Pane Info struct for pane 'obj_keywords' */
int                         obj_keywords_selected;          /* TRUE if input was from pane 'obj_keywords' */
kform_struct                *obj_keywords_struct;          /* pass to xvf_set_attributes() */

obj_attributes_paneattrs  *paneattrs;          /* ptr to Pane Info struct for pane 'paneattrs' */
int                      paneattrs_selected;          /* TRUE if input was from pane 'paneattrs' */
kform_struct             *paneattrs_struct;          /* pass to xvf_set_attributes() */

}  composer_obj_attributes;

/*
 * Pane Info Struct for 'logging' Pane
 */
typedef struct _logform_logging{

int          clear;          /* TRUE when user clicks on 'clear'*/
kform_struct *clear_struct;  /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          gen_code;          /* TRUE when user clicks on 'gen_code'*/
kform_struct *gen_code_struct;  /* pass to xvf_set_attributes() */

int           force;         /* TRUE if the box for 'force' is ON */
kform_struct *force_struct;  /* pass to xvf_set_attributes() */

kform_struct *make_struct; /* submenu button, pass to xvf_set_attributes() */

int          make_target;          /* TRUE when user clicks on 'make_target'*/
kform_struct *make_target_struct;  /* pass to xvf_set_attributes() */

int          make_install;          /* TRUE when user clicks on 'make_install'*/
kform_struct *make_install_struct;  /* pass to xvf_set_attributes() */

int          make_Imakefile;          /* TRUE when user clicks on 'make_Imakefile'*/
kform_struct *make_Imakefile_struct;  /* pass to xvf_set_attributes() */

int          make_Makefile;          /* TRUE when user clicks on 'make_Makefile'*/
kform_struct *make_Makefile_struct;  /* pass to xvf_set_attributes() */

int          make_klint;          /* TRUE when user clicks on 'make_klint'*/
kform_struct *make_klint_struct;  /* pass to xvf_set_attributes() */

int          make_clean;          /* TRUE when user clicks on 'make_clean'*/
kform_struct *make_clean_struct;  /* pass to xvf_set_attributes() */

kform_struct *make_lib_struct; /* submenu button, pass to xvf_set_attributes() */

int          lib_make_target;          /* TRUE when user clicks on 'lib_make_target'*/
kform_struct *lib_make_target_struct;  /* pass to xvf_set_attributes() */

int          lib_make_install;          /* TRUE when user clicks on 'lib_make_install'*/
kform_struct *lib_make_install_struct;  /* pass to xvf_set_attributes() */

int          lib_make_Imakefile;          /* TRUE when user clicks on 'lib_make_Imakefile'*/
kform_struct *lib_make_Imakefile_struct;  /* pass to xvf_set_attributes() */

int          lib_make_Makefile;          /* TRUE when user clicks on 'lib_make_Makefile'*/
kform_struct *lib_make_Makefile_struct;  /* pass to xvf_set_attributes() */

int          lib_make_klint;          /* TRUE when user clicks on 'lib_make_klint'*/
kform_struct *lib_make_klint_struct;  /* pass to xvf_set_attributes() */

int          lib_make_clean;          /* TRUE when user clicks on 'lib_make_clean'*/
kform_struct *lib_make_clean_struct;  /* pass to xvf_set_attributes() */

xvobject     workspace;          /* address of workspace 'workspace'*/
kform_struct *workspace_struct;  /* pass to xvf_set_attributes() */

char         *grep;         /* string for 'grep'*/
kform_struct *grep_struct;  /* pass to xvf_set_attributes() */
int          grep_selected; /* TRUE on <cr> for 'grep' */

} logform_logging;

/*
 * Subform Info Struct for 'logform' Subform
 */
typedef struct _composer_logform {

logform_logging  *logging;          /* ptr to Pane Info struct for pane 'logging' */
int             logging_selected;          /* TRUE if input was from pane 'logging' */
kform_struct    *logging_struct;          /* pass to xvf_set_attributes() */

}  composer_logform;

/*
 * Form Info Struct for 'composer' form
 */
typedef struct _gui_info_struct {

kform_struct *status_struct; /* pass to xvf_set_attributes() */

kform_struct *options_struct; /* submenu button, pass to xvf_set_attributes() */

kform_struct *license_struct; /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Quit' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          file_type_val;      /* value of toggle 'file_type'*/
int          file_type_num;      /* number of toggle member selected (1-N) */
kform_struct *file_type_struct;  /* pass to xvf_set_attributes() */
int          file_type_selected; /* TRUE on <cr> for 'file_type' */

int          filelist;          /* int value of 'filelist'*/
char         *filelist_label;   /* label representing int value of 'filelist'*/
kform_struct *filelist_struct;  /* pass to xvf_set_attributes() */
int          filelist_selected; /* TRUE on <cr> for 'filelist' */
int          filelist_dblclick;   /* TRUE for double click on list */

int          save;          /* TRUE when user clicks on 'save'*/
kform_struct *save_struct;  /* pass to xvf_set_attributes() */

int          spawntty;          /* TRUE when user clicks on 'spawntty'*/
kform_struct *spawntty_struct;  /* pass to xvf_set_attributes() */

kform_struct *fileops_struct; /* submenu button, pass to xvf_set_attributes() */

int          interactive;          /* TRUE when user clicks on 'interactive'*/
kform_struct *interactive_struct;  /* pass to xvf_set_attributes() */

int          edit;          /* TRUE when user clicks on 'edit'*/
kform_struct *edit_struct;  /* pass to xvf_set_attributes() */

int          view;          /* TRUE when user clicks on 'view'*/
kform_struct *view_struct;  /* pass to xvf_set_attributes() */

int          rmfile;          /* TRUE when user clicks on 'rmfile'*/
kform_struct *rmfile_struct;  /* pass to xvf_set_attributes() */

composer_addfile  *addfile;
int addfile_selected;
kform_struct *addfile_struct;

composer_renamefile  *renamefile;
int renamefile_selected;
kform_struct *renamefile_struct;

composer_printfile  *printfile;
int printfile_selected;
kform_struct *printfile_struct;

composer_obj_attributes  *obj_attributes;
int obj_attributes_selected;
kform_struct *obj_attributes_struct;

composer_logform  *logform;
int logform_selected;
kform_struct *logform_struct;


kform_struct *composer_struct;


 } gui_info_struct; 

        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void composer_file_type	PROTO((gui_info_struct *));
void composer_filelist	PROTO((gui_info_struct *));
void composer_filelist_dblclick     PROTO((gui_info_struct *));
void composer_save	PROTO((gui_info_struct *));
void composer_spawntty	PROTO((gui_info_struct *));
void composer_interactive	PROTO((gui_info_struct *));
void composer_edit	PROTO((gui_info_struct *));
void composer_view	PROTO((gui_info_struct *));
void composer_rmfile	PROTO((gui_info_struct *));
void _xvf_free_composer PROTO((gui_info_struct *));
void _xvf_get_composer  PROTO((gui_info_struct *));

int  _xvf_init_composer PROTO((kform *, gui_info_struct *));
void run_composer       PROTO((kform *, ksubform *, kaddr));

void run_addfile      PROTO((composer_addfile *));
void _xvf_get_addfile PROTO((composer_addfile *));

void run_add_pane      PROTO((addfile_add_pane *));
void _xvf_get_add_pane PROTO((addfile_add_pane *));
void add_pane_add_file	PROTO((addfile_add_pane *));
void add_pane_add	PROTO((addfile_add_pane *));

void run_renamefile      PROTO((composer_renamefile *));
void _xvf_get_renamefile PROTO((composer_renamefile *));

void run_rename_pane      PROTO((renamefile_rename_pane *));
void _xvf_get_rename_pane PROTO((renamefile_rename_pane *));
void rename_pane_rename_to	PROTO((renamefile_rename_pane *));
void rename_pane_rename	PROTO((renamefile_rename_pane *));

void run_printfile      PROTO((composer_printfile *));
void _xvf_get_printfile PROTO((composer_printfile *));

void run_printpane      PROTO((printfile_printpane *));
void _xvf_get_printpane PROTO((printfile_printpane *));
void printpane_print	PROTO((printfile_printpane *));

void run_obj_attributes      PROTO((composer_obj_attributes *));
void _xvf_get_obj_attributes PROTO((composer_obj_attributes *));

void run_obj_attrs      PROTO((obj_attributes_obj_attrs *));
void _xvf_get_obj_attrs PROTO((obj_attributes_obj_attrs *));
void obj_attrs_apply	PROTO((obj_attributes_obj_attrs *));

void run_obj_keywords      PROTO((obj_attributes_obj_keywords *));
void _xvf_get_obj_keywords PROTO((obj_attributes_obj_keywords *));
void obj_keywords_keylist	PROTO((obj_attributes_obj_keywords *));
void obj_keywords_delete	PROTO((obj_attributes_obj_keywords *));
void obj_keywords_addkey	PROTO((obj_attributes_obj_keywords *));
void obj_keywords_chkey	PROTO((obj_attributes_obj_keywords *));

void run_paneattrs      PROTO((obj_attributes_paneattrs *));
void _xvf_get_paneattrs PROTO((obj_attributes_paneattrs *));
void paneattrs_apply	PROTO((obj_attributes_paneattrs *));

void run_logform      PROTO((composer_logform *));
void _xvf_get_logform PROTO((composer_logform *));

void run_logging      PROTO((logform_logging *));
void _xvf_get_logging PROTO((logform_logging *));
void logging_clear	PROTO((logform_logging *));
void logging_gen_code	PROTO((logform_logging *));
void logging_make_target	PROTO((logform_logging *));
void logging_make_install	PROTO((logform_logging *));
void logging_make_Imakefile	PROTO((logform_logging *));
void logging_make_Makefile	PROTO((logform_logging *));
void logging_make_klint	PROTO((logform_logging *));
void logging_make_clean	PROTO((logform_logging *));
void logging_lib_make_target	PROTO((logform_logging *));
void logging_lib_make_install	PROTO((logform_logging *));
void logging_lib_make_Imakefile	PROTO((logform_logging *));
void logging_lib_make_Makefile	PROTO((logform_logging *));
void logging_lib_make_klint	PROTO((logform_logging *));
void logging_lib_make_clean	PROTO((logform_logging *));
void logging_grep	PROTO((logform_logging *));




#endif /* _form_info_h_ */ 
/* Don't add after this point */
