 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	GUI Drivers for 'composer'
   >>>> 
   >>>>  Private: 
   >>>> 	run_composer
   >>>> 	run_addfile
   >>>> 	run_add_pane
   >>>> 	run_renamefile
   >>>> 	run_rename_pane
   >>>> 	run_printfile
   >>>> 	run_printpane
   >>>> 	run_obj_attributes
   >>>> 	run_obj_attrs
   >>>> 	run_obj_keywords
   >>>> 	run_paneattrs
   >>>> 	run_logform
   >>>> 	run_logging
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "composer.h"

/*-----------------------------------------------------------
| 
|  Routine Name: run_composer
| 
|       Purpose: Main GUI Driver for composer
| 
|         Input: None
| 
|        Output: Returns TRUE on success, FALSE on failure
|    Written By: conductor -oname composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void run_composer(
     kform    *form,
     ksubform *subform,
     kaddr    client_data)
{
	/*
	 * GUI info structure passed in as client_data 
	 */
	gui_info_struct *master_info = (gui_info_struct *) client_data;

	/*
	 * Get information from the forms
	 */
	_xvf_get_composer(master_info);

	if (form->quit)
	{
	    xvf_destroy_allforms();
	    _xvf_free_composer(master_info);
	    return;
	}

	    /*
	     * user selected 'live' toggle selection 'file_type'
	     */
	    if (master_info->file_type_selected)
	    {
	        composer_file_type(master_info);
	        master_info->file_type_selected = FALSE;
	    }
	    /*
	     * user double-clicked on list filelist	     */
	    else if ((master_info->filelist_selected)
	              && (master_info->filelist_dblclick))
	    {
	        composer_filelist_dblclick(master_info);
	        master_info->filelist_selected = FALSE;
	    }
	    /*
	     * user selected 'live' list selection 'filelist'
	     */
	    else if (master_info->filelist_selected)
	    {
	        composer_filelist(master_info);
	        master_info->filelist_selected = FALSE;
	    }
	    /*
	     * user clicked on pane action button selection 'save'
	     */
	    else if (master_info->save)
	    {
	        composer_save(master_info);
	        master_info->save = FALSE;
	    }
	    /*
	     * user clicked on pane action button selection 'spawntty'
	     */
	    else if (master_info->spawntty)
	    {
	        composer_spawntty(master_info);
	        master_info->spawntty = FALSE;
	    }
	    /*
	     * user clicked on pane action button selection 'interactive'
	     */
	    else if (master_info->interactive)
	    {
	        composer_interactive(master_info);
	        master_info->interactive = FALSE;
	    }
	    /*
	     * user clicked on pane action button selection 'edit'
	     */
	    else if (master_info->edit)
	    {
	        composer_edit(master_info);
	        master_info->edit = FALSE;
	    }
	    /*
	     * user clicked on pane action button selection 'view'
	     */
	    else if (master_info->view)
	    {
	        composer_view(master_info);
	        master_info->view = FALSE;
	    }
	    /*
	     * user clicked on pane action button selection 'rmfile'
	     */
	    else if (master_info->rmfile)
	    {
	        composer_rmfile(master_info);
	        master_info->rmfile = FALSE;
	    }
	/*
	 * action came from the 'addfile' subform
	 */
	if (master_info->addfile_selected)
	    run_addfile(master_info->addfile);
	/*
	 * action came from the 'renamefile' subform
	 */
	if (master_info->renamefile_selected)
	    run_renamefile(master_info->renamefile);
	/*
	 * action came from the 'printfile' subform
	 */
	if (master_info->printfile_selected)
	    run_printfile(master_info->printfile);
	/*
	 * action came from the 'obj_attributes' subform
	 */
	if (master_info->obj_attributes_selected)
	    run_obj_attributes(master_info->obj_attributes);
	/*
	 * action came from the 'logform' subform
	 */
	if (master_info->logform_selected)
	    run_logform(master_info->logform);

	xvf_clear_selections(form);

}

/*-----------------------------------------------------------
| 
|  Routine Name: run_addfile
| 
|       Purpose: GUI Driver for subform 'addfile'
| 
|         Input: form      - pointer to the form tree
|                addfile_info - pointer to composer_addfile struct
| 
|        Output: None
|    Written By: conductor -program_name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_addfile(
     composer_addfile *addfile_info)
{

	/*
	 * action came from the 'add_pane' pane
	 */
	if (addfile_info->add_pane_selected)
	    run_add_pane(addfile_info->add_pane);


}   /* end run_addfile */



/*-----------------------------------------------------------
| 
|  Routine Name: run_add_pane
| 
|       Purpose: GUI Driver for pane 'add_pane'
| 
|         Input: form - pointer to the form tree
|                add_pane_info - pointer to addfile_add_pane struct
| 
|        Output: None
|    Written By: conductor -program_name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_add_pane(
     addfile_add_pane *add_pane_info)

{

	/*
	 * user selected 'live' string selection 'add_file'
	 */
	if (add_pane_info->add_file_selected)
	{
	    add_pane_add_file(add_pane_info);
	    add_pane_info->add_file_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'add'
	 */
	else if (add_pane_info->add)
	{
	    add_pane_add(add_pane_info);
	    add_pane_info->add = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_renamefile
| 
|       Purpose: GUI Driver for subform 'renamefile'
| 
|         Input: form      - pointer to the form tree
|                renamefile_info - pointer to composer_renamefile struct
| 
|        Output: None
|    Written By: conductor -program_name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_renamefile(
     composer_renamefile *renamefile_info)
{

	/*
	 * action came from the 'rename_pane' pane
	 */
	if (renamefile_info->rename_pane_selected)
	    run_rename_pane(renamefile_info->rename_pane);


}   /* end run_renamefile */



/*-----------------------------------------------------------
| 
|  Routine Name: run_rename_pane
| 
|       Purpose: GUI Driver for pane 'rename_pane'
| 
|         Input: form - pointer to the form tree
|                rename_pane_info - pointer to renamefile_rename_pane struct
| 
|        Output: None
|    Written By: conductor -program_name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_rename_pane(
     renamefile_rename_pane *rename_pane_info)

{

	/*
	 * user selected 'live' string selection 'rename_to'
	 */
	if (rename_pane_info->rename_to_selected)
	{
	    rename_pane_rename_to(rename_pane_info);
	    rename_pane_info->rename_to_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'rename'
	 */
	else if (rename_pane_info->rename)
	{
	    rename_pane_rename(rename_pane_info);
	    rename_pane_info->rename = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_printfile
| 
|       Purpose: GUI Driver for subform 'printfile'
| 
|         Input: form      - pointer to the form tree
|                printfile_info - pointer to composer_printfile struct
| 
|        Output: None
|    Written By: conductor -program_name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_printfile(
     composer_printfile *printfile_info)
{

	/*
	 * action came from the 'printpane' pane
	 */
	if (printfile_info->printpane_selected)
	    run_printpane(printfile_info->printpane);


}   /* end run_printfile */



/*-----------------------------------------------------------
| 
|  Routine Name: run_printpane
| 
|       Purpose: GUI Driver for pane 'printpane'
| 
|         Input: form - pointer to the form tree
|                printpane_info - pointer to printfile_printpane struct
| 
|        Output: None
|    Written By: conductor -program_name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_printpane(
     printfile_printpane *printpane_info)

{

	/*
	 * user clicked on pane action button selection 'print'
	 */
	if (printpane_info->print)
	{
	    printpane_print(printpane_info);
	    printpane_info->print = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_obj_attributes
| 
|       Purpose: GUI Driver for subform 'obj_attributes'
| 
|         Input: form      - pointer to the form tree
|                obj_attributes_info - pointer to composer_obj_attributes struct
| 
|        Output: None
|    Written By: conductor -program_name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_obj_attributes(
     composer_obj_attributes *obj_attributes_info)
{

	/*
	 * action came from the 'obj_attrs' pane
	 */
	if (obj_attributes_info->obj_attrs_selected)
	    run_obj_attrs(obj_attributes_info->obj_attrs);

	/*
	 * action came from the 'obj_keywords' pane
	 */
	else if (obj_attributes_info->obj_keywords_selected)
	    run_obj_keywords(obj_attributes_info->obj_keywords);

	/*
	 * action came from the 'paneattrs' pane
	 */
	else if (obj_attributes_info->paneattrs_selected)
	    run_paneattrs(obj_attributes_info->paneattrs);


}   /* end run_obj_attributes */



/*-----------------------------------------------------------
| 
|  Routine Name: run_obj_attrs
| 
|       Purpose: GUI Driver for pane 'obj_attrs'
| 
|         Input: form - pointer to the form tree
|                obj_attrs_info - pointer to obj_attributes_obj_attrs struct
| 
|        Output: None
|    Written By: conductor -program_name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_obj_attrs(
     obj_attributes_obj_attrs *obj_attrs_info)

{

	/*
	 * user clicked on pane action button selection 'apply'
	 */
	if (obj_attrs_info->apply)
	{
	    obj_attrs_apply(obj_attrs_info);
	    obj_attrs_info->apply = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_obj_keywords
| 
|       Purpose: GUI Driver for pane 'obj_keywords'
| 
|         Input: form - pointer to the form tree
|                obj_keywords_info - pointer to obj_attributes_obj_keywords struct
| 
|        Output: None
|    Written By: conductor -program_name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_obj_keywords(
     obj_attributes_obj_keywords *obj_keywords_info)

{

	/*
	 * user selected 'live' list selection 'keylist'
	 */
	if (obj_keywords_info->keylist_selected)
	{
	    obj_keywords_keylist(obj_keywords_info);
	    obj_keywords_info->keylist_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'delete'
	 */
	else if (obj_keywords_info->delete)
	{
	    obj_keywords_delete(obj_keywords_info);
	    obj_keywords_info->delete = FALSE;
	}
	/*
	 * user selected 'live' string selection 'addkey'
	 */
	else if (obj_keywords_info->addkey_selected)
	{
	    obj_keywords_addkey(obj_keywords_info);
	    obj_keywords_info->addkey_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'chkey'
	 */
	else if (obj_keywords_info->chkey_selected)
	{
	    obj_keywords_chkey(obj_keywords_info);
	    obj_keywords_info->chkey_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_paneattrs
| 
|       Purpose: GUI Driver for pane 'paneattrs'
| 
|         Input: form - pointer to the form tree
|                paneattrs_info - pointer to obj_attributes_paneattrs struct
| 
|        Output: None
|    Written By: conductor -program_name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_paneattrs(
     obj_attributes_paneattrs *paneattrs_info)

{

	/*
	 * user clicked on pane action button selection 'apply'
	 */
	if (paneattrs_info->apply)
	{
	    paneattrs_apply(paneattrs_info);
	    paneattrs_info->apply = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_logform
| 
|       Purpose: GUI Driver for subform 'logform'
| 
|         Input: form      - pointer to the form tree
|                logform_info - pointer to composer_logform struct
| 
|        Output: None
|    Written By: conductor -program_name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_logform(
     composer_logform *logform_info)
{

	/*
	 * action came from the 'logging' pane
	 */
	if (logform_info->logging_selected)
	    run_logging(logform_info->logging);


}   /* end run_logform */



/*-----------------------------------------------------------
| 
|  Routine Name: run_logging
| 
|       Purpose: GUI Driver for pane 'logging'
| 
|         Input: form - pointer to the form tree
|                logging_info - pointer to logform_logging struct
| 
|        Output: None
|    Written By: conductor -program_name composer -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_logging(
     logform_logging *logging_info)

{

	/*
	 * user clicked on pane action button selection 'clear'
	 */
	if (logging_info->clear)
	{
	    logging_clear(logging_info);
	    logging_info->clear = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'gen_code'
	 */
	else if (logging_info->gen_code)
	{
	    logging_gen_code(logging_info);
	    logging_info->gen_code = FALSE;
	}
	/*
	 * user clicked on master action button selection 'make_target'
	 */
	else if (logging_info->make_target)
	    logging_make_target(logging_info);
	/*
	 * user clicked on master action button selection 'make_install'
	 */
	else if (logging_info->make_install)
	    logging_make_install(logging_info);
	/*
	 * user clicked on master action button selection 'make_Imakefile'
	 */
	else if (logging_info->make_Imakefile)
	    logging_make_Imakefile(logging_info);
	/*
	 * user clicked on master action button selection 'make_Makefile'
	 */
	else if (logging_info->make_Makefile)
	    logging_make_Makefile(logging_info);
	/*
	 * user clicked on master action button selection 'make_klint'
	 */
	else if (logging_info->make_klint)
	    logging_make_klint(logging_info);
	/*
	 * user clicked on master action button selection 'make_clean'
	 */
	else if (logging_info->make_clean)
	    logging_make_clean(logging_info);
	/*
	 * user clicked on master action button selection 'lib_make_target'
	 */
	else if (logging_info->lib_make_target)
	    logging_lib_make_target(logging_info);
	/*
	 * user clicked on master action button selection 'lib_make_install'
	 */
	else if (logging_info->lib_make_install)
	    logging_lib_make_install(logging_info);
	/*
	 * user clicked on master action button selection 'lib_make_Imakefile'
	 */
	else if (logging_info->lib_make_Imakefile)
	    logging_lib_make_Imakefile(logging_info);
	/*
	 * user clicked on master action button selection 'lib_make_Makefile'
	 */
	else if (logging_info->lib_make_Makefile)
	    logging_lib_make_Makefile(logging_info);
	/*
	 * user clicked on master action button selection 'lib_make_klint'
	 */
	else if (logging_info->lib_make_klint)
	    logging_lib_make_klint(logging_info);
	/*
	 * user clicked on master action button selection 'lib_make_clean'
	 */
	else if (logging_info->lib_make_clean)
	    logging_lib_make_clean(logging_info);
	/*
	 * user selected 'live' string selection 'grep'
	 */
	else if (logging_info->grep_selected)
	{
	    logging_grep(logging_info);
	    logging_info->grep_selected = FALSE;
	}


}


