 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Form Info Structure for cantata Form
   >>>> 
   >>>>    Written By: conductor -name cantata -l 3
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 20, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _form_info_h_
#define _form_info_h_

#include <xvinclude.h>

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

/*
 * Pane Info Struct for 'console' Pane
 */
typedef struct _consoleform_console{

int          clear;          /* TRUE when user clicks on 'clear'*/
kform_struct *clear_struct;  /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

xvobject     wksp;          /* address of workspace 'wksp'*/
kform_struct *wksp_struct;  /* pass to xvf_set_attributes() */

} consoleform_console;

/*
 * Subform Info Struct for 'consoleform' Subform
 */
typedef struct _cantata_consoleform {

consoleform_console  *console;          /* ptr to Pane Info struct for pane 'console' */
int                 console_selected;          /* TRUE if input was from pane 'console' */
kform_struct        *console_struct;          /* pass to xvf_set_attributes() */

}  cantata_consoleform;

/*
 * Pane Info Struct for 'customize' Pane
 */
typedef struct _preferences_customize{

int          change;          /* TRUE when user clicks on 'change'*/
kform_struct *change_struct;  /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          toolboxes;          /* int value of 'toolboxes'*/
char         *toolboxes_label;   /* label representing int value of 'toolboxes'*/
kform_struct *toolboxes_struct;  /* pass to xvf_set_attributes() */
int          toolboxes_selected; /* TRUE on <cr> for 'toolboxes' */

int          objects;          /* int value of 'objects'*/
char         *objects_label;   /* label representing int value of 'objects'*/
kform_struct *objects_struct;  /* pass to xvf_set_attributes() */
int          objects_selected; /* TRUE on <cr> for 'objects' */

char         *tbname;         /* string for 'tbname'*/
kform_struct *tbname_struct;  /* pass to xvf_set_attributes() */
int          tbname_selected; /* TRUE on <cr> for 'tbname' */

char         *oname;         /* string for 'oname'*/
kform_struct *oname_struct;  /* pass to xvf_set_attributes() */
int          oname_selected; /* TRUE on <cr> for 'oname' */

char         *icon_name;         /* string for 'icon_name'*/
kform_struct *icon_name_struct;  /* pass to xvf_set_attributes() */
int          icon_name_selected; /* TRUE on <cr> for 'icon_name' */

char         *category;         /* string for 'category'*/
kform_struct *category_struct;  /* pass to xvf_set_attributes() */
int          category_selected; /* TRUE on <cr> for 'category' */

char         *subcategory;         /* string for 'subcategory'*/
kform_struct *subcategory_struct;  /* pass to xvf_set_attributes() */
int          subcategory_selected; /* TRUE on <cr> for 'subcategory' */

} preferences_customize;

/*
 * Subform Info Struct for 'preferences' Subform
 */
typedef struct _cantata_preferences {

preferences_customize  *customize;          /* ptr to Pane Info struct for pane 'customize' */
int                   customize_selected;          /* TRUE if input was from pane 'customize' */
kform_struct          *customize_struct;          /* pass to xvf_set_attributes() */

}  cantata_preferences;

/*
 * Pane Info Struct for 'program' Pane
 */
typedef struct _create_program{

int          create;          /* TRUE when user clicks on 'create'*/
kform_struct *create_struct;  /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          toolboxes;          /* int value of 'toolboxes'*/
char         *toolboxes_label;   /* label representing int value of 'toolboxes'*/
kform_struct *toolboxes_struct;  /* pass to xvf_set_attributes() */
int          toolboxes_selected; /* TRUE on <cr> for 'toolboxes' */

int          objects;          /* int value of 'objects'*/
char         *objects_label;   /* label representing int value of 'objects'*/
kform_struct *objects_struct;  /* pass to xvf_set_attributes() */
int          objects_selected; /* TRUE on <cr> for 'objects' */

char         *tbname;         /* string for 'tbname'*/
kform_struct *tbname_struct;  /* pass to xvf_set_attributes() */

char         *oname;         /* string for 'oname'*/
kform_struct *oname_struct;  /* pass to xvf_set_attributes() */

char         *icon_name;         /* string for 'icon_name'*/
kform_struct *icon_name_struct;  /* pass to xvf_set_attributes() */

char         *category;         /* string for 'category'*/
kform_struct *category_struct;  /* pass to xvf_set_attributes() */
int          category_selected; /* TRUE on <cr> for 'category' */

char         *subcategory;         /* string for 'subcategory'*/
kform_struct *subcategory_struct;  /* pass to xvf_set_attributes() */

} create_program;

/*
 * Subform Info Struct for 'create' Subform
 */
typedef struct _cantata_create {

create_program  *program;          /* ptr to Pane Info struct for pane 'program' */
int            program_selected;          /* TRUE if input was from pane 'program' */
kform_struct   *program_struct;          /* pass to xvf_set_attributes() */

}  cantata_create;

/*
 * Pane Info Struct for 'annotations' Pane
 */
typedef struct _annotationform_annotations{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *restore;         /* filename for 'restore'*/
kform_struct *restore_struct;  /* pass to xvf_set_attributes() */
int          restore_selected; /* TRUE on <cr> for 'restore' */

char         *save;         /* filename for 'save'*/
kform_struct *save_struct;  /* pass to xvf_set_attributes() */
int          save_selected; /* TRUE on <cr> for 'save' */

xvobject     wksp;          /* address of workspace 'wksp'*/
kform_struct *wksp_struct;  /* pass to xvf_set_attributes() */

} annotationform_annotations;

/*
 * Subform Info Struct for 'annotationform' Subform
 */
typedef struct _cantata_annotationform {

annotationform_annotations  *annotations;          /* ptr to Pane Info struct for pane 'annotations' */
int                        annotations_selected;          /* TRUE if input was from pane 'annotations' */
kform_struct               *annotations_struct;          /* pass to xvf_set_attributes() */

}  cantata_annotationform;

/*
 * Pane Info Struct for 'files' Pane
 */
typedef struct _dir_files{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *restore_workspace;         /* filename for 'restore_workspace'*/
kform_struct *restore_workspace_struct;  /* pass to xvf_set_attributes() */
int          restore_workspace_selected; /* TRUE on <cr> for 'restore_workspace' */

char         *save_workspace;         /* filename for 'save_workspace'*/
kform_struct *save_workspace_struct;  /* pass to xvf_set_attributes() */
int          save_workspace_selected; /* TRUE on <cr> for 'save_workspace' */

char         *save_glyphs;         /* filename for 'save_glyphs'*/
kform_struct *save_glyphs_struct;  /* pass to xvf_set_attributes() */
int          save_glyphs_selected; /* TRUE on <cr> for 'save_glyphs' */

char         *tmpdir;         /* string for 'tmpdir'*/
kform_struct *tmpdir_struct;  /* pass to xvf_set_attributes() */
int          tmpdir_selected; /* TRUE on <cr> for 'tmpdir' */

kform_struct *blank0_struct; /* pass to xvf_set_attributes() */

kform_struct *blank1_struct; /* pass to xvf_set_attributes() */

kform_struct *blank3_struct; /* pass to xvf_set_attributes() */

kform_struct *blank4_struct; /* pass to xvf_set_attributes() */

} dir_files;

/*
 * Subform Info Struct for 'dir' Subform
 */
typedef struct _cantata_dir {

dir_files   *files;          /* ptr to Pane Info struct for pane 'files' */
int        files_selected;          /* TRUE if input was from pane 'files' */
kform_struct *files_struct;          /* pass to xvf_set_attributes() */

}  cantata_dir;

/*
 * Pane Info Struct for 'routines' Pane
 */
typedef struct _list_routines{

int          open;          /* TRUE when user clicks on 'open'*/
kform_struct *open_struct;  /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

xvobject     rlists;          /* address of workspace 'rlists'*/
kform_struct *rlists_struct;  /* pass to xvf_set_attributes() */

} list_routines;

/*
 * Subform Info Struct for 'list' Subform
 */
typedef struct _cantata_list {

list_routines  *routines;          /* ptr to Pane Info struct for pane 'routines' */
int           routines_selected;          /* TRUE if input was from pane 'routines' */
kform_struct  *routines_struct;          /* pass to xvf_set_attributes() */

}  cantata_list;

/*
 * Pane Info Struct for 'finder' Pane
 */
typedef struct _find_finder{

int          open;          /* TRUE when user clicks on 'open'*/
kform_struct *open_struct;  /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

xvobject     flist;          /* address of workspace 'flist'*/
kform_struct *flist_struct;  /* pass to xvf_set_attributes() */

char         *expr;         /* string for 'expr'*/
kform_struct *expr_struct;  /* pass to xvf_set_attributes() */
int          expr_selected; /* TRUE on <cr> for 'expr' */

} find_finder;

/*
 * Subform Info Struct for 'find' Subform
 */
typedef struct _cantata_find {

find_finder  *finder;          /* ptr to Pane Info struct for pane 'finder' */
int         finder_selected;          /* TRUE if input was from pane 'finder' */
kform_struct *finder_struct;          /* pass to xvf_set_attributes() */

}  cantata_find;

/*
 * Pane Info Struct for 'variables' Pane
 */
typedef struct _var_variables{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *expression;         /* string for 'expression'*/
kform_struct *expression_struct;  /* pass to xvf_set_attributes() */

int          evaluate;          /* TRUE when user clicks on 'evaluate'*/
kform_struct *evaluate_struct;  /* pass to xvf_set_attributes() */

int          scope;          /* int value of 'scope'*/
char         *scope_label;   /* label representing int value of 'scope'*/
kform_struct *scope_struct;  /* pass to xvf_set_attributes() */
int          scope_selected; /* TRUE on <cr> for 'scope' */

int          vardef;          /* int value of 'vardef'*/
char         *vardef_label;   /* label representing int value of 'vardef'*/
kform_struct *vardef_struct;  /* pass to xvf_set_attributes() */
int          vardef_selected; /* TRUE on <cr> for 'vardef' */

int          delete;          /* TRUE when user clicks on 'delete'*/
kform_struct *delete_struct;  /* pass to xvf_set_attributes() */

kform_struct *blank1_struct; /* pass to xvf_set_attributes() */

kform_struct *blank2_struct; /* pass to xvf_set_attributes() */

} var_variables;

/*
 * Subform Info Struct for 'var' Subform
 */
typedef struct _cantata_var {

var_variables  *variables;          /* ptr to Pane Info struct for pane 'variables' */
int           variables_selected;          /* TRUE if input was from pane 'variables' */
kform_struct  *variables_struct;          /* pass to xvf_set_attributes() */

}  cantata_var;

/*
 * Form Info Struct for 'cantata' form
 */
typedef struct _gui_info_struct {

kform_struct *options_struct; /* submenu button, pass to xvf_set_attributes() */

kform_struct *bugs_struct; /* pass to xvf_set_attributes() */

kform_struct *license_struct; /* pass to xvf_set_attributes() */

kform_struct *help1_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Quit' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

xvobject     workspace;          /* address of workspace 'workspace'*/
kform_struct *workspace_struct;  /* pass to xvf_set_attributes() */

int          wksp_attributes;          /* TRUE when user clicks on 'wksp_attributes'*/
kform_struct *wksp_attributes_struct;  /* pass to xvf_set_attributes() */

kform_struct *workspace_menu_struct; /* submenu button, pass to xvf_set_attributes() */

int          run;          /* TRUE when user clicks on 'run'*/
kform_struct *run_struct;  /* pass to xvf_set_attributes() */

int          reset;          /* TRUE when user clicks on 'reset'*/
kform_struct *reset_struct;  /* pass to xvf_set_attributes() */

int          clear;          /* TRUE when user clicks on 'clear'*/
kform_struct *clear_struct;  /* pass to xvf_set_attributes() */

int          check;          /* TRUE when user clicks on 'check'*/
kform_struct *check_struct;  /* pass to xvf_set_attributes() */

int          redraw;          /* TRUE when user clicks on 'redraw'*/
kform_struct *redraw_struct;  /* pass to xvf_set_attributes() */

int          wksp_info;          /* TRUE when user clicks on 'wksp_info'*/
kform_struct *wksp_info_struct;  /* pass to xvf_set_attributes() */

kform_struct *b4_struct; /* pass to xvf_set_attributes() */

int          panel;          /* TRUE when user clicks on 'panel'*/
kform_struct *panel_struct;  /* pass to xvf_set_attributes() */

int          export;          /* TRUE when user clicks on 'export'*/
kform_struct *export_struct;  /* pass to xvf_set_attributes() */

kform_struct *b5_struct; /* pass to xvf_set_attributes() */

int          create_procedure;          /* TRUE when user clicks on 'create_procedure'*/
kform_struct *create_procedure_struct;  /* pass to xvf_set_attributes() */

int          create_countloop;          /* TRUE when user clicks on 'create_countloop'*/
kform_struct *create_countloop_struct;  /* pass to xvf_set_attributes() */

int          create_whileloop;          /* TRUE when user clicks on 'create_whileloop'*/
kform_struct *create_whileloop_struct;  /* pass to xvf_set_attributes() */

kform_struct *b6_struct; /* pass to xvf_set_attributes() */

kform_struct *b7_struct; /* pass to xvf_set_attributes() */

kform_struct *help2_struct; /* pass to xvf_set_attributes() */

kform_struct *clipboard_menu_struct; /* submenu button, pass to xvf_set_attributes() */

int          copy;          /* TRUE when user clicks on 'copy'*/
kform_struct *copy_struct;  /* pass to xvf_set_attributes() */

int          cut;          /* TRUE when user clicks on 'cut'*/
kform_struct *cut_struct;  /* pass to xvf_set_attributes() */

int          paste;          /* TRUE when user clicks on 'paste'*/
kform_struct *paste_struct;  /* pass to xvf_set_attributes() */

int          duplicate;          /* TRUE when user clicks on 'duplicate'*/
kform_struct *duplicate_struct;  /* pass to xvf_set_attributes() */

int          raise;          /* TRUE when user clicks on 'raise'*/
kform_struct *raise_struct;  /* pass to xvf_set_attributes() */

int          lower;          /* TRUE when user clicks on 'lower'*/
kform_struct *lower_struct;  /* pass to xvf_set_attributes() */

int          delete;          /* TRUE when user clicks on 'delete'*/
kform_struct *delete_struct;  /* pass to xvf_set_attributes() */

int          undo;          /* TRUE when user clicks on 'undo'*/
kform_struct *undo_struct;  /* pass to xvf_set_attributes() */

kform_struct *b1_struct; /* pass to xvf_set_attributes() */

int          select;          /* TRUE when user clicks on 'select'*/
kform_struct *select_struct;  /* pass to xvf_set_attributes() */

int          unselect;          /* TRUE when user clicks on 'unselect'*/
kform_struct *unselect_struct;  /* pass to xvf_set_attributes() */

kform_struct *b2_struct; /* pass to xvf_set_attributes() */

int          show_clipboard;          /* TRUE when user clicks on 'show_clipboard'*/
kform_struct *show_clipboard_struct;  /* pass to xvf_set_attributes() */

kform_struct *b3_struct; /* pass to xvf_set_attributes() */

kform_struct *help3_struct; /* pass to xvf_set_attributes() */

kform_struct *b0_struct; /* pass to xvf_set_attributes() */

cantata_consoleform  *consoleform;
int consoleform_selected;
kform_struct *consoleform_struct;

cantata_preferences  *preferences;
int preferences_selected;
kform_struct *preferences_struct;

cantata_create  *create;
int create_selected;
kform_struct *create_struct;

cantata_annotationform  *annotationform;
int annotationform_selected;
kform_struct *annotationform_struct;

cantata_dir  *dir;
int dir_selected;
kform_struct *dir_struct;

cantata_list  *list;
int list_selected;
kform_struct *list_struct;

cantata_find  *find;
int find_selected;
kform_struct *find_struct;

cantata_var  *var;
int var_selected;
kform_struct *var_struct;


kform_struct *cantata_struct;


 } gui_info_struct; 

        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void cantata_wksp_attributes	PROTO((gui_info_struct *));
void cantata_run	PROTO((gui_info_struct *));
void cantata_reset	PROTO((gui_info_struct *));
void cantata_clear	PROTO((gui_info_struct *));
void cantata_check	PROTO((gui_info_struct *));
void cantata_redraw	PROTO((gui_info_struct *));
void cantata_wksp_info	PROTO((gui_info_struct *));
void cantata_panel	PROTO((gui_info_struct *));
void cantata_export	PROTO((gui_info_struct *));
void cantata_create_procedure	PROTO((gui_info_struct *));
void cantata_create_countloop	PROTO((gui_info_struct *));
void cantata_create_whileloop	PROTO((gui_info_struct *));
void cantata_copy	PROTO((gui_info_struct *));
void cantata_cut	PROTO((gui_info_struct *));
void cantata_paste	PROTO((gui_info_struct *));
void cantata_duplicate	PROTO((gui_info_struct *));
void cantata_raise	PROTO((gui_info_struct *));
void cantata_lower	PROTO((gui_info_struct *));
void cantata_delete	PROTO((gui_info_struct *));
void cantata_undo	PROTO((gui_info_struct *));
void cantata_select	PROTO((gui_info_struct *));
void cantata_unselect	PROTO((gui_info_struct *));
void cantata_show_clipboard	PROTO((gui_info_struct *));
void _xvf_free_cantata PROTO((gui_info_struct *));
void _xvf_get_cantata  PROTO((gui_info_struct *));

int  _xvf_init_cantata PROTO((kform *, gui_info_struct *));
void run_cantata       PROTO((kform *, ksubform *, kaddr));

void run_consoleform      PROTO((cantata_consoleform *));
void _xvf_get_consoleform PROTO((cantata_consoleform *));

void run_console      PROTO((consoleform_console *));
void _xvf_get_console PROTO((consoleform_console *));
void console_clear	PROTO((consoleform_console *));

void run_preferences      PROTO((cantata_preferences *));
void _xvf_get_preferences PROTO((cantata_preferences *));

void run_customize      PROTO((preferences_customize *));
void _xvf_get_customize PROTO((preferences_customize *));
void customize_change	PROTO((preferences_customize *));
void customize_toolboxes	PROTO((preferences_customize *));
void customize_objects	PROTO((preferences_customize *));
void customize_tbname	PROTO((preferences_customize *));
void customize_oname	PROTO((preferences_customize *));
void customize_icon_name	PROTO((preferences_customize *));
void customize_category	PROTO((preferences_customize *));
void customize_subcategory	PROTO((preferences_customize *));

void run_create      PROTO((cantata_create *));
void _xvf_get_create PROTO((cantata_create *));

void run_program      PROTO((create_program *));
void _xvf_get_program PROTO((create_program *));
void program_create	PROTO((create_program *));
void program_toolboxes	PROTO((create_program *));
void program_objects	PROTO((create_program *));
void program_category	PROTO((create_program *));

void run_annotationform      PROTO((cantata_annotationform *));
void _xvf_get_annotationform PROTO((cantata_annotationform *));

void run_annotations      PROTO((annotationform_annotations *));
void _xvf_get_annotations PROTO((annotationform_annotations *));
void annotations_restore	PROTO((annotationform_annotations *));
void annotations_save	PROTO((annotationform_annotations *));

void run_dir      PROTO((cantata_dir *));
void _xvf_get_dir PROTO((cantata_dir *));

void run_files      PROTO((dir_files *));
void _xvf_get_files PROTO((dir_files *));
void files_restore_workspace	PROTO((dir_files *));
void files_save_workspace	PROTO((dir_files *));
void files_save_glyphs	PROTO((dir_files *));
void files_tmpdir	PROTO((dir_files *));

void run_list      PROTO((cantata_list *));
void _xvf_get_list PROTO((cantata_list *));

void run_routines      PROTO((list_routines *));
void _xvf_get_routines PROTO((list_routines *));
void routines_open	PROTO((list_routines *));

void run_find      PROTO((cantata_find *));
void _xvf_get_find PROTO((cantata_find *));

void run_finder      PROTO((find_finder *));
void _xvf_get_finder PROTO((find_finder *));
void finder_open	PROTO((find_finder *));
void finder_expr	PROTO((find_finder *));

void run_var      PROTO((cantata_var *));
void _xvf_get_var PROTO((cantata_var *));

void run_variables      PROTO((var_variables *));
void _xvf_get_variables PROTO((var_variables *));
void variables_evaluate	PROTO((var_variables *));
void variables_scope	PROTO((var_variables *));
void variables_vardef	PROTO((var_variables *));
void variables_delete	PROTO((var_variables *));




#endif /* _form_info_h_ */ 
/* Don't add after this point */
