 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane files
   >>>> 
   >>>>  Private: 
   >>>> 	files_save_workspace
   >>>> 	files_restore_workspace
   >>>> 	files_tmpdir
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "cantata.h"

/*-----------------------------------------------------------
| 
|  Routine Name: files_save_workspace
| 
|       Purpose: Do routine which is called when
|                  output selection save_workspace is used
| 
|         Input: files_info - ptr to PaneInfo struct for files pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Mar 11, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void files_save_workspace(
     dir_files *files_info)
{
	save_workspace(files_info->save_workspace, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: files_restore_workspace
| 
|       Purpose: Do routine which is called when
|                  input selection restore_workspace is used
| 
|         Input: files_info - ptr to PaneInfo struct for files pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Mar 11, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void files_restore_workspace(
     dir_files *files_info)
{
	restore_workspace(files_info->restore_workspace);
}


/*-----------------------------------------------------------
| 
|  Routine Name: files_tmpdir
| 
|       Purpose: Do routine which is called when
|                  string selection tmpdir is used
| 
|         Input: files_info - ptr to PaneInfo struct for files pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Mar 11, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void files_tmpdir(
     dir_files *files_info)
{
	/* PUT YOUR CODE HERE ! */
}

/*-----------------------------------------------------------
| 
|  Routine Name: files_save_glyphs
| 
|       Purpose: Do routine which is called when
|                  output selection save_glyphs is used
| 
|         Input: files_info - ptr to PaneInfo struct for files pane
| 
|        Output: None
|    Written By: 
|          Date: Mar 11, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void files_save_glyphs(
     dir_files *files_info)
{
	save_workspace(files_info->save_workspace, FALSE);
}
