 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for cantata
   >>>> 
   >>>>    Written By: 
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 12, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _cantata_h_
#define _cantata_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <design.h>
#include <xvinclude.h>
#include "form_info.h"

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DESIGN/objects/xvroutine/cantata/uis/cantata.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Alternate UIS file (optional infile)
 */
char	*form_file;	/* Alternate UIS file FILENAME */
int	 form_flag;	/* Alternate UIS file FLAG */

/*
 *  (x,y) position for automatic GUI placement */

int	 x_int;		/* x position INT */
int	 x_flag;	/* x position FLAG */

int	 y_int;		/* y position INT */
int	 y_flag;	/* y position FLAG */

/*
 *  Create Cantata Pulldown Toolbox Menus (optional logical)
 */
int	 tbmenus_logic;	/* Create Cantata Pulldown Toolbox Menus LOGIC */
int	 tbmenus_flag;  	/* Create Cantata Pulldown Toolbox Menus FLAG */

/*----- optional ME group ----*/
/*
 *  file for restoring cantata workspace (optional infile)
 */
char	*wksp_file;	/* file for restoring cantata workspace FILENAME */
int	 wksp_flag;	/* file for restoring cantata workspace FLAG */

	/*---- nested optional MI group ----*/
/*
 *  the toolbox in which the encapsulated workspace (optional string)
 */
char	*tb_string;	/* the toolbox in which the encapsulated workspace STRING */
int	 tb_flag;   	/* the toolbox in which the encapsulated workspace FLAG */

/*
 *  The encapsulated workspace object name (optional string)
 */
char	*oname_string;	/* The encapsulated workspace object name STRING */
int	 oname_flag;   	/* The encapsulated workspace object name FLAG */

	/*-- nested optional MI group end --*/

/*-- optional ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
extern gui_info_struct *gui_info;

/* -include_variables */
extern xvobject main_workspace, workspace, notifywindow, position, active;
extern xvobject routines, finder, tbmenu, status, console;
extern int status_mode;
extern kform *cantata_form;
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void cantata_get_args PROTO((kform *));
void cantata_usage_additions PROTO((void));
void cantata_free_args PROTO((int, kaddr));

/* -include_routines */
void initialize_create_program PROTO((create_program *));
void create_glyph          PROTO((xvobject, kaddr, kaddr));
void status_callback       PROTO((xvobject, kaddr, kaddr));
int  update_status         PROTO((char *, char *, char *, char *, char *));
void update_position       PROTO((xvobject, kaddr, XEvent *, int *));
void save_workspace        PROTO((char *, int));
void restore_workspace     PROTO((char *));
void initialize_cantata    PROTO((void));
void cantata_exit          PROTO((kaddr));
void change_workspace      PROTO((xvobject, kaddr, kaddr));
void update_vardef_displaylist   PROTO((xvobject));
void update_varscope_displaylist PROTO((char *));
/* -include_routines_end */

#endif
