 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Declaration of the general attributes used
   >>>>		       by all objects and gadgets.
   >>>>
   >>>>			Note:  This file should only be included
   >>>>			       in the compiled attribute utilities
   >>>>			       (compiled.c).
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Sep 10, 1992
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvw_attrib_h_
#define _xvw_attrib_h_


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

static xvattribute xvw_attributes[] =
{
  {XVW_WIDTH,             XtNwidth,             XtRInt,          XtRDimension},
  {XVW_HEIGHT,            XtNheight,            XtRInt,          XtRDimension},
  {XVW_DEPTH,		  NULL, 	        XtRInt,          NULL},
  {XVW_XPOSITION,         XtNx,                 XtRInt,          XtRPosition},
  {XVW_YPOSITION,         XtNy,                 XtRInt,          XtRPosition},
  {XVW_BORDER_WIDTH,      NULL, 	        XtRInt,          NULL},
  {XVW_FOREGROUND_COLOR,  XtNforeground,        XtRString,       XtRPixel},
  {XVW_BACKGROUND_COLOR,  XtNbackground,        XtRString,       XtRPixel},
  {XVW_BORDER_COLOR,      XtNborder,            XtRString,       XtRPixel},
  {XVW_FOREGROUND_PIXEL,  NULL, 	        XtRPixel,        NULL},
  {XVW_BACKGROUND_PIXEL,  NULL,		        XtRPixel,        NULL},
  {XVW_BORDER_PIXEL,      XtNborder,            XtRPixel,        NULL},
  {XVW_FONTNAME,          XtNfont,              XtRString,       XtRFontStruct},
  {XVW_FONT,              NULL,                 XtRFontStruct,   NULL},
  {XVW_MAP_WHEN_MANAGED,  XtNmappedWhenManaged, XtRBoolean,      NULL},
  {XVW_VISUAL,            NULL,                 XtRVisual,       NULL},
  {XVW_COLORMAP,          NULL,                 XtRColormap,     NULL},
  {XVW_BACKGROUND_PIXMAPFILE, XtNbackgroundPixmap,XtRFilename, XtRPixmap},
  {XVW_BACKGROUND_PIXMAP, XtNbackgroundPixmap,  XtRPixmap,       NULL},
  {XVW_CURSORNAME,        XVW_CURSOR,           XtRString,	 XtRCursor},
  {XVW_CURSOR,            NULL,                 XtRCursor,       NULL},
  {XVW_RESIZABLE,         NULL,                 XtRBoolean,      NULL},
  {XVW_MENUABLE,          NULL,                 XtRBoolean,      NULL},
  {XVW_SELECTABLE,        NULL,                 XtRBoolean,      NULL},
};

static int num_xvw_attributes = knumber(xvw_attributes);

#endif /* _xvw_attrib_h_ */
/* Don't add after this point */
