 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Private Utility Routines
   >>>>
   >>>>   Static:
   >>>>  Private:
   >>>>		    xvw_add_toplevel()
   >>>>		    xvw_remove_toplevel()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/*--------------------------------------------------------------
|
|  Routine Name: xvw_add_toplevel - add a toplevel object
|
|       Purpose: Every time a new toplevel object is created by one
|		 of the routines in xvutils, it must be added to the
|		 xvw_toplevels list so that when journal playback is used,
|		 this list is searched first for toplevel objects.  This makes
|		 journal playback more reliable and efficient.
|
|         Input: toplevel - the toplevel object created by
|			    xvw_create_application_shell(),
|			    xvw_create_transient_shell().
|        Output:
|	Returns:
|    Written By: Mark Young
|          Date: Oct 20, 1993
| Modifications: 
|
----------------------------------------------------------------*/

void xvw_add_toplevel(
   xvobject toplevel)
{
	/*
	 *  the node to destroy is first in the list
	 */
	xvw_toplevels = klist_add(xvw_toplevels, toplevel, NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: xvw_remove_toplevel - remove a toplevel object
|
|       Purpose: Every time a toplevel object is destroyed by one of the
|                exiting callbacks in xvutils, we must delete it  from the
|                xvw_toplevels list.  The toplevel object was created by the
|                xvw_create_application_shell(), xvw_create_transient_shell().
|                The toplevel is now being destroyed by the destroy callback
|                that requires that we delete it out of the toplevel list.
|
|         Input: toplevel - the toplevel remove created by
|			    xvw_create_application_shell(),
|			    xvw_create_transient_shell().
|
|        Output:
|       Returns:
|    Written By: Mark Young
|          Date: Oct 20, 1993
| Modifications:
|
------------------------------------------------------------*/

void xvw_remove_toplevel(
   xvobject toplevel)
{
        /*
         *  the node to destroy is first in the list
         */
        xvw_toplevels = klist_delete(xvw_toplevels, toplevel);
}
