 /* Khoros: $Id$ */
 /* $Log$ */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for xvwidgets library
   >>>>
   >>>>    Written By: Mark Young & Danielle Argiro
   >>>>
   >>>>          Date: Jul 14, 1992
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvwidgets_internals_h_
#define _xvwidgets_internals_h_


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

#include <design.h>
#include <kutils/kvarargs.h>
#include <xvinclude.h>
#include <X11/IntrinsicP.h>
#include <X11/Xresource.h>
#include <X11/CoreP.h>

/*
 *  includes for sundry X11 Calls
 */
#include <X11/keysym.h>
#include <X11/Xmu/Xmu.h>


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/
/*
 *  xvforms window or object
 */
#define XVF_WINDOW 1
#define XVF_WIDGET 2


	/*-------------------------------------*
	|       #macros 
	---------------------------------------*/

#define widname(value) (((value)->widname != NULLQUARK) ? \
			 (value)->widname : (value)->xvwname)
#define xvwname(value) (((value)->xvwname != NULLQUARK) ? \
			 (value)->xvwname : (value)->widname)
#define widres(value)  (((value)->widres != NULLQUARK) ? \
			 (value)->widres : (value)->xvwres)
#define xvwres(value)  (((value)->xvwres != NULLQUARK)  ? \
		         (value)->xvwres : (value)->widres)


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef struct
{
	XrmQuark  xvwname;
	XrmQuark  widname;
	XrmQuark  xvwres;
	XrmQuark  widres;
	kfunc_int setroutine;
	kfunc_int getroutine;
} CompiledAttribute;

typedef struct
{
        xvclass     object_class;
        int         num_attributes;
        xvattribute *attributes;
        CompiledAttribute **compiled;
} CompiledList;

/*
 *  definition for local _xvobject structure which is the xvobject
 */
struct _xvobject
{
	Widget   widget;
	xvobject busy;
	kbool    created_toplevel;

	klist  *events;
	klist  *callbacks;
	klist  *actions;
	klist  *detectfile;
	klist  *detectfid;
	klist  *timeouts;
};

/*
 *  definition used by the xvw_fork() & xvw_expression() to execute
 *  processes.
 */
typedef struct _xvw_signal
{
	int    pid;
	kaddr  data;
	void   (*routine)();

	XtInputId    inputid;
	kfile	     *file;
	char	     *error;

	struct _xvw_signal *next, *prev;
} xvw_signal;



	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

/*
 *  initialize the resources quarks...
 */
extern XrmQuark XtQstring;
extern XrmQuark XtQfont;
extern XrmQuark XtQfontStruct;
extern XrmQuark XtQpixmap;
extern XrmQuark XtQdouble;
extern XrmQuark XtQfloat;
extern XrmQuark XtQfilename;

/*
 *  temporary hack for xvobjects globals...
 *  see "globals.c" for definitions
 */
extern char  **xvw_av;
extern int     xvw_ac;
extern klist   *xvw_toplevels;

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* compiled.c */
CompiledAttribute *xvw_findcompiled PROTO((xvclass, xvclass, XrmQuark));

int xvw_addcompiled_attributes     PROTO((xvclass, xvattribute *, int));
int xvw_addcompiled_constraints    PROTO((xvclass, xvattribute *, int));
int xvw_definecompiled_attributes  PROTO((xvclass, kstring, kstring, 
                                         kfunc_int, kfunc_int));
int xvw_definecompiled_constraints PROTO((xvclass, kstring, kstring, 
                                         kfunc_int, kfunc_int));
int xvw_copy_attributes		   PROTO((xvobject, Arg *, int *));

/* convert.c */
int xvw_convert_resource PROTO((xvobject, char *, kaddr, char *, kaddr));

/* converter.c */
void xvw_init_converters PROTO((void));

/* error.c */
void xvw_init_errors      PROTO((void));

/* jp.c */
void xvw_jp_initialize     PROTO((void));
void xvw_jp_start_playback PROTO((void));

/* jp_playback.c */
int xvw_jp_elapsed_time PROTO((int *));
int xvw_jp_playback     PROTO((XEvent *));

/* jp_record.c */
void xvw_jp_record PROTO((XEvent *, char *, int, int));

/* jp_util.c */
void     xvw_popup_control        PROTO((xvobject, kaddr, XEvent *));
Window   xvw_find_window          PROTO((Window, char *, int *));
xvobject xvw_find_object          PROTO((Window, char *));
xvobject xvw_find_toplevel_object PROTO((char *));
xvobject xvw_create_jp_control    PROTO((void));

/* signal.c */
xvw_signal *xvw_add_handler    PROTO((kfunc_void, kaddr, kfile *));
void       xvw_remove_handler  PROTO((int));

char *xvw_find_name               PROTO((Window, int *, int *));

#endif /* _xvwidgets_internals_h_ */
/* Don't add after this point */
