 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Compile Attribute Utilities
   >>>>
   >>>>   Static:
   >>>>             addcompiled_attributes()
   >>>>  Private:
   >>>>             xvw_findcompiled()
   >>>>             xvw_definecompiled_attributes()
   >>>>             xvw_definecompiled_constraints()
   >>>>             xvw_addcompiled_attributes()
   >>>>             xvw_addcompiled_constraints()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include "xvw_attrib.h"  /* general xvobject attributes declaration */

static klist *attribute_list  = NULL;
static klist *constraint_list = NULL;


/*-----------------------------------------------------------
|
|  Routine Name: copy_to_arg - copy to the argument value
|
|       Purpose: This routine is used to copy data into the arg value
|		 structure.
|
|         Input: list - the attribute or constraint list to add to
|		 object_class - the object class to add for
|		 attributes   - the attributes to be associated with the
|				object class
|		 num_attributes - the number of attributes
|
|        Output: none
|	Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young and John Salas
|          Date: Aug 14, 1992 17:33
| Modifications:
|
------------------------------------------------------------*/

static void copy_to_arg(
   kaddr    src,
   XtArgVal *dest,
   unsigned int size)
{
        if (size == sizeof(long))
	   *dest = (XtArgVal)*(long*)src;
        else if (size == sizeof(short))
	   *dest = (XtArgVal)*(short*)src;
        else if (size == sizeof(char))
	   *dest = (XtArgVal)*(char*)src;
        else if (size == sizeof(XtPointer))
	   *dest = (XtArgVal)*(XtPointer*)src;
        else if (size == sizeof(char*))
	   *dest = (XtArgVal)*(char**)src;
        else if (size == sizeof(XtArgVal))
	   *dest = *(XtArgVal*)src;
        else
	   kmemcpy((char *) dest, (char *) src, (unsigned) size);
}


/*-----------------------------------------------------------
|
|  Routine Name: addcompiled_attributes - adds the compiled
|			attributes associated with a object
|
|       Purpose: This routine is used to add the compiled attributes
|		 associated with a given object class.  The routine
|		 searches the static compiled_list which contains the
|		 class, original set of attributes, and the compiled
|		 attributes.
|
|         Input: list - the attribute or constraint list to add to
|		 object_class - the object class to add for
|		 attributes   - the attributes to be associated with the
|				object class
|		 num_attributes - the number of attributes
|
|        Output: none
|	Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young and John Salas
|          Date: Aug 14, 1992 17:33
| Modifications:
|
------------------------------------------------------------*/

static int addcompiled_attributes(
   klist       **list,
   xvclass     object_class,
   xvattribute *attributes,
   int         num_attributes)
{
	static initialized = FALSE;

	int i, num = 0;
	klist *templist;
	CompiledList *temp = NULL;
	CompiledAttribute *entry, **compiled = NULL;


	if (!initialized)
	{
	   initialized = TRUE;
	   (void) addcompiled_attributes(&attribute_list, NULL, xvw_attributes,
			num_xvw_attributes);

	   xvw_define_attributes(NULL,
	    XVW_MENU_FORMFILE, XtRString, xvw_set_menuinfo, xvw_get_menuinfo,
	    XVW_MENU_CLIENTDATA, XtRPointer, xvw_set_menuinfo, xvw_get_menuinfo,
	    XVW_CHAR_XPOS, XtRFloat, xvw_set_chargeom, xvw_get_chargeom,
	    XVW_CHAR_YPOS, XtRFloat, xvw_set_chargeom, xvw_get_chargeom,
	    XVW_CHAR_XSNAP, XtRFloat, xvw_set_chargeom, xvw_get_chargeom,
	    XVW_CHAR_YSNAP, XtRFloat, xvw_set_chargeom, xvw_get_chargeom,
	    XVW_CHAR_WIDTH, XtRFloat, xvw_set_chargeom, xvw_get_chargeom,
	    XVW_CHAR_HEIGHT, XtRFloat, xvw_set_chargeom, xvw_get_chargeom,
	    XVW_CHAR_MIN_WIDTH, XtRFloat, xvw_set_chargeom, xvw_get_chargeom,
	    XVW_CHAR_MIN_HEIGHT, XtRFloat, xvw_set_chargeom, xvw_get_chargeom,
	    XVW_CHAR_MAX_WIDTH, XtRFloat, xvw_set_chargeom, xvw_get_chargeom,
	    XVW_CHAR_MAX_HEIGHT, XtRFloat, xvw_set_chargeom, xvw_get_chargeom,
	    NULL);
	}

	if ((templist = klist_locate(*list, (kaddr) object_class)) != NULL)
	{
	   temp = (CompiledList *) templist->client_data;
	   compiled = temp->compiled;
	   num  = temp->num_attributes;
	}

	/*
	 *  Compile the new attributes into the newly created compiled
	 *  attributes structure.
	 */
	for (i = 0; i < num_attributes && attributes; i++)
	{
	   if ((entry = (CompiledAttribute *) kcalloc(1,
			sizeof(CompiledAttribute))) == NULL)
	   {
	      kerror("xvwidgets", "addcompiled_attributes",
		  "Cannot allocate memory for a Compiled Attribute structure");
	      kfree(compiled);
	      return(FALSE);
	   }
	   entry->xvwname  = XrmStringToQuark(attributes[i].xvwname);
	   entry->widname = XrmStringToQuark(attributes[i].widname);
	   entry->xvwres   = XrmStringToQuark(attributes[i].xvwres);
	   entry->widres  = XrmStringToQuark(attributes[i].widres);
	   compiled = (CompiledAttribute **) karray_add((char **) compiled,
							entry, i+num);
	}

	if (temp == NULL)
	{
	   if ((temp=(CompiledList *) kcalloc(1, sizeof(CompiledList))) == NULL)
	   {
	      kerror("xvwidgets", "addcompiled_attributes",
		  "Cannot allocate memory for CompiledList structure");
	      return(FALSE);
	   }
	   temp->object_class   = object_class;
	   temp->num_attributes = num_attributes;
	   temp->attributes     = attributes;
	   temp->compiled       = compiled;
	   *list = klist_add(*list, (kaddr) object_class, (kaddr) temp);
	}
	else
	{
	   temp->compiled = compiled;
	   temp->num_attributes += num_attributes;
	}
	return(FALSE);
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_findcompiled - find the compiled attribute
|
|       Purpose: This routine is used to look thru the compiled attribute
|		 list for the desired object class.  The routine searches
|		 the static attribute_list and constraint_list which contains
|		 the class, original set of attributes, and the compiled
|		 attributes.
|
|         Input: wclass - the object's object class to search the
|			  attributes for
|		 pclass - the parent's object class to search the
|			  constraint attributes for
|		 quark  - the name to search for
|
|        Output:
|	Returns: compiled attribute on success, NULL otherwise
|
|    Written By: Mark Young
|          Date: Dec 10, 1992 14:20
| Modifications:
|
------------------------------------------------------------*/

CompiledAttribute *xvw_findcompiled(
   xvclass wclass,
   xvclass pclass,
   XrmQuark    quark)
{
	klist *entry;
	register int i;
	CompiledList *temp;
	register CompiledAttribute **compiled;


	if ((entry = klist_locate(attribute_list, wclass)) != NULL)
	{
	   temp = (CompiledList *) entry->client_data;
	   for (i = 0, compiled = temp->compiled; i < temp->num_attributes; i++,
		compiled++)
	   {
	      if (xvwname(*compiled) == quark) 
		 return(*compiled);
	   }
	}

	/*
	 *  Find the compiled attribute list associated with the specified
	 *  object class.
	 */
	if (pclass && (entry = klist_locate(constraint_list, pclass)) != NULL)
	{
	   temp = (CompiledList *) entry->client_data;
	   for (i = 0, compiled = temp->compiled; i < temp->num_attributes; i++,
		compiled++)
	   {
	      if (xvwname(*compiled) == quark) 
		 return(*compiled);
	   }
	}

	if (wclass != NULL || pclass != NULL)
	{
	   if (wclass) wclass = wclass->core_class.superclass;
	   if (pclass) pclass = pclass->core_class.superclass;
	   return(xvw_findcompiled(wclass, pclass, quark));
	}
	return(NULL);
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_addcompiled_attributes - add compiled attributes for
|					      a object class
|
|       Purpose: This routine adds compiled attributes to the
|		 object class.  The compiled attributes are used to
|		 initialize the internal menus as well as inter-
|		 face to the xvw_set_attributes()/xvw_get_attributes().
|
|         Input: object_class   - the object class to retrieve the
|				  attributes for
|                attributes     - the compiled attributes to be added.
|                num_attributes - the number of compiled attributes
|				  to be added.
|
|        Output: none
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young and John Salas
|          Date: Oct 28, 1992 16:34
| Modifications:
|
------------------------------------------------------------*/

int xvw_addcompiled_attributes(
   xvclass     object_class,
   xvattribute *attributes,
   int         num_attributes)
{
	if (object_class == NULL)
	{
	   kerror("xvwidgets", "xvw_addcompiled_attributes",
		  "xvobject Class is set to NULL therefore attributes can be \
compiled");
	   return(FALSE);
	}

	if (!klist_locate(attribute_list, object_class))
	   return(addcompiled_attributes(&attribute_list, object_class,
			attributes, num_attributes));
	else
	   return(FALSE);
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_addcompiled_constraints - add compiled constraint
|					      attributes for a object class
|
|       Purpose: This routine adds compiled attributes to the
|		 object.  The compiled attributes are used to
|		 initialize the internal menus as well as inter-
|		 face to the xvw_set_attributes()/xvw_get_attributes().
|
|         Input: object_class   - the object class to retrieve the
|				  attributes for
|                attributes     - the compiled attributes to be added.
|                num_attributes - the number of compiled attributes
|				  to be added.
|
|        Output: none
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young and John Salas
|          Date: Oct 28, 1992 16:34
| Modifications:
|
------------------------------------------------------------*/

int xvw_addcompiled_constraints(
   xvclass object_class,
   xvattribute *constraints,
   int         num_constraints)
{
	if (object_class == NULL)
	{
	   kerror("xvwidgets", "xvw_addcompiled_constraints",
		  "xvobject Class is set to NULL therefore attributes can be \
compiled");
	   return(0);
	}

	if (!klist_locate(constraint_list, object_class))
	   return(addcompiled_attributes(&constraint_list, object_class,
			constraints, num_constraints));
	else
	   return(0);
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_definecompiled_attributes - define compiled attributes for
|					      a object class
|
|       Purpose: This routine defines compiled attributes to the
|		 object class.  The compiled attributes are used to
|		 initialize the internal menus as well as inter-
|		 face to the xvw_set_attributes()/xvw_get_attributes().
|
|         Input: object_class   - the object class to retrieve the
|				  attributes for
|		 attribute_name - the attribute to be added
|		 resource_type  - the resource type
|		 setroutine     - the routine to call when xvw_set_attributes()
|				  is called
|		 getroutine     - the routine to call when xvw_get_attributes()
|				  is called.
|
|        Output: none
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young and John Salas
|          Date: Dec 10, 1992 15:06
| Modifications:
|
------------------------------------------------------------*/

int xvw_definecompiled_attributes(
   xvclass object_class,
   kstring      attribute_name,
   kstring      resource_type,
   kfunc_int   setroutine,
   kfunc_int   getroutine)
{
	int i, num = 0;
	klist *templist;
	CompiledList *temp = NULL;
	XrmQuark xvwname = XrmStringToQuark(attribute_name);
	CompiledAttribute *entry = NULL, **compiled = NULL;


	if ((templist = klist_locate(attribute_list,
			(kaddr) object_class)) != NULL)
	{
	   temp = (CompiledList *) templist->client_data;
	   compiled = temp->compiled;
	   num  = temp->num_attributes;
	   for (i = 0; i < num; i++)
	   {
	       if (compiled[i]->xvwname == xvwname)
	       {
		  entry = compiled[i];
		  break;
	       }
	   }
	}

	/*
	 *  Compile the new attributes into the newly created compiled
	 *  attributes structure.
	 */
	if (entry == NULL)
	{
	   if ((entry = (CompiledAttribute *) kcalloc(1,
				sizeof(CompiledAttribute))) == NULL)
	   {
	      kerror("xvwidgets", "addcompiled_attributes",
		  "Cannot allocate memory for a Compiled Attribute structure");
	      kfree(compiled);
	      return(FALSE);
	   }
	   compiled = (CompiledAttribute **) karray_add((char **) compiled,
							entry, num);
	   entry->xvwname = xvwname;
	   if (temp != NULL)
	   {
	      temp->compiled = compiled;
	      temp->num_attributes += 1;
	   }
	}
	entry->xvwres = XrmStringToQuark(resource_type);
	entry->setroutine = setroutine;
	entry->getroutine = getroutine;

	if (temp == NULL)
	{
	   if ((temp=(CompiledList *) kcalloc(1, sizeof(CompiledList))) == NULL)
	   {
	      kerror("xvwidgets", "addcompiled_attributes",
		  "Cannot allocate memory for CompiledList structure");
	      return(FALSE);
	   }
	   temp->object_class   = object_class;
	   temp->num_attributes = 1;
	   temp->compiled       = compiled;
	   attribute_list = klist_add(attribute_list, (kaddr) object_class,
			(kaddr) temp);
	}
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: xvw_definecompiled_constraints - define compiled constraint
|				attributes for a object class
|
|       Purpose: This routine defines compiled constraint attributes to the
|		 object class.  The compiled constraint attributes are used to
|		 initialize the internal menus as well as inter-
|		 face to the xvw_set_attributes()/xvw_get_attributes().
|
|         Input: object_class   - the object class to retrieve the
|				  constraint attributes for
|		 attribute_name - the attribute to be added
|		 resource_type  - the resource type
|		 setroutine     - the routine to call when xvw_set_attributes()
|				  is called
|		 getroutine     - the routine to call when xvw_get_attributes()
|				  is called.
|
|        Output: none
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Dec 06, 1994
| Modifications:
|
------------------------------------------------------------*/

int xvw_definecompiled_constraints(
   xvclass object_class,
   kstring      attribute_name,
   kstring      resource_type,
   kfunc_int   setroutine,
   kfunc_int   getroutine)
{
	int i, num = 0;
	klist *templist;
	CompiledList *temp = NULL;
	XrmQuark xvwname = XrmStringToQuark(attribute_name);
	CompiledAttribute *entry = NULL, **compiled = NULL;


	if ((templist = klist_locate(constraint_list,
			(kaddr) object_class)) != NULL)
	{
	   temp = (CompiledList *) templist->client_data;
	   compiled = temp->compiled;
	   num  = temp->num_attributes;
	   for (i = 0; i < num; i++)
	   {
	       if (compiled[i]->xvwname == xvwname)
	       {
		  entry = compiled[i];
		  break;
	       }
	   }
	}

	/*
	 *  Compile the new attributes into the newly created compiled
	 *  attributes structure.
	 */
	if (entry == NULL)
	{
	   if ((entry = (CompiledAttribute *) kcalloc(1,
				sizeof(CompiledAttribute))) == NULL)
	   {
	      kerror("xvwidgets", "addcompiled_constraints",
		  "Cannot allocate memory for a Compiled Attribute structure");
	      kfree(compiled);
	      return(FALSE);
	   }
	   compiled = (CompiledAttribute **) karray_add((char **) compiled,
							entry, num);
	   entry->xvwname = xvwname;
	   if (temp != NULL)
	   {
	      temp->compiled = compiled;
	      temp->num_attributes += 1;
	   }
	}
	entry->xvwres = XrmStringToQuark(resource_type);
	entry->setroutine = setroutine;
	entry->getroutine = getroutine;

	if (temp == NULL)
	{
	   if ((temp=(CompiledList *) kcalloc(1, sizeof(CompiledList))) == NULL)
	   {
	      kerror("xvwidgets", "addcompiled_constraints",
		  "Cannot allocate memory for CompiledList structure");
	      return(FALSE);
	   }
	   temp->object_class   = object_class;
	   temp->num_attributes = 1;
	   temp->compiled       = compiled;
	   constraint_list = klist_add(constraint_list, (kaddr) object_class,
			(kaddr) temp);
	}
	return(TRUE);
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_copy_attributes - copy the attributes of an object
|
|       Purpose: copy the attributes of a widget.
|
|         Input: object - object to copy attributes for
|        Output: args   - the arg structure in which to store the attributes
|		 num    - the number of attributes copied
|
|	Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Feb 23, 1993 08:33
| Modifications:
|
------------------------------------------------------------*/

static int copy_attributes(
   Widget   widget,
   xvobject object,
   XtResourceList resources,
   Cardinal num_resources,
   XtResourceList constraints,
   Cardinal num_constraints,
   Arg      *args,
   int      *num)
{
	xvclass wclass, pclass;

	XrmQuark     quark;
	CompiledList *temp;
	klist	     *entry;
	int	     i, j, count;
	char	     dest[KLENGTH];
	CompiledAttribute **compiled;


	count = 0;
	wclass = xvw_class(object);

	if ((entry = klist_locate(attribute_list, wclass)) != NULL)
	{
	   temp = (CompiledList *) klist_clientdata(entry);

	   for (i = 0, compiled = temp->compiled; i < temp->num_attributes; i++,
		compiled++)
	   {
	      /*
	       *  xvw_define_attribute sets a getroutine in which to get
	       *  the resource value.  This *will not* work with the
	       *  XtVaGetValues() routine used below.  Hence, if a getroutine
	       *  is defined, we need to skip this resource and move onto the
	       *  next one.
	       */
	      if ((*compiled)->getroutine != NULL)
		 continue;

	      quark = widname(*compiled);
	      for (j = 0; j < num_resources; j++)
	      {
		 /*
		  *  Find the resource from which to copy the attribute.
		  */
		 if (XrmStringToName(resources[j].resource_name) == quark)
		 {
		    /*
		     *  We found the corresponding Xt attribute.  Now we can
		     *  use XtVaGetValues() to get the value from the widget.
		     */
	            args->name = resources[j].resource_name;
	            XtVaGetValues(widget, args->name, dest, NULL);
		    copy_to_arg(dest, &args->value, resources[j].resource_size);
		    count++; args++;
		    break;
		 }
	      }
	   }
	}

	pclass = xvw_class(xvw_parent(object));
	if ((entry = klist_locate(constraint_list, pclass)) != NULL)
	{
	   temp = (CompiledList *) klist_clientdata(entry);
	   for (i = 0, compiled = temp->compiled; i < temp->num_attributes; i++,
		compiled++)
	   {
              quark = widname(*compiled);
              for (j = 0; j < num_constraints; j++)
              {
                 if (XrmStringToName(constraints[i].resource_name) == quark)
                 {
                    args->name = constraints[j].resource_name;
                    XtVaGetValues(widget, args->name, dest, NULL);
		    copy_to_arg(dest,&args->value,constraints[j].resource_size);
		    count++; args++;
                    break;
                 }
              }
	   }
	}

	if (wclass || pclass)
	{
	   copy_attributes(widget, xvw_parent(object), resources, num_resources,
			constraints, num_constraints, args, &i);
	   count += i;
	}
	if (num) *num = count;
	return(TRUE);
}

int xvw_copy_attributes(
   xvobject object,
   Arg      *args,
   int      *num)
{
	Widget	    widget = xvw_widget(object);
	xvclass class  = xvw_class(object);
	XtResourceList resources, constraints;
	Cardinal num_resources, num_constraints;

	XtGetResourceList(class, &resources, &num_resources);
	XtGetConstraintResourceList(class, &constraints, &num_constraints);
	copy_attributes(widget, object, resources, num_resources,
			constraints, num_constraints, args, num);

	XtFree((XtPointer) resources);
	XtFree((XtPointer) constraints);
	return(TRUE);
}
