 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>		       Info Display			      <<<<
   >>>>                                                       <<<<
   >>>>  Private:      xvu_info()			      <<<<              
   >>>>                                                       <<<<
   >>>>   Static:      xvu_info_ok()		              <<<<              
   >>>>                                                       <<<<
   >>>>   Public:      xvu_info_wait()			      <<<<              
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"	

static int xvu_info_done;

/*-----------------------------------------------------------
|
|  Routine Name: xvu_info_ok()
|
|       Purpose: Destroys the info object when the user clicks 
|                on the acknowledgement button.
|
|         Input: object      - the acknowledgement button
|                client_data - toplevel of info object
|		 call_data   - unused
|
|        Output:
|    Written By: Danielle Argiro & Mark Young
|          Date: Jan 4, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void xvu_info_ok(
   xvobject object,
   kaddr  client_data,
   kaddr  call_data)
{
	xvu_info_done = TRUE;
}

/*-----------------------------------------------------------------
|
|  Routine Name: xvu_info
|
|       Purpose: xvu_info produces standardized info messages for
|                X-based Khoros library routines and X based Khoros 
|                applications.  It will be set up as the info
|		 handler for kinfo in all X-based Khoros routines by
|                xvf_initialize().
|
|         Input: toolbox   - name of toolbox (if applicable)
|                program   - name of program (if applicable, NULL otherwise)
|                library   - name of library (if applicable, NULL otherwise)
|                routine   - name of routine
|                category  - name of info message category (~/vinfos.h)
|                message   - grammatically correct, clear explanation of
|                            the info that occurred
|        Output:
|    Written By: Danielle Argiro & Mark Young
|          Date: Jan 4, 1994
| Modifications:
|
--------------------------------------------------------------*/

int xvu_info(
   char *message)
{
	knotify handler;

	handler = kset_infohandler(NULL);
	xvu_info_wait(message, "Information:", NULL);

	(void) kset_infohandler(handler);
        return(TRUE);
}


/**************************************************************
*
*  Routine Name: xvu_info_wait - pop up info object (1 button); wait for
*				 acknowledgement
*
*       Purpose: Creates a pop-up info object which must be acknowledged 
*                by the user before control is returned to the application 
*                program.  
*
*                IMPORTANT NOTE: to be consistent with the standards
*                of the Khoros Software development system, you should really
*                be calling kinfo(), not xvu_info_wait().  
*
*         Input: info_mesg   - string describing info message
*                info_label  - short label for top of info object; passing 
*                               NULL will result in default of "Information".
*		 button_label - label for acknowledgment button; passing
*                               NULL will result in default of "Ok".
*        Output:
*	Returns: Returns FALSE if it failed to create the info object
*		 otherwise waits for user to acknowledge info message,
*    Written By: Danielle Argiro & Mark Young
*          Date: Jan 4, 1994
*      Verified:
*  Side Effects:
* Modifications:
*
**************************************************************/

int xvu_info_wait(
   char *info_mesg,
   char *info_label,
   char *button_label)
{
	knotify  handler;
	char     name[KLENGTH];
	xvobject info, button = NULL;


        /*
         *  xvu_info_wait supports non-X displays
         */
	xvu_info_done = FALSE;
	if (xvw_display(NULL) == NULL)
	{
	    kinfo(KSTANDARD, "%s\n", info_mesg);
	    return(TRUE);
	}

	/*
	 *  xvw_create_info creates the info object pop-up
	 */
	xvw_busy(NULL, TRUE);
	handler = kset_infohandler(NULL);

	(void) ksprintf(name, "Information for %s", kprog_get_program());
	if ((info = xvw_create_info(NULL, name)) == NULL)
	{
	   (void) kset_infohandler(handler);
	    xvw_busy(NULL, FALSE);
	   return(FALSE);
	}
	xvw_set_attributes(info,
		XVW_INFO_MESSAGE, info_mesg,
		XVW_INFO_LABEL,   info_label ? info_label : "Information",
		XVW_INFO_BUTTON_LABEL, button_label ? button_label : "Ok",
		NULL);
	xvw_add_callback(info, XVW_INFO_CALLBACK, xvu_info_ok, NULL);
	xvw_get_attribute(info, XVW_INFO_BUTTON_OBJECT, &button);

	(void) kset_infohandler(handler);
	xvw_place(info, button);
	while (!xvu_info_done)
	    xvw_process_event();  

	xvw_busy(NULL, FALSE);
	return(TRUE);
}
