 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Integer GUI Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>>			Initialize()
   >>>> 		SetValues()
   >>>> 		ActionCallback()
   >>>> 		ScrollbarCallback()
   >>>>   Public:
   >>>>			xvw_create_integer()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvobjects/IntegerP.h>

static Boolean	SetValues       PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static void     ClassInitialize PROTO((void));
static void	Initialize	PROTO((Widget, Widget, ArgList, Cardinal *));
static void	ActionCallback  PROTO((xvobject, kaddr));
static void     ScrollbarCallback PROTO((xvobject, kaddr, kaddr));



/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_INTEGER_LABEL_OBJECT,     NULL,   XtRPointer,  NULL},
{XVW_INTEGER_CRLABEL_OBJECT,   NULL,   XtRPointer,  NULL},
{XVW_INTEGER_SCROLLBAR_OBJECT, NULL,   XtRPointer,  NULL},
{XVW_INTEGER_TEXT_OBJECT,      NULL,   XtRPointer,  NULL},
{XVW_INTEGER_VALUE,            NULL,   XtRInt,      NULL},
{XVW_INTEGER_MINVALUE,         NULL,   XtRInt,      NULL},
{XVW_INTEGER_MAXVALUE,         NULL,   XtRInt,      NULL},
{XVW_INTEGER_CALLBACK,	       NULL,   XtRCallback, NULL},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwIntegerWidgetRec, integerpart.field)

static XtResource resources[] = { 
{XVW_INTEGER_VALUE, NULL, XtRInt, sizeof(int),
        offset(value), XtRString, (XtPointer) "0"},
{XVW_INTEGER_MINVALUE, NULL, XtRInt, sizeof(int),
        offset(minvalue), XtRString, (XtPointer) "0"},
{XVW_INTEGER_MAXVALUE, NULL, XtRInt, sizeof(int),
        offset(maxvalue), XtRString, (XtPointer) "100"},
{XVW_INTEGER_LABEL_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(label), XtRImmediate, (XtPointer) NULL},
{XVW_INTEGER_TEXT_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(text), XtRImmediate, (XtPointer) NULL},
{XVW_INTEGER_SCROLLBAR_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(scrollbar), XtRImmediate, (XtPointer) NULL},
{XVW_INTEGER_CRLABEL_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(crlabel), XtRImmediate, (XtPointer) NULL},
{XVW_INTEGER_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(integer_callback), XtRCallback, (XtPointer) NULL},

{XVW_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwIntegerWidgetRec, core.width),
        XtRImmediate, (XtPointer) 300 },
{XVW_BORDER_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwIntegerWidgetRec, core.border_width),
        XtRImmediate, (XtPointer) 0 },
{XVW_BUFFER_DIST, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwIntegerWidgetRec, manager.buffer_dist),
        XtRImmediate, (XtPointer) 0 },
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Integer Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwManagerWidgetClassRec)

XvwIntegerWidgetClassRec xvwIntegerWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Integer",				/* class_name		  */
    sizeof(XvwIntegerWidgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwIntegerWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwIntegerWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwIntegerWidgetClass = (WidgetClass) &xvwIntegerWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for widget definition
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	     (XvwIntegerWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwIntegerWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|         Input:
|
|        Output:
|       Returns: 
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwIntegerWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/Integer");
}


/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial interger widget instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|
|	 Output: None
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwIntegerWidget xwid = kwidget(new);
	xvobject object = xvw_object(new);

	char temp[KLENGTH];

	xwid->integerpart.label = xvw_create_labelstr(object, "label");
	xvw_set_attributes(xwid->integerpart.label,
		XVW_LABEL,	      "Integer:",
		XVW_CHAR_MAX_HEIGHT,  1.0,
		XVW_LABEL_JUSTIFY,    KLABEL_JUSTIFY_LEFT,
		XVW_BORDER_WIDTH,     0,
		XVW_RIGHT_OF,	      NULL,
		XVW_ABOVE,	      NULL,
		XVW_BELOW,	      NULL,
		NULL);

	xwid->integerpart.crlabel = xvw_create_pixmap(object, "cr_pixmap");
	xvw_set_attributes(xwid->integerpart.crlabel,
		XVW_BORDER_WIDTH,     0,
		XVW_LEFT_OF,	      NULL,
		XVW_ABOVE,	      NULL,
		XVW_BELOW,	      NULL,
		NULL);

	(void) ksprintf(temp, "%d", xwid->integerpart.value);
	xwid->integerpart.text = xvw_create_text(object, "text");
	xvw_set_attributes(xwid->integerpart.text,
		XVW_TEXT_STRING,      temp,
		XVW_TEXT_MULTILINE,   FALSE,
		XVW_CHAR_MAX_HEIGHT,  1.0,
		XVW_CHAR_WIDTH,	      10.0,
		XVW_BORDER_WIDTH,     2,
		XVW_LEFT_OF,	      xwid->integerpart.crlabel,
		XVW_ABOVE,	      NULL,
		XVW_BELOW,	      NULL,
		NULL);

	xwid->integerpart.scrollbar = xvw_create_scrollbar(object, "scrollbar");
	xvw_set_attributes(xwid->integerpart.scrollbar,
		XVW_CHAR_MAX_HEIGHT,  1.0,
		XVW_SCROLL_VALUE,     (double) xwid->integerpart.value,
		XVW_SCROLL_MIN,       (double) xwid->integerpart.minvalue,
		XVW_SCROLL_MAX,	      (double) xwid->integerpart.maxvalue,
		XVW_LEFT_OF,	      xwid->integerpart.text,
		XVW_RIGHT_OF,	      xwid->integerpart.label,
		XVW_TACK_EDGE,	      KMANAGER_TACK_HORIZ,
		XVW_ABOVE,	      NULL,
		XVW_BELOW,	      NULL,
		NULL);

	xvw_set_attributes(object,
		XVW_CHAR_MAX_HEIGHT, 1.0,
		XVW_CHAR_MIN_HEIGHT, 1.0,
		XVW_BORDER_WIDTH,    0,
		NULL);

	xvw_add_action(xwid->integerpart.text, "<Key>Return", ActionCallback,
		object, TRUE);
	xvw_insert_callback(xwid->integerpart.scrollbar, XVW_SCROLL_CONT_MOTION,
			 FALSE, ScrollbarCallback, (XtPointer) object);
	xvw_insert_callback(xwid->integerpart.scrollbar, XVW_SCROLL_INCR_MOTION,
			 FALSE, ScrollbarCallback, (XtPointer) object);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwIntegerWidget instance.  The public values
|                which can be changed are all related to the display
|		 of the interger.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output:
|       Returns:
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwIntegerWidget cxwid = kwidget(current);
	XvwIntegerWidget nxwid = kwidget(new);

	char temp[KLENGTH];

	if (cxwid->integerpart.value    != nxwid->integerpart.value ||
	    cxwid->integerpart.minvalue != nxwid->integerpart.minvalue ||
	    cxwid->integerpart.maxvalue != nxwid->integerpart.maxvalue)
	{
	   xvw_set_attributes(nxwid->integerpart.scrollbar,
		XVW_SCROLL_MIN,    (double) nxwid->integerpart.minvalue,
		XVW_SCROLL_VALUE,  (double) nxwid->integerpart.value,
		XVW_SCROLL_MAX,    (double) nxwid->integerpart.maxvalue,
		NULL);

	   ksprintf(temp, "%d", nxwid->integerpart.value);
	   xvw_set_attribute(nxwid->integerpart.text, XVW_TEXT_STRING, temp);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ActionCallback
|
|       Purpose: This routine will be called when the user presses return
|		 within the text window.
|
|         Input: text      - which text being manipulated
|                client_data - the interger gui object
|
|        Output: None
|       Returns: None
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ActionCallback(
   xvobject text,
   kaddr    client_data)
{
	xvobject object = (xvobject) client_data;
	XvwIntegerWidget xwid = (XvwIntegerWidget) xvw_widget(object);

	int value;
	char *tmp = NULL;

	xvw_get_attribute(text, XVW_TEXT_STRING, &tmp);
	(void) ksscanf(tmp, "%d", &value);
	xvw_set_attribute(object, XVW_INTEGER_VALUE, value);
	XtCallCallbacks(xvw_widget(object), XVW_INTEGER_CALLBACK,
		&xwid->integerpart.value);
}

/*-----------------------------------------------------------
|
|  Routine Name: ScrollbarCallback
|
|       Purpose: This routine will change the text and update the
|	 	 scrollbar according to the value paased in.
|
|         Input: scrollbar      - which scrollbar being manipulated
|		 client_data - the integer gui object
|		 call_data   - double representing the scroll position
|
|        Output: None
|       Returns: None 
|
|    Written By: Mark Young 
|          Date: Jun 06, 1993 10:58
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ScrollbarCallback(
   xvobject scrollbar,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject object = (xvobject) client_data;
	XvwIntegerWidget xwid = (XvwIntegerWidget) xvw_widget(object);
	double value = *((double *) call_data);


	xvw_set_attribute(object, XVW_INTEGER_VALUE, (int) value);
	XtCallCallbacks(xvw_widget(object), XVW_INTEGER_CALLBACK,
		&xwid->integerpart.value);
}

/************************************************************
*
*  Routine Name: xvw_create_integer - create an integer GUI object
*
*       Purpose: The integer GUI object 
*                allows the user to enter a integer value.
*                It features a text box in which the user may explicitly 
*                enter the integer value;  the integer value is registered 
*                when the user hits <cr>.  The integer value may be bounded 
*                by a minimum and maximum value, if desired.
*
*                A scroll bar provides an alternate way for the user to 
*                specify the integer value.  The integer object consists of 
*                a manager object with four children: a label object, a 
*                text object, a scrollbar, and a pixmap object.  
*
*                A callback can be installed on the integer object, which
*                will be fired when the user enters a new integer value.
*
*         Input: parent - parent of the integer object; NULL will cause
*                         a default toplevel to be created automatically
*                name   - name with which to reference integer object
*
*        Output:
*       Returns: The integer object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Nov 01, 1993
*      Verified: 
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_integer(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, FALSE, TRUE, name, IntegerWidgetClass);
	return(object);
}
