 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Input Only Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>> 		Initialize()
   >>>> 		SetValues()
   >>>> 		Realize()
   >>>>
   >>>> 		SetBusy()
   >>>> 		GetBusy()
   >>>>   Public:
   >>>>			xvw_create_inputonly()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvobjects/InputOnlyP.h>

static void	Realize         PROTO((Widget, XtValueMask *, 
                                       XSetWindowAttributes *));
static void     ClassInitialize PROTO((void));
static void     Initialize      PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean	SetValues       PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
int  SetBusy	      PROTO((xvobject, char *, kaddr));
int  GetBusy	      PROTO((xvobject, char *, kaddr));


/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute *attributes = NULL;

/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwInputOnlyWidgetRec, inputonly.field)

static XtResource resources[] =
{
  {XVW_CURSOR, XVW_CURSORNAME, XtRCursor, sizeof(Cursor),
     offset(cursor), XtRImmediate, (XtPointer) None},

  {XVW_MAP_WHEN_MANAGED, NULL, XtRBoolean, sizeof(Boolean),
     XtOffsetOf(WidgetRec, core.mapped_when_managed), XtRImmediate,
     (XtPointer) FALSE},
  {XVW_WIDTH, NULL, XtRDimension, sizeof(Dimension),
     XtOffsetOf(WidgetRec, core.width), XtRImmediate, (XtPointer) 10000},
  {XVW_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
     XtOffsetOf(WidgetRec, core.height), XtRImmediate, (XtPointer) 10000},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for InputOnly Widget
|
--------------------------------------------------------------------*/

#define superclass (&widgetClassRec)

XvwInputOnlyWidgetClassRec xvwInputOnlyWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "InputOnly",			/* class_name		  */
    sizeof(XvwInputOnlyWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    Realize,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    NULL,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwInputOnlyWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwInputOnlyWidgetClass = (WidgetClass) &xvwInputOnlyWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/

#undef kwidget
#undef kwidgetclass

#define kwidget(widget)	    (XvwInputOnlyWidget) (widget)
#define kwidgetclass(widget) (XvwInputOnlyWidgetClass) (widget)->core.widget_class


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwInputOnlyWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|         Input: None
|
|        Output: None
|       Returns: None 
|
|    Written By: Mark Young
|          Date: Jul 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwInputOnlyWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/InputOnly");
	xvw_define_attribute(xvwInputOnlyWidgetClass, XVW_BUSY,
		XtRInt, SetBusy, GetBusy);
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method will set up the initial values 
|                for all the fields for a XvwManagerWidget instance.
|                It will set up an initial size, the gc used for refresh, 
|                as well as other private variables.
|		 Accelerators and Event Handlers for managing
|		 the instance's children are installed here. 
|
|         Input: request - widget instance with requested public settings 
|                new     - widget instance after initialization, with 
|                          settings initialized 
|
|        Output: none 
|       Returns: none 
|
|    Written By: Mark Young
|          Date: Aug 19, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwInputOnlyWidget xwid = kwidget(new);
	xvobject object = xvw_object(new);


	/*
	 *  Initialize the busy count to 0
	 */
	xwid->inputonly.busy = 0;
}

/*-----------------------------------------------------------
|
|  Routine Name: Realize
|
|       Purpose: This method will set up the window attributes
|                and create a window for the XvwInputOnlyWidget. 
|                The desired initial window attributes are passed 
|                in via a mask and list of specification attributes.
|		 The gc is also initialized here.
|
|         Input: widget     - the widget to realize
|                valuemask  - determines the window attributes being passed in
|                attributes - the list of window attributes to be set
|
|        Output: None
|       Returns: None 
|
|    Written By: Mark Young
|          Date: Jul 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Realize(
   Widget               widget,
   XtValueMask          *valuemask,
   XSetWindowAttributes *winattrib)
{
	XvwInputOnlyWidget xwid = kwidget(widget);

	
	*valuemask = None;
	if ((winattrib->cursor = xwid->inputonly.cursor) != None)
	   *valuemask |= CWCursor;

	widget->core.depth = 0;
	widget->core.border_width = 0;
	if (widget->core.width  == 0) widget->core.width  = 1;
	if (widget->core.height == 0) widget->core.height = 1;
	*valuemask |= CWDontPropagate;
	winattrib->do_not_propagate_mask = KeyPressMask | KeyReleaseMask |
			PointerMotionMask | ButtonPressMask | ButtonReleaseMask;

	/*
	 *  Now create the input only widget's window.
	 */
	XtCreateWindow(widget,InputOnly, CopyFromParent, *valuemask, winattrib);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwInputOnlyWidget instance.  The public values
|                which can be changed are all related to the core class. 
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output: None directly
|       Returns: None 
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Jul 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwInputOnlyWidget cxwid = kwidget(current);
	XvwInputOnlyWidget nxwid = kwidget(new);


	if (cxwid->inputonly.cursor != nxwid->inputonly.cursor &&
	    new->core.window)
	{
	   XDefineCursor(XtDisplay(new),XtWindow(new),nxwid->inputonly.cursor);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetBusy - set whether or not the input only window
|			   is busy.
|
|       Purpose: This resource attributes is used to increment or
|		 decrement the busy count.  When the busy count is
|		 zero then we unmap the input only widget.  Otherwise
|		 when the count is greater than zero we map ourselves.
|
|         Input: xvobject  - the object in which we set busy
|                attribute - the XVW_BUSY
|		 calldata  - whether we should be busy
|        Output: none
|       Returns: none 
|    Written By: Mark Young
|          Date: Jul 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int SetBusy(
   xvobject object,
   char     *attribute,
   kaddr    calldata)
{
	int	 busy = *(int *) calldata;
	Widget   widget = xvw_widget(object);
        XvwInputOnlyWidget xwid = kwidget(widget);


	if (busy)
	{
	   if (xwid->inputonly.busy == 0)
	   {
	      xvw_map(object);
	      if (xvw_check_realized(object)) xvw_raise(object);
	   }
	   xwid->inputonly.busy++;
	}
	else
	{
	   if (xwid->inputonly.busy == 1)
	      xvw_unmap(object);

	   if (xwid->inputonly.busy > 0) xwid->inputonly.busy--;
	}
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: GetBusy - return whether we are busy or not
|
|       Purpose: Resource attribute for returning whether we are busy or not.
|
|         Input: xvobject  - the object in which we inquiry about
|                attribute - the XVW_BUST
|
|        Output: calldata  - the return data indicating busy or not
|       Returns: none 
|    Written By: Mark Young
|          Date: Jun 18, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int GetBusy(
   xvobject object,
   char     *attribute,
   kaddr    calldata)
{
	int      *busy = (int *) calldata;
	Widget   widget = xvw_widget(object);
        XvwInputOnlyWidget xwid = kwidget(widget);


	/*
	 *  Return whether we are busy or not
	 */
	*busy = (xwid->inputonly.busy) ? TRUE : FALSE;
	return(TRUE);
}

/************************************************************
*
*  Routine Name: xvw_create_inputonly - create a inputonly object
*
*       Purpose: The inputonly window object is a core widget with
*		 InputOnly window attributes added.
*
*         Input: parent - parent of the input window object; NULL will cause
*                         a default toplevel to be created automatically
*                name   - name with which to reference input window object
*
*        Output: none
*       Returns: The inputonly object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Jul 01, 1993
*      Verified: 
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_inputonly(
   xvobject parent,
   char     *name)
{
	xvobject inputonly;

	inputonly = xvw_create(parent, FALSE, TRUE, name, InputOnlyWidgetClass);
	xvw_manage(inputonly);
	return(inputonly);
}

/*-----------------------------------------------------------
|
|  Routine Name: xvw_check_inputonly - checks to see if the object is of
|				       type inputonly
|
|       Purpose: Checks to see if the object is of type input-only.
|         Input: object - object to be checked.
|
|        Output: none
|       Returns: TRUE (1) if inputonly object, FALSE (0) otherwise
|
|  Restrictions:
|    Written By: Mark Young
|          Date: Jul 01, 1993
|      Verified: 
|  Side Effects:
| Modifications:
|
------------------------------------------------------------------*/
/* ARGSUSED */
int xvw_check_inputonly(
   xvobject object)
{
	return(xvw_class(object) == InputOnlyWidgetClass);
}
