 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Error Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>>			Initialize()
   >>>> 		ButtonCallback()
   >>>>   Public:
   >>>>			xvw_create_error()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvobjects/ErrorP.h>

static void     ClassInitialize PROTO((void));
static void	Initialize	PROTO((Widget, Widget, ArgList, Cardinal *));
static void	ButtonCallback  PROTO((xvobject, kaddr, kaddr));


/*-------------------------------------------------------------------*
|
|   Define Default Pixmap Paths
|
--------------------------------------------------------------------*/
 
#define ERROR_PIXMAP "$DESIGN/objects/library/xvobjects/misc/pixmaps/stopsign.xpm"

/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_ERROR_LABEL_OBJECT,   NULL,   XtRPointer,  NULL},
{XVW_ERROR_BUTTON_OBJECT,  NULL,   XtRPointer,  NULL},
{XVW_ERROR_TEXT_OBJECT,    NULL,   XtRPointer,  NULL},
{XVW_ERROR_CALLBACK,	   NULL,   XtRCallback, NULL},

{XVW_ERROR_PIXMAP,	   NULL,   XtRPixmap,   NULL},
{XVW_ERROR_PIXMAPFILE,	   XVW_ERROR_PIXMAP, XtRFilename, XtRPixmap},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwErrorWidgetRec, error.field)

static XtResource resources[] = { 
{XVW_ERROR_LABEL_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(label), XtRImmediate, (XtPointer) NULL},
{XVW_ERROR_BUTTON_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(button), XtRImmediate, (XtPointer) NULL},
{XVW_ERROR_TEXT_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(text), XtRImmediate, (XtPointer) NULL},
{XVW_ERROR_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(error_callback), XtRCallback, (XtPointer) NULL},

{XVW_ERROR_PIXMAP, XVW_ERROR_PIXMAPFILE,  XtRPixmap, sizeof(Pixmap),
        offset(error_pixmap), XtRString, (XtPointer) ERROR_PIXMAP},

};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Error Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwManagerWidgetClassRec)

XvwErrorWidgetClassRec xvwErrorWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Error",				/* class_name		  */
    sizeof(XvwErrorWidgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    NULL,    				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,				/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwErrorWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwErrorWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwErrorWidgetClass = (WidgetClass) &xvwErrorWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for widget definition
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	     (XvwErrorWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwErrorWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|         Input:
|
|        Output:
|       Returns: 
|
|    Written By: Mark Young
|          Date: Oct 19, 1992 9:54
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwErrorWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/Error");
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial error widget instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|
|	 Output: None
|
|    Written By: Mark Young
|          Date: May 26, 1993 13:28
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwErrorWidget xwid = kwidget(new);
	xvobject stopsign, object = xvw_object(new);


	stopsign = xvw_create_pixmap(object, "pixmap");
	xvw_set_attributes(stopsign,
		XVW_PIXMAP,	      xwid->error.error_pixmap,
		XVW_BELOW,            NULL,
		XVW_RIGHT_OF,         NULL,
		XVW_BORDER_WIDTH,     0,
		NULL);

	xwid->error.text = xvw_create_text(object, "text");
	xvw_set_attributes(xwid->error.text,
		XVW_TEXT_MULTILINE,   TRUE,
		XVW_TACK_EDGE,        KMANAGER_TACK_ALL,
		XVW_TEXT_WRAP,        KTEXT_WRAP_WORD,
		XVW_TEXT_EDIT_TYPE,   KTEXT_READ,
		XVW_BELOW,	      stopsign,
		NULL);

	xwid->error.button = xvw_create_button(object, "button");
	xvw_set_attributes(xwid->error.button,
		XVW_LABEL,		"Ok",
		XVW_CHAR_HEIGHT,	1.0,
		XVW_LABEL_JUSTIFY,      KLABEL_JUSTIFY_CENTER,
		XVW_LEFT_OF,		NULL,
		XVW_ABOVE,		xwid->error.text,
		XVW_BELOW,		NULL,
		NULL);

	xwid->error.label = xvw_create_label(object, "label");
	xvw_set_attributes(xwid->error.label,
		XVW_BORDER_WIDTH,	0,
		XVW_LABEL,		"Error:",
		XVW_CHAR_HEIGHT,	1.0,
		XVW_LABEL_JUSTIFY,      KLABEL_JUSTIFY_CENTER,
		XVW_RIGHT_OF,		stopsign,
		XVW_LEFT_OF,		xwid->error.button,
		XVW_ABOVE,		xwid->error.text,
		XVW_BELOW,		NULL,
		NULL);

	xvw_set_attributes(object,
		XVW_CHAR_WIDTH,	     42.0,
		XVW_CHAR_HEIGHT,     9.0,
		NULL);

	xvw_insert_callback(xwid->error.button, XVW_BUTTON_SELECT, TRUE,
			ButtonCallback, object);
}

/*-----------------------------------------------------------
|
|  Routine Name: ButtonCallback
|
|       Purpose: This routine will be called when the button callback is
|                activated.
|
|         Input: object      - which button being manipulated
|                client_data - the button widget
|                call_data   - int representing the index
|
|        Output: None
|       Returns: None
|
|    Written By: Mark Young
|          Date: Jun 06, 1993 10:58
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ButtonCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject error = (xvobject) client_data;


	XtCallCallbacks(xvw_widget(error), XVW_ERROR_CALLBACK, NULL);
	xvw_unmap(xvw_toplevel(error));
	xvw_destroy(error);
}


/************************************************************
*
*  Routine Name: xvw_create_error - create an error object 
*
*       Purpose: The error object is
*		 a pop-up window that displays an error message.
*                A stop sign icon on the upper left hand side of
*                the error object draws the attention of the user;
*                a single button on the upper right hand side of
*                the error object allows the user to acknowledge 
*                the error message.
*
*		 After the user clicks on the acknowledgment button,
*                the error object is destroyed.
*
*                A callback can be installed on the error object, which
*                will be fired when the user clicks on the acknowledgment
*                button.
*
*         Input: parent - parent of the error widget; NULL will cause
*                         a default toplevel to be created automatically
*                name   - name with which to reference error object
*
*        Output:
*       Returns: The error object on success, NULL on failure
*  Restrictions:
*    Written By: Mark Young
*          Date: Oct 27, 1993
*      Verified: 
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_error(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, TRUE, TRUE, name, ErrorWidgetClass);
	return(object);
}
