 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Browser GUI Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>>			Initialize()
   >>>>			SetValues()
   >>>> 		BrowserCallback()
   >>>> 		UpdateBrowserList()
   >>>> 		ChangeBrowserMode()
   >>>>   Public:
   >>>>			xvw_create_browser()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvobjects/BrowserP.h>

static void Initialize	   PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean SetValues   PROTO((Widget, Widget, Widget, ArgList, Cardinal *));
static void ClassInitialize   PROTO((void));
static void BrowserCallback   PROTO((xvobject, kaddr, kaddr));
static void UpdateBrowserList PROTO((xvobject));
static void ChangeBrowserMode PROTO((xvobject, int, char *));

static char **alias_array = NULL;
static int  num_aliases  = 0;


/*-------------------------------------------------------------------*
|
|   Define Default Pixmap Paths
|
--------------------------------------------------------------------*/
 
#define BROWSER1_PIXMAP "$DESIGN/objects/library/xvobjects/misc/pixmaps/browser1.xpm"
#define BROWSER2_PIXMAP "$DESIGN/objects/library/xvobjects/misc/pixmaps/browser2.xpm"

/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_BROWSER_DIRECTORY,       NULL,   XtRString,   NULL},
{XVW_BROWSER_FILTER,          NULL,   XtRString,   NULL},
{XVW_BROWSER_CANCEL_OBJECT,   NULL,   XtRPointer,  NULL},
{XVW_BROWSER_FILENAME_OBJECT, NULL,   XtRPointer,  NULL},
{XVW_BROWSER_FILTER_OBJECT,   NULL,   XtRPointer,  NULL},
{XVW_BROWSER_LABEL_OBJECT,    NULL,   XtRPointer,  NULL},
{XVW_BROWSER_LIST_OBJECT,     NULL,   XtRPointer,  NULL},
{XVW_BROWSER_CALLBACK,	      NULL,   XtRCallback, NULL},
{XVW_BROWSER_DESTROY_ON_QUIT, NULL,   XtRInt,      XtRBoolean},

{XVW_BROWSER_DIRECTORY_PIXMAP,	   NULL,   XtRPixmap,   NULL},
{XVW_BROWSER_ALIASES_PIXMAP,	   NULL,   XtRPixmap,   NULL},
{XVW_BROWSER_DIRECTORY_PIXMAPFILE,  XVW_BROWSER_DIRECTORY_PIXMAP,
		XtRFilename, XtRPixmap},
{XVW_BROWSER_ALIASES_PIXMAPFILE,  XVW_BROWSER_ALIASES_PIXMAP,
		XtRFilename, XtRPixmap},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwBrowserWidgetRec, browser.field)

static XtResource resources[] = { 
{XVW_BROWSER_DIRECTORY, NULL, XtRString, sizeof(String),
        offset(directory), XtRImmediate, (XtPointer) NULL},
{XVW_BROWSER_FILTER, NULL, XtRString, sizeof(String),
        offset(filter_string), XtRImmediate, (XtPointer) NULL},
{XVW_BROWSER_CANCEL_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(cancel), XtRImmediate, (XtPointer) NULL},
{XVW_BROWSER_FILENAME_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(filename), XtRImmediate, (XtPointer) NULL},
{XVW_BROWSER_FILTER_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(filter), XtRImmediate, (XtPointer) NULL},
{XVW_BROWSER_LABEL_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(label), XtRImmediate, (XtPointer) NULL},
{XVW_BROWSER_LIST_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(list), XtRImmediate, (XtPointer) NULL},
{XVW_BROWSER_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(browser_callback), XtRCallback, (XtPointer) NULL},
{XVW_BROWSER_DESTROY_ON_QUIT, NULL, XtRBoolean, sizeof(Boolean),
      offset(destroy_on_quit), XtRImmediate, (XtPointer) TRUE},

{XVW_BROWSER_DIRECTORY_PIXMAP, XVW_BROWSER_DIRECTORY_PIXMAPFILE,  XtRPixmap, 
      sizeof(Pixmap),
      offset(directory_pixmap), XtRString, (XtPointer) BROWSER1_PIXMAP},
{XVW_BROWSER_ALIASES_PIXMAP, XVW_BROWSER_ALIASES_PIXMAPFILE,  XtRPixmap, 
      sizeof(Pixmap),
      offset(aliases_pixmap), XtRString, (XtPointer) BROWSER2_PIXMAP},

{XVW_PREFERRED_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwManagerWidgetRec, manager.preferred_width),
	XtRImmediate, (XtPointer) 300 },
{XVW_PREFERRED_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwManagerWidgetRec, manager.preferred_height),
	XtRImmediate, (XtPointer) 400},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Browser Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwManagerWidgetClassRec)

XvwBrowserWidgetClassRec xvwBrowserWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Browser",			/* class_name		  */
    sizeof(XvwBrowserWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,				/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwBrowserWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine   */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwBrowserWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwBrowserWidgetClass = (WidgetClass) &xvwBrowserWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for widget definition
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	     (XvwBrowserWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwBrowserWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|         Input:
|
|        Output:
|       Returns: 
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwBrowserWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/Browser");
}


/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial browser widget instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|
|	 Output: None
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwBrowserWidget xwid = kwidget(new);
	xvobject object = xvw_object(new);
	xvobject tmplabel;


	xwid->browser.pixmap = xvw_create_pixmap(object, "pixmap");
	xvw_set_attributes(xwid->browser.pixmap,
		XVW_PIXMAP,	      xwid->browser.directory_pixmap,
		XVW_RIGHT_OF,	      NULL,
		XVW_BORDER_WIDTH,     0,
		NULL);

	xwid->browser.cancel = xvw_create_button(object, "quit");
	xvw_set_attributes(xwid->browser.cancel,
		XVW_LABEL,	      "Cancel",
		XVW_CHAR_WIDTH,       6.0,
		XVW_CHAR_HEIGHT,      1.0,
		XVW_LEFT_OF,	      NULL,
		XVW_BELOW,	      NULL,
		NULL);

	xwid->browser.help = xvw_create_button(object, "help");
	xvw_set_attributes(xwid->browser.help,
		XVW_LABEL,	      "Help",
		XVW_CHAR_WIDTH,       6.0,
		XVW_CHAR_HEIGHT,      1.0,
		XVW_LEFT_OF,	      xwid->browser.cancel,
		XVW_BELOW,	      NULL,
		NULL);

	xwid->browser.label = xvw_create_labelstr(object, "label");
	xvw_set_attributes(xwid->browser.label,
		XVW_LABEL,	      "Directory Browser",
		XVW_LEFT_OF,	      xwid->browser.help,
		XVW_RIGHT_OF,	      xwid->browser.pixmap,
		XVW_ABOVE,	      xwid->browser.help,
		XVW_BELOW,	      xwid->browser.help,
		XVW_RIGHT_OF,	      xwid->browser.pixmap,
		NULL);

	xwid->browser.filter = xvw_create_textinput(object, "filter");
	xvw_set_attributes(xwid->browser.filter,
		XVW_TEXTINPUT_LABEL,  "Filter:",
		XVW_TACK_EDGE,	      KMANAGER_TACK_HORIZ,
		XVW_BELOW,	      xwid->browser.pixmap,
		NULL);

	xwid->browser.filename = xvw_create_outputfile(object, "filename");
	xvw_set_attributes(xwid->browser.filename,
		XVW_OUTPUTFILE_DISPLAY_BUTTON,  FALSE,
		XVW_TACK_EDGE,	      KMANAGER_TACK_HORIZ,
		XVW_ABOVE,	      NULL,
		NULL);

	tmplabel = xvw_create_labelstr(object, "tmplabel");	
	xvw_set_attributes(tmplabel,
                XVW_TACK_EDGE,        KMANAGER_TACK_HORIZ,
                XVW_LABEL,            "Directory / Filename:",
                XVW_ABOVE,            xwid->browser.filename,
                NULL);
	
	xwid->browser.list = xvw_create_list(object, "list");
	xvw_set_attributes(xwid->browser.list,
		XVW_BELOW,	      xwid->browser.filter,
		XVW_ABOVE,	      tmplabel,
		XVW_TACK_EDGE,	      KMANAGER_TACK_ALL,
		NULL);
	xwid->browser.list = xvw_retrieve_list(xwid->browser.list);

	xvw_add_callback(xwid->browser.cancel, XVW_BUTTON_SELECT,
			BrowserCallback, object);
	xvw_add_callback(xwid->browser.help, XVW_BUTTON_SELECT,
			BrowserCallback, object);
	xvw_add_callback(xwid->browser.list, XVW_LIST_ITEM_SELECT,
			BrowserCallback, object);
	xvw_add_callback(xwid->browser.filename, XVW_OUTPUTFILE_CALLBACK,
			BrowserCallback, object);
	xvw_add_callback(xwid->browser.filter, XVW_TEXTINPUT_CALLBACK,
			BrowserCallback, object);
	xvw_add_event(xwid->browser.pixmap, ButtonPressMask,
			BrowserCallback, object);

	xwid->browser.aliases = FALSE;
	xwid->browser.old_directory = NULL;
	xwid->browser.directory = kstrdup(xwid->browser.directory);
	xvw_set_attribute(object, XVW_BROWSER_DIRECTORY, "./");
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues 
|
|       Purpose: This method is used to set the public values 
|                of a XvwBrowserWidget instance.  The public values
|		 which can be changed are the current directory and
|		 the filter being used.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Dec 13, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwBrowserWidget cxwid = kwidget(current);
	XvwBrowserWidget nxwid = kwidget(new);

	Boolean update_browser = FALSE;


	if (cxwid->browser.directory != nxwid->browser.directory)
	{
	   char *directory;

	   update_browser = TRUE;
	   if (!nxwid->browser.directory)
	      nxwid->browser.directory = "./";

	   /*
	    *  We want to change the browser mode if the new directory
	    *  being entered contains a ':' and we are in "directory" mode.
	    *  Or if it doesn't contain a ':' and we are in "alias" mode.
	    *  Finally, if none of these conditions exist, then go ahead and
	    *  free the previously supplied directory name.  Note: in the
	    *  first two cases the old directory name is saved, so you better
	    *  not free it!
	    */
	   directory = nxwid->browser.directory;
	   nxwid->browser.directory = cxwid->browser.directory;
	   if (nxwid->browser.aliases == FALSE && kstrchr(directory, ':'))
	      ChangeBrowserMode(xvw_object(new), TRUE, NULL);
	   else if (nxwid->browser.aliases == TRUE && kstrchr(directory, '/'))
	      ChangeBrowserMode(xvw_object(new), FALSE, NULL);
	   else
	      kfree(cxwid->browser.directory);

	   nxwid->browser.directory = kstring_cleanup(directory, NULL);
	   xvw_set_attribute(nxwid->browser.filename, XVW_OUTPUTFILE_FILENAME,
			nxwid->browser.directory);
	}

	if (cxwid->browser.filter_string != nxwid->browser.filter_string)
	{
	   kfree(cxwid->browser.filter_string);
	   nxwid->browser.filter_string =
			kstring_cleanup(nxwid->browser.filter_string, NULL);
	   xvw_set_attribute(nxwid->browser.filter, XVW_TEXTINPUT_TEXT,
			nxwid->browser.filter_string);
	   update_browser = TRUE;
	}

	if (update_browser == TRUE)
	   UpdateBrowserList(xvw_object(new));

	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: BrowserCallback
|
|       Purpose: This routine will change the text and update the
|	 	 scrollbar according to the value paased in.
|
|         Input: object      - the object which is calling us
|		 call_data   - none
|		 client_data - the browser gui object
|    Written By: Mark Young 
|          Date: Jun 06, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static void BrowserCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject browser = (xvobject) client_data;
	XvwBrowserWidget xwid = (XvwBrowserWidget) xvw_widget(browser);

        struct stat buf;
	int    len, aliases = xwid->browser.aliases;
	char   *directory = xwid->browser.directory;
	char   temp[KLENGTH], fullpath[KLENGTH], *name;


	temp[0] = '\0';
	if (object == xwid->browser.list)
	{
	   xvw_list_struct *list = (xvw_list_struct *) call_data; 

	   if (kstrcmp("-- aliases --", list->string) == 0)
	   {
	      ChangeBrowserMode(browser, TRUE, temp);
	   }
	   else if (kstrcmp("-- directory --", list->string) == 0)
	   {
	      ChangeBrowserMode(browser, FALSE, temp);
	   }
	   else if (kstrcmp("../", list->string) == 0)
	   {
	      len = kstrlen(directory);
	      if (aliases == TRUE && len > 0)
	      {
		 if (directory[len-1] == ':')
		    directory[len-1] = '\0';

	         if ((name = kstrrchr(directory, ':')) != NULL)
	         {
		    name[1] = '\0';
		    kstrcpy(temp, directory);
	         }
	         else temp[0] = '\0';
	      }
	      else if (aliases == FALSE)
	      {
		 if (len > 0 && directory[len-1] != '/')
		    ksprintf(temp, "%s/%s", directory, list->string);
		 else if (directory[len-1] == '/')
		    ksprintf(temp, "%s%s", directory, list->string);
		 else
		    kstrcpy(temp, list->string);

	         kexpandpath(temp, NULL, temp);
		 if (kstrcmp(temp, "/") != 0) kstrcat(temp, "/");
	      }
	   }
	   else
	   {
	       if ((len = kstrlen(directory)) == 0)
	          kstrcpy(temp, list->string);
	       else if (aliases == FALSE && directory[len-1] != '/')
	         ksprintf(temp, "%s/%s", directory, list->string);
	       else if (aliases == TRUE  && directory[len-1] != ':')
	         ksprintf(temp, "%s:%s", directory, list->string);
	       else
	         ksprintf(temp, "%s%s", directory, list->string);
	   }

           if (kfullpath(temp, NULL, fullpath) &&
	       stat(fullpath, &buf) != -1 && !S_ISDIR(buf.st_mode))
	   {
	      name = kstring_cleanup(temp, temp);
	      XtCallCallbacks(xvw_widget(browser), XVW_BROWSER_CALLBACK, &name);
	      if (xwid->browser.destroy_on_quit)
	         xvw_destroy(browser);
	      else
	         xvw_unmap(xvw_toplevel(browser));
	   }
	   else
	      xvw_set_attribute(browser, XVW_BROWSER_DIRECTORY, temp);
	}
	else if (object == xwid->browser.filename)
	{
	   name = *((char **) call_data); 

	   /* changing from directory mode to aliases mode */
	   if (xwid->browser.aliases == FALSE && kstrchr(name, ':'))
	      ChangeBrowserMode(browser, TRUE, temp);

	   /* changing from aliases mode to directory mode */
	   else if (xwid->browser.aliases == TRUE && kstrchr(name, '/'))
	      ChangeBrowserMode(browser, FALSE, temp);

	   /* user entered name of an existing file as directory/filepath */
	   if (kfullpath(name, NULL, temp) && 
               stat(temp, &buf) != -1 && S_ISREG(buf.st_mode))
	   {
	      XtCallCallbacks(xvw_widget(browser), XVW_BROWSER_CALLBACK, &name);
              if (xwid->browser.destroy_on_quit)
                 xvw_destroy(browser);
              else xvw_unmap(xvw_toplevel(browser));
	   }

	   /* user entered something else in the directory/filepath parameter*/
	   else xvw_set_attribute(browser, XVW_BROWSER_DIRECTORY, name);
	}
	else if (object == xwid->browser.filter)
	{
	   char *filter_string = *((char **) call_data); 

	   xvw_set_attribute(browser, XVW_BROWSER_FILTER, filter_string);
	}
	else if (object == xwid->browser.help)
	{
	   xvobject help;

	   help = xvw_create_help(NULL, "Online Help");
           xvw_set_attributes(help,
                XVW_HELP_TITLE, "Online Help for Browser Object",
                XVW_HELP_FILENAME,
			"$DESIGN/objects/library/xvutils/help/Browser.hlp",
                NULL);
	}
	else if (object == xwid->browser.cancel)
	{
	   name = NULL;
	   XtCallCallbacks(xvw_widget(browser), XVW_BROWSER_CALLBACK, &name);
	   if (xwid->browser.destroy_on_quit)
	      xvw_destroy(browser);
	   else
	      xvw_unmap(xvw_toplevel(browser));
	}
	else if (object == xwid->browser.pixmap)
	{
           if (xwid->browser.aliases == FALSE)
	      ChangeBrowserMode(browser, TRUE, temp);
           else
	      ChangeBrowserMode(browser, FALSE, temp);

	   xvw_set_attribute(browser, XVW_BROWSER_DIRECTORY, temp);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: UpdateBrowserList
|
|       Purpose: This routine will update the browser list according
|                to current directory.
|
|         Input: browser - the browser object to update
|    Written By: Mark Young
|          Date: Dec 13, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void UpdateBrowserList(
   xvobject browser)
{
	XvwBrowserWidget xwid = (XvwBrowserWidget) xvw_widget(browser);

	struct stat buf;
	int  i, j, num, mode, dirsize, size = 0;
	char **list, **tmp, temp[KLENGTH], *end, *begin,
	     *filter = xwid->browser.filter_string,
	     *directory = xwid->browser.directory;


	/*
	 *  Initialize the browser to have the aliases as the first selection
	 */
	if (xwid->browser.aliases == FALSE)
	{
	   list = karray_add(NULL, kstrdup("-- aliases --"), size++);

	   if (kfullpath(directory, NULL, temp) &&
	       (stat(temp, &buf) == -1 || !S_ISDIR(buf.st_mode)))
	   {
	      kdirname(directory, temp);
	   }

	   /*
	    *  List the directories first...
	    */
	   mode = KDIR;
           tmp = karray_dirlist(NULL, temp, NULL, mode, TRUE, &num);
	   list = karray_merge(list, tmp, size, num, FALSE);
	   size += num; kfree(tmp);

	   /*
	    *  Now list the files...
	    */
	   mode = KFILE;
           tmp = karray_dirlist(NULL, temp, filter, mode, TRUE, &num);
	   list = karray_merge(list, tmp, size, num, FALSE);
	   size += num; kfree(tmp);
	}
	else
	{
	   if (alias_array == NULL)
	      alias_array = kalias_list2array(&num_aliases);

	   if ((end = kstrrchr(directory, ':')) != NULL)
	      dirsize = (end - directory) + 1;
	   else
	      dirsize = kstrlen(directory);

	   list = karray_add(NULL, kstrdup("-- directory --"), size++);
	   list = karray_add(list, kstrdup("../"), size++);
	   for (i = 0; i < num_aliases; i++)
	   {
	       if (kstring_subcmp(alias_array[i], directory) == 0)
	       {
		  begin = &alias_array[i][dirsize];
		  if ((end = kstrchr(begin, ':')) != NULL)
		     kstring_ncopy(begin, (end-begin)+1, temp);
		  else
		     kstrcpy(temp, begin);

	          for (j = 0; j < size; j++)
		     if (kstrcmp(list[j], temp) == 0) break;

	          if (j == size)
		     list = karray_add(list, kstrdup(temp), size++);
	       }
	   }
	}
	xvw_change_list(xwid->browser.list, list, size, FALSE);
	karray_free(list, size, NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: ChangeBrowserMode
|
|       Purpose: This routine will change the browser mode from aliases
|		 to directory and back again.  It's responsibility is to
|		 update all the internal and visual cues.
|
|         Input: browser - the browser object to update.
|		 aliases - whether to update to aliases or directory mode.
|	 Output: temp    - the directory to update the browser list to.
|    Written By: Mark Young
|          Date: Jan 26, 1995
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ChangeBrowserMode(
   xvobject browser,
   int	    aliases,
   char	    *temp)
{
	XvwBrowserWidget xwid = (XvwBrowserWidget) xvw_widget(browser);


	if (aliases == TRUE)
	{
	   xwid->browser.aliases = TRUE;
	   if (temp) kstrcpy(temp, xwid->browser.old_directory);
	   kfree(xwid->browser.old_directory);
	   xvw_set_attribute(xwid->browser.label, XVW_LABEL, "Alias Browser");
	   xvw_set_attribute(xwid->browser.pixmap,
		XVW_PIXMAP, xwid->browser.aliases_pixmap);

	   xwid->browser.old_directory = xwid->browser.directory;
	   xwid->browser.directory = NULL;
	}
	else
	{
	   xwid->browser.aliases = FALSE;
	   if (temp) kstrcpy(temp, xwid->browser.old_directory);
	   kfree(xwid->browser.old_directory);
	   xvw_set_attribute(xwid->browser.label,XVW_LABEL,"Directory Browser");
	   xvw_set_attribute(xwid->browser.pixmap,
		XVW_PIXMAP, xwid->browser.directory_pixmap);

	   xwid->browser.old_directory = xwid->browser.directory;
	   xwid->browser.directory = NULL;
	}
}


/************************************************************
*
*  Routine Name: xvw_create_browser - create a browser GUI object
*
*       Purpose: The browser GUI object
*                allows the user to enter an input file.  It features a 
*                list object in which the user may select a file, or a
*		 text box in which the user may type in the filename;  
*                the filename is registered when the user hits <cr> or
*		 selects a file from the browser list.  The filter object
*		 can be used to filter
*                
*                The browser GUI object consists of a manager object 
*                with six children: two button object, a list object, 
*                a label object, a textinput object, and a textinput
*		 object.
*
*                A callback can be installed on the browser object, which
*                will be fired when the user enters a new filename.
*
*         Input: parent - parent of the browser object; NULL will cause
*                         a default toplevel to be created automatically
*                name   - name with which to reference browser object
*
*        Output:
*       Returns: The browser object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Nov 01, 1993
*      Verified: 
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_browser(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, TRUE, TRUE, name, BrowserWidgetClass);
	return(object);
}
