 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "copyright.h"          /* Khoros copyright */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros ToolboxMenu Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>>			Initialize()
   >>>> 		SetValues()
   >>>> 		MenuCallback()
   >>>>   Public:
   >>>>			xvw_create_toolboxmenu()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvlang/ToolboxMenuP.h>

static Boolean	SetValues       PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static void     ClassInitialize PROTO((void));
static void	Initialize	PROTO((Widget, Widget, ArgList, Cardinal *));
static void	MenuCallback    PROTO((xvobject, kaddr, kaddr));



/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_TOOLBOXMENU_CREATE,    NULL,   XtRCallback, NULL},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwToolboxMenuWidgetRec, toolboxmenu.field)

static XtResource resources[] = { 
{XVW_TOOLBOXMENU_CREATE, NULL, XtRCallback, sizeof(XtPointer),
      offset(menu_callback), XtRCallback, (XtPointer) NULL},

{XVW_ROWCOL_SPACING, NULL, XtRInt, sizeof(int),
        XtOffsetOf(XvwRowColWidgetRec, rowcol.spacing),
        XtRString, (XtPointer) "3"},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for ToolboxMenu Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwRowColWidgetClassRec)

XvwToolboxMenuWidgetClassRec xvwToolboxMenuWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "ToolboxMenu",			/* class_name		  */
    sizeof(XvwToolboxMenuWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwToolboxMenuWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwRowColWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwToolboxMenuWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwToolboxMenuWidgetClass = (WidgetClass) &xvwToolboxMenuWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for widget definition
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	     (XvwToolboxMenuWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwToolboxMenuWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
	xvw_init_attributes(xvwToolboxMenuWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvlang/app-defaults/ToolboxMenu");
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial toolboxmenu widget
|		 instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/

static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwToolboxMenuWidget xwid = kwidget(new);
	xvobject parent = xvw_object(new);

	char     *name, **info;
	xvobject menubutton, menu, submenu, button;
	klist    *category_list, *subcategory_list, *panelist, *menulist = NULL;


	kannounce(XVLANG, "Initialize", "Creating Walking Menus for toolboxes");
        xvw_get_contents(&category_list, NULL);
        while (category_list != NULL)
        {
	   name = ktoken_to_string((int) category_list->identifier);
	   menubutton = xvw_create_menubutton(parent, name);
	   menu = xvw_retrieve_menu(menubutton);
	   xvw_set_attributes(menubutton,
			XVW_LABEL,      name,
			XVW_CHAR_MIN_HEIGHT, 1.25,
			XVW_CHAR_MIN_WIDTH,  15.0,
			NULL);

	   subcategory_list = (klist *) klist_clientdata(category_list);
	   while (subcategory_list != NULL)
	   {
	      name = ktoken_to_string((int) subcategory_list->identifier);
	      menubutton = xvw_create_menubutton(menu, name);
	      xvw_set_attribute(menubutton, XVW_LABEL, name);

	      panelist = (klist *) subcategory_list->client_data;
	      submenu = xvw_retrieve_menu(menubutton);
	      while (panelist != NULL)
	      {
		 info = klist_clientdata(panelist);
		 button = xvw_create_button(submenu, info[0]);
		 xvw_set_attribute(button, XVW_LABEL, info[0]);
		 xvw_add_callback(button,XVW_BUTTON_SELECT,MenuCallback,parent);
		 menulist = klist_add(menulist, button, panelist);
		 panelist = klist_next(panelist);
	      }
              subcategory_list = klist_next(subcategory_list);
	   }
           category_list = klist_next(category_list);
        }
	xwid->toolboxmenu.menulist = menulist;
	kannounce(XVLANG, "Initialize", "");
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwToolboxMenuWidget instance.  The public values
|                which can be changed are all related to the display
|		 of the error.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/

static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwToolboxMenuWidget cxwid = kwidget(current);
	XvwToolboxMenuWidget nxwid = kwidget(new);


	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: MenuCallback
|
|       Purpose: This routine will be called when the menu callback is
|                activated.
|
|         Input: object      - which button being manipulated
|                client_data - the button widget
|                call_data   - int representing the index
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/
 
static void MenuCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject toolboxmenu = (xvobject) client_data;
	Widget   widget = xvw_widget(toolboxmenu);
	XvwToolboxMenuWidget xwid = kwidget(widget);

	xvw_program_info program_info;
	klist *entry = klist_locate(xwid->toolboxmenu.menulist, object);
	klist *panelist = klist_clientdata(entry);


	/*
	 *  Go ahead and load the program info structure
	 */
	if (!widget || !xvw_load_content(panelist, &program_info))
	   return;

	XtCallCallbacks(widget, XVW_TOOLBOXMENU_CREATE, &program_info);
}


/************************************************************
*
*  Routine Name: xvw_create_toolboxmenu - create a toolbox menu object
*
*       Purpose: The toolbox menu object allows the user to select an 
*		 operator according to its category/subcategory/operator 
*		 name.  In cantata, the toolbox menu object is used
*		 as the first method for glyph creation; the 
*		 Creates a toolbox menu object, that consists of three
*		 menu objects.  The first menu displays the different
*		 categories.  The second menu displays the sub-categories
*		 for the selected category.  And finally the third
*		 displays the operators for the selected sub-category.
*
*		 Two callbacks are provided which can be used to notify
*		 the programmer when the user selects or activates an operator
*		 from the menu.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object
*        Output: None
*       Returns: The toolboxmenu object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Jul 02, 1994
*      Verified:
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_toolboxmenu(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, FALSE, TRUE, name, ToolboxMenuWidgetClass);
	return(object);
}
