 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Procedure Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>> 		ClassPartInitialize()
   >>>> 		Initialize()
   >>>> 		SetValues()
   >>>> 		Destroy()
   >>>>	
   >>>> 		ProcedureExec()
   >>>> 		ProcedureHandler()
   >>>> 		ProcedureRunCallback()
   >>>>   Public:
   >>>>			xvw_create_procedure()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvlang/ProcedureP.h>
#include <xvlang/WorkspaceP.h>

static void ClassInitialize PROTO((void));
static void ClassPartInitialize PROTO((WidgetClass));
static void Initialize      PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,Cardinal *));
static void    Destroy	    PROTO((Widget));

static void ProcedureExec	    PROTO((Widget, int));
static void ProcedureHandler	    PROTO((xvobject, kaddr, XEvent *, int *));
static void ProcedureRunCallback    PROTO((xvobject, kaddr, kaddr));


/*-------------------------------------------------------------------*
|
|   Define Default Pixmap Paths
|
--------------------------------------------------------------------*/

#define OPEN_PIXMAP "$DESIGN/objects/library/xvlang/misc/glyph/open.xpm"
#define PROCEDURE_PIXMAP "$DESIGN/objects/library/xvlang/misc/glyph/procedure.xpm"
/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_PROCEDURE_WORKSPACE_OBJECT,   NULL,   XtRPointer,  NULL},

{XVW_PROCEDURE_PIXMAP,   NULL,   XtRPixmap,  NULL},
{XVW_PROCEDURE_OPEN_PIXMAP, NULL, XtRPixmap, NULL},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwProcedureWidgetRec, procedure.field)

static XtResource resources[] = { 
{XVW_PROCEDURE_WORKSPACE_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(workspace), XtRImmediate, (XtPointer) NULL},
{XVW_PROCEDURE_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(procedure_pixmap), XtRString, (XtPointer) PROCEDURE_PIXMAP},
{XVW_PROCEDURE_OPEN_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(open_pixmap), XtRString, (XtPointer) OPEN_PIXMAP},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Procedure Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwGlyphWidgetClassRec)

XvwProcedureWidgetClassRec xvwProcedureWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Procedure",			/* class_name		  */
    sizeof(XvwProcedureWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    ClassPartInitialize,		/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwProcedureWidgetConstraintsRec),/* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    XtInheritCheckNode,	                    /* firing rule check  */
    ProcedureExec,  	                    /* execute node       */
    NULL,  		                    /* extension          */
  },  /* XvwNodeWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwGlyphWidgetClass fields initialization */
  {
    NULL,  		                    /* run callback       */
    NULL,  		                    /* extension          */
  },  /* XvwProcedureWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwProcedureWidgetClass = (WidgetClass) &xvwProcedureWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	    (XvwProcedureWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwProcedureWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|    Written By: Mark Young
|          Date: Oct 19, 1992
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
	xvw_init_attributes(xvwProcedureWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvlang/uis/Procedure.pane");
	xvw_load_resources("$DESIGN/objects/library/xvlang/app-defaults/Procedure");
}

/*-----------------------------------------------------------
|
|  Routine Name: ClassPartInitialize
|
|       Purpose: This method is called when the first time an
|                instance of XvwProcedureWidgetClass or a subclass of
|                the XvwProcedureWidgetClass is created.  It handles the
|                inheritence of the run_callback method from the superclass
|                to the subclass.
|
|         Input: wclass - the widget class
|    Written By: Mark Young
|          Date: Dec 11, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassPartInitialize(
   WidgetClass wclass)
{
        XvwProcedureWidgetClass mclass = (XvwProcedureWidgetClass) wclass;
        XvwProcedureWidgetClass sclass = (XvwProcedureWidgetClass)
                                                wclass->core_class.superclass;
 
        if (wclass != xvwProcedureWidgetClass)
        {
           if (mclass->procedure_class.run_callback == XtInheritRunCallback)
              mclass->procedure_class.run_callback =
				sclass->procedure_class.run_callback;
        }
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method will set up the initial procedure
|                widget instance.
|
|         Input: request - not used
|                new     - widget instance after initialization
|
|        Output:
|
|    Written By: Mark Young
|          Date: May 26, 1993 13:28
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
        XvwProcedureWidget xwid = kwidget(new);
	xvobject object = xvw_object(new);
	xvobject parent = xvw_parent(object);

	long  mask, id;
	kform *form = NULL;


	/*
	 *  Add a workspace pixmap button to the center of the procedure
	 *  so that we associate the pixmap with the procedure's workspace.
	 */
	xvw_set_attributes(xwid->node.icon,
		XVW_BELOW,  xwid->glyph.destroy,
		XVW_PIXMAP, xwid->procedure.procedure_pixmap,
		NULL);

	xwid->procedure.open = xvw_create_pixmap(object, "open");
	xvw_set_attributes(xwid->procedure.open,
		XVW_PIXMAP,       xwid->procedure.open_pixmap,
		XVW_BELOW,	  NULL,
		XVW_RIGHT_OF,     xwid->glyph.menuform,
		XVW_BORDER_WIDTH, 0,
		XVW_HORIZ_DIST,	  3,
		XVW_VERT_DIST,    1,
                NULL);
	mask = ButtonPressMask | ButtonReleaseMask |
	       EnterWindowMask | LeaveWindowMask;
	xvw_add_event(xwid->procedure.open, mask, ProcedureHandler, object);

	/*
	 *  Need to make the execute right of our new open procedure
	 *  button.
 	 */
	xvw_set_attribute(xwid->glyph.execute, XVW_RIGHT_OF,
		xwid->procedure.open);

	/*
	 *  Now create the workspace for the procedure
	 */
	if (xvw_class(parent) == WorkspaceWidgetClass)
	{
	   XvwWorkspaceWidget xpar = (XvwWorkspaceWidget) xvw_widget(parent);

	   xpar->viewport.override = TRUE;
	   xwid->procedure.workspace = xvw_create(parent, FALSE, FALSE,
			"ProcedureWorkspace", WorkspaceWidgetClass);
	   xpar->viewport.override = FALSE;
	}
	else
	   xwid->procedure.workspace = xvw_create(parent, FALSE, FALSE,
			"ProcedureWorkspace", WorkspaceWidgetClass);

	/*
	 *  Make sure the workspace is tacked to it's parent
	 */
	xvw_set_attributes(xwid->procedure.workspace,
		XVW_MAP_WHEN_MANAGED, FALSE,
		XVW_WORKSPACE_PROCEDURE_OBJECT, object,
		XVW_TACK_EDGE, KMANAGER_TACK_ALL,
		XVW_VERT_DIST,    0,
		XVW_HORIZ_DIST,   0,
		XVW_BORDER_WIDTH, 0,
		NULL);
	xvw_get_attribute(xwid->procedure.workspace,
		XVW_WORKSPACE_WKSPGUI, &form);
	xvw_set_attribute(object, XVW_GLYPH_FORM, form);
	id = (long) xwid->glyph.expression_id;
	kexpr_parent_set((long) xwid->procedure.workspace, id);
	xwid->glyph.expression_id = xwid->procedure.workspace;
	xvw_insert_callback(xwid->procedure.workspace,
		XVW_WORKSPACE_RUN_CALLBACK, FALSE, ProcedureRunCallback,object);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwProcedureWidget instance.  The public values
|                which can be changed are all related to the display
|		 of the procedure.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output:
|       Returns:
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Aug 19, 1992 9:13
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwProcedureWidget cxwid = kwidget(current);
	XvwProcedureWidget nxwid = kwidget(new);

	if (cxwid->node.modified != nxwid->node.modified)
	{
	   if (nxwid->node.modified == TRUE)
	   {
	      xvw_set_attribute(nxwid->procedure.workspace,
			XVW_WORKSPACE_RESET, TRUE);
	   }
	}

	if (cxwid->node.name != nxwid->node.name)
	{
	   xvw_set_attribute(nxwid->procedure.workspace, XVW_WORKSPACE_NAME,
			nxwid->node.name);
	}

	if (cxwid->glyph.expression_id != nxwid->glyph.expression_id)
	{
	   long id = (long) nxwid->glyph.expression_id;

	   nxwid->glyph.expression_id = nxwid->procedure.workspace;
	   kexpr_parent_set((long) nxwid->procedure.workspace, id);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: destroy the procedure...
|         Input: widget - the procedure widget being destroyed 
|        Output: 
|
|    Written By: Mark Young
|          Date: Nov 21, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
	XvwProcedureWidget xwid = kwidget(widget);


	xvw_destroy(xwid->procedure.workspace);
}

/*-----------------------------------------------------------
|
|  Routine Name: ProcedureExec
|
|       Purpose: This routine will run or stop the execution of a procedure.
|         Input: widget      - the procedure widget to be run
|                exec        - whether we wish to run or stop the procedure
|
|    Written By: Mark Young
|          Date: Jul 30, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void ProcedureExec(
   Widget   widget,
   int      exec)
{
	XvwProcedureWidget xwid = kwidget(widget);

	int i, run;

	if (exec == KNODE_RUNNING)
	{
	   /*
	    *  Make sure that our glyph data available is set to
	    *  false.
	    */
	   run = TRUE;
	   for (i = 0; i < xwid->glyph.osize; i++)
	      xvw_set_attribute(xwid->glyph.oports[i], XVW_PORT_DAV, FALSE);

	   xvw_set_attribute(xwid->glyph.execute, XVW_PIXMAP,
			xwid->glyph.on_pixmap);
	}
	else if (exec == KNODE_STOPPED)
	{
	   /*
	    *  Make sure that our glyph data available is set to
	    *  true.
	    */
	   run = FALSE;
	   for (i = 0; i < xwid->glyph.osize; i++)
	      xvw_set_attribute(xwid->glyph.oports[i], XVW_PORT_DAV, TRUE);

	   xvw_set_attribute(xwid->glyph.execute, XVW_PIXMAP,
			xwid->glyph.off_pixmap);
	}
	xvw_set_attribute(xwid->procedure.workspace, XVW_WORKSPACE_RUN, run);
}

/*-----------------------------------------------------------
|
|  Routine Name: ProcedureRunCallback
|
|       Purpose: This routine will be called on the workspace run callback.
|         Input: object      - the button being activated
|                client_data - the procedure widget
|                call_data   - whether we wish to run or stop
|
|    Written By: Mark Young
|          Date: Sep 06, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void ProcedureRunCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	int running    = *((int *) call_data);
	xvobject glyph = (xvobject) client_data;
	Widget widget  = xvw_widget(glyph);

	int i;
	XvwProcedureWidget      xwid;
	XvwWorkspaceWidget      xtmp;
	XvwProcedureWidgetClass class;

	xwid  = (XvwProcedureWidget) widget;
	xtmp  = (XvwWorkspaceWidget) xvw_widget(xwid->procedure.workspace);
	class = (XvwProcedureWidgetClass) xwid->core.widget_class;
	if (class->procedure_class.run_callback == NULL)
	{
	   if (running == FALSE)
	   {
	      xvw_set_attribute(glyph, XVW_NODE_MODIFIED, FALSE);
	      xvw_set_attribute(glyph, XVW_NODE_EXECUTE, FALSE);
	   }
	   else if (xtmp->workspace.scheduling == FALSE)
	   {
	      /*
	       *  Make sure that our glyph data available is set to true.
	       */
	      for (i = 0; i < xwid->glyph.osize; i++)
	         xvw_set_attribute(xwid->glyph.oports[i], XVW_PORT_DAV, TRUE);
	   }
	}
	else
	   class->procedure_class.run_callback(widget, running);
}

/*-----------------------------------------------------------
|
|  Routine Name: ProcedureHandler
|
|       Purpose: This routine will perform a variety of procedure callbacks,
|		 such as opening the workspace.
|         Input: object      - the button being activated
|                client_data - the procedure widget
|                event       - event the activated us
|		 dispatch    - whether to continue dispatch the event
|
|    Written By: Mark Young
|          Date: Jul 27, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void ProcedureHandler(
   xvobject object,
   kaddr    client_data,
   XEvent   *event,
   int      *dispatch)
{
	xvobject procedure = (xvobject) client_data;
	XvwProcedureWidget xwid = (XvwProcedureWidget) xvw_widget(procedure);

	Widget widget;

	*dispatch = FALSE;
	widget = xvw_widget(object);
	object = xvw_object(widget);
	if (event->type == LeaveNotify)
	{
	   if (xwid->glyph.show_status == TRUE)
	      xvw_set_attribute(xwid->glyph.status, XVW_LABEL, NULL);

	   kannounce(XVLANG, "GlyphHandler", " ");
	   return;
	}
	else if (event->type == EnterNotify)
	{
	   char     *tmp = NULL;
	   kform_struct *kformstruct = NULL;

	   if (object == xwid->procedure.open)
	      tmp = "Procedure's Workspace";

	   if (xwid->glyph.show_status == TRUE)
	      xvw_set_attribute(xwid->glyph.status, XVW_LABEL, tmp);

	   kannounce(XVLANG,"ProcedureHandler","%s:  %s", xwid->node.name, tmp);
	   return;
	}
	else if (event->type != ButtonRelease)
	   return;


	if (object == xwid->procedure.open)
	{
	   if (!xvw_check_mapped(xwid->procedure.workspace))
	   {
	      if (xvw_check_managed(xwid->procedure.workspace) == FALSE)
	         xvw_manage(xwid->procedure.workspace);

	      WorkspaceMap(xwid->procedure.workspace);
	   }
	   else
	      WorkspaceUnmap(xwid->procedure.workspace);
	}
}


/************************************************************
*
*  Routine Name: xvw_create_procedure - create a procedure object
*
*       Purpose: The purpose of the procedure GUI object is to provide a
*		 visual heirarchy for visual programming.  The procedure
*		 object consists of glyph object, which is the node used
*		 to represent the iconified visual program.  When the Procedure
*		 is opened a workspace object will be mapped which will contain
*		 the visual program.  The workspace can be used to construct
*		 visual programs, where the exported input/output parameters
*		 will appear on the Procedure object as input & output
*		 ports.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object
*        Output: None
*       Returns: The procedure object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Jan 14, 1993
*      Verified:
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_procedure(
   xvobject parent,
   char     *name)
{
	xvobject procedure;


	procedure = xvw_create(parent, FALSE, TRUE, name, ProcedureWidgetClass);
	xvw_set_attributes(procedure,
		XVW_SELECTABLE, TRUE,
		XVW_RESIZABLE, FALSE,
		XVW_MENUABLE, FALSE,
		NULL);
	return(procedure);
}
