 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "copyright.h"          /* Khoros copyright */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros CommandBar Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>>			Initialize()
   >>>> 		SetValues()
   >>>> 		Destroy()
   >>>> 		CommandbarAnnounce()
   >>>> 		CommandbarCallbacks()
   >>>> 		CommandLineCallback()
   >>>> 		WorkspaceRunCallback()
   >>>> 		WorkspaceActiveCallback()
   >>>>   Public:
   >>>>			xvw_create_commandbar()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <xvlang/CommandBarP.h>

static Boolean	SetValues       PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static void     Destroy		PROTO((Widget));
static void     ClassInitialize PROTO((void));
static void	Initialize	PROTO((Widget, Widget, ArgList, Cardinal *));
static void	CommandbarAnnounce PROTO((xvobject, kaddr, XEvent *, int *));
static void	CommandbarCallbacks      PROTO((xvobject, kaddr, kaddr));
static void	WorkspaceRunCallback     PROTO((xvobject, kaddr, kaddr));
static void	CommandLineCallback      PROTO((xvobject, kaddr, kaddr));
static void	WorkspaceActiveCallback  PROTO((xvobject, kaddr, kaddr));
static void	WorkspaceRestoreCallback PROTO((xvobject, kaddr, kaddr));

/*-------------------------------------------------------------------*
|
|   Define Default Pixmap Paths
|
--------------------------------------------------------------------*/

typedef struct
{
        char *name;
        char *set_pixmapfile;
        char *unset_pixmapfile;
        char *attribute;
        char *command;
        char *announce;
} CommandBarItem;

static CommandBarItem commandbar_list[] = 
{
  {"Execute", "off.xpm", "on.xpm", NULL, "run",
	"Run Workspace."},
  {"Step", "step.xpm", NULL, XVW_WORKSPACE_STEP, "step",
	"Single Step Execute."},

  {"Reset", "reset.xpm", NULL, XVW_WORKSPACE_RESET, "reset",
	"Reset Workspace."},
  {"Clear", "clear.xpm", NULL, XVW_WORKSPACE_CLEAR, "clear",
	"Clear Workspace."},
  {"Check", "check.xpm", NULL, XVW_WORKSPACE_CHECK, "check",
	"Check Workspace."},
  {"Info", "info.xpm", NULL, XVW_WORKSPACE_INFO, "print info",
	"Display Workspace Information."},
  {"WorkspaceGui", "wkspgui.xpm", NULL, XVW_WORKSPACE_SHOW_WKSPGUI, "show gui",
	"Show Workspace GUI."},
  {"CreateProcedure", "procedure.xpm", NULL, XVW_WORKSPACE_CREATE_PROCEDURE,
	"create procedure", "Create Procedure."},
  {"CreateCountloop", "countloop.xpm", NULL, XVW_WORKSPACE_CREATE_COUNTLOOP,
	"create countloop", "Create Count Loop."},
  {"CreateWhileloop", "whileloop.xpm", NULL, XVW_WORKSPACE_CREATE_WHILELOOP,
	"create whileloop", "Create While Loop."},

  {"ShowClipboard", "clipboard.xpm", NULL, XVW_WORKSPACE_SHOW_CLIPBOARD,
	"show clipboard", "Show Workspace Clipboard."},
  {"Cut", "cut.xpm", NULL, XVW_CANVAS_CUT,
	"cut", "Cut Selected Glyphs to Clipboard."},
  {"Paste", "paste.xpm", NULL, XVW_CANVAS_PASTE,
	"paste", "Paste Clipboard to Workspace."},
  {"Duplicate", "duplicate.xpm", NULL, XVW_CANVAS_DUPLICATE,
	"duplicate", "Duplicate Selected Glyphs."},
  {"Delete", "delete.xpm", NULL, XVW_CANVAS_DELETE, "delete",
	"Delete Selected Glyphs."},
  {"Undo", "undo.xpm", NULL, XVW_CANVAS_UNDO, "undo",
	"Undo Deletion."},
  {"SelectAll", "selectall.xpm", NULL, XVW_CANVAS_SELECTALL, "select all",
	"Select All Glyphs."},
  {"UnselectAll", "unselectall.xpm", NULL, XVW_CANVAS_UNSELECTALL,
	"unselect all", "Unselect All Glyphs."},

  {"Attributes", "attributes.xpm", NULL, NULL,
	"show attributes", "Show Workspace Attributes."},
  {"RestoreWksp", "restorewksp.xpm", NULL, NULL,
	"restore", "Restore Workspace."},
  {"SaveWksp", "savewksp.xpm", NULL, NULL,
	"save", "Save Workspace."},
};


/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_COMMANDBAR_WORKSPACE,    NULL,   XtRPointer, NULL},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwCommandBarWidgetRec, commandbar.field)

static XtResource resources[] = { 
{XVW_COMMANDBAR_WORKSPACE, NULL, XtRPointer, sizeof(XtPointer),
      offset(workspace), XtRImmediate, (XtPointer) NULL},

{XVW_DEF_HORIZ_DIST, NULL, XtRPosition, sizeof(Position),
        XtOffsetOf(XvwManagerWidgetRec, manager.horiz_offset),
        XtRString, (XtPointer) "2"},
{XVW_DEF_VERT_DIST, NULL, XtRPosition, sizeof(Position),
        XtOffsetOf(XvwManagerWidgetRec, manager.vert_offset),
        XtRString, (XtPointer) "1"},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for CommandBar Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwRowColWidgetClassRec)

XvwCommandBarWidgetClassRec xvwCommandBarWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "CommandBar",			/* class_name		  */
    sizeof(XvwCommandBarWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwCommandBarWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,  		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwRowColWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwCommandBarWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwCommandBarWidgetClass = (WidgetClass) &xvwCommandBarWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for widget definition
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	     (XvwCommandBarWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwCommandBarWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|    Written By: Mark Young
|          Date: Nov 05, 1994
|
------------------------------------------------------------*/
/*ARGSUSED*/
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwCommandBarWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvlang/app-defaults/CommandBar");
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial commandbar widget
|		 instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|    Written By: Mark Young
|          Date: Nov 05, 1994
|
------------------------------------------------------------*/
/*ARGSUSED*/
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwCommandBarWidget xwid = kwidget(new);

	int  	 i;
	CommandBarItem *entry;
	char	 filename[KLENGTH];
	xvobject button, object = xvw_object(new);
	long	 mask = EnterWindowMask | LeaveWindowMask;


        xwid->commandbar.browser  = NULL;
        xwid->commandbar.execute  = NULL;
	xwid->commandbar.execute_indx = -1;

	for (i = 0; i < knumber(commandbar_list); i++)
	{
	   entry = &commandbar_list[i];
	   button = xvw_create_button(object, entry->name);
	   kfullpath(entry->set_pixmapfile,
                "$DESIGN/objects/library/xvlang/misc/workspace", filename);

	   xvw_set_attributes(button,
		XVW_PIXMAP_FILENAME, filename,
		XVW_BUTTON_TYPE, KBUTTON_TYPE_PIXMAP,
		NULL);

	   xvw_add_callback(button, XVW_BUTTON_SELECT,
		CommandbarCallbacks, entry);

	   xvw_add_event(button, mask, CommandbarAnnounce, entry);
	   if (kstrcmp(entry->name, "Execute") == 0)
	   {
	      xwid->commandbar.execute_indx = i;
	      xwid->commandbar.execute = button;
	   }
	}

	xwid->commandbar.cli = xvw_create_textinput(object, "CommandLine");
	xvw_set_attributes(xwid->commandbar.cli,
		XVW_BELOW,	     button,
		XVW_ROWCOL_ACTIVE,   FALSE,
		XVW_TACK_EDGE,	     KMANAGER_TACK_HORIZ,
		XVW_TEXTINPUT_LABEL, "Command String:",
		NULL);
	xvw_unmanage(xwid->commandbar.cli);
        xvw_add_callback(xwid->commandbar.cli, XVW_TEXTINPUT_CALLBACK,
                CommandLineCallback, object);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwCommandBarWidget instance.  The public values
|                which can be changed are all related to the display
|		 of the error.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Nov 05, 1994
|
------------------------------------------------------------*/
/*ARGSUSED*/
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwCommandBarWidget cxwid = kwidget(current);
	XvwCommandBarWidget nxwid = kwidget(new);


	if (cxwid->commandbar.workspace != nxwid->commandbar.workspace)
	{
	   xvobject object = xvw_object(new);

	   if (cxwid->commandbar.workspace != NULL)
	   {
	      xvw_remove_callback(cxwid->commandbar.workspace,
		   XVW_WORKSPACE_RUN_CALLBACK, WorkspaceRunCallback, object);
	      xvw_remove_callback(cxwid->commandbar.workspace,
		   XVW_WORKSPACE_ACTIVE_CALLBACK, WorkspaceActiveCallback,
		   object);
	   }

	   if (nxwid->commandbar.workspace != NULL)
	   {
	      xvw_add_callback(nxwid->commandbar.workspace,
		   XVW_WORKSPACE_RUN_CALLBACK, WorkspaceRunCallback, object);
	      xvw_add_callback(nxwid->commandbar.workspace,
		   XVW_WORKSPACE_ACTIVE_CALLBACK, WorkspaceActiveCallback,
		   object);
	   }
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: destroy the glyph...
|         Input: widget - the glyph widget being destroyed 
|    Written By: Mark Young
|          Date: Apr 13, 1995
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
	XvwCommandBarWidget xwid = kwidget(widget);

	/*
	 *  Destroy the browser if it exists...
	 */
	if (xwid->commandbar.browser != NULL)
	   xvw_destroy(xwid->commandbar.browser);
}

/*-----------------------------------------------------------
|
|  Routine Name: CommandbarCallbacks - commandbar button callbacks routine
|
|       Purpose: This routine is the handler for performing certain workspace
|		 button callbacks functions, such as mapping or unmapping the
|		 clipboard.
|
|         Input: object - object in which the object was invoked
|		 client_data - the workspace widget
|		 calldata    - not used
|    Written By: Mark Young
|          Date: Nov 05, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void CommandbarCallbacks(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	CommandBarItem *entry = (CommandBarItem *) client_data;

	char     *filename = NULL;
	xvobject workspace, commandbar = xvw_parent(object);
	XvwCommandBarWidget xwid = (XvwCommandBarWidget) xvw_widget(commandbar);


	/*
	 *  Sanity check
	 */
	if ((workspace = xwid->commandbar.workspace) == NULL)
	   return;

	if (kstrcmp(entry->name, "Attributes") == 0)
	{
	   if (xvw_check_menuactive(workspace) == FALSE)
	      xvw_activate_menu(workspace);
	   else
	      xvw_inactivate_menu(workspace);
	}
	else if (kstrcmp(entry->name, "Execute") == 0)
	{
	   int running = FALSE;

	   xvw_get_attribute(workspace, XVW_WORKSPACE_RUN, &running);
	   if (running == KNODE_STOPPED)
	      xvw_set_attribute(workspace, XVW_WORKSPACE_RUN, TRUE);
	   else
	      xvw_set_attribute(workspace, XVW_WORKSPACE_RUN, FALSE);
	}
	else if (kstrcmp(entry->name, "RestoreWksp") == 0)
	{
	   if (xwid->commandbar.browser == NULL)
	   {
	      xwid->commandbar.browser = xvw_create_browser(NULL, "Browser");
	      xvw_set_attributes(xwid->commandbar.browser,
			XVW_BROWSER_DESTROY_ON_QUIT, FALSE,
			XVW_BROWSER_DIRECTORY, "workspaces:",
			NULL);
	      xvw_add_callback(xwid->commandbar.browser, XVW_BROWSER_CALLBACK,
			WorkspaceRestoreCallback, commandbar);
	   }
	   xvw_place(xwid->commandbar.browser, NULL);
	}
	else if (kstrcmp(entry->name, "SaveWksp") == 0)
	{
	   int    status;
           char   *prompt = "Workspace: ", temp[KLENGTH], *answer = temp;

	   xvw_get_attribute(workspace, XVW_WORKSPACE_FILENAME, &filename);
	   if (filename == NULL)
	      answer[0] = '\0';
	   else
	      kstrcpy(answer, filename);

	   status = xvu_query_wait("Please enter the filename in which to save \
current workspace.", &prompt, "Ok", &answer, 1, 40);
	   if (status && kstrlen(answer) > 0 && koverwrite(KSTANDARD, answer))
	      xvw_set_attribute(workspace, XVW_WORKSPACE_SAVEALL, answer);
	}
	else if (entry->attribute != NULL)
	{
	   xvw_set_attribute(workspace, entry->attribute, TRUE);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: CommandLineCallback - command line callback
|
|       Purpose: This routine handles the command line callbacks
|
|         Input: object - object in which the object was invoked
|                client_data - the commandline object
|                calldata    - not used
|    Written By: Mark Young
|          Date: Dec 10, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void CommandLineCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
        char *string = *((char **) call_data);
        xvobject commandbar = (xvobject) client_data;
        XvwCommandBarWidget xwid = (XvwCommandBarWidget) xvw_widget(commandbar);
 
	int i;
        CommandBarItem *entry;
	char temp[KLENGTH], filename[KLENGTH];
	xvobject workspace;


	/*
	 *  Sanity check
	 */
	if ((workspace = xwid->commandbar.workspace) == NULL)
	   return;

	kstring_lower(string, temp);
        kfprintf(kstderr,"CommandLineInterface:  '%s'", string);
	for (i = 0; i < knumber(commandbar_list); i++)
	{
	   entry = &commandbar_list[i];
	   if (kstring_subcmp(entry->command, temp) == 0)
	   {
	      if (ksscanf(string, "restore %s", filename) == 1 &&
		  kstrlen(filename) > 0)
	      {
	         xvw_set_attribute(workspace, XVW_WORKSPACE_RESTORE, filename);
	      }
	      else if (ksscanf(string, "save %s", filename) == 1 &&
		       kstrlen(filename) > 0)
	      {
                 if (koverwrite(KSTANDARD, filename) == TRUE)
		    xvw_set_attribute(workspace,XVW_WORKSPACE_SAVEALL,filename);
	      }
	      else
		 CommandbarCallbacks(object, entry, NULL);
	      break;
	   }
	}
}
 
/*-----------------------------------------------------------
|
|  Routine Name: WorkspaceRunCallback - workspace run callback
|
|       Purpose: This routine handlers the changing of the run switch in order
|		 to indicate whether the program is running or not.
|
|         Input: object - object in which the object was invoked
|		 client_data - the commandbar object
|		 calldata    - not used
|    Written By: Mark Young
|          Date: Nov 05, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void WorkspaceRunCallback(
   xvobject workspace,
   kaddr    client_data,
   kaddr    call_data)
{
	int      running = *((int *) call_data);
	xvobject commandbar = (xvobject) client_data;
	XvwCommandBarWidget xwid = (XvwCommandBarWidget) xvw_widget(commandbar);

	char temp[KLENGTH];
	CommandBarItem *entry;


	if (xwid->commandbar.execute == NULL ||
	    xwid->commandbar.execute_indx == -1 ||
	    xwid->commandbar.execute_indx >= knumber(commandbar_list))
	{
	   return;
	}

	entry = &commandbar_list[xwid->commandbar.execute_indx];
	if (running == KNODE_STOPPED)
	   kfullpath(entry->set_pixmapfile,
                "$DESIGN/objects/library/xvlang/misc/workspace", temp);
	else
	   kfullpath(entry->unset_pixmapfile,
                "$DESIGN/objects/library/xvlang/misc/workspace", temp);

	 xvw_set_attribute(xwid->commandbar.execute, XVW_PIXMAP_FILENAME, temp);
}

/*-----------------------------------------------------------
|
|  Routine Name: WorkspaceActiveCallback - workspace active callback
|
|       Purpose: This routine handlers the changing of the active workspace.
|
|         Input: object - object in which the object was invoked
|		 client_data - the commandbar object
|		 calldata    - not used
|    Written By: Mark Young
|          Date: Nov 05, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void WorkspaceActiveCallback(
   xvobject workspace,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject active = *((xvobject *) call_data);
	xvobject commandbar = (xvobject) client_data;
	XvwCommandBarWidget xwid = (XvwCommandBarWidget) xvw_widget(commandbar);

	int running;
	char temp[KLENGTH];
	CommandBarItem *entry;


	/*
	 *  Switch the attributes menuform if the previous workspace was
	 *  active.
	 */
	if (xvw_check_menuactive(xwid->commandbar.workspace) == TRUE)
	   xvw_activate_menu(active);

	xwid->commandbar.workspace = active;
	if (xwid->commandbar.execute == NULL ||
	    xwid->commandbar.execute_indx == -1 ||
	    xwid->commandbar.execute_indx >= knumber(commandbar_list))
	{
	   return;
	}
	xvw_get_attribute(active, XVW_WORKSPACE_RUN, &running);

	entry = &commandbar_list[xwid->commandbar.execute_indx];
	if (running == KNODE_STOPPED)
	   kfullpath(entry->set_pixmapfile,
                "$DESIGN/objects/library/xvlang/misc/workspace", temp);
	else
	   kfullpath(entry->unset_pixmapfile,
                "$DESIGN/objects/library/xvlang/misc/workspace", temp);

	 xvw_set_attribute(xwid->commandbar.execute, XVW_PIXMAP_FILENAME, temp);
}

/*-----------------------------------------------------------
|
|  Routine Name: WorkspaceRestoreCallback - workspace restore callback
|
|       Purpose: This callback handlers the restoring of workspace
|
|         Input: object - object in which the object was invoked
|		 client_data - the commandbar object
|		 calldata    - the workspace filename to be restore
|    Written By: Mark Young
|          Date: Nov 05, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void WorkspaceRestoreCallback(
   xvobject workspace,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject commandbar = (xvobject) client_data;
	XvwCommandBarWidget xwid = (XvwCommandBarWidget) xvw_widget(commandbar);

	char *filename;

	if (call_data == NULL || xwid->commandbar.workspace == NULL)
	   return;

	filename = *((char **) call_data);
	if (filename != NULL)
	{
	   xvw_set_attribute(xwid->commandbar.workspace, XVW_WORKSPACE_RESTORE,
			filename);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: CommandbarAnnounce
|
|       Purpose: This routine will perform a variety of workspace announces
|		 for such things as clear, wkspgui, run, etc.
|         Input: object      - the button to announce for
|                client_data - the workspace widget
|                event       - event the activated us
|		 dispatch    - whether to continue dispatch the event
|    Written By: Mark Young
|          Date: Nov 23, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void CommandbarAnnounce(
   xvobject object,
   kaddr    client_data,
   XEvent   *event,
   int      *dispatch)
{
	CommandBarItem *entry = (CommandBarItem *) client_data;

	char *filename = NULL;
	xvobject workspace, commandbar = xvw_parent(object);
	XvwCommandBarWidget xwid = (XvwCommandBarWidget) xvw_widget(commandbar);

	if ((workspace = xwid->commandbar.workspace) == NULL)
	   return;

	if (event->type == LeaveNotify)
	{
	   kannounce(XVLANG, "CommandbarAnnounce", "");
	}
	else if (event->type == EnterNotify)
	{
	   if (entry->announce == NULL)
	      return;

	   xvw_get_attribute(workspace, XVW_WORKSPACE_FILENAME, &filename);
	   if (filename != NULL && kstrcmp(entry->name, "SaveWksp") == 0)
	   {
	      kannounce(XVLANG, "CommandbarAnnounce", "%s  '%s'",
			entry->announce, filename);
	   }
	   else
	      kannounce(XVLANG, "CommandbarAnnounce", "%s", entry->announce);
	}
}


/************************************************************
*
*  Routine Name: xvw_create_commandbar - create a toolbox menu object
*
*       Purpose: Creates a toolbox menu object, that consists of three
*		 menu objects.  The first menu displays the different
*		 categories.  The second menu displays the sub-categories
*		 for the selected category.  And finally the third
*		 displays the operators for the selected sub-category.
*
*		 Two callbacks are provided which can be used to notify
*		 the programmer when the user selects or activates an operator
*		 from the menu.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object
*        Output: None
*       Returns: The commandbar object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Nov 05, 1994
*      Verified:
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_commandbar(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, FALSE, TRUE, name, CommandBarWidgetClass);
	return(object);
}
