/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Internal declaration for xvisual library
   >>>>
   >>>>    Written By: Mark Young & John Salas
   >>>>
   >>>>          Date: Jan 18, 1993 18:36
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_internals_h_
#define _xvisual_internals_h_


	/*-------------------------------------*
	|       #include
	---------------------------------------*/

#include <design.h>
#include <xvinclude.h>
#include <X11/IntrinsicP.h>
#include <xvisual/xvisual.h>
#include "colorspace.h"


	/*-------------------------------------*
	|       #defines
	---------------------------------------*/
#define XVISUAL "design"

#define KUPDATE_TYPE "UpdateType"
#define KRELOAD_TYPE "ReloadType"

#define MOTION_EVENT_UPDATE	   1
#define BUTTONPRESS_EVENT_UPDATE   2
#define PANICON_POSITION_UPDATE	   3
#define IMAGE_REFRESH_UPDATE	   4
#define IMAGE_POSITION_UPDATE	   5

#define IMAGE_OBJECT_RELOAD	   1
#define ZOOM_OBJECT_RELOAD	   2
#define IMAGEICON_OBJECT_RELOAD	   3
#define PANICON_OBJECT_RELOAD	   4

#define MaxMapLength 4096

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* ColorUtil.c */
void ColorUtilCallback	PROTO((xvobject, kaddr, kaddr));

/* ColorNorm.c */
void ApplyMapcolFunction  PROTO((Widget, int));
void ComputeNormalization PROTO((Widget, double *, double *, double *,
				 double *, double *, double *));

/* axis_utils.c */
void parse_scale_factor PROTO((int, int , char *));
void find_scale_factor PROTO((int, double, double , double , int *, double *, char *));
void find_decimal_places PROTO((int, double, double , double , int *));
int max_min_linear PROTO((double *, double *, double , double ));
int nothing_linear PROTO((double *, double *, double *, double *));
int number_steps_linear PROTO((double *, double, double *, double *, Boolean));
int size_number_linear PROTO((double , double, double *, double *));
int step_size_linear PROTO((double , double *, double *, double *, Boolean));
int max_min_log PROTO((double *, double *, double *, double *));
int nothing_log PROTO((double *, double *, double *, double *));
int number_steps_log PROTO((double *, double, double *, double *));
int size_number_log PROTO((double , double, double *, double *));
int step_size_log PROTO((double , double *, double *, double *));
double fracround PROTO((double));
double truncate_double PROTO((double, int));
int numdecs PROTO((double));
int numdigs PROTO((double));
int first_digit PROTO((double));

/* utilities.c */
int xvw_set_type PROTO((kobject, int, int));
int xvw_get_type PROTO((kobject, int *, int *));

#endif /* _xvisual_internals_h_ */
/* Don't add after this point */
