 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                 Zoom Widget Routines
   >>>>
   >>>>	 Private:
   >>>>	  Static:
   >>>>			ClassInitialize()
   >>>>			SetValues()
   >>>>			ZoomCallback()
   >>>>   Public:
   >>>>			xvw_create_zoom()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <xvisual/ZoomP.h>

static void ClassInitialize PROTO((void));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,
				   Cardinal *));
static void ZoomCallback    PROTO((kobject, char *, Widget, kdms_callback *));


/*--------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_ZOOM_FACTOR,	     NULL,    XtRDouble,   NULL},
{XVW_ZOOM_LOCATIONMARKER,    NULL,    XtRInt,      NULL},
{XVW_ZOOM_UPDATEMODE,	     NULL,    XtRInt,      NULL},
{XVW_ZOOM_INTERPOLATE,	     NULL,    XtRInt,      NULL},
};

/*--------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwZoomWidgetRec, zoom.field)

static XtResource resources[] = { 
{XVW_ZOOM_FACTOR, NULL, XtRDouble, sizeof(double),
      offset(zoomfactor), XtRString, (XtPointer) "2.0"},
{XVW_ZOOM_LOCATIONMARKER, NULL, XtRInt, sizeof(int),
      offset(location_marker), XtRImmediate, (XtPointer) KZOOM_LM_CROSS},
{XVW_ZOOM_UPDATEMODE, NULL, XtRInt, sizeof(int),
      offset(update_mode), XtRImmediate, (XtPointer) KZOOM_UM_CONTINUOUS},
{XVW_ZOOM_INTERPOLATE, NULL, XtRInt, sizeof(int),
      offset(interpolate), XtRImmediate, (XtPointer) KZERO_ORDER},

{XVW_IMAGE_BACKING, NULL, XtRBoolean, sizeof(Boolean),
      XtOffsetOf(XvwImageWidgetRec, image.backing),
      XtRImmediate, (XtPointer) FALSE},
{NULL, NULL, XtRInt, sizeof(int),
      XtOffsetOf(XvwImageWidgetRec, image.reload_type),
      XtRImmediate, (XtPointer) ZOOM_OBJECT_RELOAD},
};
#undef offset


#define SUPERCLASS (&xvwImageWidgetClassRec)

XvwZoomWidgetClassRec xvwZoomWidgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Zoom",				/* class_name		  */
    sizeof(XvwZoomWidgetRec),			/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    NULL,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,	            		/* subresources       */
    0,					/* subresources_count */
    sizeof(XvwManagerWidgetConstraintsRec),/* constraint_size    */
    NULL,				/* initialize         */
    NULL,                               /* destroy            */
    NULL,				/* set_values         */
    NULL,                               /* extension          */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                    /* child layout routine  */
    XtInheritChangeSel,                 /* change selected proc   */
    XtInheritEraseSel,                  /* erase selected proc    */
    XtInheritRefreshSel,                /* refresh selection proc */
    XtInheritResize,                    /* resize                 */
    XtInheritGeometryManager,           /* geometry_manager       */
  }, /* XvwManagerWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwGraphicsWidgetClass fields initialization */
  {
    XtInheritColorReload,		/* reload color proc             */
  },  /* XvwColorWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwImageWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwZoomWidgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwZoomWidgetClass for public consumption
 */
WidgetClass xvwZoomWidgetClass = (WidgetClass) &xvwZoomWidgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of zoom widget class has been created.
|                It will initialize all the class attributes.
|
|         Input: None 
|
|        Output: None
|
|    Written By: Mark Young and John M. Salas
|          Date: Aug 15, 1992 12:31
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwZoomWidgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/Zoom.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Zoom");
}


/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a zoom widget instance.   
|		 THIS LOOKS DIFFERENT FROM OTHER SET_VALUES CODE... 
|		 IT DOESN'T SEEM TO LOOK AT ALL THE ZOOM ATTRIBUTES -SK
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output: None
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Oct 24, 1992 23:59
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwZoomWidget cxwid = (XvwZoomWidget) current;
	XvwZoomWidget nxwid = (XvwZoomWidget) new;

	int w, h, d, t, e, *order, *size, xoff, yoff, redisplay = FALSE;


	if (cxwid->image.iobject != nxwid->image.iobject)
	{
	   kpds_add_value_callback(nxwid->image.iobject,
			KPDS_CALLBACK_ACCESS, ZoomCallback, (kaddr) new);
	}

	if (nxwid->image.iobject != NULL &&
	    (cxwid->image.iobject   != nxwid->image.iobject  ||
	     cxwid->zoom.zoomfactor != nxwid->zoom.zoomfactor))
	{
	   if (nxwid->zoom.zoomfactor <= 0.0)
	   {
	      kwarn("design", "ZoomClass", 
		      "Attempt to set zoom factor <= 0; resetting to 0.001"); 
	      nxwid->zoom.zoomfactor = 0.001;
	   }

	   if (cxwid->zoom.zoomfactor != nxwid->zoom.zoomfactor)
	      kfree(nxwid->image.idata);

	   /*
	    *  Get the value data demsionality
	    */
	   kdms_get_attributes(nxwid->image.iobject, KDMS_SEGMENT_VALUE,
			KDMS_PHYSICAL_SIZE, &size,
			KDMS_PHYSICAL_INDEX_ORDER, &order,
			NULL);

	   w = _kdms_get_order(KWIDTH,    order, size, 5, 0);
	   h = _kdms_get_order(KHEIGHT,   order, size, 5, 0);
	   d = _kdms_get_order(KDEPTH,    order, size, 5, 0);
	   t = _kdms_get_order(KTIME,     order, size, 5, 0);
	   e = _kdms_get_order(KELEMENTS, order, size, 5, 0);
	   w *= nxwid->zoom.zoomfactor; h *= nxwid->zoom.zoomfactor;
	   kpds_set_attributes(nxwid->image.iobject,
		KPDS_VALUE_SIZE,        w, h, d, t, e,
		KPDS_VALUE_INTERPOLATE, nxwid->zoom.interpolate,
		NULL);
	   nxwid->image.wsize = w;
	   nxwid->image.hsize = h;
	   nxwid->image.dsize = d;
	   nxwid->image.tsize = t;
	   nxwid->image.esize = e;

	   /*
	    *  In case there is a mask segment...
	    */
	   kpds_set_attribute(nxwid->image.iobject, KPDS_MASK_INTERPOLATE,
			nxwid->zoom.interpolate);

	   if (cxwid->image.iobject == nxwid->image.iobject)
	   {
	      xoff = nxwid->image.xposition * nxwid->zoom.zoomfactor;
	      yoff = nxwid->image.yposition * nxwid->zoom.zoomfactor;

	      xvw_set_attributes(xvw_object(new),
		  XVW_IMAGE_XOFFSET, xoff,
		  XVW_IMAGE_YOFFSET, yoff,
		  XVW_IMAGE_RELOAD,  TRUE,
		  NULL);
	   }
	}

	if (cxwid->zoom.interpolate != nxwid->zoom.interpolate)
	{
	   kpds_set_attribute(nxwid->image.iobject,
		KPDS_VALUE_INTERPOLATE, nxwid->zoom.interpolate);

	   /*
	    *  In case there is a mask segment...
	    */
	   kpds_set_attribute(nxwid->image.iobject,
		KPDS_MASK_INTERPOLATE,  nxwid->zoom.interpolate);
	   redisplay = TRUE;
	}
	return(redisplay);
}


/*-----------------------------------------------------------
|
|  Routine Name: ZoomCallback
|
|       Purpose: This redisplays the position of the object being tracked
|                 
|         Input: 
|        Output:
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 17, 1992 10:24
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ZoomCallback(
   kobject object,
   char    *segment,
   Widget  widget,
   kdms_callback *cb)
{
	XvwZoomWidget xwid = (XvwZoomWidget) widget;

	int w, h, d, update, reload;


	/*
	 *  Make sure we aren't here because of ourself
	 */
	if (object == cb->object)
	   return;

	xvw_get_type(object, &reload, &update);
	if (xwid->zoom.update_mode == KZOOM_UM_CONTINUOUS &&
	    update != MOTION_EVENT_UPDATE ||
	    xwid->zoom.update_mode == KZOOM_UM_BUTTON_PRESS &&
	    update != BUTTONPRESS_EVENT_UPDATE ||
	    reload == ZOOM_OBJECT_RELOAD)
	    /*update != IMAGE_POSITION_UPDATE)*/
	{
	   return;
	}
	w = (cb->end.w - cb->begin.w)/2 + cb->begin.w;
	h = (cb->end.h - cb->begin.h)/2 + cb->begin.h;
	d = cb->begin.d;

	w -= (((int) xwid->core.width)  - xwid->zoom.zoomfactor)/2;
	h -= (((int) xwid->core.height) - xwid->zoom.zoomfactor)/2;
	xwid->image.xposition = xwid->image.yposition = -1;
	xvw_set_attributes(xvw_object(widget),
	    XVW_IMAGE_XOFFSET, w,
	    XVW_IMAGE_YOFFSET, h,
	    /*XVW_IMAGE_BANDNUM, d,*/
	    NULL);
}


/************************************************************
*
*  Routine Name: xvw_create_zoom - create a zoom object
*
*       Purpose: The zoom object provides a zoom window which is
*                used to zoom in on an image.  It was designed for
*                use in conjunction with an image object.
*
*                The zoom factor can be set as desired. The zoom object
*                may be set to update on either Button Press or 
*                Pointer Motion events.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output: none
*	Returns: The zoom object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Oct 08, 1992 15:37
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_zoom(
   xvobject parent,
   char     *name)
{
	xvobject object;

	object = xvw_create(parent, FALSE, TRUE, name, ZoomWidgetClass);
	return(object);
}
