 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                 Timer Gadget Routines
   >>>>
   >>>>	Private:
   >>>>	 Static:
   >>>>			ClassInitialize()
   >>>>			Initialize()
   >>>>			SetValues()
   >>>>			Destroy()
   >>>>			RecomputeTime()
   >>>>   Public:
   >>>>			xvw_create_timer()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <xvisual/TimerP.h>

static void ClassInitialize	PROTO((void));
static void Initialize		PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean SetValues	PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static void Destroy		PROTO((Widget));
static void RecomputeTime	PROTO((XtPointer, XtIntervalId *));


/*--------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_TIMER_UPDATETIME,    NULL,    XtRDouble,    NULL},
{XVW_TIMER_COUNTER,       NULL,    XtRDouble,    NULL},
};

/*--------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwTimerGadgetRec, timer.field)

static XtResource resources[] = { 
{XVW_TIMER_UPDATETIME, NULL, XtRDouble, sizeof(double),
      offset(update_time), XtRString, (XtPointer) "0.1"},
{XVW_TIMER_COUNTER, NULL, XtRDouble, sizeof(double),
      offset(counter), XtRString, (XtPointer) "0.0"},
};
#undef offset

#define SUPERCLASS (&xvwStringValueGadgetClassRec)

XvwTimerGadgetClassRec xvwTimerGadgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Timer",			        /* class_name		  */
    sizeof(XvwTimerGadgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    NULL,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    FALSE,				/* compress_exposure	  */
    FALSE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
    XtInheritPicking,			/* pick object proc       */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    XtInheritChangeGeometry,		/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
    XtInheritRecomputePosition,		/* recompute position proc    */
  },  /* XvwGraphicsGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* xvwStringGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* xvwStringValueGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* XvwTimerGadgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwTimerGadgetClass for public consumption
 */
WidgetClass xvwTimerGadgetClass = (WidgetClass) &xvwTimerGadgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of timer object class has been created.
|                It will initialize all the class attributes. 
|
|         Input:
|
|        Output:
|
|    Written By: Mark Young
|          Date: Oct 23, 1993
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwTimerGadgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/Timer.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Timer");
}


/*-----------------------------------------------------------
|
|  Routine Name: Initialize 
|
|       Purpose: This method will set up the initial values 
|                for all the timer fields of a timer object instance.
|		 The timer update routine is also installed to update
|		 the timer again after the initial update time.
|
|         Input: request - not used 
|                new     - object instance after initialization, with
|                          timer initialized 
|        Output:
|
|    Written By: Mark Young
|          Date: Oct 23, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
        XvwTimerGadget xobj = (XvwTimerGadget) new;

	xobj->timer.time_id = 0;
	RecomputeTime((XvwTimerGadget) new, NULL);
}


/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public fields
|                of a timer object instance.  These fields are
|		 the timer update time.
|                 
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output:
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Oct 23, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwTimerGadget cobj = (XvwTimerGadget) current;
	XvwTimerGadget nobj = (XvwTimerGadget) new;

	if (cobj->timer.update_time != nobj->timer.update_time)
	{
	   if (cobj->timer.update_time == 0) RecomputeTime(nobj, NULL);
	}
	return( FALSE );
}


/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: This method will uninstall the timer update
|		 timeout before the timer object is destroyed. 
|
|         Input: widget - the object being destroyed
|
|        Output:
|
|    Written By: Mark Young
|          Date: Oct 23, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
	XvwTimerGadget xobj = (XvwTimerGadget) widget;

        if (xobj->timer.time_id)
	   XtRemoveTimeOut(xobj->timer.time_id);
}


/*-----------------------------------------------------------
|
|  Routine Name: RecomputeTime 
|
|       Purpose: This routine will recalculate the new timer using the
|		 UNIX time.  This routine will reinstall 
|		 itself to run again in the number of seconds specified
|		 in the timer object's update time field. 
|
|         Input: xobj - the timer object being updated 
|		 id   - the id of the timeout interval
|        Output:
|
|    Written By: Mark Young
|          Date: Oct 23, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void RecomputeTime(
   XtPointer    calldata,
   XtIntervalId *id)
{
	XvwTimerGadget xobj = (XvwTimerGadget) calldata;


	/*
	 *  Compute the position of the object in device coordinates
	 */
	if (xobj->timer.update_time > 0)
	{
           xobj->timer.time_id = XtAppAddTimeOut(
			 XtWidgetToApplicationContext((Widget) xobj),
		 	 (unsigned long) (xobj->timer.update_time*1000),
                         RecomputeTime, (XtPointer) xobj);
	}
	else
	   xobj->timer.time_id = 0;

	xobj->timer.counter += xobj->timer.update_time;
	xvw_set_attribute(xvw_object(calldata), XVW_STRING_VALUE,
			xobj->timer.counter);
}


/************************************************************
*
*  Routine Name: xvw_create_timer - create a timer object.
*
*       Purpose: The timer object is for use as a stopwatch.
*                It displays the current time (including seconds)
*                according to the system clock of the computer.
*                It can be started and stopped as desired, and
*                the update time can be specified to fractions of
*                a second.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output:
*	Returns: The timer object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Oct 23, 1993
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_timer(
   xvobject parent,
   char     *name)
{
	xvobject  object;

	/*
	 *  Call the xvw_create() routine to do the actual creation.
	 */
	object = xvw_create(parent, FALSE, TRUE, name, TimerGadgetClass);
	if (object != NULL)
	{
	   xvw_set_attributes(object,
                XVW_MENUABLE,     TRUE,     /* menuable       */
                XVW_RESIZABLE,    FALSE,    /* resizable      */
                XVW_SELECTABLE,   TRUE,     /* selectable     */
		NULL);
	}
	return(object);
}
