 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>             Rectangle Gadget Routines
   >>>>
   >>>>	 Private:
   >>>>	  Static:
   >>>>			ClassInitialize()
   >>>>			Redisplay()
   >>>>			SetValues()
   >>>>			RecomputePosition()
   >>>>			ChangeGeometry()
   >>>>   Public:
   >>>>			xvw_create_rectangle()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvisual/RectangleP.h>

static void    ClassInitialize	 PROTO((void));
static void    Redisplay	 PROTO((Widget, XEvent *, Region));
static Boolean SetValues	 PROTO((Widget, Widget, Widget, ArgList,
					Cardinal *));
static void    Realize		 PROTO((Widget, XtValueMask *,
					XSetWindowAttributes *));

static void RecomputePosition	 PROTO((Widget));
static void ChangeGeometry	 PROTO((Widget));


/*--------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_RECTANGLE_XCORNER,      NULL,    XtRDouble,    NULL},
{XVW_RECTANGLE_YCORNER,      NULL,    XtRDouble,    NULL},
{XVW_RECTANGLE_XDIAGONAL,    NULL,    XtRDouble,    NULL},
{XVW_RECTANGLE_YDIAGONAL,    NULL,    XtRDouble,    NULL},
};

/*--------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwRectangleGadgetRec, rectangle.field)

static XtResource resources[] = { 
{XVW_RECTANGLE_XCORNER, NULL, XtRDouble, sizeof(double), 
      offset(corner.x), XtRString, (XtPointer) "0.0"},
{XVW_RECTANGLE_YCORNER, NULL, XtRDouble, sizeof(double), 
      offset(corner.y), XtRString, (XtPointer) "0.0"},
{XVW_RECTANGLE_XDIAGONAL, NULL, XtRDouble, sizeof(double), 
      offset(diagonal.x), XtRString, (XtPointer) "0.0"},
{XVW_RECTANGLE_YDIAGONAL, NULL, XtRDouble, sizeof(double), 
      offset(diagonal.y), XtRString, (XtPointer) "0.0"},
};
#undef offset


#define SUPERCLASS (&xvwGraphicsGadgetClassRec)

XvwRectangleGadgetClassRec xvwRectangleGadgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Rectangle",			/* class_name		  */
    sizeof(XvwRectangleGadgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    NULL,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    (XtProc) Realize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),			/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    FALSE,				/* compress_exposure	  */
    FALSE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    Redisplay,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
    XtInheritPicking,			/* pick object proc       */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    ChangeGeometry,			/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
    RecomputePosition,			/* recompute position proc    */
  },  /* XvwGraphicsGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* XvwRectangleGadgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwRectangleGadgetClass for public consumption
 */
WidgetClass xvwRectangleGadgetClass = (WidgetClass) &xvwRectangleGadgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of rectangle object class has been created.
|                It will initialize all the class attributes. 
|
|    Written By: Mark Young
|          Date: Aug 03, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
        xvw_init_attributes(xvwRectangleGadgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/Rectangle.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Rectangle");
}

/*-----------------------------------------------------------
|
|  Routine Name: Realize
|
|       Purpose: This method will 
|         Input: widget     - the object to realize
|    Written By: Mark Young
|          Date: Dec 30, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Realize(
   Widget		widget,
   XtValueMask          *valuemask,
   XSetWindowAttributes *winattrib)
{
	XvwRectangleGadget xobj = (XvwRectangleGadget) widget;
}

/*-----------------------------------------------------------
|
|  Routine Name: Redisplay
|
|       Purpose: This routine will redraw the rectangle object in response
|                to an expose event. 
|
|         Input: widget - the rectangle object that was exposed 
|                event  - the event that caused the redraw
|                region - the region that was exposed 
|
|    Written By: Mark Young
|          Date: Aug 03, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Redisplay(
   Widget widget,
   XEvent *event,
   Region region)
{
	XvwRectangleGadget xobj = (XvwRectangleGadget) widget;

	Coord  coord;
	int    id;
	XColor *fg, *bg;
	Real   width, height;

	id	 = xobj->graphics.id;
	fg	 = &xobj->graphics.fg;
	bg	 = &xobj->graphics.bg;
	coord.x  = kmin(xobj->rectangle.corner.x, xobj->rectangle.diagonal.x);
	coord.y  = kmin(xobj->rectangle.corner.y, xobj->rectangle.diagonal.y);
	width    = kabs(xobj->rectangle.corner.x - xobj->rectangle.diagonal.x);
	height   = kabs(xobj->rectangle.corner.y - xobj->rectangle.diagonal.y);

	if (xobj->graphics.filled == FALSE)
	   X2D_draw_rectangle(id, coord, width, height, fg);
	else
	   X2D_fill_rectangle(id, coord, width, height, fg, bg);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: If the the size or postion of the rectangle has changed, 
|                recalculate the size and position of the rectangle.
|
|         Input: current - the object containing current settings 
|                request - the object containing requested settings
|                new     - the object processed through all set values methods 
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Aug 03, 1994
| Modifications: 
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwRectangleGadget cobj = (XvwRectangleGadget) current;
	XvwRectangleGadget nobj = (XvwRectangleGadget) new;


	if (cobj->rectangle.corner.x != nobj->rectangle.corner.x     ||
	    cobj->rectangle.corner.y != nobj->rectangle.corner.y     ||
	    cobj->rectangle.diagonal.x != nobj->rectangle.diagonal.x ||
	    cobj->rectangle.diagonal.y != nobj->rectangle.diagonal.y)
	{
#if 0
	   RecomputePosition(new);
#endif
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: RecomputePosition
|
|       Purpose: Given a new world coordinate rectangle 
|                corner and diagonal, recompute the new 
|                device coordinate size and position of 
|		 the rectangle. 
|
|         Input: widget - the rectangle object 
|
|    Written By: Mark Young
|          Date: Aug 03, 1994
| Modifications: 
|
------------------------------------------------------------*/
/* ARGSUSED */
static void RecomputePosition(
   Widget widget)
{
	XvwRectangleGadget xobj = (XvwRectangleGadget) widget;

	XtWidgetGeometry temp;
	int id = xobj->graphics.id;
	Real xpos1, xpos2, ypos1, ypos2;


	if (xobj->manager.realized == FALSE)
	   return;

	X2D_convert_point_wc_to_dc(id, xobj->rectangle.corner, &xpos1, &ypos1);
	X2D_convert_point_wc_to_dc(id, xobj->rectangle.diagonal, &xpos2,&ypos2);

	temp.request_mode = CWWidth | CWHeight | CWX | CWY;
	temp.x = (Position) kmin(xpos1, xpos2);
	temp.y = (Position) kmin(ypos1, ypos2);
	temp.width  = (Dimension) kabs(xpos2 - xpos1);
	temp.height = (Dimension) kabs(ypos2 - ypos1);
	(void) XtMakeGeometryRequest(widget, &temp, &temp);
}

/*-----------------------------------------------------------
|
|  Routine Name: ChangeGeometry
|
|       Purpose: Given a device coordinate description of the 
|		 rectangle, recompute the world coordinate 
|                corner and diagonal point.
|
|         Input: widget - the rectangle object 
|    Written By: Mark Young
|          Date: Aug 03, 1994
| Modifications: 
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ChangeGeometry(
   Widget widget)
{
	XvwRectangleGadget xobj = (XvwRectangleGadget) widget;

	int id = xobj->graphics.id;
	Real xpos1, xpos2, ypos1, ypos2;


	if (xobj->rectangle.corner.x < xobj->rectangle.diagonal.x)
	{
	   xpos1 = (Real) widget->core.x;
	   xpos2 = (Real) ((int) widget->core.x  + (int) widget->core.width);
	}
	else
	{
	   xpos1 = (Real) ((int) widget->core.x  + (int) widget->core.width);
	   xpos2 = (Real) widget->core.x;
	}

	if (xobj->rectangle.corner.y < xobj->rectangle.diagonal.y)
	{
	   ypos1 = (Real) widget->core.y;
	   ypos2 = (Real) ((int) widget->core.y + (int) widget->core.height);
	}
	else
	{
	   ypos1 = (Real) ((int) widget->core.y + (int) widget->core.height);
	   ypos2 = (Real) widget->core.y;
	}
	X2D_convert_point_dc_to_wc(id, xpos1, ypos1, &xobj->rectangle.diagonal);
	X2D_convert_point_dc_to_wc(id, xpos2, ypos2, &xobj->rectangle.corner);
}


/************************************************************
*
*  Routine Name: xvw_create_rectangle - creates a rectangle object
*
*       Purpose: A rectangle visual object supports the display of a rectangle.
*                The (x, y) location of one rectangle corner and an opposite 
*                corner are specified in world coordinates.  The world
*                coordinates are specified by the parent.  By default, these
*                world coordinates are from 0 to 1 unless otherwise specified.
*                So, for example, if the rectangle is created as the child of
*                a manager object, its world coordinates are from 0 to 1.
*                In contrast, if the rectangle is created as the child of an 
*                image, the world coordinates will be dictated by the size of 
*                the image; if it created as the child of a plot object, the 
*                world coordinates will be dictated by the plot.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output: None 
*
*	Returns: The rectangle object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young 
*          Date: Jun 29, 1992 10:31
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_rectangle(
   xvobject parent,
   char     *name)
{
	xvobject  object;


	/*
	 *  Create the rectangle object
	 */
	object = xvw_create(parent, FALSE, TRUE, name, RectangleGadgetClass);
	return(object);
}
