 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                PrintPixel Widget Routines
   >>>>
   >>>>	Private:
   >>>>	 Static:
   >>>>			ClassInitialize()
   >>>>			Initialize()
   >>>>			Redisplay()
   >>>>			SetValues()
   >>>>			GetObjectName()
   >>>>			SetObjectName()
   >>>>			ReloadCallback()
   >>>>			PositionCallback()
   >>>>			RedisplayPixels()
   >>>>			HighlightValue()
   >>>>  Public:
   >>>>			xvw_create_printpixel()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvisual/PrintPixelP.h>


static void ClassInitialize PROTO((void));
static void Initialize      PROTO((Widget, Widget, ArgList, Cardinal *));
static void Redisplay	    PROTO((Widget, XEvent *, Region));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,
				   Cardinal *));

static int  GetObjectName    PROTO((xvobject, char *, kaddr));
static int  SetObjectName    PROTO((xvobject, char *, kaddr));
static void ReloadCallback   PROTO((kobject, char *, Widget, kdms_callback *));
static void PositionCallback PROTO((kobject, char *, Widget, kdms_callback *));
static void RedisplayPixels  PROTO((Widget));
static void HighlightValue   PROTO((Widget, int, int));



#undef  kwidget
#define kwidget(widget)      (XvwPrintPixelWidget) (widget)

/*-------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_PRINTPIXEL_WIDTH,     NULL,    XtRInt,        NULL},
{XVW_PRINTPIXEL_HEIGHT,    NULL,    XtRInt,        NULL},
{XVW_PRINTPIXEL_EDITABLE,  NULL,    XtRInt,        XtRBoolean},
{XVW_PRINTPIXEL_OBJECT,    NULL,    XtRPointer,    NULL},
{XVW_PRINTPIXEL_SHOWCOLOR, NULL,    XtRInt,        XtRBoolean},
{XVW_PRINTPIXEL_UPDATEMODE,NULL,    XtRInt,        NULL},
{XVW_PRINTPIXEL_XPOSITION, NULL,    XtRInt,        NULL},
{XVW_PRINTPIXEL_YPOSITION, NULL,    XtRInt,        NULL},
};

/*-------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwPrintPixelWidgetRec, printpixel.field)

static XtResource resources[] = { 

{XVW_PRINTPIXEL_WIDTH, NULL, XtRInt, sizeof(int),
      offset(width), XtRImmediate, (XtPointer) 8},
{XVW_PRINTPIXEL_HEIGHT, NULL, XtRInt, sizeof(int),
      offset(height), XtRImmediate, (XtPointer) 8},
{XVW_PRINTPIXEL_EDITABLE, NULL, XtRBoolean, sizeof(Boolean),
      offset(editable), XtRImmediate, (XtPointer) FALSE},
{XVW_PRINTPIXEL_SHOWCOLOR, NULL, XtRBoolean, sizeof(Boolean),
      offset(showcolor), XtRImmediate, (XtPointer) TRUE},
{XVW_PRINTPIXEL_OBJECT, NULL, XtRPointer, sizeof(kobject),
      offset(object), XtRImmediate, (XtPointer) NULL},
{XVW_PRINTPIXEL_UPDATEMODE, NULL, XtRInt, sizeof(int),
      offset(update_mode), XtRImmediate, (XtPointer) KPRINTPIXEL_UM_CONTINUOUS},
{XVW_PRINTPIXEL_XPOSITION, NULL, XtRInt, sizeof(int),
      offset(xposition), XtRImmediate, (XtPointer) 0},
{XVW_PRINTPIXEL_YPOSITION, NULL, XtRInt, sizeof(int),
      offset(yposition), XtRImmediate, (XtPointer) 0},

{NULL, NULL, XtRPixel, sizeof(Pixel),
      offset(black), XtRString, (XtPointer) "black"},
{NULL, NULL, XtRPixel, sizeof(Pixel),
      offset(white), XtRString, (XtPointer) "white"},
};
#undef offset


#define SUPERCLASS (&xvwColorWidgetClassRec)

XvwPrintPixelWidgetClassRec xvwPrintPixelWidgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "PrintPixel",			/* class_name		  */
    sizeof(XvwPrintPixelWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    Redisplay,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    XtInheritTranslations,		/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,	            		/* subresources       */
    0,					/* subresources_count */
    sizeof(XvwManagerWidgetConstraintsRec),/* constraint_size    */
    NULL,				/* initialize         */
    NULL,                               /* destroy            */
    NULL,				/* set_values         */
    NULL,                               /* extension          */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,			/* child layout routine  */
    XtInheritChangeSel,		        /* change selected proc   */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    XtInheritResize,			/* resize		  */
    XtInheritGeometryManager,  		/* geometry_manager	  */
  }, /* XvwManagerWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwGraphicsWidgetClass fields initialization */
  {
    XtInheritColorReload,		/* reload color proc             */
  },  /* XvwColorWidgetClass fields initialization */
  {
    NULL,                               /* field not used    */
  },  /* XvwPrintPixelWidgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwPrintPixelWidgetClass for public consumption
 */
WidgetClass xvwPrintPixelWidgetClass = (WidgetClass) &xvwPrintPixelWidgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of printpixel widget class has been created.
|                It will initialize all the class attributes.
|
|         Input: none 
|
|        Output: none
|
|    Written By: Mark Young 
|          Date: Nov 17, 1993
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwPrintPixelWidgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$XVISUAL/objects/library/xvisual/uis/PrintPixel.pane");
	xvw_load_resources("$XVISUAL/objects/library/xvisual/app-defaults/PrintPixel");

	xvw_define_attributes(xvwPrintPixelWidgetClass,
	  XVW_PRINTPIXEL_FILENAME, XtRString, SetObjectName, GetObjectName,
	  NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method will set up the initial image
|                for an image widget instance.
|
|         Input: request - not used
|                new     - widget instance after initialization, with
|                          initial image
|
|        Output: None
|
|    Written By: Mark Young
|          Date: Mon Jun 29 10:35:11 MDT 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
        XvwPrintPixelWidget xwid = kwidget(new);

	XColor color;
	int width, height;

	xwid->printpixel.rgb = FALSE;

	xvw_recompute_charfont(xvw_object(new), &width, &height);
	xwid->printpixel.font_width  = width;
	xwid->printpixel.font_height = height - (int) height * 0.2;

	color.flags = DoRed | DoGreen | DoBlue;

	color.red = color.green = color.blue = 0;
	if (XAllocColor(XtDisplay(new), new->core.colormap, &color) != 0)
	   xwid->printpixel.black = color.pixel;

	color.red = color.green = color.blue = 65535;
	if (XAllocColor(XtDisplay(new), new->core.colormap, &color) != 0)
	   xwid->printpixel.white = color.pixel;
}

/*-----------------------------------------------------------
|
|  Routine Name: Redisplay
|
|       Purpose: This routine calls the RedisplayPixel procedure when an
|                expose event occurs.
|
|         Input: widget - widget data structure for palette
|		 event	- the event that caused the redraw
|		 region	- the region that was exposed
|
|        Output: None
|
|    Written By: Mark Young
|          Date: Nov 17, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Redisplay(
   Widget widget,
   XEvent *event,
   Region region)
{
	XvwPrintPixelWidget xwid = kwidget(widget);

	RedisplayPixels(widget);
	(*xvwPrintPixelWidgetClass->core_class.superclass->core_class.expose)
                (widget, event, region);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: Determine what the widget should do by
|		 comparing the current values verse the
|		 new settings.
|
|         Input: current - the widget containing current settings 
|		 request - the widget containing requested settings
|		 new	 - the widget processed through all set values methods 
|
|        Output: None directly
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 17, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	int e, type;
	XvwPrintPixelWidget cxwid = kwidget(current);
	XvwPrintPixelWidget nxwid = kwidget(new);

	Boolean redisplay = FALSE;


	if (cxwid->printpixel.object != nxwid->printpixel.object)
	{
	   nxwid->printpixel.object =
		kpds_reference_object(nxwid->printpixel.object);
	   kpds_close_object(cxwid->printpixel.object);
	   kpds_add_value_callback(nxwid->printpixel.object,
		KPDS_CALLBACK_CHANGE, ReloadCallback, (kaddr) new);
	   kpds_add_value_callback(nxwid->printpixel.object,
                     KPDS_CALLBACK_ACCESS, PositionCallback, (kaddr) new);

	   xvw_set_attribute(xvw_object(new), XVW_COLOR_COLOROBJ,
                        nxwid->printpixel.object);

	   /*
            *  see if we have an RGB image
	    */
           kpds_get_attributes(nxwid->printpixel.object,
                        KPDS_VALUE_SIZE, NULL, NULL, NULL, NULL, &e,
                        KPDS_VALUE_DATA_TYPE, &type,
                        NULL);

           nxwid->printpixel.rgb = (e == 3 || e == 4);

	   redisplay = TRUE;
	}

	if (cxwid->printpixel.width  != nxwid->printpixel.width  ||
	    cxwid->printpixel.height != nxwid->printpixel.height)
	{
	   redisplay = TRUE;
	}

	if (cxwid->manager.font != nxwid->manager.font)
	{
	   int width, height;

	   xvw_recompute_charfont(xvw_object(new), &width, &height);
	   nxwid->printpixel.font_width  = width;
	   nxwid->printpixel.font_height = height - (int) height * 0.2;
	   redisplay = TRUE;
	}

	return(redisplay);
}

/*-----------------------------------------------------------
|
|  Routine Name: GetObjectName
|
|       Purpose: GetObjectName is used to get the filename associated
|		 with the attribute.
|
|         Input: widget    - the widget in which we will be getting the
|			     filename
|		 attribute - the old object to be closed
|
|        Output: calldata  - pointer to retrieve the object name
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 17, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int GetObjectName(
   xvobject object,
   char     *attribute,
   kaddr    calldata)
{
	XvwPrintPixelWidget xwid = (XvwPrintPixelWidget) xvw_widget(object);
	String *filename = (String *) calldata;


	if (kstrcmp(attribute, XVW_PRINTPIXEL_FILENAME) != 0)
	{
	   kerror(XVISUAL, "GetObjectName", "invalid attribute %s",
			attribute);
	   return(FALSE);
	}
	*filename = NULL;
	return(kpds_get_attribute(xwid->printpixel.object, KPDS_NAME,filename));
}


/*-----------------------------------------------------------
|
|  Routine Name: SetObjectName
|
|       Purpose: SetObjectName is used to set the filename associated
|		 with the attribute.
|
|         Input: object    - the object in which we will be getting the
|			     filename
|		 attribute - the old object to be closed
|		 calldata  - the filename to be set
|
|        Output:
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 17, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int SetObjectName(
   xvobject printpixel,
   char     *attribute,
   kaddr    calldata)
{
	int	locate = TRUE;
	kobject object = NULL;
	XvwPrintPixelWidget xwid = (XvwPrintPixelWidget) xvw_widget(printpixel);
	String *filename = (String *) calldata;


	if (*filename != NULL && (object = kdms_locate(*filename)) == NULL)
	{
	   locate = FALSE;
	   if ((object = kpds_open_object(*filename, KOBJ_READ)) == NULL)
	   {
	      kerror(XVISUAL, "SetObjectName", "Failed to load image '%s'",
			*filename);
	      return(TRUE);
	   }
	}

	if (kstrcmp(attribute, XVW_PRINTPIXEL_FILENAME) == 0)
	   xvw_set_attribute(printpixel, XVW_PRINTPIXEL_OBJECT, object);
	else
	{
	   kerror(XVISUAL, "SetObjectName", "invalid attribute %s",
			attribute);
	   if (!locate) kpds_close_object(object);
	   return(FALSE);
	}
	if (!locate) kpds_close_object(object);
	
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ReloadCallback
|
|       Purpose: Reload the pixels since the data has changed
|
|         Input: xwid - the printpixel widget to load the value data
|        Output: 
|    Written By: Mark Young
|          Date: Nov 17, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ReloadCallback(
   kobject object,
   char    *segment,
   Widget  widget,
   kdms_callback *cb)
{
	/* perform check to see if we are in the area that's changed */
	RedisplayPixels(widget);
}

/*-----------------------------------------------------------
|
|  Routine Name: PositionCallback
|
|       Purpose: This re-prints the pixels of the object being tracked
|
|         Input: xwid - the printpixel widget to load the value data
|        Output: 
|    Written By: Mark Young
|          Date: Nov 17, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void PositionCallback(
   kobject object,
   char    *segment,
   Widget  widget,
   kdms_callback *cb)
{
	int      w, h, update;
	XvwPrintPixelWidget xwid = (XvwPrintPixelWidget) widget;


	/*
	 *  Make sure we aren't here because of ourself
	 */
	if (object == cb->object)
	   return;

	xvw_get_type(object, NULL, &update);
	if (xwid->printpixel.update_mode == KPRINTPIXEL_UM_CONTINUOUS &&
	    update != MOTION_EVENT_UPDATE ||
	    xwid->printpixel.update_mode == KPRINTPIXEL_UM_BUTTON_PRESS &&
	    update != BUTTONPRESS_EVENT_UPDATE)
	    /*update != IMAGE_POSITION_UPDATE)*/
	{
	   return;
	}

	w = (cb->end.w - cb->begin.w)/2 + cb->begin.w;
	h = (cb->end.h - cb->begin.h)/2 + cb->begin.h;
	xwid->printpixel.xposition = w - xwid->printpixel.width/2;
	xwid->printpixel.yposition = h - xwid->printpixel.height/2;
	RedisplayPixels(widget);
}
 
/*-----------------------------------------------------------
|
|  Routine Name: RedisplayPixels - create and relayout the pixels
|
|       Purpose: create and relayout the pixels being displayed.
|
|         Input: widget - the printpixel widget to create the pixels for
|        Output: 
|       Returns: 
|    Written By: Mark Young
|          Date: Nov 17, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void RedisplayPixels(
   Widget widget)
{
	XvwPrintPixelWidget xwid = kwidget(widget);
	xvobject printpixel = xvw_object(widget);
	XColor   *xcolors = ColorGetXColors(widget);

	char     temp[KLENGTH];
	unsigned char *mdata = NULL;
	int	 i, xpos, ypos, indx;
	Pixel	 background, foreground;
	double   *data, light, val1 = 0.0, val3 = 0.0;

	GC	 gc = xwid->manager.gc;
	Window   window   = XtWindow(widget);
	Display  *display = XtDisplay(widget);
	kobject  object = xwid->printpixel.object;
	int      xposition = xwid->printpixel.xposition;
	int      yposition = xwid->printpixel.yposition;
	int      width   = xwid->printpixel.width;
	int      height  = xwid->printpixel.height;
	int      font_width   = xwid->printpixel.font_width;
	int      font_height  = xwid->printpixel.font_height;


	if (!xvw_check_visible(xvw_object(widget)) || object == NULL)
	   return;

        if (kpds_query_mask(object) == TRUE)
	{
	   kpds_set_attributes(object,
		KPDS_MASK_POSITION, xposition, yposition, 0, 0, 0,
		KPDS_MASK_DATA_TYPE, KUBYTE,
		KPDS_MASK_REGION_SIZE, width, height, 1, 1, 1,
		NULL);

	   mdata = kpds_get_data(object, KPDS_MASK_REGION, NULL);
	}

        kpds_set_attributes(object,
                            KPDS_VALUE_POSITION, xposition, yposition, 0, 0, 0,
                            KPDS_VALUE_DATA_TYPE, KDOUBLE,
			    NULL);

	if (!xwid->printpixel.rgb)
	{
	   kpds_set_attribute(object, KPDS_VALUE_REGION_SIZE, 
			      width, height, 1, 1, 1);

	   if ((data = kpds_get_data(object, KPDS_VALUE_REGION, NULL)) == NULL)
           {
              kerror(XVISUAL, "RedisplayPixels", "Unable to get image pixels");
              return;
           }
	   xpos = 3;
	   ypos = font_height;
	   for (i = 0; i < width*height; i++, xpos += 4*font_width)
	   {
	      if ((i % width) == 0 && i != 0)
	      {
	         xpos = 3;
	         ypos += font_height;
	      }

	      if (mdata != NULL && mdata[i] == 0)
	      {
	         XClearArea(display, window, xpos, ypos-font_height,
			   4*font_width, font_height, FALSE);
	         continue;
	      }

	      indx = (int) data[i];
	      ksprintf(temp, " %3g ", data[i]);
	      if (xwid->printpixel.showcolor)
	      {
	         RGB_to_HLS(xcolors[indx], val1, light, val3);
	         if (light >= 0.45)
		    foreground = xwid->printpixel.black;
	         else
		    foreground = xwid->printpixel.white;

	         background = ColorAllocate(widget, indx);
	         XSetBackground(display, gc, background);
	         XSetForeground(display, gc, foreground);
                 XDrawImageString(display, window, gc, xpos, ypos, temp, 5);
	      }
	      else
	         XDrawImageString(display, window, gc, xpos, ypos, temp, 5);

	      /*
	       *  If this is the pixel the cursor is on, highlight it.
	       */
	      if ( i == (int)(width/2)*height + (int)(width/2))
		HighlightValue(widget, xpos, ypos);
	   }
	   kfree(data);
	}
	else
	{
	   double    dvect[4];
	   char      temp0[KLENGTH];
	   char      temp1[KLENGTH];
	   char      temp2[KLENGTH];
	   int       e, j;
	   int       display_height = font_height*height;

	   kpds_get_attribute(object, KPDS_VALUE_SIZE,
			      NULL, NULL, NULL, NULL, &e);
           xpos = 3;
           ypos = font_height;
           for (i = 0; i < width; i++, xpos += 4*font_width)
           {
 	      ypos = 0;
	      for (j = 0; j < height; j++, ypos += 1.15*font_height)
	      {
                 kpds_set_attribute(object, KPDS_VALUE_POSITION, 
		 		       xposition+i, yposition+j, 0, 0, 0);
                 if (mdata != NULL && mdata[i] == 0)
                 {
                       XClearArea(display, window, xpos, ypos-font_height,
                                 4*font_width, font_height, FALSE);
                       continue;
                 }
		 if (kpds_get_data(object,KPDS_VALUE_VECTOR, dvect)!= NULL)
                 {
                    ksprintf(temp0, " %3g ", dvect[0]);
                    ksprintf(temp1, " %3g ", dvect[1]);
                    ksprintf(temp2, " %3g ", dvect[2]);
                    if (xwid->printpixel.showcolor)
                    {
                       XDrawImageString(display, window, gc, xpos, 
				        ypos, temp0, 5);
                       XDrawImageString(display, window, gc, xpos, 
					ypos+display_height+font_height*3, 
				        temp1, 5);
                       XDrawImageString(display, window, gc, xpos, 
					ypos+2*display_height+font_height*6, 
				        temp2, 5);

	               /*
	                * If this is the pixel the cursor is on, highlight each.
	                */
	               if ((i == (int)((width+1)/2)) && 
			   (j == (int)((height+1)/2)) )
 		       {
		           HighlightValue(widget, xpos, ypos);
		           HighlightValue(widget, xpos, 
			                  ypos+display_height+font_height*3);
		           HighlightValue(widget, xpos, 
			                  ypos+2*display_height+font_height*6);
		       }
                     }
	         }
	      }
           }
	}
	kfree(mdata);
}

/*-----------------------------------------------------------
|
|  Routine Name: HighlightValue - highlight value that cursor is on
|
|       Purpose: Utility routine to highlight the printpixel value
|                that represents the pixel that the cursor is positioned over.
|
|         Input: widget - the printpixel widget
|                xpos   - x position in printpixel display
|                ypos   - y position in printpixel display
|        Output:
|       Returns:
|    Written By: Danielle Argiro
|          Date: Dec 16, 1994
| Modifications:
|
------------------------------------------------------------*/

static void HighlightValue(
   Widget widget,
   int    xpos,
   int    ypos)
{
        XvwPrintPixelWidget xwid = kwidget(widget);
        xvobject printpixel = xvw_object(widget);

        GC       gc = xwid->manager.gc;
        Window   window   = XtWindow(widget);
        Display  *display = XtDisplay(widget);
        kobject  object = xwid->printpixel.object;
        int      width   = xwid->printpixel.width;
        int      height  = xwid->printpixel.height;
        int      font_width   = xwid->printpixel.font_width;
        int      font_height  = xwid->printpixel.font_height;


	/*
         *  Draw the background "black" rectangles.
         */
	XSetForeground(display, gc, xwid->printpixel.black);
        XDrawRectangle(display, window, gc, xpos-3,
                                ypos-font_height*3/4-1,
                                (unsigned int) 4*font_width+2,
                                (unsigned int) font_height);
        XDrawRectangle(display, window, gc, xpos-1,
                                ypos-font_height*3/4+1,
                                (unsigned int) 4*font_width-2,
                                (unsigned int) font_height-4);
        /*
         *  Now draw the foreground "white" rectangle.
         */
        XSetForeground(display, gc, xwid->printpixel.white);
        XDrawRectangle(display, window, gc, xpos-2,
                                ypos-font_height*3/4,
                               (unsigned int) 4*font_width,
                               (unsigned int) font_height-2);
}



/************************************************************
*
*  Routine Name: xvw_create_printpixel - create a printpixel xvobject
*
*       Purpose: A printpixel object provides a mechanism which will track 
*                pointer movement in an image object and print the values of 
*                the pixels in the area under the pointer.
*                It was designed for use in conjunction with an image object.
*
*                The printpixel object is made up of one or more 
*                (width x height) sets of label objects.  The background of 
*                each label is the color in which the pixel appears.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output: None
*
*	Returns: The printpixel xvobject on success, NULL otherwise
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Nov 17, 1993
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_printpixel(
   xvobject parent,
   char     *name)
{
	xvobject object;


	/*
	 *  Call the xvw_create() routine to do the actual creation.
	 */
	object = xvw_create(parent, FALSE, TRUE, name, PrintPixelWidgetClass);
	return(object);
}
