/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>           Graphics Widget/Gadget Routines
   >>>>
   >>>>	 Static:
   >>>>			ClassPartInitializeWidget()
   >>>>			ClassPartInitializeGadget()
   >>>>			ClassInitializeGadget()
   >>>>			ClassInitializeWidget()
   >>>>			Initialize()
   >>>>			RealizeWidget()
   >>>>			RealizeGadget()
   >>>>			ResizeGadget()
   >>>>			Destroy()
   >>>>			SetValuesGadget()
   >>>>			SetValuesWidget()
   >>>>			SetValues()
   >>>>
   >>>>			RecomputePosition()
   >>>>			ChangeGeometry()
   >>>>			SetWorldView()
   >>>>	Private:
   >>>>		    	GetGraphicsPart()
   >>>>	 Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvisual/GraphicsP.h>


static void ClassPartInitializeWidget	PROTO((WidgetClass));
static void ClassPartInitializeGadget	PROTO((WidgetClass));
static void ClassInitializeGadget	PROTO((void));
static void ClassInitializeWidget	PROTO((void));
static void Initialize			PROTO((Widget, Widget, ArgList,
					       Cardinal *));
static void RealizeWidget		PROTO((Widget,XtValueMask *,
					       XSetWindowAttributes *));
static void RealizeGadget		PROTO((Widget,XtValueMask *,
					       XSetWindowAttributes *));
static void ResizeGadget		PROTO((Widget));
static void Destroy			PROTO((Widget));
static Boolean SetValuesGadget		PROTO((Widget, Widget, Widget,
					       ArgList, Cardinal *));
static Boolean SetValuesWidget		PROTO((Widget, Widget, Widget,
				      	       ArgList, Cardinal *));
static Boolean SetValues		PROTO((Widget, XvwGraphicsPart *, XvwGraphicsPart *, XvwGraphicsPart *));

static void RecomputePosition		PROTO((Widget));
static void ChangeGeometry		PROTO((Widget));
static void SetWorldView		PROTO((Widget, XvwGraphicsPart *));


/*-------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_GRAPHICS_WCMIN_X,	          NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_WCMIN_Y,	          NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_WCMIN_Z,	          NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_WCMAX_X,	          NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_WCMAX_Y,	          NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_WCMAX_Z,	          NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_FILLED,	          NULL,    XtRInt,	  XtRBoolean},
{XVW_GRAPHICS_LINETYPE,	          NULL,    XtRInt,	  NULL},
{XVW_GRAPHICS_MARKERTYPE,         NULL,    XtRInt,	  NULL},
{XVW_GRAPHICS_LINEWIDTH,          NULL,    XtRInt,	  NULL},
{XVW_GRAPHICS_PROPORTIONAL,       NULL,    XtRInt,	  NULL},
{XVW_GRAPHICS_CLIPPING,	          NULL,    XtRInt,	  XtRBoolean},
{XVW_GRAPHICS_RESET_WORLD,        NULL,    XtRInt,	  XtRBoolean},
{XVW_GRAPHICS_DEPTH_CLIPPING,     NULL,    XtRInt,	  XtRBoolean},
{XVW_GRAPHICS_PROJECTION,         NULL,    XtRInt,	  NULL},
{XVW_GRAPHICS_ALPHA,	          NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_THETA,	          NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_GAMMA,	          NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_EYE,	          NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_VIEWDISTANCE,       NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_VIEWPORT_MIN_X,     NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_VIEWPORT_MIN_Y,     NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_VIEWPORT_MIN_Z,     NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_VIEWPORT_MAX_X,     NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_VIEWPORT_MAX_Y,     NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_VIEWPORT_MAX_Z,     NULL,    XtRDouble,	  NULL},
{XVW_GRAPHICS_MODE_X,	          NULL,    XtRInt,	  NULL},
{XVW_GRAPHICS_MODE_Y,	          NULL,    XtRInt,	  NULL},
{XVW_GRAPHICS_MODE_Z,	          NULL,    XtRInt,	  NULL},
{XVW_GRAPHICS_SYMMETRIC_X,        NULL,    XtRInt,	  XtRBoolean},
{XVW_GRAPHICS_SYMMETRIC_Y,        NULL,    XtRInt,	  XtRBoolean},
{XVW_GRAPHICS_SYMMETRIC_Z,        NULL,    XtRInt,	  XtRBoolean},
{XVW_GRAPHICS_TYPE, 	          NULL,    XtRInt,	  NULL},
};

/*-------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwGraphicsPart, field)

static double graphics_alpha   = 100.0,
	      graphics_theta   = 200.0,
	      graphics_gamma   = 0.0,
	      graphics_eye     = 0.0,
	      graphics_view    = 6.0;

static double graphics_min     = 0.0,
	      graphics_max     = 1.0;

static XtResource graphics_resources[] = { 
{XVW_BACKGROUND, NULL, XtRPixel, sizeof(Pixel),
      offset(bg.pixel), XtRString, XtDefaultBackground},
{XVW_FOREGROUND, NULL, XtRPixel, sizeof(Pixel),
      offset(fg.pixel), XtRString, XtDefaultForeground},
{XVW_GRAPHICS_LINETYPE,  NULL, XtRInt, sizeof(int),
      offset(line_type), XtRImmediate, (XtPointer) KLINE_SOLID},
{XVW_GRAPHICS_MARKERTYPE,  NULL, XtRInt, sizeof(int),
      offset(marker_type), XtRImmediate, (XtPointer) KMARKER_SQUARE},
{XVW_GRAPHICS_FILLED,  NULL, XtRBoolean, sizeof(Boolean),
      offset(filled), XtRImmediate, (XtPointer) FALSE},
{XVW_GRAPHICS_LINEWIDTH,  NULL, XtRInt, sizeof(int),
      offset(line_width), XtRImmediate, (XtPointer) KLINE_EXTRA_FINE},
{XVW_GRAPHICS_WCMIN_X, NULL, XtRDouble, sizeof(double), 
      offset(wcmin.x), XtRDouble, (XtPointer) &graphics_min},
{XVW_GRAPHICS_WCMIN_Y, NULL, XtRDouble, sizeof(double), 
      offset(wcmin.y), XtRDouble, (XtPointer) &graphics_min},
{XVW_GRAPHICS_WCMIN_Z, NULL, XtRDouble, sizeof(double), 
      offset(wcmin.z), XtRDouble, (XtPointer) &graphics_min},
{XVW_GRAPHICS_WCMAX_X, NULL, XtRDouble, sizeof(double), 
      offset(wcmax.x), XtRDouble, (XtPointer) &graphics_max},
{XVW_GRAPHICS_WCMAX_Y, NULL, XtRDouble, sizeof(double), 
      offset(wcmax.y), XtRDouble, (XtPointer) &graphics_max},
{XVW_GRAPHICS_WCMAX_Z, NULL, XtRDouble, sizeof(double), 
      offset(wcmax.z), XtRDouble, (XtPointer) &graphics_max},
{XVW_GRAPHICS_PROPORTIONAL, NULL, XtRInt, sizeof(int), 
      offset(proportional), XtRImmediate, (XtPointer) KGRAPHICS_NONPROP},
{XVW_GRAPHICS_CLIPPING, NULL, XtRBoolean, sizeof(Boolean), 
      offset(clipping), XtRImmediate, (XtPointer) TRUE},
{XVW_GRAPHICS_DEPTH_CLIPPING, NULL, XtRBoolean, sizeof(Boolean), 
      offset(depth_clipping), XtRImmediate, (XtPointer) TRUE},
{XVW_GRAPHICS_RESET_WORLD, NULL, XtRBoolean, sizeof(Boolean), 
      offset(reset_world), XtRImmediate, (XtPointer) TRUE},
{XVW_GRAPHICS_PROJECTION, NULL, XtRInt, sizeof(int), 
      offset(projection), XtRImmediate,(XtPointer) KGRAPHICS_PERSPECTIVE},
{XVW_GRAPHICS_ALPHA, NULL, XtRDouble, sizeof(double), 
      offset(alpha), XtRDouble, (XtPointer) &graphics_alpha},
{XVW_GRAPHICS_THETA, NULL, XtRDouble, sizeof(double), 
      offset(theta), XtRDouble, (XtPointer) &graphics_theta},
{XVW_GRAPHICS_GAMMA, NULL, XtRDouble, sizeof(double), 
      offset(gamma), XtRDouble, (XtPointer) &graphics_gamma},
{XVW_GRAPHICS_EYE, NULL, XtRDouble, sizeof(double), 
      offset(eye_distance), XtRDouble, (XtPointer) &graphics_eye},
{XVW_GRAPHICS_VIEWDISTANCE, NULL, XtRDouble, sizeof(double), 
      offset(view_distance), XtRDouble, (XtPointer) &graphics_view},
{XVW_GRAPHICS_VIEWPORT_MIN_X, NULL, XtRDouble, sizeof(double), 
      offset(viewmin.x), XtRDouble, (XtPointer) &graphics_min},
{XVW_GRAPHICS_VIEWPORT_MIN_Y, NULL, XtRDouble, sizeof(double), 
      offset(viewmin.y), XtRDouble, (XtPointer) &graphics_min},
{XVW_GRAPHICS_VIEWPORT_MIN_Z, NULL, XtRDouble, sizeof(double), 
      offset(viewmin.z), XtRDouble, (XtPointer) &graphics_min},
{XVW_GRAPHICS_VIEWPORT_MAX_X, NULL, XtRDouble, sizeof(double), 
      offset(viewmax.x), XtRDouble, (XtPointer) &graphics_max},
{XVW_GRAPHICS_VIEWPORT_MAX_Y, NULL, XtRDouble, sizeof(double), 
      offset(viewmax.y), XtRDouble, (XtPointer) &graphics_max},
{XVW_GRAPHICS_VIEWPORT_MAX_Z, NULL, XtRDouble, sizeof(double), 
      offset(viewmax.z), XtRDouble, (XtPointer) &graphics_max},
{XVW_GRAPHICS_MODE_X, NULL, XtRInt, sizeof(int),
      offset(axis_mode_x), XtRImmediate, (XtPointer) KGRAPHICS_LINEAR},
{XVW_GRAPHICS_MODE_Y, NULL, XtRInt, sizeof(int),
      offset(axis_mode_y), XtRImmediate, (XtPointer) KGRAPHICS_LINEAR},
{XVW_GRAPHICS_MODE_Z, NULL, XtRInt, sizeof(int),
      offset(axis_mode_z), XtRImmediate, (XtPointer) KGRAPHICS_LINEAR},
{XVW_GRAPHICS_SYMMETRIC_X, NULL, XtRBoolean, sizeof(Boolean), 
      offset(symmetric_x), XtRImmediate, (XtPointer) FALSE},
{XVW_GRAPHICS_SYMMETRIC_Y, NULL, XtRBoolean, sizeof(Boolean), 
      offset(symmetric_y), XtRImmediate, (XtPointer) FALSE},
{XVW_GRAPHICS_SYMMETRIC_Z, NULL, XtRBoolean, sizeof(Boolean), 
      offset(symmetric_z), XtRImmediate, (XtPointer) FALSE},
{XVW_GRAPHICS_TYPE, NULL, XtRInt, sizeof(int), offset(graphics_type),
      XtRImmediate, (XtPointer) KGRAPHICS_2D},
};
#undef offset

#define SUPERCLASS (&xvwManagerGadgetClassRec)

XvwGraphicsGadgetClassRec xvwGraphicsGadgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Graphics",				/* class_name		  */
    sizeof(XvwGraphicsGadgetRec),	/* size			  */
    ClassInitializeGadget,		/* class_initialize	  */
    ClassPartInitializeGadget,		/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,		                /* initialize_hooks       */
    (XtProc) RealizeGadget,		/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    NULL,				/* resources		  */
    0,					/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    FALSE,				/* compress_exposure	  */
    FALSE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    ResizeGadget,			/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValuesGadget,			/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
    XtInheritPicking,                   /* pick object proc       */
    XtInheritEraseSel,                  /* erase selected proc    */
    XtInheritRefreshSel,                /* refresh selection proc */
    ChangeGeometry,			/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
    RecomputePosition,			/* recompute position proc       */
  },  /* XvwGraphicsGadgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwGraphicsGadgetClass for public consumption
 */
WidgetClass xvwGraphicsGadgetClass = (WidgetClass) &xvwGraphicsGadgetClassRec;



#define SUPERCLASS (&xvwManagerWidgetClassRec)

XvwGraphicsWidgetClassRec xvwGraphicsWidgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Graphics",				/* class_name		  */
    sizeof(XvwGraphicsWidgetRec),		/* size			  */
    ClassInitializeWidget,		/* class_initialize	  */
    ClassPartInitializeWidget,		/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    RealizeWidget,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    NULL,				/* resources		  */
    0,					/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValuesWidget,			/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    XtInheritTranslations,		/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,             /* change_managed         */
    XtInheritInsertChild,               /* insert_child           */
    XtInheritDeleteChild,               /* delete_child           */
    NULL,                               /* extension              */
  },  /* CompositeClass fields initialization */
  {
    NULL,		                /* subresources           */
    0,					/* subresources_count     */
    sizeof(XvwManagerWidgetConstraintsRec),/* constraint_size        */
    NULL,			        /* initialize             */
    NULL,                               /* destroy                */
    NULL,                               /* set_values             */
    NULL,                               /* extension              */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                    /* child layout routine   */
    XtInheritChangeSel,		        /* change selected proc   */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    XtInheritResize,			/* resize		  */
    XtInheritGeometryManager,  		/* geometry_manager	  */
  }, /* XvwManagerWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwGraphicsWidgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwGraphicsWidgetClass for public consumption
 */
WidgetClass xvwGraphicsWidgetClass = (WidgetClass) &xvwGraphicsWidgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassPartInitializeWidget
|
|       Purpose: This method would be called when the first time an 
|                instance of graphics widget class or a subclass of 
|                the graphics widget class is created.  
|
|    Written By: Mark Young and John M. Salas
|          Date: Aug 15, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassPartInitializeWidget(
   WidgetClass wclass)
{
	XvwGraphicsWidgetClass gclass = (XvwGraphicsWidgetClass) wclass;
	XvwGraphicsWidgetClass sclass = (XvwGraphicsWidgetClass)
					wclass->core_class.superclass;

}

/*-----------------------------------------------------------
|
|  Routine Name: ClassPartInitializeGadget
|
|       Purpose: This method is called when the first time an 
|                instance of XvwGraphicsGadgetClass or a subclass of 
|                the XvwGraphicsGadgetClass is created.  It handles the
|                inheritence of special methods from the superclass 
|                to the subclass.
|
|         Input: wclass - the object class being initialized
|    Written By: Mark Young and John M. Salas
|          Date: Oct 23, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassPartInitializeGadget(
   WidgetClass wclass)
{
	XvwGraphicsGadgetClass gclass = (XvwGraphicsGadgetClass) wclass;
	XvwGraphicsGadgetClass sclass = (XvwGraphicsGadgetClass)
					wclass->core_class.superclass;

	/*
	 *  make sure we aren't trying to inherit from the graphics object's
	 *  superclass.
	 */
	if (wclass != xvwGraphicsGadgetClass)
	{
	   if (gclass->graphics_class.recompute_position ==
	       XtInheritRecomputePosition)
	   {
	      gclass->graphics_class.recompute_position =
			sclass->graphics_class.recompute_position;
	   }
	}
}


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitializeGadget
|
|       Purpose: This method is called the first time an 
|                instance of graphics object class has been created. 
|		 It makes a copy of the graphics resources so that
|		 the graphics object class has them available.
|
|    Written By: Mark Young and John M. Salas
|          Date: Oct 23, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitializeGadget(void)
{
	int	   i;
	XtResource *resources;
	unsigned int num_bytes     = sizeof(graphics_resources);
	unsigned int num_resources = knumber(graphics_resources);
	unsigned int res_offset    = XtOffsetOf(XvwGraphicsGadgetRec, graphics);


	/*
	 *  Redo the resources so that we can share them between both
	 *  the xvwGraphicsGadgetClass and xvwGraphicsWidgetClass
	 */
	resources = (XtResource *) XtMalloc(num_bytes);
	kmemcpy(resources, (char *) graphics_resources, num_bytes);

	for (i = 0; i < num_resources; i++)
	    resources[i].resource_offset += res_offset;

	xvwGraphicsGadgetClass->core_class.resources     = resources;
	xvwGraphicsGadgetClass->core_class.num_resources = num_resources;
        xvw_init_attributes(xvwGraphicsGadgetClass, attributes,
		knumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Graphics");
}

/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an 
|                instance of graphics widget class has been created. 
|		 It makes a copy of the graphics resources so that
|		 the graphics widget class has them available.
|
|    Written By: Mark Young and John M. Salas
|          Date: Oct 23, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitializeWidget(void)
{
	int	   i;
	XtResource *resources;
	unsigned int num_bytes     = sizeof(graphics_resources);
	unsigned int num_resources = knumber(graphics_resources);
	unsigned int res_offset    = XtOffsetOf(XvwGraphicsWidgetRec, graphics);


	resources = (XtResource *) XtMalloc(num_bytes);
	kmemcpy(resources, (char *) graphics_resources, num_bytes);

	for (i = 0; i < num_resources; i++)
	    resources[i].resource_offset += res_offset;

	xvwGraphicsWidgetClass->core_class.resources     = resources;
	xvwGraphicsWidgetClass->core_class.num_resources = num_resources;
        xvw_init_attributes(xvwGraphicsWidgetClass, attributes,
		knumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Graphics");
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method will set up the initial values 
|                for all the fields for a graphics widget instance.
|                It will initialize the graphics objects library.
|
|         Input: request - widget instance with requested public settings
|                new     - widget instance after initialization, with
|                          private settings initialized and public 
|                          settings verified 
|
|    Written By: Mark Young and John M. Salas
|          Date: Oct 23, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwGraphicsPart *graphics = GetGraphicsPart(new);

	Colormap colormap;


	/*
	 *  Graphical objects border width is really it's line width.  If
	 *  the line width is 0, this means it uses a hardware line width
	 *  of 1, so make sure that the border width reflects this.
	 */
	new->core.border_width = graphics->line_width;
	if (new->core.border_width == 0) new->core.border_width = 1;

	/*
	 *  Get the xcolors for the desired foreground & background
	 */
	if (XtIsSubclass(new, xvwGraphicsWidgetClass))
	   colormap = new->core.colormap;
        else
	   colormap = new->core.parent->core.colormap;

	XQueryColor(XtDisplay(new), colormap, &graphics->fg);
	XQueryColor(XtDisplay(new), colormap, &graphics->bg);

	/*
	 *  Compute the position of the object in device coordinates
	 */
	graphics->id = (int) new;
	graphics->gc = NULL;
	X3D_init_graphics(graphics->id, graphics->graphics_type);
	X3D_set_X11(graphics->id, XtDisplay(new), None, XtParent(new));
	SetWorldView(new, graphics);

	/*
	 *  Get the viewport and world coordinate min and max values.
	 */
	X3D_get_wc_min_max(graphics->id, &graphics->wcmin, &graphics->wcmax);
	X3D_get_viewport(graphics->id, &graphics->viewmin, &graphics->viewmax);
	graphics->wcmin.d = 0;   graphics->wcmax.d = 0;
	graphics->viewmin.d = 0; graphics->viewmax.d = 0;
}

/*-----------------------------------------------------------
|
|  Routine Name: RealizeWidget
|
|       Purpose: This method will set up the window attributes
|                and create a window for the graphics widget.  
|		 The desired initial window attributes are passed 
|	 	 in via a mask and list of specification attributes. 
|
|         Input: widget     - the widget to realize
|                valuemask  - determines the window attributes being passed in 
|                attributes - the list of window attributes to be set 
|
|    Written By: Mark Young and John M. Salas
|          Date: Oct 23, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void RealizeWidget(
   Widget               widget,
   XtValueMask          *valuemask,
   XSetWindowAttributes *winattrib)
{
        XvwGraphicsWidget xwid = (XvwGraphicsWidget) widget;
	XGCValues values;
	unsigned  long mask;


	values.foreground = xwid->graphics.fg.pixel;
	values.background = xwid->graphics.bg.pixel;
	mask = GCForeground | GCBackground;
	xwid->graphics.gc = XtGetGC(widget, mask, &values);

	(*xvwGraphicsWidgetClass->core_class.superclass->core_class.realize)
                (widget, valuemask, winattrib);
	X3D_set_X11(xwid->graphics.id, XtDisplay(widget), None,  widget);
}

/*-----------------------------------------------------------
|
|  Routine Name: RealizeGadget
|
|       Purpose: This method will ... WHAT DOES THIS DO... -SK 
|
|         Input: widget     - the object to realize
|    Written By: Mark Young and John M. Salas
|          Date: Oct 23, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void RealizeGadget(
   Widget		widget,
   XtValueMask          *valuemask,
   XSetWindowAttributes *winattrib)
{
	XvwGraphicsGadget xobj = (XvwGraphicsGadget) widget;
	XvwGraphicsGadgetClass gclass = (XvwGraphicsGadgetClass)
						widget->core.widget_class;

	XGCValues values;
	unsigned  long mask;


	values.foreground = xobj->graphics.fg.pixel;
	values.background = xobj->graphics.bg.pixel;
	mask = GCForeground | GCBackground;
	xobj->graphics.gc = XtGetGC(widget, mask, &values);

	X3D_set_X11(xobj->graphics.id,XtDisplay(widget),None,XtParent(widget));

	/*
	 *  Recompute the widget's position from it currently set coordinates
	 */
	if (gclass->graphics_class.recompute_position != NULL)
	   gclass->graphics_class.recompute_position(widget);
}

/*-----------------------------------------------------------
|
|  Routine Name: ResizeGadget
|
|       Purpose: This method will recalculate any components 
|		 of the object that are position or size dependent. 
|
|         Input: widget - the object to resize
|    Written By: Mark Young and John M. Salas
|          Date: Oct 23, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ResizeGadget(
   Widget widget)
{
	XvwGraphicsGadget xobj = (XvwGraphicsGadget) widget;

	X3D_set_X11(xobj->graphics.id,XtDisplay(widget),None,XtParent(widget));
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: This method will close the X3D graphics
|		 on the widget, thus leaving things
|		 nice and clean for everyone else before
|		 it is destroyed. 
|
|         Input: widget - the widget being destroyed
|    Written By: Mark Young and John M. Salas
|          Date: Oct 23, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
	XvwGraphicsPart *graphics = GetGraphicsPart(widget);

	/*
	 *  Delete Graphics ID
	 */
	X3D_close_graphics(graphics->id);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValuesGadget
|
|       Purpose: This method is used to set the public values
|                of a graphics object instance.  The actual changes
|		 to the graphics part are made throught a 
|		 specific set values call to a routine which
|		 operates only on the graphics part.
|                 
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young and John M. Salas
|          Date: Oct 23, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValuesGadget(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwGraphicsGadget      cobj   = (XvwGraphicsGadget) current;
	XvwGraphicsGadget      robj   = (XvwGraphicsGadget) request;
	XvwGraphicsGadget      nobj   = (XvwGraphicsGadget) new;
	XvwGraphicsGadgetClass gclass = (XvwGraphicsGadgetClass)
						new->core.widget_class;

	Boolean redisplay = FALSE;


	/*
	 *  If SetValues() returns TRUE then we need to recompute it's position
	 *  according to it's new coordinates.
	 */
	if (SetValues(new, &cobj->graphics, &robj->graphics, &nobj->graphics))
	{
           /*
            *  Recompute the widget's position from it currently set coordinates
            */
	   SetWorldView(new, &nobj->graphics);
#if 0
           if (gclass->graphics_class.recompute_position != NULL)
              gclass->graphics_class.recompute_position(new);
#endif
	   redisplay = TRUE;
	}

	/*
	 *  Get the xcolors for the desired foreground & background
	 */
	if (cobj->manager.foreground != nobj->manager.foreground ||
	    cobj->manager.background != nobj->manager.background)
	{
	   Colormap colormap = new->core.parent->core.colormap;
	   nobj->graphics.fg.pixel = nobj->manager.foreground;
	   nobj->graphics.bg.pixel = nobj->manager.background;

	   XQueryColor(XtDisplay(new), colormap, &nobj->graphics.fg);
	   XQueryColor(XtDisplay(new), colormap, &nobj->graphics.bg);

	   if (nobj->graphics.gc)
	   {
	      XGCValues values;
              unsigned  long mask;

	      XtReleaseGC(new, nobj->graphics.gc);
              values.foreground = nobj->graphics.fg.pixel;
              values.background = nobj->graphics.bg.pixel;
              mask = GCForeground | GCBackground;
	      nobj->graphics.gc = XtGetGC(new, mask, &values);
	   }
	   redisplay = TRUE;
	}
	return(redisplay && nobj->manager.mapped);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValuesWidget
|
|       Purpose: This method is used to set the public values
|                of a graphics widget instance.  The actual changes
|		 to the graphics part are made throught a 
|		 specific set values call to a routine which
|		 operates only on the graphics part.
|                 
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young and John M. Salas
|          Date: Oct 23, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValuesWidget (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwGraphicsWidget	    cxwid  = (XvwGraphicsWidget) current;
	XvwGraphicsWidget	    rxwid  = (XvwGraphicsWidget) request;
	XvwGraphicsWidget	    nxwid  = (XvwGraphicsWidget) new;
	XvwGraphicsWidgetClass gclass = (XvwGraphicsWidgetClass)
						new->core.widget_class;

	Boolean redisplay = FALSE;


        /*
         *  If SetValues() returns TRUE then we need to recompute it's position
         *  according to it's new coordinates.
         */
        if (SetValues(new, &cxwid->graphics, &rxwid->graphics,&nxwid->graphics))
        {
           /*
            *  Recompute the widget's position from it currently set coordinates
            */
           SetWorldView(new, &nxwid->graphics);
           redisplay = TRUE;
        }

	/*
	 *  Get the xcolors for the desired foreground & background
	 */
	if (cxwid->core.background_pixel != nxwid->core.background_pixel ||
	    cxwid->manager.foreground_pixel != nxwid->manager.foreground_pixel)
	{
	   Colormap colormap = new->core.colormap;
	   nxwid->graphics.bg.pixel = nxwid->core.background_pixel;
	   nxwid->graphics.fg.pixel = nxwid->manager.foreground_pixel;

	   XQueryColor(XtDisplay(new), colormap, &nxwid->graphics.fg);
	   XQueryColor(XtDisplay(new), colormap, &nxwid->graphics.bg);
	   redisplay = TRUE;
	}
	return(redisplay);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|		 to the graphics part which is used by both the
|		 graphics widget and graphics object. 
|                 
|         Input: widget  - not used 
|		 current - the graphicsPart containing current settings
|                request - the graphicsPart containing requested settings
|                new     - the graphicsPart processed through set values method
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young and John M. Salas
|          Date: Oct 23, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget          widget,
   XvwGraphicsPart *current,
   XvwGraphicsPart *request,
   XvwGraphicsPart *new)
{
	Boolean	   redraw_workspace = FALSE;


	/*
	 * See if the world coordinate reset has been changed
	 */
	if (current->projection  != new->projection   ||
	    current->line_type   != new->line_type    ||
	    current->marker_type != new->marker_type  ||
	    current->line_width  != new->line_width   ||
	    current->filled      != new->filled	      ||
	    current->clipping    != new->clipping     ||
            current->depth_clipping != new->depth_clipping)
	{
	   redraw_workspace = TRUE;
	}

        /*
         * See if the wcmin and max have changed.  Check to see if
         * the minimum is less than the maximum if not swap the values and
         * tell the user.  Then check to see if the axis is not LINEAR that
         * the change requested is not less than zero.  If symmetry set and
         * the change does not maintain symmetry, unset symmetry.
         */
        if (!GraphicsCheckCoord(current->wcmin, new->wcmin)     ||
            !GraphicsCheckCoord(current->wcmax, new->wcmax)     ||
            !GraphicsCheckCoord(current->viewmin, new->viewmin) ||
            !GraphicsCheckCoord(current->viewmax, new->viewmax) ||
	    current->axis_mode_x != new->axis_mode_x            ||
	    current->axis_mode_y != new->axis_mode_y            ||
	    current->axis_mode_z != new->axis_mode_z )
        {
	   redraw_workspace = TRUE;

           if ( new->axis_mode_x != KGRAPHICS_LINEAR &&
                new->wcmin.x <= 0.0 )
           {
             if ( current->axis_mode_x != new->axis_mode_x )
             {
               new->axis_mode_x = KGRAPHICS_LINEAR;
               kinfo(KFORCE, "SetValues (Graphics Widget): Log axis mode requested, but x-axis <= 0.0, axis_mode set to KGRAPHICS_LINEAR.\n");
             }
             else
             {
               new->wcmin.x = current->wcmin.x;
               new->wcmax.x = current->wcmax.x;
               kinfo(KFORCE, "SetValues (Graphics Widget): Axis mode is not KGRAPHICS_LINEAR and requested x-axis <= 0.0, resetting to old x-axis range.\n");
             }
           }

           if ( new->axis_mode_y != KGRAPHICS_LINEAR &&
                new->wcmin.y <= 0.0 )
           {
             if ( current->axis_mode_y != new->axis_mode_y )
             {
               new->axis_mode_y = KGRAPHICS_LINEAR;
               kinfo(KFORCE, "SetValues (Graphics Widget): Log axis mode requested, but y-axis <= 0.0, axis mode set to KGRAPHICS_LINEAR.\n");
             }
             else
             {
               new->wcmin.y = current->wcmin.y;
               new->wcmax.y = current->wcmax.y;
               kinfo(KFORCE, "SetValues (Graphics Widget): Axis mode is not KGRAPHICS_LINEAR and requested y-axis <= 0.0, resetting to old y-axis range.\n");
             }
           }
	}

	if (new->graphics_type == KGRAPHICS_3D &&
	    (current->alpha	   != new->alpha ||
	     current->theta	   != new->theta ||
	     current->gamma	   != new->gamma ||
	     current->eye_distance  != new->eye_distance ||
	     current->view_distance != new->view_distance))
	{
	   redraw_workspace = TRUE;
	}
	return(redraw_workspace);
}

/*-----------------------------------------------------------
|
|  Routine Name: GetGraphicsPart
|
|       Purpose: Given and graphics widget/object, get its graphics part.
|
|         Input: widget - the graphics object/widget we want the
|			  graphics part from
|       Returns: The graphics part 
|    Written By: Mark Young and John M. Salas
|          Date: May 15, 1993 15:28
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
XvwGraphicsPart *GetGraphicsPart(
   Widget widget)
{
	if (widget == NULL)
	   return(NULL);
	else if (XtIsSubclass(widget, xvwGraphicsWidgetClass))
	   return(&((XvwGraphicsWidget) widget)->graphics);
	else if (XtIsSubclass(widget, xvwGraphicsGadgetClass))
	   return(&((XvwGraphicsGadget) widget)->graphics);

	return(NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetWorldView - set the xvgraphics world
|				and view port
|
|       Purpose: This routine will set the xvgraphics world
|		 coordinates and view port.  If the user does
|		 not over-ride this routine with there own.
|
|         Input: widget   - the graphics widget
|		 graphics - the graphics part
|    Written By: John M. Salas
|          Date: Nov 04, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void SetWorldView(
   Widget          widget,
   XvwGraphicsPart *graphics)
{
	X3D_set_X11(graphics->id, XtDisplay(widget), None, XtParent(widget));
	X3D_set_viewport(graphics->id, graphics->viewmin, graphics->viewmax);
	X3D_set_line_type(graphics->id, graphics->line_type);
	X3D_set_line_width(graphics->id, graphics->line_width);
	X3D_set_wc_min_max(graphics->id, graphics->wcmin, graphics->wcmax);

	X3D_set_projection(graphics->id, graphics->projection);
	X3D_set_view_distance(graphics->id, graphics->view_distance);
	X3D_set_clipping(graphics->id,(int) graphics->clipping,
			(int) graphics->depth_clipping);
	X3D_set_wc_scale(graphics->id, graphics->axis_mode_x,
                         graphics->axis_mode_y, graphics->axis_mode_z);
	X3D_set_viewpoint(graphics->id, graphics->alpha, graphics->theta,
			  graphics->gamma, graphics->eye_distance);
}

/*-----------------------------------------------------------
|
|  Routine Name: RecomputePosition
|
|       Purpose: Recalculate the device coordinate position
|		 of the graphics object when its world coordinate
|		 location has been changed. 
|
|         Input: widget - the object to calculate the new position for
|    Written By: Mark Young
|          Date: Apr 14, 1995
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void RecomputePosition(
   Widget widget)
{
	XvwGraphicsGadget xobj = (XvwGraphicsGadget) widget;

	Coord pt;
	Widget parent;
	XtWidgetGeometry temp;
	Real xpos1, xpos2, ypos1, ypos2, x, y;
	int id = xobj->graphics.id;
	int bw = /*widget->core.border_width << 1*/0;


	if (xobj->manager.realized == FALSE)
	   return;

	if (xobj->graphics.graphics_type == KGRAPHICS_2D)
	{
	   X2D_convert_point_wc_to_dc(id, xobj->graphics.wcmin, &xpos1, &ypos1);
	   X2D_convert_point_wc_to_dc(id, xobj->graphics.wcmax, &xpos2, &ypos2);
	}
	else
	{
	   pt.x = xobj->graphics.wcmin.x;
	   pt.y = xobj->graphics.wcmin.y;
	   pt.z = xobj->graphics.wcmin.z;
	   X3D_convert_point_wc_to_dc(id, pt, &x, &y);
	   xpos1 = xpos2 = x; ypos1 = ypos2 = y;

	   pt.x = xobj->graphics.wcmax.x;
	   pt.y = xobj->graphics.wcmin.y;
	   pt.z = xobj->graphics.wcmin.z;
	   X3D_convert_point_wc_to_dc(id, pt, &x, &y);
	   xpos1 = kmin(xpos1, x); xpos2 = kmax(xpos2, x);
	   ypos1 = kmin(ypos1, y); ypos2 = kmax(ypos2, y);

	   pt.x = xobj->graphics.wcmin.x;
	   pt.y = xobj->graphics.wcmax.y;
	   pt.z = xobj->graphics.wcmin.z;
	   X3D_convert_point_wc_to_dc(id, pt, &x, &y);
	   xpos1 = kmin(xpos1, x); xpos2 = kmax(xpos2, x);
	   ypos1 = kmin(ypos1, y); ypos2 = kmax(ypos2, y);

	   pt.x = xobj->graphics.wcmin.x;
	   pt.y = xobj->graphics.wcmin.y;
	   pt.z = xobj->graphics.wcmax.z;
	   X3D_convert_point_wc_to_dc(id, pt, &x, &y);
	   xpos1 = kmin(xpos1, x); xpos2 = kmax(xpos2, x);
	   ypos1 = kmin(ypos1, y); ypos2 = kmax(ypos2, y);

	   pt.x = xobj->graphics.wcmin.x;
	   pt.y = xobj->graphics.wcmax.y;
	   pt.z = xobj->graphics.wcmax.z;
	   X3D_convert_point_wc_to_dc(id, pt, &x, &y);
	   xpos1 = kmin(xpos1, x); xpos2 = kmax(xpos2, x);
	   ypos1 = kmin(ypos1, y); ypos2 = kmax(ypos2, y);

	   pt.x = xobj->graphics.wcmax.x;
	   pt.y = xobj->graphics.wcmax.y;
	   pt.z = xobj->graphics.wcmin.z;
	   X3D_convert_point_wc_to_dc(id, pt, &x, &y);
	   xpos1 = kmin(xpos1, x); xpos2 = kmax(xpos2, x);
	   ypos1 = kmin(ypos1, y); ypos2 = kmax(ypos2, y);

	   pt.x = xobj->graphics.wcmax.x;
	   pt.y = xobj->graphics.wcmax.y;
	   pt.z = xobj->graphics.wcmax.z;
	   X3D_convert_point_wc_to_dc(id, pt, &x, &y);
	   xpos1 = kmin(xpos1, x); xpos2 = kmax(xpos2, x);
	   ypos1 = kmin(ypos1, y); ypos2 = kmax(ypos2, y);
	}
	parent = XtParent(widget);
	temp.request_mode = CWWidth | CWHeight | CWX | CWY;
	temp.x = (Position) kmin(xpos1, xpos2);
	temp.y = (Position) kmin(ypos1, ypos2);
	temp.width  = (Dimension) (kabs(xpos2 - xpos1) - bw) + 1;
	temp.height = (Dimension) (kabs(ypos2 - ypos1) - bw) + 1;
	temp.width  = kmin(temp.width,  parent->core.width);
	temp.height = kmin(temp.height, parent->core.height);
	(void) XtMakeGeometryRequest(widget, &temp, &temp);
}

/*-----------------------------------------------------------
|
|  Routine Name: ChangeGeometry
|
|       Purpose: Recalculate the world coordinate location
|		 of the graphics object when its device coordinate
|		 position has been changed. 
|
|         Input: widget - the object to calculate the new coordinates for
|    Written By: John M. Salas
|          Date: Oct 23, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ChangeGeometry(
   Widget widget)
{
	XvwGraphicsGadget xobj = (XvwGraphicsGadget) widget;

	int id = xobj->graphics.id;
	Real xpos1, xpos2, ypos1, ypos2;
	int bw = /*widget->core.border_width << 1;*/0;


	if (xobj->manager.realized == FALSE)
	   return;

#if 0
	xpos1 = (Real) widget->core.x;
	xpos2 = (Real) (widget->core.x + (int) widget->core.width + bw)   - 1;
	ypos1 = (Real) (widget->core.y + (int) widget->core.height + bw)  - 1;
	ypos2 = (Real) widget->core.y;

	X2D_convert_point_dc_to_wc(id, xpos1, ypos1, &xobj->graphics.wcmin);
	X2D_convert_point_dc_to_wc(id, xpos2, ypos2, &xobj->graphics.wcmax);
#endif
}
