/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                 Date Gadget Routines
   >>>>
   >>>>	Private:
   >>>>	 Static:
   >>>>			ClassInitialize()
   >>>>			Initialize()
   >>>>			SetValues()
   >>>>			Destroy()
   >>>>			RecomputeDate()
   >>>>   Public:
   >>>>			xvw_create_date()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <time.h>
#include <xvisual/DateP.h>

static void ClassInitialize	PROTO((void));
static void Initialize		PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean SetValues	PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static void Destroy		PROTO((Widget));
static void RecomputeDate	PROTO((XtPointer, XtIntervalId *));


/*--------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_DATE_FORMAT,        NULL,    XtRString,    NULL},
{XVW_DATE_UPDATETIME,    NULL,    XtRInt,       NULL},
};

/*--------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwDateGadgetRec, date.field)

static XtResource resources[] = { 
{XVW_DATE_FORMAT, NULL, XtRString, sizeof(String),
      offset(format), XtRString, (XtPointer) "%h %d, 19%y %H:%M"},
{XVW_DATE_UPDATETIME, NULL, XtRInt, sizeof(int),
      offset(update_time), XtRString, (XtPointer) "1"},
};
#undef offset

#define SUPERCLASS (&xvwStringGadgetClassRec)

XvwDateGadgetClassRec xvwDateGadgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Date",			        /* class_name		  */
    sizeof(XvwDateGadgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    NULL,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    FALSE,				/* compress_exposure	  */
    FALSE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
    XtInheritPicking,			/* pick object proc       */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    XtInheritChangeGeometry,		/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
    XtInheritRecomputePosition,		/* recompute position proc    */
  },  /* XvwGraphicsGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* xvwStringGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* XvwDateGadgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwDateGadgetClass for public consumption
 */
WidgetClass xvwDateGadgetClass = (WidgetClass) &xvwDateGadgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of date object class has been created.
|                It will initialize all the class attributes. 
|
|    Written By: Mark Young & John Salas
|          Date: Aug 15, 1992
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwDateGadgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/Date.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Date");
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize 
|
|       Purpose: This method will set up the initial values 
|                for all the date fields of a date object instance.
|		 The date update routine is also installed to update
|		 the date again after the initial update time.
|
|         Input: request - not used 
|                new     - object instance after initialization, with
|                          date initialized 
|
|    Written By: Mark Young & John Salas
|          Date: Aug 15, 1992 12:31
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
        XvwDateGadget xobj = (XvwDateGadget) new;

	xobj->date.time_id = 0;
	xobj->date.format  = kstrdup(xobj->date.format);
	RecomputeDate((XvwDateGadget) new, NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public fields
|                of a date object instance.  These fields are
|		 the date format and update time.
|                 
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young 
|          Date: Oct 23, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwDateGadget cobj = (XvwDateGadget) current;
	XvwDateGadget nobj = (XvwDateGadget) new;

	if (cobj->date.update_time != nobj->date.update_time)
	{
	   if (cobj->date.update_time == 0) RecomputeDate(nobj, NULL);
	}

	if (cobj->date.format != nobj->date.format)
	{
	   kfree(cobj->date.format);
	   nobj->date.format = kstrdup(nobj->date.format);
	   RecomputeDate(nobj, NULL);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: This method will uninstall the date update
|		 timeout before the date object is destroyed. 
|
|         Input: widget - the object being destroyed
|
|        Output:
|
|    Written By: Mark Young
|          Date: Oct 23, 1992 14:06
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
	XvwDateGadget xobj = (XvwDateGadget) widget;

        if (xobj->date.time_id)
	   XtRemoveTimeOut(xobj->date.time_id);
}

/*-----------------------------------------------------------
|
|  Routine Name: RecomputeDate 
|
|       Purpose: This routine will recalculate the new date using the
|		 UNIX time and strftime.  This routine will reinstall 
|		 itself to run again in the number of seconds specified
|		 in the date object's update time field. 
|
|         Input: xobj - the date object being updated 
|		 id   - the id of the timeout interval
|
|        Output:
|
|    Written By: Mark Young and Steve Kubica
|          Date: Oct 23, 1992 14:06
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void RecomputeDate(
   XtPointer    calldata,
   XtIntervalId *id)
{
	XvwDateGadget xobj = (XvwDateGadget) calldata;
	struct tm  *tmval; 
	time_t     timeval;
	char	   temp[KLENGTH]; 


	/*
	 * Update the date string based on the paramters
	 * in the date widget. 
         */
	timeval = time(NULL);
	tmval   = localtime(&timeval);

	/*
	 * Compare the new date string with the current one,
         * and if different, then update it...
	 */
	if (tmval != NULL)
	{
	   kstrftime(temp, KLENGTH, xobj->date.format, tmval);
	   if (kstrcmp(temp, xobj->string.string) != 0)
	      xvw_set_attribute(xvw_object(calldata), XVW_STRING_STRING, temp);
	}

	/*
	 *  Compute the position of the object in device coordinates
	 */
	if (xobj->date.update_time > 0)
	{
           xobj->date.time_id = XtAppAddTimeOut(
			 XtWidgetToApplicationContext((Widget) xobj),
		 	 (unsigned long) xobj->date.update_time*1000,
                         RecomputeDate, (XtPointer) xobj);
	}
	else
	   xobj->date.time_id = 0;
}


/************************************************************
*
*  Routine Name: xvw_create_date - create a date object.
*
*       Purpose: A date visual object displays the current date 
*                according to the internal clock of your computer.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output:
*	Returns: The date object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young 
*          Date: Jun 29, 1992 10:31
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_date(
   xvobject parent,
   char     *name)
{
	xvobject  object;

	/*
	 *  Call the xvw_create() routine to do the actual creation.
	 */
	object = xvw_create(parent, FALSE, TRUE, name, DateGadgetClass);
	if (object != NULL)
	{
	   xvw_set_attributes(object,
                XVW_MENUABLE,     TRUE,     /* menuable       */
                XVW_RESIZABLE,    FALSE,    /* resizable      */
                XVW_SELECTABLE,   TRUE,     /* selectable     */
		NULL);
	}
	return(object);
}
