 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                ColorCell Widget Routines
   >>>>
   >>>>	Private:
   >>>>	 Static:
   >>>>			ClassInitialize()
   >>>>			Initialize()
   >>>>			ChangeColorCellIndex()
   >>>>			SetValues()
   >>>>			Destroy()
   >>>>			Redisplay()
   >>>>  Public:
   >>>>			xvw_create_colorcell()
   >>>>			xvw_display_colorcell()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvisual/xvisual.h>
#include <xvisual/ColorCellP.h>
#include <xvisual/Palette.h>

static void ClassInitialize PROTO((void));
static void Initialize	    PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,Cardinal *));
static void Destroy         PROTO((Widget));
static void Redisplay	    PROTO((Widget, XEvent *, Region));
static void ReloadCallback  PROTO((kobject, char *, Widget, kdms_callback *));
static int  ChangeColorCellIndex PROTO((xvobject, char *, kaddr));
static void ColorCallback   PROTO((xvobject, kaddr));

#undef kwidget
#undef kwidgetclass
#undef kconstraint

#define kwidget(widget)      (XvwColorCellWidget) (widget)
#define kwidgetclass(widget) (XvwColorCellWidgetClass) (widget)->core.widget_class
#define kconstraint(widget)  (XvwColorCellWidgetConstraints) (widget)->core.constraints

/*-------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_COLORCELL_INDEX,		 NULL, XtRInt, NULL},
{XVW_COLORCELL_INDEXLIST,        NULL, XtRPointer, NULL},
{XVW_COLORCELL_INDEXNUM,         NULL, XtRInt, NULL},
{XVW_COLORCELL_REDVAL,		 NULL, XtRInt, NULL},
{XVW_COLORCELL_GREENVAL,	 NULL, XtRInt, NULL},
{XVW_COLORCELL_BLUEVAL,		 NULL, XtRInt, NULL},
{XVW_COLORCELL_SHOWINDEX,        NULL, XtRInt, XtRBoolean},
{XVW_COLORCELL_UPDATE_ONADD,     NULL, XtRInt, XtRBoolean},
{XVW_COLORCELL_RESTORE_ONDELETE, NULL, XtRInt, XtRBoolean},
};

/*-------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwColorCellWidgetRec, colorcell.field)

static XtResource resources[] = { 
{XVW_COLORCELL_INDEX, NULL, XtRInt, sizeof(int),
      offset(index), XtRImmediate, (XtPointer) -1},
{XVW_COLORCELL_INDEXLIST, NULL, XtRPointer, sizeof(XtPointer),
      offset(indexes), XtRImmediate, (XtPointer) NULL},
{XVW_COLORCELL_INDEXNUM, NULL, XtRInt, sizeof(int),
      offset(num), XtRImmediate, (XtPointer) 0},
{XVW_COLORCELL_REDVAL, NULL, XtRInt, sizeof(int),
      offset(red), XtRImmediate, (XtPointer) 0},
{XVW_COLORCELL_GREENVAL, NULL, XtRInt, sizeof(int),
      offset(green), XtRImmediate, (XtPointer) 0},
{XVW_COLORCELL_BLUEVAL, NULL, XtRInt, sizeof(int),
      offset(blue), XtRImmediate, (XtPointer) 0},
{XVW_COLORCELL_SHOWINDEX, NULL, XtRBoolean, sizeof(Boolean),
      offset(show_index), XtRImmediate, (XtPointer) TRUE},
{XVW_COLORCELL_UPDATE_ONADD, NULL, XtRBoolean, sizeof(Boolean),
      offset(update_onadd), XtRImmediate, (XtPointer) FALSE},
{XVW_COLORCELL_RESTORE_ONDELETE, NULL, XtRBoolean, sizeof(Boolean),
      offset(restore_ondelete), XtRImmediate, (XtPointer) FALSE},
};
#undef offset


#define SUPERCLASS (&xvwColorWidgetClassRec)

XvwColorCellWidgetClassRec xvwColorCellWidgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "ColorCell",			/* class_name		  */
    sizeof(XvwColorCellWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    NULL,				/* resize		  */
    Redisplay,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    XtInheritTranslations,		/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,	            		/* subresources       */
    0,					/* subresources_count */
    sizeof(XvwManagerWidgetConstraintsRec),/* constraint_size    */
    NULL,				/* initialize         */
    NULL,                               /* destroy            */
    NULL,				/* set_values         */
    NULL,                               /* extension          */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,			/* child layout routine  */
    XtInheritChangeSel,		        /* change selected proc   */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    XtInheritResize,			/* resize		  */
    XtInheritGeometryManager,  		/* geometry_manager	  */
  }, /* XvwManagerWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwGraphicsWidgetClass fields initialization */
  {
    ColorCallback,                      /* reload color proc    */
  },  /* XvwColorWidgetClass fields initialization */
  {
    NULL,				/* field not used	*/
  },  /* XvwColorCellWidgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwColorCellWidgetClass for public consumption
 */
WidgetClass xvwColorCellWidgetClass = (WidgetClass) &xvwColorCellWidgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of colorcell widget class has been created.
|                It will initialize all the class attributes.
|
|         Input: none 
|
|        Output: none
|
|    Written By: Mark Young 
|          Date: Nov 17, 1992 19:24
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwColorCellWidgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/ColorCell.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/ColorCell");

	xvw_define_attributes(xvwColorCellWidgetClass,
	  XVW_COLORCELL_ADD,     XtRInt, ChangeColorCellIndex, NULL,
	  XVW_COLORCELL_DELETE,  XtRInt, ChangeColorCellIndex, NULL,
	  XVW_COLORCELL_CLEAR,   XtRInt, ChangeColorCellIndex, NULL,
	  XVW_COLORCELL_RESTORE, XtRInt, ChangeColorCellIndex, NULL,
	  XVW_COLORCELL_UPDATE,  XtRInt, ChangeColorCellIndex, NULL,
	  NULL);
}


/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial colorcell color
|                widget instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|
|	 Output: None
|
|    Written By: Mark Young
|          Date: May 26, 1993 13:28
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwColorCellWidget xwid = kwidget(new);
	xvobject object = xvw_object(new);


        /*
         *  Set the "maps" of the indexes to be empty.  This is used by the
         *  add/delete/clear/restore ChangeColorCellIndex()
         */
        xwid->colorcell.maps = NULL;

	/*
	 *  Create the index value indicator
	 */
	xwid->colorcell.value = xvw_create_stringvalue(object, "value");

	/*
	 *  Initialize the palette to extend the width of the palette
	 */
	xvw_set_attributes(xwid->colorcell.value,
		XVW_STRING_VALUE, (double) xwid->colorcell.index,
		XVW_ABOVE,	NULL,
		XVW_BELOW,	NULL,
		XVW_LEFT_OF,	NULL,
		XVW_RIGHT_OF,	NULL,
		XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_CENTER,
		NULL);
}


/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: Determine what the widget should do by
|		 comparing the current values verse the
|		 new settings.
|
|         Input: current - the widget containing current settings 
|		 request - the widget containing requested settings
|		 new	 - the widget processed through all set values methods 
|
|        Output: None directly
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 17, 1992 19:24
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwColorCellWidget cxwid = kwidget(current);
	XvwColorCellWidget nxwid = kwidget(new);

	/*
	 *  changed the XVW_COLORCELL_SHOWINDEX attribute 
	 */
        if (cxwid->colorcell.show_index != nxwid->colorcell.show_index)
        {
           xvw_set_attribute(nxwid->colorcell.value, XVW_MAPPED,
                nxwid->colorcell.show_index);
        }

	/*
	 *  This part of the code has to do with updating the object according
	 *  to the index.  So don't update anything unless we have a valid 
	 *  index and color object.
	 */
	if (nxwid->colorcell.index == -1 || nxwid->color.object == NULL)
	   return(FALSE);

	if (cxwid->colorcell.index != nxwid->colorcell.index)
	{
	   if (cxwid->colorcell.index == -1)
	   {
	      xvw_set_attribute(xvw_object(new), XVW_COLORCELL_ADD,
			        nxwid->colorcell.index);
	   }
	}

	if (cxwid->core.background_pixel != nxwid->core.background_pixel)
	{
	   XColor *xcolors = ColorGetXColors(new);
	   int indx = nxwid->colorcell.index;

	   /* gotta store the RGB values of the Pixel */
	   if (xcolors && xcolors[indx].pixel != nxwid->graphics.bg.pixel)
	   {
	      ColorStore(new, indx, &nxwid->graphics.bg);
	   }
	}

	if (cxwid->colorcell.red   != nxwid->colorcell.red   ||
	    cxwid->colorcell.green != nxwid->colorcell.green ||
	    cxwid->colorcell.blue  != nxwid->colorcell.blue)
	{
	   xvw_set_attribute(xvw_object(new), XVW_COLORCELL_UPDATE, TRUE);
	}

	if (cxwid->colorcell.index != nxwid->colorcell.index ||
	    cxwid->color.object    != nxwid->color.object)
	{
	   xvw_set_attribute(nxwid->colorcell.value, XVW_STRING_VALUE,
		(double) nxwid->colorcell.index);

	   if (cxwid->color.object != nxwid->color.object)
	   {
	      kpds_add_map_callback(nxwid->color.object, KPDS_CALLBACK_CHANGE,
		ReloadCallback, (kaddr) new);
	   }

	   if (ColorGetXColors(new) != NULL)
	   {
	      xvw_set_attribute(xvw_object(new), XVW_BACKGROUND,
		ColorAllocate(new, nxwid->colorcell.index));
	   }
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: Destroy string object sub-part
|		 before colorcell is destroyed.
|
|         Input: widget - the image widget being destroyed
|
|        Output: None
|
|    Written By: Mark Young
|          Date: Dec 08, 1992 11:50
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
        XvwColorCellWidget xobj = (XvwColorCellWidget) widget;

	karray_free((kaddr) xobj->colorcell.maps, xobj->colorcell.num, NULL);
	kfree(xobj->colorcell.indexes);
}


/*-----------------------------------------------------------
|
|  Routine Name: Redisplay
|
|       Purpose: This routine will redraw the background widget in response
|                to an expose event 
|
|         Input: widget - widget data structure for colorcell
|		 event	- the event that caused the redraw
|		 region	- the region that was exposed
|
|        Output:
|    Written By: Mark Young
|          Date: Nov 02, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Redisplay(
   Widget widget,
   XEvent *event,
   Region region)
{
	XvwColorCellWidget xwid = kwidget(widget);


	if (ColorGetXColors(widget) != NULL && xwid->colorcell.index != -1)
        {
	   xvw_set_attribute(xvw_object(widget), XVW_BACKGROUND,
		ColorAllocate(widget, xwid->colorcell.index));
	}
	(*xvwColorCellWidgetClass->core_class.superclass->core_class.expose)
                (widget, event, region);
}


/*-----------------------------------------------------------
|
|  Routine Name: ReloadCallback
|
|       Purpose: Reload the xcolor data structure from the color
|                data object.
|
|         Input: widget - the image widget to load the image data
|
|        Output: none
|
|    Written By: Mark Young
|          Date: May 18, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ReloadCallback(
	kobject object,
	char    *segment,
	Widget  widget,
	kdms_callback *cb)
{

}

/*-----------------------------------------------------------
|
|  Routine Name: ColorCallback
|
|       Purpose: Refresh the colorcell display since our ColorClass
|		 has had a change to its map data, and we are required
|		 to change the colors in the colorcell.
|
|         Input: object - the object to be refreshed (the Palette)
|		 call_data   - (not used)
|        Output:
|    Written By: Mark Young & Danielle Argiro
|          Date: May 24, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ColorCallback(
   xvobject object,
   kaddr    call_data)
{
	XvwColorCellWidget xwid = (XvwColorCellWidget) xvw_widget(object);
	XEvent event;
	Region  region   = XCreateRegion();

	event.type = Expose;
	event.xexpose.x = event.xexpose.y = 0;
	event.xexpose.width  = xwid->core.width;
	event.xexpose.height = xwid->core.height;
	XtAddExposureToRegion(&event, region);
	Redisplay((Widget) xwid, &event, region);
	XDestroyRegion(region);
}

/*-----------------------------------------------------------
|
|  Routine Name: ChangeColorCellIndex
|
|       Purpose: ChangeColorCellIndex is used to set the indexes associated
|		 with the colorcell widget.
|
|         Input: object    - the object in which we will be getting the
|			     filename
|		 attribute - the old object to be closed
|		 calldata  - the filename to be set
|
|        Output:
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 05, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int ChangeColorCellIndex(
   xvobject object,
   char     *attribute,
   kaddr    calldata)
{
	XvwColorCellWidget xwid = (XvwColorCellWidget) xvw_widget(object);
	int indx = *((int *) calldata);

	int     i;
	Widget  widget = (Widget) xwid;
	int     num = xwid->colorcell.num,
	        *indexes = xwid->colorcell.indexes;
	kaddr	*maps = xwid->colorcell.maps;
	XColor  *temp, *xcolors = ColorGetXColors(widget);


	if (kstrcmp(attribute, XVW_COLORCELL_ADD) == 0)
	{
	   if (karray_locate((char **) indexes, (kaddr) indx, num) == -1)
	   {
	      temp = (XColor *) kcalloc(1, sizeof(XColor));

	      *temp = xcolors[indx];
	      maps = (kaddr *) karray_add((char **) maps, (kaddr) temp, num);

	      if (xwid->colorcell.update_onadd && indexes != NULL)
	      {
		 ColorStore(widget, indx, &xcolors[indexes[0]]);
	      }
	      else if (!indexes)
	      {
		 xvw_set_attribute(object, XVW_COLORCELL_INDEX, indx);
		 xwid->colorcell.red   = temp->red   >> 8;
		 xwid->colorcell.green = temp->green >> 8;
		 xwid->colorcell.blue  = temp->blue  >> 8;
	      }
	      indexes = (int *) karray_add((char **)indexes, (kaddr) indx, num);
	      num++;
	   }
	}
        else if (kstrcmp(attribute, XVW_COLORCELL_DELETE) == 0)
	{
	   i = karray_locate((char **) indexes, (kaddr) indx, num);
	   if (i != -1)
	   {
	      temp = (XColor *) maps[i];
	      if (xwid->colorcell.restore_ondelete)
	         ColorStore(widget, indexes[i], temp);

	      maps = (kaddr *) karray_delete((char **) maps, (kaddr) temp, num);
	      indexes=(int *) karray_delete((char **)indexes,(kaddr) indx, num);
	      num--;
	      if (num == 0)
		xvw_set_attribute(object, XVW_COLORCELL_INDEX, -1);
	   }
	}
        else if (kstrcmp(attribute, XVW_COLORCELL_CLEAR) == 0)
	{
	   kfree(indexes);
	   karray_free((kaddr) maps, num, NULL);
	   indexes = NULL; maps = NULL; num = 0;
	}
        else if (kstrcmp(attribute, XVW_COLORCELL_RESTORE) == 0)
	{
	   if (maps == NULL)
	      return(TRUE);

	   for (i = 0; i < num; i++)
	   {
	      temp = maps[i];
	      ColorStore(widget, indexes[i], temp);
	   }
	   temp = (XColor *) maps[0];
	   xwid->colorcell.red   = temp->red >> 8;
	   xwid->colorcell.green = temp->green >> 8;
	   xwid->colorcell.blue  = temp->blue >> 8;
	}
        else if (kstrcmp(attribute, XVW_COLORCELL_UPDATE) == 0)
	{
	   for (i = 0; i < num; i++)
	   {
	      indx = indexes[i];
	      xcolors[indx].red   = xwid->colorcell.red << 8;
	      xcolors[indx].green = xwid->colorcell.green << 8;
	      xcolors[indx].blue  = xwid->colorcell.blue << 8;

	      ColorStore(widget, indx, NULL);
	   }
	}
	else
	{
	   kerror(XVISUAL, "ChangeColorCellIndex", "invalid attribute %s",
			attribute);
	   return(FALSE);
	}
	xwid->colorcell.num  = num;
	xwid->colorcell.maps = maps;
	xwid->colorcell.indexes = indexes;
	return(TRUE);
}


/************************************************************
*
*  Routine Name: xvw_create_colorcell - create a colorcell xvobject
*
*       Purpose: A colorcell visual object is used to display the color and 
*                the value of pixels in an image object; thus, it is designed 
*                to be used in conjunction with an image object.   It is 
*                comprised of a square area in which the color of the pixel(s)
*                are displayed.  When a single pixel is associated with the 
*                colorcell object, the numeric value of that pixel may also be 
*                shown.  The colorcell object may be used simply to reflect 
*                the color of one or more pixels in the image, or it may be 
*                used to control those colors.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output: None
*
*	Returns: The colorcell object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Nov 17, 1992 19:24
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_colorcell(
   xvobject parent,
   char     *name)
{
	xvobject object;


	/*
	 *  Call the xvw_create() routine to do the actual creation.
	 */
	object = xvw_create(parent, FALSE, TRUE, name, ColorCellWidgetClass);
	return(object);
}
