 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                Axis Gadget Routines
   >>>>
   >>>>	Static:
   >>>>			ClassInitialize()
   >>>>			Initialize()
   >>>>			Realize()
   >>>>			Resize()
   >>>>			Redisplay()
   >>>>			Destroy()
   >>>>			SetValues()
   >>>>			PickGadget()
   >>>>
   >>>>			draw_axis_system()
   >>>>			draw_tics_grid_labels_linear()
   >>>>			draw_tics_grid_labels_log10()
   >>>>			set_labeling_parameters()
   >>>>			set_label_mode()
   >>>>			draw_tic_label()
   >>>>			update_axis_label()
   >>>>			draw_begin_value()
   >>>>			draw_end_value()
   >>>>			update_tic_label_list()
   >>>>			valid_axis()
   >>>> Private:
   >>>> Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvisual/AxisP.h>


static void Realize	  PROTO((Widget,XtValueMask *, XSetWindowAttributes *));
static void Resize	  PROTO((Widget));
static void Initialize	  PROTO((Widget, Widget, ArgList, Cardinal *));
static void Redisplay	  PROTO((Widget, XEvent *, Region));
static void Destroy	  PROTO((Widget));
static Boolean SetValues  PROTO((Widget, Widget, Widget, ArgList, Cardinal *));
static int PickGadget	  PROTO((Widget, int, int));
static void ClassInitialize   PROTO((void));


static Boolean draw_tic_label PROTO((XvwAxisGadget, Coord *, Coord *, 
				     double, double, double, tic_label_list *,
				     char *, char *, Pixel));
static void draw_axis_system		 PROTO((XvwAxisGadget));
static void draw_tics_grid_labels_linear PROTO((XvwAxisGadget));
static void draw_tics_grid_labels_log10	 PROTO((XvwAxisGadget));
static void set_labeling_parameters	 PROTO((XvwAxisGadget));
static Boolean set_label_mode		 PROTO((int *, int *, double *,
						double *, double *, double *));
static int valid_axis		  	 PROTO((Coord *, Coord *, Coord *));
static Boolean draw_begin_value		 PROTO((Coord *, Coord *, double));
static Boolean draw_end_value		 PROTO((Coord *, Coord *, double));
static void update_axis_label		 PROTO((XvwAxisGadget));
static void update_tic_label_list	 PROTO((XvwAxisGadget));
/*
 *  These are the unique identifiers for the 9 different possible corners
 *  that the begin and end should be.  They are used to make sure that both
 *  correspond the a valid axis.  That is that if the begin is the ORIGIN
 *  than the end can only be XCORNER, YCORNER and ZCORNER.
 */
#define NOT_A_CORNER	0x0
#define ORIGIN		0x007
#define XCORNER		0x019
#define YCORNER		0x062
#define ZCORNER		0x184
#define XYCORNER	0x228
#define XZCORNER	0x490
#define YZCORNER	0x940
#define XYZCORNER	0xe00


/*--------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {

{XVW_AXIS_RESTORE_LABELS,	  NULL,				   XtRInt,
		XtRBoolean}, 
{XVW_AXIS_AXIS_MODE,		  NULL,				   XtRInt,
	  	NULL}, 
{XVW_AXIS_SHOW_BOX,		  NULL,				   XtRInt,
	  	XtRBoolean}, 
{XVW_AXIS_BOX_COLOR,		  XVW_AXIS_BOX_PIXEL,		   XtRString,
		XtRPixel},
{XVW_AXIS_BOX_PIXEL,		  NULL,				   XtRPixel,
		NULL},
{XVW_AXIS_SHOW_MAJOR_GRID,	  NULL,				   XtRInt,
		XtRBoolean}, 
{XVW_AXIS_SHOW_MINOR_GRID,	  NULL,				   XtRInt,
		XtRBoolean}, 
{XVW_AXIS_MAJOR_GRID_LINE_TYPE,   NULL,				   XtRInt,
		NULL},
{XVW_AXIS_MINOR_GRID_LINE_TYPE,   NULL,				   XtRInt,
		NULL},
{XVW_AXIS_MAJOR_GRID_LINE_WIDTH,  NULL,				   XtRInt,
		NULL},
{XVW_AXIS_MINOR_GRID_LINE_WIDTH,  NULL,				   XtRInt,
		NULL},
{XVW_AXIS_MAJOR_GRID_COLOR,	  XVW_AXIS_MAJOR_GRID_PIXEL,	   XtRString,
		XtRPixel},
{XVW_AXIS_MINOR_GRID_COLOR,	  XVW_AXIS_MINOR_GRID_PIXEL,	   XtRString,
		XtRPixel},
{XVW_AXIS_MAJOR_GRID_PIXEL,	  NULL,				   XtRPixel,
		NULL}, 
{XVW_AXIS_MINOR_GRID_PIXEL,	  NULL,				   XtRPixel,
		NULL}, 
{XVW_AXIS_BEGIN_AXIS,		  NULL,				   XtRPointer,
		NULL},
{XVW_AXIS_END_AXIS,		  NULL,				   XtRPointer,
		NULL},
{XVW_AXIS_DIRECTION,		  NULL,				   XtRPointer,
		NULL},
{XVW_AXIS_SHOW_AXIS,		  NULL,				   XtRInt,
		XtRBoolean},
{XVW_AXIS_AXIS_COLOR,		  XVW_AXIS_AXIS_PIXEL,		   XtRString,
		XtRPixel},
{XVW_AXIS_AXIS_PIXEL,		  NULL,				   XtRPixel,
		NULL},
{XVW_AXIS_SHOW_AXIS_LABEL,	  NULL,				   XtRInt,
		XtRBoolean},
{XVW_AXIS_LABEL,		  NULL,				   XtRString,
		NULL},
{XVW_AXIS_SHOW_ZERO_LINE,	  NULL,				   XtRInt,
		XtRBoolean},
{XVW_AXIS_NUMBER_MINOR_TICS,	  NULL,				   XtRInt,
		NULL},
{XVW_AXIS_TIC_JUSTIFICATION,	  NULL,				   XtRInt,
		NULL},
{XVW_AXIS_SHOW_TICS,		  NULL,				   XtRInt,
		XtRBoolean},
{XVW_AXIS_LABELING_MODE,	  NULL,				   XtRInt,
		NULL},
{XVW_AXIS_LABELED_MAX,		  NULL,				   XtRDouble,
		NULL},
{XVW_AXIS_LABELED_MIN,		  NULL,				   XtRDouble,
		NULL},
{XVW_AXIS_LABELED_INTERVAL,	  NULL,				   XtRDouble,
		NULL},
{XVW_AXIS_NICE_LABELS,		  NULL,				   XtRInt,
		XtRBoolean},
{XVW_AXIS_NUMBER_STEPS,		  NULL,				   XtRDouble,
		NULL},
{XVW_AXIS_SHOW_NUMERICAL_LABELS,  NULL,				   XtRInt,
		XtRBoolean}, 
{XVW_AXIS_NUMERICAL_LABELS_COLOR, XVW_AXIS_NUMERICAL_LABELS_PIXEL, XtRString,
		XtRPixel}, 
{XVW_AXIS_NUMERICAL_LABELS_PIXEL,  NULL,			   XtRPixel,
		NULL},
{XVW_AXIS_NUMERICAL_LABELS_FORMAT, NULL,			   XtRPointer,
		NULL},
};

/*--------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwAxisGadgetRec, axis.field)

static Coord init_coord0 = {0.0, 0.0, 0.0, 0};
static Coord init_coord1 = {1.0, 1.0, 1.0, 0};

static double default_labeled_min = 0.0,
	      default_labeled_max = 1.0,
	      default_number_steps = 5.0,
	      default_labeled_interval = 0.2;

static XtResource resources[] = {

{XVW_AXIS_RESTORE_LABELS, NULL, XtRBoolean, sizeof(Boolean),
      offset(restore_labels), XtRImmediate, (XtPointer) FALSE},

{XVW_AXIS_AXIS_MODE, NULL, XtRInt, sizeof(int),
      offset(axis_mode), XtRImmediate, (XtPointer) KGRAPHICS_LINEAR},

{XVW_AXIS_SHOW_BOX, NULL, XtRBoolean, sizeof(Boolean),
      offset(show_box), XtRImmediate, (XtPointer) TRUE},

{XVW_AXIS_BOX_PIXEL, XVW_AXIS_BOX_COLOR, XtRPixel, sizeof(Pixel),
      offset(box_color.pixel), XtRString, XtDefaultForeground},

{XVW_AXIS_SHOW_MAJOR_GRID, NULL, XtRBoolean, sizeof(Boolean),
      offset(show_major_grid), XtRImmediate, (XtPointer) FALSE},

{XVW_AXIS_SHOW_MINOR_GRID, NULL, XtRBoolean, sizeof(Boolean),
      offset(show_minor_grid), XtRImmediate, (XtPointer) FALSE},

{XVW_AXIS_MAJOR_GRID_LINE_TYPE, NULL, XtRInt, sizeof(int),
      offset(major_grid_line_type), XtRImmediate,
      (XtPointer) KLINE_GRID_DOTTED},

{XVW_AXIS_MINOR_GRID_LINE_TYPE, NULL, XtRInt,
      sizeof(int), offset(minor_grid_line_type), XtRImmediate,
      (XtPointer) KLINE_GRID_DOTTED},

{XVW_AXIS_MAJOR_GRID_LINE_WIDTH, NULL, XtRInt,
      sizeof(int), offset(major_grid_line_width), XtRImmediate,
      (XtPointer) KLINE_MEDIUM_FINE},

{XVW_AXIS_MINOR_GRID_LINE_WIDTH, NULL,
      XtRInt, sizeof(int), offset(minor_grid_line_width), XtRImmediate,
      (XtPointer) KLINE_EXTRA_FINE},

{XVW_AXIS_MAJOR_GRID_PIXEL, XVW_AXIS_MAJOR_GRID_COLOR, XtRPixel, sizeof(Pixel),
      offset(major_grid_color.pixel), XtRString, XtDefaultForeground},

{XVW_AXIS_MINOR_GRID_PIXEL, XVW_AXIS_MINOR_GRID_COLOR, XtRPixel, sizeof(Pixel),
      offset(minor_grid_color.pixel), XtRString, XtDefaultForeground},

{XVW_AXIS_BEGIN_AXIS, NULL, XtRCoord, sizeof(Coord),
      offset(begin_axis), XtRCoord, (XtPointer) &init_coord0},

{XVW_AXIS_END_AXIS, NULL, XtRCoord, sizeof(Coord),
      offset(end_axis), XtRCoord, (XtPointer) &init_coord1},

{XVW_AXIS_DIRECTION, NULL, XtRCoord, sizeof(Coord),
      offset(axis_direction), XtRCoord, (XtPointer) &init_coord1},

{XVW_AXIS_SHOW_AXIS, NULL, XtRBoolean, sizeof(Boolean),
      offset(show_axis), XtRImmediate, (XtPointer) TRUE},

{XVW_AXIS_AXIS_PIXEL, XVW_AXIS_AXIS_COLOR, XtRPixel, sizeof(Pixel),
      offset(axis_color.pixel), XtRString, XtDefaultForeground},

{XVW_AXIS_SHOW_AXIS_LABEL, NULL, XtRBoolean,
      sizeof(Boolean), offset(show_axis_label), XtRImmediate, (XtPointer) TRUE},

{XVW_AXIS_LABEL, NULL, XtRString,
      sizeof(char *), offset(label), XtRImmediate, (XtPointer) NULL},

{XVW_AXIS_SHOW_ZERO_LINE, NULL, XtRBoolean, sizeof(Boolean),
      offset(show_zero_line), XtRImmediate, (XtPointer) TRUE},

{XVW_AXIS_NUMBER_MINOR_TICS, NULL, XtRInt, sizeof(int),
      offset(number_minor_tics), XtRImmediate, (XtPointer) 0},

{XVW_AXIS_TIC_JUSTIFICATION, NULL, XtRInt, sizeof(int),
      offset(tic_justification), XtRImmediate, (XtPointer) KAXIS_INSIDE },

{XVW_AXIS_SHOW_TICS, NULL, XtRBoolean, sizeof(Boolean),
      offset(show_tics), XtRImmediate, (XtPointer) TRUE },

{XVW_AXIS_LABELING_MODE, NULL, XtRInt, sizeof(int),
      offset(labeling_mode), XtRImmediate, (XtPointer) KAXIS_SET_DEFAULT_MODE },

{XVW_AXIS_LABELED_MAX, NULL, XtRDouble, sizeof(double),
      offset(labeled_max), XtRDouble, (XtPointer) &default_labeled_max},

{XVW_AXIS_LABELED_MIN, NULL, XtRDouble, sizeof(double),
      offset(labeled_min), XtRDouble, (XtPointer) &default_labeled_min},

{XVW_AXIS_LABELED_INTERVAL, NULL, XtRDouble,
      sizeof(double), offset(labeled_interval), XtRDouble,
      (XtPointer) &default_labeled_interval},

{XVW_AXIS_NICE_LABELS, NULL, XtRBoolean, sizeof(Boolean), offset(nice_labels),
      XtRImmediate, (XtPointer) FALSE},

{XVW_AXIS_NUMBER_STEPS, NULL, XtRDouble, sizeof(double),
      offset(number_steps), XtRDouble, (XtPointer) &default_number_steps},

{XVW_AXIS_SHOW_NUMERICAL_LABELS, NULL, XtRBoolean,
      sizeof(Boolean), offset(show_tic_labels), XtRImmediate,
      (XtPointer) TRUE},

{XVW_AXIS_NUMERICAL_LABELS_PIXEL, XVW_AXIS_NUMERICAL_LABELS_COLOR, XtRPixel,
      sizeof(Pixel), offset(tic_labels_color.pixel), XtRString,
      XtDefaultForeground},

{XVW_AXIS_NUMERICAL_LABELS_FORMAT, NULL, XtRPointer,
      sizeof(char *), offset(tic_labels_format), XtRImmediate,
      (XtPointer) "%g"},
};
#undef offset

#define SUPERCLASS (&xvwGraphicsGadgetClassRec)

XvwAxisGadgetClassRec xvwAxisGadgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Axis",				/* class_name		  */
    sizeof(XvwAxisGadgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,		                /* initialize_hooks       */
    (XtProc) Realize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),			/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    FALSE,				/* compress_exposure	  */
    FALSE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    Resize,				/* resize		  */
    Redisplay,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
    PickGadget,				/* pick object proc       */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    XtInheritChangeGeometry,		/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
    XtInheritRecomputePosition,		/* recompute position proc    */
  },  /* XvwGraphicsGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* XvwAxisGadgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwAxisGadgetClass for public consumption
 */
WidgetClass xvwAxisGadgetClass = (WidgetClass) &xvwAxisGadgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize - initializes the axis class
|
|       Purpose: Called the first time an instance of axis object class
|		 has been created.  It will initialize all the class
|		 attributes.  It also sets up the menu associated
|		 with the axis object.
|
|         Input: none
|
|        Output: none
|
|       Returns: nothing
|
|    Written By: Mark Young and John M. Salas
|          Date: Aug 15, 1992
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
	xvw_init_attributes(xvwAxisGadgetClass, attributes,
		knumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Axis");
}


/*-----------------------------------------------------------
|
|  Routine Name: Initialize - initializes the axis object
|
|       Purpose: Sets up the initial values for all the fields for a
|		 axis object instance and xvgraphics parameters.
|
|         Input: request - widget instance with requested public settings
|                new     - widget instance after initialization, with
|			   settings initialized
|
|        Output: initializes several of the axis objects values.
|		 begin_axis		     - the begin point of the
|					       axis system
|		 end_axis		     - the end point of the
|					       axis system
|		 axis_direction		     - the axis direction
|					       for the axis
|		 number_stringvalue_widgets  - the total number of string
|					       value widgets
|		 list_head		     - the head of the list of
|					       string value widgets
|		 list_tail		     - the tail of the list of
|					       string value widgets
|		 old_tic_labels_format - the parameter that gets
|					       track of the old label
|					       format
|		 old_tic_labels_color  - the parameter that gets
|					       track of the old label
|					       color
|		 id			     - the axis id
|		 axis_label_initialized	     - parameter that indicates
|					       whether the axis label
|					       has been initialized
|		 maximum_same		     - parameter that indicates
|					       whether the actual and
|					       labeled maximum is the same
|		 minimum_same		     - parameter that indicates
|					       whether the actual and
|					       labeled minimum is the same
|
|       Returns: nothing
|
|    Written By: Mark Young and John M. Salas
|          Date: Jul 02, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
  XvwAxisGadget axis = (XvwAxisGadget) new;
  Colormap colormap;

/*
 *  Set up the parameters for the location and direction of the
 *  axis to be drawn.  Since, this must be done by the programmer
 *  all we can do is give them values that are legal, but it will
 *  not draw a valid axis system.  Oh well, hope the programmer
 *  sets the parameters up right.
 */
  axis->axis.begin_axis.x = 0.0;
  axis->axis.begin_axis.y = 0.0;
  axis->axis.begin_axis.z = 0.0;

  axis->axis.end_axis.x = 1.0;
  axis->axis.end_axis.y = 1.0;
  axis->axis.end_axis.z = 1.0;

  axis->axis.axis_direction.x = 1.0;
  axis->axis.axis_direction.y = 1.0;
  axis->axis.axis_direction.z = 1.0;

  axis->axis.number_stringvalue_widgets = 0;
  axis->axis.list_head = NULL;
  axis->axis.list_tail = NULL;
  axis->axis.old_tic_labels_format = NULL;
  axis->axis.old_tic_labels_color.pixel =
			axis->axis.tic_labels_color.pixel;
  axis->axis.maximum_same = TRUE;
  axis->axis.minimum_same = TRUE;



 /*
  *  Compute the position of the object in device coordinates
  */
  axis->axis.id = (int) axis+1;
/*
 axis->axis.id = (int) new;
 */
 X3D_init_graphics(axis->axis.id, KGRAPHICS_2D);
 X3D_set_X11(axis->axis.id, XtDisplay(new), None, XtParent(new));

/*
 *  Axis object does not want to clip since the tic marks and
 *  string objects are outside of view port, but still should
 *  be drawn.
 */
  xvw_set_attributes(xvw_object(new),
		     XVW_GRAPHICS_CLIPPING,	  FALSE,
		     XVW_GRAPHICS_DEPTH_CLIPPING, FALSE,
		     NULL);

/*
 *  Creates the default axis label.
 */
  axis->axis.axis_label = xvw_create_string(xvw_object(axis->object.parent),
					    "label");
  xvw_set_attributes(axis->axis.axis_label,
		     XVW_STRING_STRING,		  "Axis",
		     XVW_MAPPED,		  FALSE,
		     XVW_MENUABLE,		  TRUE,
		     XVW_GRAPHICS_CLIPPING,	  FALSE,
		     XVW_GRAPHICS_DEPTH_CLIPPING, FALSE,
		     NULL);

  axis->axis.axis_label_initialized = FALSE;

/*
 *  Allocate the RGB value for the colors needed by the axis in the
 *  colormap for the display.
 */
  colormap = axis->object.parent->core.colormap;
  XQueryColor(XtDisplay(new), colormap, &axis->axis.box_color);
  XQueryColor(XtDisplay(new), colormap, &axis->axis.major_grid_color);
  XQueryColor(XtDisplay(new), colormap, &axis->axis.minor_grid_color);
  XQueryColor(XtDisplay(new), colormap, &axis->axis.tic_labels_color);
  XQueryColor(XtDisplay(new), colormap, &axis->axis.axis_color);
}

/*-----------------------------------------------------------
|
|  Routine Name: Realize
|
|       Purpose: This method will realize the axis object
|
|         Input: widget  - the object to realize
|    Written By: Mark Young and John M. Salas
|          Date: Aug 30, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Realize(
   Widget		widget,
   XtValueMask          *valuemask,
   XSetWindowAttributes *winattrib)
{
	XvwAxisGadget xobj = (XvwAxisGadget) widget;

	X3D_set_X11(xobj->axis.id, XtDisplay(widget), None, XtParent(widget));
	update_tic_label_list(xobj);
	update_axis_label(xobj);
	xobj->axis.axis_label_initialized = FALSE;
}

/*-----------------------------------------------------------
|
|  Routine Name: Resize
|
|       Purpose: This method will recalculate any components 
|		 of the object that are position or size dependent. 
|
|         Input: widget - the object to resize
|    Written By: Mark Young and John M. Salas
|          Date: Aug 30, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Resize(
   Widget widget)
{
	XvwAxisGadget xobj = (XvwAxisGadget) widget;

	X3D_set_X11(xobj->axis.id, XtDisplay(widget), None, XtParent(widget));
	xobj->axis.axis_label_initialized = FALSE;
}

/*-----------------------------------------------------------
|
|  Routine Name: Redisplay - redisplays the axis gadget
|
|       Purpose: Will initialize the tic axis labels if they
|		 are to be drawn by calling update_tic_label_list()
|		 or will unmapped them from the display if not.
|
|		 Will redisplay the axis (tic marks, grid, etc.)
|		 according to the axis direction and other values
|		 specified in the axis object data structure by
|		 calling draw_axis_system().
|
|         Input: widget - widget to display
|                event  - the event that caused the redraw
|		 region - the region that was exposed
|
|        Output: none
|
|       Returns: nothing
|
|    Written By: Mark Young and John M. Salas
|          Date: Jul 02, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Redisplay(
   Widget widget,
   XEvent *event,
   Region region)
{
  XvwAxisGadget		axis = (XvwAxisGadget) widget;

  int			i;
  tic_label_list	*temp_list;

/*
 *  If the tic labels are to be drawn (re-)initialize them.
 *  If not, unmap them so that they will not be displayed.
 */
  if ( axis->axis.show_tic_labels )
  {
    update_tic_label_list(axis);
  }
  else
  {
    temp_list = axis->axis.list_head;

    for ( i = 0 ; i < axis->axis.number_stringvalue_widgets &&
		  temp_list != NULL ;
	  i++ , temp_list = temp_list->next)
    {
      xvw_set_attributes(temp_list->stringvalue, XVW_MAPPED, FALSE, NULL);
    }
  }

/*
 *  Draw the axis system.
 */
  draw_axis_system(axis);
  axis->axis.axis_label_initialized = TRUE;
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy - destroys the widget
|
|       Purpose: Destroy's the objects associated with the axis
|		 object, i.e. the tic and axis labels.
|
|         Input: widget - widget to destroy
|
|        Output: none
|
|       Returns: nothing
|
|    Written By: Mark Young and John M. Salas
|          Date: Jul 02, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
  XvwAxisGadget		axis = (XvwAxisGadget) widget;

  int			i;
  tic_label_list	*temp_list;
  Widget                parent;

/*
 *  Destroy associated StringValues as well
 */
  parent =  XtParent(widget);
  if (parent->core.being_destroyed)
     return;
  temp_list = axis->axis.list_head;
  for ( i = 0 ; i < axis->axis.number_stringvalue_widgets && temp_list != NULL ;
	i++ , temp_list = temp_list->next)
  {
    xvw_destroy(temp_list->stringvalue);
  }
  xvw_destroy(axis->axis.axis_label);
}


/*-----------------------------------------------------------
|
|  Routine Name: SetValues - check the resource values set on the axis object
|
|       Purpose: Checks to see if the resources set are valid with
|		 respect to legitimate values for those resources
|		 and with respect to each other.
|
|         Input: current - current settings of the resources
|                request - requested settings of the resources
|                new	 - new settings of the resources
|
|        Output: a modified new settings of the resourses
|
|	Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young and John M. Salas
|          Date: Jul 02, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
  XvwAxisGadget caxis = (XvwAxisGadget) current;
  XvwAxisGadget raxis = (XvwAxisGadget) request;
  XvwAxisGadget naxis = (XvwAxisGadget) new;
  Boolean redisplay_axis_system = FALSE;
  Boolean reset_labeling_parameters = FALSE;
  Boolean one_set;
  Boolean new_direction = FALSE,
	  new_begin_axis = FALSE,
	  new_end_axis = FALSE;
  static Boolean resetting_max_min = FALSE;

/*
 * This check insures that this routine does not get re-executed when setting
 * values via xvw_set_attributes.
 */
  if ( resetting_max_min )
    return(TRUE);

  if (caxis->axis.label != naxis->axis.label)
  {
      kfree(caxis->axis.label);
      naxis->axis.label = kstrdup(naxis->axis.label);
      xvw_set_attribute(naxis->axis.axis_label,
			XVW_STRING_STRING, naxis->axis.label);
      update_axis_label(naxis);
  }

  if (!GraphicsCheckCoord(caxis->axis.axis_direction,
		naxis->axis.axis_direction))
  {
/*
 * Check to see if the axis direction is not a 0.0 or a 1.0, I know this
 * parameter should probably be an integer, but ...
 */
    if ( ( naxis->axis.axis_direction.x != 0.0 &&
	   naxis->axis.axis_direction.x != 1.0 ) ||
	 ( naxis->axis.axis_direction.y != 0.0 &&
	   naxis->axis.axis_direction.y != 1.0 ) ||
	 ( naxis->axis.axis_direction.z != 0.0 &&
	   naxis->axis.axis_direction.z != 1.0 ) )
    {
      naxis->axis.axis_direction.x = caxis->axis.axis_direction.x;
      naxis->axis.axis_direction.y = caxis->axis.axis_direction.y;
      naxis->axis.axis_direction.z = caxis->axis.axis_direction.z;

      kinfo(KFORCE, "Axis Object: the axes direction can only be 0.0 or 1.0,\
 I know this should be a integer, but ...\n");
    }

/*
 * Check to see if more than one of the directions is set.
 */
    one_set = (int) naxis->axis.axis_direction.x ^
	      (int) naxis->axis.axis_direction.y ^
	      (int) naxis->axis.axis_direction.z;

    if ( ( naxis->axis.axis_direction.x == 1.0 &&
	   naxis->axis.axis_direction.y == 1.0 &&
	   naxis->axis.axis_direction.z == 1.0 ) || ! one_set)
    {
      naxis->axis.axis_direction.x = caxis->axis.axis_direction.x;
      naxis->axis.axis_direction.y = caxis->axis.axis_direction.y;
      naxis->axis.axis_direction.z = caxis->axis.axis_direction.z;

      kinfo(KFORCE, "Axis Object: only one axes directions can be set; have\
 to many directions to draw the axis system, please give me one direction at\
 a time ;^).\n");
    }

 /*
  * Check to see if the direction is all zeros or no direction at all.
  */
    if ( naxis->axis.axis_direction.x == naxis->axis.axis_direction.y &&
	 naxis->axis.axis_direction.y == naxis->axis.axis_direction.z &&
	 naxis->axis.axis_direction.z == 0.0 )
    {
      naxis->axis.axis_direction.x = caxis->axis.axis_direction.x;
      naxis->axis.axis_direction.y = caxis->axis.axis_direction.y;
      naxis->axis.axis_direction.z = caxis->axis.axis_direction.z;

      kinfo(KFORCE, "Axis Object: all axes directions are 0.0; do not know\
 which direction to draw the axis system, please give me direction ;^).\n");
    }

/*
 * If the direction specified passes the above test it has changed.
 */
    if (!GraphicsCheckCoord(caxis->axis.axis_direction,
	     naxis->axis.axis_direction))
    {
      new_direction = TRUE;
    }
  }

  if (!GraphicsCheckCoord(caxis->axis.begin_axis, naxis->axis.begin_axis))
  {
/*
 * Check to see if the begin point of the axis is within the WC.
 */
    if ( naxis->axis.begin_axis.x < 0.0 || naxis->axis.begin_axis.x > 1.0 ||
	 naxis->axis.begin_axis.y < 0.0 || naxis->axis.begin_axis.y > 1.0 ||
	 naxis->axis.begin_axis.z < 0.0 || naxis->axis.begin_axis.z > 1.0)
    {
      naxis->axis.begin_axis.x = caxis->axis.begin_axis.x;
      naxis->axis.begin_axis.y = caxis->axis.begin_axis.y;
      naxis->axis.begin_axis.z = caxis->axis.begin_axis.z;
      kinfo(KFORCE, "Axis Object: begin axis value is out of range should be\
 between 0.0 and 1.0.\n");
    }

 /*
  * Check to see if the begin point of the axis is greater than the end point
  */
    if ( naxis->axis.end_axis.x < naxis->axis.begin_axis.x &&
	 naxis->axis.end_axis.y < naxis->axis.begin_axis.y &&
	 naxis->axis.end_axis.z < naxis->axis.begin_axis.z )
    {
      naxis->axis.begin_axis.x = caxis->axis.begin_axis.x;
      naxis->axis.begin_axis.y = caxis->axis.begin_axis.y;
      naxis->axis.begin_axis.z = caxis->axis.begin_axis.z;
      kinfo(KFORCE, "Axis Object: begin axis value is greater than the end\
 axis value.\n");
    }

/*
 * If the begin point specified passes the above test it has changed.
 */
    if (!GraphicsCheckCoord(caxis->axis.begin_axis, naxis->axis.begin_axis))
    {
      new_begin_axis = TRUE;
    }
  }

  if (!GraphicsCheckCoord(caxis->axis.end_axis, naxis->axis.end_axis))
  {
/*
 * Check to see if the end point of the axis is within the WC.
 */
    if ( naxis->axis.end_axis.x < 0.0 || naxis->axis.end_axis.x > 1.0 ||
	 naxis->axis.end_axis.y < 0.0 || naxis->axis.end_axis.y > 1.0 ||
	 naxis->axis.end_axis.z < 0.0 || naxis->axis.end_axis.z > 1.0)
    {
      naxis->axis.end_axis.x = caxis->axis.end_axis.x;
      naxis->axis.end_axis.y = caxis->axis.end_axis.y;
      naxis->axis.end_axis.z = caxis->axis.end_axis.z;
      kinfo(KFORCE, "Axis Object: end axis value is out of range should be\
 between 0.0 and 1.0.\n");
    }

/*
 * Check to see if the end point of the axis is less than the begin point
 */
    if ( naxis->axis.end_axis.x < naxis->axis.begin_axis.x &&
	 naxis->axis.end_axis.y < naxis->axis.begin_axis.y &&
	 naxis->axis.end_axis.z < naxis->axis.begin_axis.z )
    {
      naxis->axis.end_axis.x = caxis->axis.end_axis.x;
      naxis->axis.end_axis.y = caxis->axis.end_axis.y;
      naxis->axis.end_axis.z = caxis->axis.end_axis.z;
      kinfo(KFORCE, "Axis Object: end axis value is less than the begin axis\
 value.\n");
    }

/*
 * If the end point specified passes the above test it has changed.
 */
    if (!GraphicsCheckCoord(caxis->axis.end_axis, naxis->axis.end_axis))
    {
      new_end_axis = TRUE;
    }
  }

/*
 * If the direction, begin and end point has changed make sure they are
 * valid as a group.
 */
  if ( new_direction || new_begin_axis || new_end_axis )
  {
    if ( ! valid_axis(&naxis->axis.begin_axis, &naxis->axis.end_axis,
		      &naxis->axis.axis_direction) )
    {
/*
 * Reset to the old values and check again.
 */
      naxis->axis.axis_direction.x = caxis->axis.axis_direction.x;
      naxis->axis.axis_direction.y = caxis->axis.axis_direction.y;
      naxis->axis.axis_direction.z = caxis->axis.axis_direction.z;

      naxis->axis.begin_axis.x = caxis->axis.begin_axis.x;
      naxis->axis.begin_axis.y = caxis->axis.begin_axis.y;
      naxis->axis.begin_axis.z = caxis->axis.begin_axis.z;

      naxis->axis.end_axis.x = caxis->axis.end_axis.x;
      naxis->axis.end_axis.y = caxis->axis.end_axis.y;
      naxis->axis.end_axis.z = caxis->axis.end_axis.z;

      if ( ! valid_axis(&naxis->axis.begin_axis, &naxis->axis.end_axis,
		        &naxis->axis.axis_direction) )
      {
        kinfo(KFORCE, "Axis Object: begin and end not a valid set of values,\
 de-activating.\n");
        redisplay_axis_system |= TRUE;
      }
      else
      {
        kinfo(KFORCE, "Axis Object: begin and end not a valid set of values\
 using current settings.\n");
        redisplay_axis_system |= FALSE;
      }
    }
    else
    {
      reset_labeling_parameters = TRUE;
      redisplay_axis_system |= TRUE;
    }
  }

/*
 * According to the axis direction set the actual_max and actual_min variables
 * using the graphic object's wcmax and wcmin values.  Also, if the graphics
 * axis mode has changed set the axis_mode variable.
 */
  if ( raxis->graphics.axis_mode_x != caxis->graphics.axis_mode_x &&
  	    naxis->axis.axis_direction.x == 1.0 )
  {
       caxis->axis.axis_mode  = caxis->graphics.axis_mode_x;
       naxis->axis.axis_mode  = raxis->graphics.axis_mode_x;
  }
  else if ( raxis->graphics.axis_mode_y != caxis->graphics.axis_mode_y &&
  	    naxis->axis.axis_direction.y == 1.0 )
  {
       caxis->axis.axis_mode  = caxis->graphics.axis_mode_y;
       naxis->axis.axis_mode  = raxis->graphics.axis_mode_y;
  }
  else if ( raxis->graphics.axis_mode_z != caxis->graphics.axis_mode_z &&
  	    naxis->axis.axis_direction.z == 1.0 )
  {
       caxis->axis.axis_mode  = caxis->graphics.axis_mode_z;
       naxis->axis.axis_mode  = raxis->graphics.axis_mode_z;
  }

  if ( naxis->axis.axis_direction.x == 1.0 )
  {
    caxis->axis.actual_max = caxis->graphics.wcmax.x;
    caxis->axis.actual_min = caxis->graphics.wcmin.x;
    naxis->axis.actual_max = naxis->graphics.wcmax.x;
    naxis->axis.actual_min = naxis->graphics.wcmin.x;
#if 0
kprintf("X Axis:  Setting min (%g) max (%g)\n", naxis->graphics.wcmin.x, naxis->graphics.wcmax.x);
#endif
  }
  else if ( naxis->axis.axis_direction.y == 1.0 )
  {
    caxis->axis.actual_max = caxis->graphics.wcmax.y;
    caxis->axis.actual_min = caxis->graphics.wcmin.y;
    naxis->axis.actual_max = naxis->graphics.wcmax.y;
    naxis->axis.actual_min = naxis->graphics.wcmin.y;
#if 0
kprintf("Y Axis:  Setting min (%g) max (%g)\n", naxis->graphics.wcmin.y, naxis->graphics.wcmax.y);
#endif
  }
  else
  {
    caxis->axis.actual_max = caxis->graphics.wcmax.z;
    caxis->axis.actual_min = caxis->graphics.wcmin.z;
    naxis->axis.actual_max = naxis->graphics.wcmax.z;
    naxis->axis.actual_min = naxis->graphics.wcmin.z;
#if 0
kprintf("Z Axis:  Setting min (%g) max (%g)\n", naxis->graphics.wcmin.z, naxis->graphics.wcmax.z);
#endif
  }

/*
 * Determine which labeling parameter(s) have changed and set the labeling_mode
 * accordingly if the programmer has not explicity specified the labeling_mode.
 * The order of priority is,
 *	0) nice labels reset to TRUE (KAXIS_SET_DEFAULT_MODE)
 *	1) Maximum, minimum or nice labels reset to FALSE (KAXIS_SET_MAX_MIN)
 *	2) Label interval and number of steps (KAXIS_SET_INTERVAL_STEPS)
 *	3) Label interval (KAXIS_SET_LABELED_INTERVAL)
 *	4) Number of steps (KAXIS_SET_NUMBER_STEPS)
 */
  if (caxis->axis.labeling_mode      == naxis->axis.labeling_mode &&
      ( caxis->axis.nice_labels      != naxis->axis.nice_labels ||
        caxis->axis.number_steps     != naxis->axis.number_steps ||
        caxis->axis.labeled_interval != naxis->axis.labeled_interval ||
        caxis->axis.labeled_max      != naxis->axis.labeled_max ||
        caxis->axis.labeled_min      != naxis->axis.labeled_min ||
        caxis->axis.actual_max       != naxis->axis.actual_max ||
        caxis->axis.actual_min       != naxis->axis.actual_min))
  {
    if ( ( caxis->axis.labeled_max   != naxis->axis.labeled_max ||
	   caxis->axis.labeled_min   != naxis->axis.labeled_min ||
	   caxis->axis.actual_max    != naxis->axis.actual_max ||
	   caxis->axis.actual_min    != naxis->axis.actual_min ||
	   caxis->axis.nice_labels   != naxis->axis.nice_labels ) &&
	   naxis->axis.nice_labels )
    {
        naxis->axis.labeling_mode = KAXIS_SET_DEFAULT_MODE;
    }
    else if ( ( caxis->axis.labeled_max != naxis->axis.labeled_max ||
	        caxis->axis.labeled_min != naxis->axis.labeled_min ||
	        caxis->axis.actual_max  != naxis->axis.actual_max ||
	        caxis->axis.actual_min  != naxis->axis.actual_min ||
	        caxis->axis.nice_labels != naxis->axis.nice_labels ) &&
		! naxis->axis.nice_labels )
    {
      naxis->axis.labeling_mode = KAXIS_SET_MAX_MIN;
    }
    else if ( caxis->axis.number_steps     != naxis->axis.number_steps &&
	      caxis->axis.labeled_interval != naxis->axis.labeled_interval )
    {
      naxis->axis.labeling_mode = KAXIS_SET_INTERVAL_STEPS;
    }
    else if ( caxis->axis.labeled_interval != naxis->axis.labeled_interval )
    {
      naxis->axis.labeling_mode = KAXIS_SET_LABELED_INTERVAL;
    }
    else if ( caxis->axis.number_steps != naxis->axis.number_steps )
    {
      naxis->axis.labeling_mode = KAXIS_SET_NUMBER_STEPS;
    }

/* MY:
    naxis->axis.labeling_mode = KAXIS_SET_MAX_MIN;
*/
  }

/*
 * If the restore_labels value is FALSE:
 *	Check to see of the graphics maximum and/or minimum has changed.
 *	However, the labeling maximum and/or minimum could be different so
 *	check to see if they were the same in the past so the actual and
 *	labeled values will or will not be modified together.
 * If the restore_labels value is TRUE:
 *	reset the labeled maximum and minimum to the actual values and
 *	reset the restore_labels action.
 *
 */
  if ( ! naxis->axis.restore_labels )
  {
    if ( caxis->axis.actual_max  != naxis->axis.actual_max ||
         caxis->axis.labeled_max != naxis->axis.labeled_max )
    {
      if ( caxis->axis.labeled_max == naxis->axis.labeled_max &&
	   caxis->axis.actual_max  == caxis->axis.labeled_max )
      {
        naxis->axis.labeled_max  = naxis->axis.actual_max;
        naxis->axis.maximum_same = TRUE;
      }
      else
      {
        naxis->axis.maximum_same = FALSE;
      }
    }
/* MY
naxis->axis.labeled_max  = naxis->axis.actual_max;
naxis->axis.maximum_same = TRUE;
*/


    if ( caxis->axis.actual_min  != naxis->axis.actual_min ||
         caxis->axis.labeled_min != naxis->axis.labeled_min )
    {
      if ( caxis->axis.labeled_min == naxis->axis.labeled_min &&
	   caxis->axis.actual_min  == caxis->axis.labeled_min )
      {
        naxis->axis.labeled_min  = naxis->axis.actual_min;
        naxis->axis.minimum_same = TRUE;
      }
      else
      {
        naxis->axis.minimum_same = FALSE;
      }
/* MY:
naxis->axis.labeled_min  = naxis->axis.actual_min;
naxis->axis.minimum_same = TRUE;
*/

    }
  }
  else if ( naxis->axis.restore_labels )
  {
        naxis->axis.labeled_max    = naxis->axis.actual_max;
        naxis->axis.maximum_same   = TRUE;
        naxis->axis.labeled_min    = naxis->axis.actual_min;
        naxis->axis.minimum_same   = TRUE;
	naxis->axis.restore_labels = FALSE;
  }

/*
 * Set the labeling parameters if neccessary.
 */
  if (caxis->axis.labeling_mode    != naxis->axis.labeling_mode ||
      caxis->axis.nice_labels      != naxis->axis.nice_labels ||
      caxis->axis.axis_mode        != naxis->axis.axis_mode ||
      caxis->axis.number_steps     != naxis->axis.number_steps ||
      caxis->axis.labeled_interval != naxis->axis.labeled_interval ||
      caxis->axis.labeled_max      != naxis->axis.labeled_max ||
      caxis->axis.labeled_min      != naxis->axis.labeled_min ||
      caxis->axis.actual_max       != naxis->axis.actual_max ||
      caxis->axis.actual_min       != naxis->axis.actual_min)
  {
    if ( set_label_mode(&naxis->axis.labeling_mode,
			&naxis->axis.axis_mode,
			&naxis->axis.number_steps,
			&naxis->axis.labeled_interval,
			&naxis->axis.labeled_max,
			&naxis->axis.labeled_min) )
    {
      set_labeling_parameters(naxis);

/*
 * It is possible for the world coordinates and axis mode to have changed when
 * setting the labels.  So, set the real values in the graphics superclass via
 * xvw_set_attributes so that it can do its checking, but to make sure that we
 * do not enter an endless loop set the static variable resetting_max_min so
 * that this routine is not re-executed.
 *  
 */
      if ( naxis->axis.axis_direction.x == 1.0 )
      {
/*
	resetting_max_min = TRUE;
        xvw_set_attributes(xvw_object(new),
			   XVW_GRAPHICS_WCMAX_X, naxis->axis.actual_max,
			   XVW_GRAPHICS_WCMIN_X, naxis->axis.actual_min,
			   XVW_GRAPHICS_MODE_X,  naxis->axis.axis_mode,
			   NULL);
	resetting_max_min = FALSE;
 */
      }
      else if ( naxis->axis.axis_direction.y == 1.0 )
      {
/*
	resetting_max_min = TRUE;
        xvw_set_attributes(xvw_object(new),
			   XVW_GRAPHICS_WCMAX_Y, naxis->axis.actual_max,
			   XVW_GRAPHICS_WCMIN_Y, naxis->axis.actual_min,
			   XVW_GRAPHICS_MODE_Y,  naxis->axis.axis_mode,
			   NULL);
	resetting_max_min = FALSE;
 */
      }
      else if ( naxis->axis.axis_direction.z == 1.0 )
      {
/*
	resetting_max_min = TRUE;
        xvw_set_attributes(xvw_object(new),
			   XVW_GRAPHICS_WCMAX_Z, naxis->axis.actual_max,
			   XVW_GRAPHICS_WCMIN_Z, naxis->axis.actual_min,
			   XVW_GRAPHICS_MODE_Z,  naxis->axis.axis_mode,
			   NULL);
	resetting_max_min = FALSE;
 */
      }
			  
      reset_labeling_parameters = TRUE;
      redisplay_axis_system |= TRUE;
    }
  }

/*
 * Set the number of minor tics.
 */
  if ( caxis->axis.number_minor_tics != naxis->axis.number_minor_tics )
  {
    if ( naxis->axis.number_minor_tics < 0 )
    {
      naxis->axis.number_minor_tics = caxis->axis.number_minor_tics;
      kinfo(KFORCE, "Axis Object: the number of minor tic marks must be greater\
 than zero.\n");
    }
    else
    {
      redisplay_axis_system |= TRUE;
    }
  }

/*
 * Check to see if any of the other axis parameters have changed.
 */
  if ( caxis->axis.show_box             != naxis->axis.show_box ||
     caxis->axis.box_color.pixel        != naxis->axis.box_color.pixel ||
     caxis->axis.show_major_grid        != naxis->axis.show_major_grid ||
     caxis->axis.show_minor_grid        != naxis->axis.show_minor_grid ||
     caxis->axis.major_grid_line_type   != naxis->axis.major_grid_line_type ||
     caxis->axis.minor_grid_line_type   != naxis->axis.minor_grid_line_type ||
     caxis->axis.major_grid_line_width  != naxis->axis.major_grid_line_width ||
     caxis->axis.minor_grid_line_width  != naxis->axis.minor_grid_line_width ||
     caxis->axis.major_grid_color.pixel !=naxis->axis.major_grid_color.pixel ||
     caxis->axis.minor_grid_color.pixel !=naxis->axis.minor_grid_color.pixel ||
     caxis->axis.show_axis              != naxis->axis.show_axis ||
     caxis->axis.axis_color.pixel       != naxis->axis.axis_color.pixel ||
     caxis->axis.tic_justification      != naxis->axis.tic_justification ||
     caxis->axis.show_tics              != naxis->axis.show_tics ||
     caxis->axis.show_zero_line         != naxis->axis.show_zero_line ||
     caxis->axis.show_tic_labels  != naxis->axis.show_tic_labels ||
     caxis->axis.tic_labels_color.pixel !=
		naxis->axis.tic_labels_color.pixel ||
     caxis->axis.tic_labels_format!= naxis->axis.tic_labels_format)
  {
/*
 * If the tic label color has changed save the old value so that
 * it can be used in draw_tic_label().
 */
     if ( caxis->axis.tic_labels_color.pixel !=
	  naxis->axis.tic_labels_color.pixel )
       naxis->axis.old_tic_labels_color.pixel =
		caxis->axis.tic_labels_color.pixel;

/*
 * If the tic label format has changed save the old value so that
 * it can be used in draw_tic_label().
 */
    if ( caxis->axis.tic_labels_format !=
	 naxis->axis.tic_labels_format )
    {
      naxis->axis.tic_labels_format =
		kstrdup(naxis->axis.tic_labels_format);

      kfree(naxis->axis.old_tic_labels_format);

      naxis->axis.old_tic_labels_format =
		caxis->axis.tic_labels_format;
      caxis->axis.tic_labels_format = NULL;
    }

    reset_labeling_parameters = TRUE;
    redisplay_axis_system |= TRUE;
  }

/*
 * Check to see if the axis label is to be displayed.
 */
  if ( caxis->axis.show_axis_label != naxis->axis.show_axis_label )
  {
    xvw_set_attributes(naxis->axis.axis_label,
		       XVW_MAPPED, naxis->axis.show_axis_label,
		       NULL);
  }

/*
 * New direction
  if (new_direction)
  {
     if (naxis->axis.axis_direction.x == 1.0)
        xvw_set_attribute(naxis->axis.axis_label, XVW_STRING_STRING, "X Axis");
     else
	xvw_set_attribute(naxis->axis.axis_label, XVW_STRING_STRING, "Y Axis");
  }
 */

/*
 * New viewport
 */
  if (!GraphicsCheckCoord(caxis->graphics.viewmin, naxis->graphics.viewmin) ||
      !GraphicsCheckCoord(caxis->graphics.viewmax, naxis->graphics.viewmax))
  {
     X3D_set_viewport(naxis->axis.id, naxis->graphics.viewmin,
		naxis->graphics.viewmax);
  }

  if (  caxis->graphics.axis_mode_x != naxis->graphics.axis_mode_x ||
	caxis->graphics.axis_mode_y != naxis->graphics.axis_mode_y ||
	caxis->graphics.axis_mode_z != naxis->graphics.axis_mode_z)
  {
     reset_labeling_parameters = TRUE;
  }
  if (caxis->graphics.alpha 	   != naxis->graphics.alpha ||
      caxis->graphics.theta 	   != naxis->graphics.theta ||
      caxis->graphics.gamma 	   != naxis->graphics.gamma ||
      caxis->graphics.eye_distance != naxis->graphics.eye_distance)
  {
     X3D_set_viewpoint(naxis->axis.id, naxis->graphics.alpha,
		naxis->graphics.theta, naxis->graphics.gamma,
		naxis->graphics.eye_distance);
     reset_labeling_parameters = TRUE;
  }

  if (reset_labeling_parameters)
     naxis->axis.axis_label_initialized = FALSE;
  return(redisplay_axis_system);
}

/*----e------------------------------------------------------
|
|  Routine Name: PickGadget - determines if the axis has been selected
|
|       Purpose: Checks to see if the (x,y) location passed in
|		 lies on the axis's edge.  It will not be selected
|		 if it is in the middle of the widget.  It will
|		 be selected, if it is a x-axis, if the y is on
|		 the bottom or top of the widget or, if it is a
|		 y-axis, if the x is on the left or right edge.
|
|         Input: widget	- the axis object
|		 x	- the x location of the pick event
|		 y	- the y location of the pick event
|
|        Output: none
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: John M. Salas
|          Date:
| Modifications:
|
------------------------------------------------------------*/

static int PickGadget(
   Widget widget,
   int    xpos,
   int    ypos)
{
	XvwAxisGadget axis = (XvwAxisGadget) widget;

	int xpos1, ypos1, xpos2, ypos2, tolerance;


	xpos1 = widget->core.x;
	ypos1 = widget->core.y;
	xpos2 = xpos1 + widget->core.width;
	ypos2 = ypos1 + widget->core.height;
	tolerance = kmax(PICK_TOLERANCE, axis->graphics.line_width);

	if (((kabs(xpos - xpos1) <= tolerance ||
	      kabs(xpos - xpos2) <= tolerance) &&
	      axis->axis.axis_direction.y == 1.0) ||
	    ((kabs(ypos - ypos1) <= tolerance ||
	      kabs(ypos - ypos2) <= tolerance) &&
	     axis->axis.axis_direction.x == 1.0))
	{
	   return(TRUE);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: draw_tic_label - draws a tic label
|
|       Purpose: Converts the value passed in to a string and
|		 passes it the the stringvalue widget to be
|		 displayed.  It checks to see if the format and
|		 color has not been change by the user.  If they
|		 have been changed leave them alone.  When these
|		 parameters set by the user to the same as the
|		 axis objects they will track the axis objects
|		 values till they are changed to something
|		 different.
|
|         Input: begin_axis	  - begin point of axis 
|		 axis_direction	  - direction of the specified axis
|		 x		  - x value
|		 y		  - y value
|		 value		  - value to be drawn
|		 tolerance	  - ?
|		 tic_label	  - ?
|		 viewmin	  - ?
|		 viewmax	  - ?
|		 format	          - ?
|		 old_format       - ?
|		 pixel	          - Pixel to which to set label foreground
|
|        Output: all the passed in parameters can be modified
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: John M. Salas & Mark Young
|          Date: Jul 04, 1992
| Modifications:
|
------------------------------------------------------------*/

static Boolean draw_tic_label(
   XvwAxisGadget  axis,
   Coord          *begin_axis,
   Coord          *axis_direction,
   double         x,
   double         y,
   double         value,
   tic_label_list *tic_label,
   char           *format,
   char           *old_format,
   Pixel          pixel)
{
  Widget xobj;
  Coord position;
  Real  xpos, ypos;
  char	*current_format;

  xvobject object = xvw_object((Widget) axis);

  if ( axis->axis.axis_label_initialized == TRUE ) return(1);

  if ( tic_label == NULL ) return(1);

  if ( tic_label->stringvalue == NULL ) return(1);

  if ( (xobj = xvw_widget(tic_label->stringvalue)) == NULL ) return(1);
 
  position.x = x;
  position.y = y;
  if ( axis->graphics.graphics_type == KGRAPHICS_2D)
  {
     if ( !X2D_convert_point_wc_to_dc(axis->axis.id, position, &xpos, &ypos) )
        return(1);
  }
  else
  {
     if ( !X3D_convert_point_wc_to_dc(axis->axis.id, position, &xpos, &ypos) )
        return(1);
  }

/*
 * Get the stringvalue format to see if the user has used the string
 * value menu to change it.  If the user has changed it do not set
 * it to the one used by the axis.
 */
  xvw_get_attribute(tic_label->stringvalue, XVW_STRING_FORMAT, &current_format);

  if ( !kstrlen(current_format) || !kstrcmp(current_format, old_format) )
      xvw_set_attribute(tic_label->stringvalue, XVW_STRING_FORMAT, format);



/*
 * Set color of tic label to the foreground color specified
 */
    xvw_set_attribute(tic_label->stringvalue, XVW_FOREGROUND, pixel);

/*
 *  Modify the (x,y) location depending on whether the axis is an x or y
 *  axis.
 */
  if ( axis_direction->x == 1.0 )
  {
    if ( begin_axis->y < 0.5 )
    {
      xvw_set_attributes(tic_label->stringvalue,
		XVW_MAPPED, TRUE,
		XVW_XPOSITION,  (int) xpos,
		XVW_BELOW,	object,
		XVW_VERT_DIST,   5,
		XVW_HORIZ_DIST,  0,
		XVW_STRING_VALUE, value,
/*
		XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_CENTER,
 */
		NULL);
    }
    else
    {
      xvw_set_attributes(tic_label->stringvalue,
		XVW_MAPPED, TRUE,
		XVW_XPOSITION,  (int) xpos,
		XVW_ABOVE,	object,
		XVW_VERT_DIST,   5,
		XVW_HORIZ_DIST,  0,
		XVW_STRING_VALUE, value,
/*
		XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_CENTER,
 */
		NULL);
    }
  }
  else if ( axis_direction->y == 1.0 )
  {
    if ( begin_axis->x < 0.5 )
    {
      xvw_set_attributes(tic_label->stringvalue,
		XVW_MAPPED, TRUE,
		XVW_YPOSITION,  (int) ypos,
		XVW_LEFT_OF,	object,
		XVW_VERT_DIST,  0,
		XVW_HORIZ_DIST, 5,
		XVW_STRING_VALUE, value,
/*
		XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_RIGHT,
 */
		NULL);
    }
    else
    {
      xvw_set_attributes(tic_label->stringvalue,
		XVW_MAPPED, TRUE,
		XVW_YPOSITION,  (int) ypos,
		XVW_RIGHT_OF,	object,
		XVW_VERT_DIST,     0,
		XVW_HORIZ_DIST,   20,
		XVW_STRING_VALUE, value,
/*
		XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_RIGHT,
 */
		NULL);
    }
  }
  return(FALSE);
}


/*-----------------------------------------------------------
|
|  Routine Name: draw_axis_system - draws the axis system
|
|       Purpose: Draws the axis system drawing the axis and/or the box
|		 then calling either draw_tics_grid_labels_linear()
|		 or draw_tics_grid_labels_log() to draw the rest of the
|		 axis system and the tic labels.
|
|         Input: axis - the axis object
|
|        Output: none
|
|       Return: nothing
|
|    Written By: Mark Young and John M. Salas
|          Date: Jul 02, 1992
| Modifications:
|
------------------------------------------------------------*/

static void draw_axis_system(
   XvwAxisGadget axis)
{
  int	  id = axis->axis.id;
  Coord   *begin_axis = &axis->axis.begin_axis,
	  *end_axis = &axis->axis.end_axis,
	  *axis_direction = &axis->axis.axis_direction;
  Boolean show_axis = axis->axis.show_axis;
  XColor  *axis_color = &axis->axis.axis_color;
  double  labeled_max = axis->axis.labeled_max,
	  labeled_min = axis->axis.labeled_min;
  int     axis_mode = axis->axis.axis_mode;
  Boolean show_box = axis->axis.show_box;
  XColor  *box_color = &axis->axis.box_color;
  Boolean show_major_grid = axis->axis.show_major_grid;
  Boolean show_minor_grid = axis->axis.show_minor_grid;
  int     major_grid_line_type = axis->axis.major_grid_line_type;
  int     minor_grid_line_type = axis->axis.minor_grid_line_type;
  int     major_grid_line_width = axis->axis.major_grid_line_width;
  int     minor_grid_line_width = axis->axis.minor_grid_line_width;
  XColor  *major_grid_color = &axis->axis.major_grid_color;
  XColor  *minor_grid_color = &axis->axis.minor_grid_color;
  Boolean show_zero_line = axis->axis.show_zero_line;

  int	graphics_type = KGRAPHICS_2D;
  Coord	box_lines[4], axis_lines[2];
  double zeropoint;
  XColor *zero_line_color;

/*
JMAS
 
Routine does not exist.

  X3D_get_graphics(parent_id, &graphics_type);

*/

  if ( show_axis )
  {
    axis_lines[0].x = begin_axis->x;
    axis_lines[0].y = begin_axis->y;
    axis_lines[0].z = 0.0;

    axis_lines[1].x = end_axis->x;
    axis_lines[1].y = end_axis->y;
    axis_lines[1].z = 0.0;

    X2D_draw_segments(id, axis_lines, 2, axis_color);
  }

/*
 * Draw the box lines, if it or grid is specified.
 */
  if ( ( show_box || show_major_grid || show_minor_grid ) &&
       graphics_type == KGRAPHICS_2D )
  {
/*
 *  The box's line type and width have priority ...
 */
    if ( show_box )
    {
      X3D_set_line_type(id, KLINE_SOLID);
      X3D_set_line_width(id, KLINE_FINE);
    }
/*
 *  ... else the major grid's line type and width ...
 */
    else if ( show_major_grid )
    {
      X3D_set_line_type(id, major_grid_line_type);
      X3D_set_line_width(id, major_grid_line_width);
    }
/*
 *  ... else the minor grid's line type and width.
 */
    else if ( show_minor_grid )
    {
      X3D_set_line_type(id, minor_grid_line_type);
      X3D_set_line_width(id, minor_grid_line_width);
    }
/*
JMAS
      if (xp_device != xpX11)
	X3D_set_line_width(id, EXTRA_WIDE);

NOTE: The below code only works for 2D.
*/

    box_lines[0].x = 0.0;
    box_lines[0].y = 0.0;
    box_lines[0].z = 0.0;

    box_lines[1].x = axis_direction->x;
    box_lines[1].y = axis_direction->y;
    box_lines[1].z = 0.0;

    box_lines[2].x = axis_direction->y;
    box_lines[2].y = axis_direction->x;
    box_lines[2].z = 0.0;

    box_lines[3].x = 1.0;
    box_lines[3].y = 1.0;
    box_lines[3].z = 0.0;

    if ( show_box )
    {
      X2D_draw_segments(id, box_lines, 4, box_color);
    }
    else if ( show_major_grid )
    {
      X2D_draw_segments(id, box_lines, 4, major_grid_color);
    }
    else if ( show_minor_grid )
    {
      X2D_draw_segments(id, box_lines, 4, minor_grid_color);
    }
  }

/*
 *  If the zero line is specified it will show up, i.e. minimum < 0 < maximum,
 *  then draw the line.
 */
  if ( show_zero_line && 
       labeled_min < 0.0 && labeled_max > 0.0 &&
       graphics_type == KGRAPHICS_2D)
  {
    zeropoint = (-labeled_min)/(labeled_max - labeled_min);

    axis_lines[0].x = zeropoint * axis_direction->x;
    axis_lines[0].y = zeropoint * axis_direction->y;
    axis_lines[0].z = 0.0;

    if ( axis_direction->x == 1.0 )
    {
      axis_lines[1].x = zeropoint * axis_direction->x;
      axis_lines[1].y = 1.0;
      axis_lines[1].z = 0.0;
    }
    else if ( axis_direction->y == 1.0 )
    {
      axis_lines[1].x = 1.0;
      axis_lines[1].y = zeropoint * axis_direction->y;
      axis_lines[1].z = 0.0;
    }

    zero_line_color = axis_color;

    X2D_draw_segments(id, axis_lines, 2, zero_line_color);
  }

/*
 *  Draw the axis system specified by the axis mode.
 */
  if ( axis_mode == KGRAPHICS_LINEAR )
  {
    draw_tics_grid_labels_linear(axis);
  }
  else if ( axis_mode == KGRAPHICS_LOG10 )
  {
    draw_tics_grid_labels_log10(axis);
  }
}


/*-----------------------------------------------------------
|
|  Routine Name: draw_tics_grid_labels_linear - draw linear axis
|
|       Purpose: Draws the axis system in a linear axis mode.
|		 Will draw the major & minor tic marks, major
|		 & minor grid,  and tic axis labels.
|
|         Input: axis - axis object to be drawn
|
|        Output: none
|
|       Returns: nothing
|
|    Written By: John M. Salas
|          Date: Jul 04, 1992
| Modifications: Taken from splot.
|
------------------------------------------------------------*/

static void draw_tics_grid_labels_linear(
   XvwAxisGadget axis)
{
  int	  id = axis->axis.id;

  Coord   *begin_axis     = &axis->axis.begin_axis;
  Coord	  *end_axis       = &axis->axis.end_axis;
  Coord	  *axis_direction = &axis->axis.axis_direction;
  XColor  *axis_color     = &axis->axis.axis_color;

  double  labeled_interval = axis->axis.labeled_interval;
  double  number_steps     = axis->axis.number_steps;
  double  labeled_max      = axis->axis.labeled_max;
  double  labeled_min      = axis->axis.labeled_min;
  int     labeling_mode    = axis->axis.labeling_mode;

  Boolean show_tics   = axis->axis.show_tics;
  Boolean nice_labels = axis->axis.nice_labels;

  char	  *labels_format     = axis->axis.tic_labels_format;
  char	  *old_labels_format = axis->axis.old_tic_labels_format;
  int     number_minor_tics  = axis->axis.number_minor_tics;
  int	  tic_justification  = axis->axis.tic_justification;

  Boolean show_box        = axis->axis.show_box;
  Boolean show_major_grid = axis->axis.show_major_grid;
  Boolean show_minor_grid = axis->axis.show_minor_grid;
  Boolean show_tic_labels = axis->axis.show_tic_labels;

  int     major_grid_line_type  = axis->axis.major_grid_line_type;
  int     minor_grid_line_type  = axis->axis.minor_grid_line_type;
  int     major_grid_line_width = axis->axis.major_grid_line_width;
  int     minor_grid_line_width = axis->axis.minor_grid_line_width;

  XColor  *major_grid_color = &axis->axis.major_grid_color;
  XColor  *minor_grid_color = &axis->axis.minor_grid_color;

  Pixel   labels_pixel      = axis->axis.tic_labels_color.pixel;

  tic_label_list *next_label;
  Coord segment[4];
  Boolean adjusted_min, adjusted_max, error, toggle, toggled;
  int minor_tic, step, number_segments, i, j, show_major_tic;

  double justification_adjustment,
	 labeling_adjustment_min,
	 labeling_adjustment_max,
	 major_tic_height,
	 major_tic_location,
	 minor_tic_height,
	 major_tic_spacing,
	 minor_tic_spacing,
	 pos;

  double min_divide,
         max_divide,
         minimum,maximum,
         multiplier = 1.0;

  XColor *tic_color;

/*
 *  Setup drawing paramters.
 */
  major_tic_spacing = (1.0 / number_steps);

  if ( number_minor_tics != 0 )
  {
    minor_tic_spacing = major_tic_spacing/(number_minor_tics + 1);
  }

  tic_color = axis_color;

/*
 * If the labels are "nice" or the labeling mode is either KAXIS_SET_MAX_MIN or
 * KAXIS_SET_DEFAULT_MODE, the begin point and/or end point for drawing the
 * major tic marks must be adjusted.  Sets the adjustment for the minimum and
 * maximum for the major tic mark locations, labeling_adjustment_min and
 * labeling_adjustment_max respectively.  This value will shift the major
 * tic mark in so that the "nice" labels are drawn in the proper locations.
 */
  labeling_adjustment_min = 0.0;
  labeling_adjustment_max = 0.0;
  adjusted_min = FALSE;
  adjusted_max = FALSE;

  if (nice_labels || labeling_mode == KAXIS_SET_MAX_MIN ||
      labeling_mode == KAXIS_SET_DEFAULT_MODE)
  {
    min_divide = floor(labeled_min/labeled_interval);
    max_divide = ceil(labeled_max/labeled_interval);
    if(labeled_min != (labeled_interval * min_divide) ||
       labeled_max != (labeled_interval * max_divide) ||
       number_steps != floor(number_steps))
    {
      if (labeled_min != (labeled_interval * min_divide))
      {
        labeling_adjustment_min = (((labeled_interval * ++min_divide) -
                                  labeled_min)/labeled_interval) * major_tic_spacing;
        adjusted_min = TRUE;
      }
      if (labeled_max != (labeled_interval * max_divide))
      {
        labeling_adjustment_max = ((labeled_max - (labeled_interval *
                                  --max_divide))/labeled_interval)
                                  * major_tic_spacing;
        adjusted_max = TRUE;
      }
      number_steps = max_divide - min_divide;
    }
  }

/*
 *  Reset the labeling parameters according to the scale factor found.
 */
  labeled_max = multiplier * labeled_max;
  labeled_min = multiplier * labeled_min;
  labeled_interval = multiplier * labeled_interval;

/*
 *  Label the minimum point on the axis if the begin point for labeling is
 *  valid.  Then adjust the minimum and/or maximim if needed so that the
 *  correspond to the nicely label major tic marks.
 */
  next_label = axis->axis.list_head;

  if ( adjusted_min && show_tic_labels &&
       draw_begin_value(begin_axis, axis_direction, 0.0) )
  {
    draw_tic_label(axis, begin_axis, axis_direction,
		   begin_axis->x * axis_direction->x,
		   begin_axis->y * axis_direction->y,
		   labeled_min,   next_label, 
		   labels_format, old_labels_format, labels_pixel);
    if ( next_label != NULL )
      next_label = next_label->next;
  }

  if ( adjusted_min )
    minimum = labeled_interval * min_divide;
  else
    minimum = labeled_min;

  if ( adjusted_max && show_tic_labels &&
       draw_end_value(end_axis, axis_direction, 1.0) )
  {
    draw_tic_label(axis, begin_axis, axis_direction,
		   end_axis->x * axis_direction->x,
		   end_axis->y * axis_direction->y,
		   labeled_max,   next_label,
		   labels_format, old_labels_format, labels_pixel);
    if ( next_label != NULL )
      next_label = next_label->next;
  }

  if ( adjusted_max )
    maximum = minimum + labeled_interval * number_steps;
  else
    maximum = labeled_max;

/*
 *  Set up the location and size of the tic marks tic_justification
 *  parameter.
 */
  if ( tic_justification == KAXIS_CENTERED )
  {
    justification_adjustment = -0.025;
    major_tic_height = 0.025;
    minor_tic_height = 0.0125;
  }
  else if ( tic_justification == KAXIS_INSIDE )
  {
    justification_adjustment = 0.0;
    major_tic_height = 0.025;
    minor_tic_height = 0.0125;
  }
  else if ( tic_justification == KAXIS_OUTSIDE )
  {
    justification_adjustment = 0.0;
    major_tic_height = -0.025;
    minor_tic_height = -0.0125;
  }

/*
 *  Draw the minor tics and grid if the minimum was not a "nice"
 *  label.  This is done since the loop the major tics and grid
 *  starts at the first major tic mark that would be after these
 *  minor tics and grid and then draws all the minor tics and grid
 *  to the next major tic mark.  If the minimum was not a "nice"
 *  label these minor tics and grid will not be drawn so draw them
 *  first.  This loop actual starts drawing from the major tic mark
 *  back towards zero.
 */
  if ( labeling_adjustment_min != 0.0 && number_minor_tics != 0 )
  {
    for ( minor_tic = 1 ; minor_tic <= number_minor_tics &&
          (pos = (labeling_adjustment_min - minor_tic_spacing*minor_tic)) > 0.0;
          minor_tic++ )
    {

      if ( show_minor_grid )
      {
        X3D_set_line_type(id, minor_grid_line_type);
        X3D_set_line_width(id, minor_grid_line_width);

        segment[0].x = pos * axis_direction->x;
        segment[0].y = pos * axis_direction->y;
        segment[0].z = 0.0;

        if ( axis_direction->x == 1.0 )
        {
	  if ( segment[0].x < begin_axis->x || segment[0].x > end_axis->x )
	  {
	    continue;
          }
          segment[1].x = pos * axis_direction->x;
          segment[1].y = axis_direction->x;
        }
        else
        {
	  if ( segment[0].y < begin_axis->y || segment[0].y > end_axis->y )
	  {
	    continue;
          }
          segment[1].x = axis_direction->y;
          segment[1].y = pos * axis_direction->y;
        }
        segment[1].z = 0.0;

        X2D_draw_segments(id, segment, 2, minor_grid_color);
      }

      X3D_set_line_type(id, KLINE_SOLID);
      X3D_set_line_width(id, KLINE_FINE);

      if ( show_tics )
      {
	if ( axis_direction->x == 1.0 )
	{
	  segment[0].x = pos;
	if ( segment[0].x < begin_axis->x || segment[0].x > end_axis->x )
	{
	  continue;
	}
	  segment[0].y = begin_axis->y + justification_adjustment/2.0;

	  segment[1].x = pos;
	  segment[1].y = begin_axis->y + minor_tic_height;
	}
	else if ( axis_direction->y == 1.0 )
	{
	  segment[0].x = begin_axis->x + justification_adjustment/2.0;
	  segment[0].y = pos;
	if ( segment[0].y < begin_axis->y || segment[0].y > end_axis->y )
	{
	  continue;
	}

	  segment[1].x = begin_axis->x + minor_tic_height;
	  segment[1].y = pos;
	}
	segment[0].z = 0.0;
	segment[1].z = 0.0;

	X2D_draw_segments(id, segment, 2, tic_color);

	if ( show_minor_grid || show_major_grid || show_box )
	{
	  if ( axis_direction->x == 1.0 )
	  {
	  if ( begin_axis->y != 1.0 )
	  {
	      segment[0].x = pos;
	      segment[0].y = 1.0 - justification_adjustment/2.0;
  
	      segment[1].x = pos;
	      segment[1].y = 1.0 - minor_tic_height;
	    number_segments = 2;
	    i = 2;
	    j = 3;
	  }
	  else
	  {
	    number_segments = 0;
	    i = 0;
	    j = 1;
	  }

	  if ( begin_axis->y != 0.0 )
	  {
	      segment[i].x = pos;
	      segment[i].y = justification_adjustment/2.0;

	      segment[j].x = pos;
	      segment[j].y = minor_tic_height;
	    number_segments += 2;
	  }
	  }
	  else if ( axis_direction->y == 1.0 )
	  {
	  if ( begin_axis->x != 1.0 )
	  {
	      segment[0].x = 1.0 - justification_adjustment/2.0;
	      segment[0].y = pos;

	      segment[1].x = 1.0 - minor_tic_height;
	      segment[1].y = pos;
	    number_segments = 2;
	    i = 2;
	    j = 3;
	  }
	  else
	  {
	    number_segments = 0;
	    i = 0;
	    j = 1;
	  }

	  if ( begin_axis->x != 0.0 )
	  {
	      segment[i].x = justification_adjustment/2.0;
	      segment[i].y = pos;

	      segment[j].x = minor_tic_height;
	      segment[j].y = pos;
	    number_segments += 2;
	  }
	  }
	  segment[0].z = 0.0;
	  segment[1].z = 0.0;
	  segment[2].z = 0.0;
	  segment[3].z = 0.0;

	  X2D_draw_segments(id, segment, number_segments, tic_color);
	}
      }
    }
  }

/*
 * Draw the major tic marks, major grid, minor grid and/or minor tics marks.
 */

  toggle = FALSE;
  toggled = FALSE;
  for ( step = 0; step <= (int) number_steps ; step++ )
  {
    major_tic_location = labeling_adjustment_min + major_tic_spacing * step;

    major_tic_location = truncate_double(major_tic_location,6);

    show_major_tic = FALSE;
    if ( axis_direction->x == 1.0 )
    {
      if ( major_tic_location >= begin_axis->x &&
	   major_tic_location <= end_axis->x )
      {
	show_major_tic = TRUE;
      }
    }
    else if ( axis_direction->y == 1.0 )
    {
      if ( major_tic_location >= begin_axis->y &&
	   major_tic_location <= end_axis->y )
      {
	show_major_tic = TRUE;
      }
    }

/*
 *  Draw the tic labels.
 */
    if ( show_tic_labels && show_major_tic )
    {
/*
COMMENTED OUT
      if ( step == 0 && adjusted_min )
      {
        tolerance = labeling_adjustment_min;
      }
      else if ( ((labeled_interval * step) + minimum) == maximum &&
		adjusted_max)
      {
        tolerance = labeling_adjustment_max;
      }
      else if ( toggled)
      {
        tolerance = 2 * major_tic_spacing;
      }
      else
      {
        tolerance = major_tic_spacing;
      }

      if ( toggle )
      {
        toggle = FALSE;
        if(adjusted_min == FALSE) toggled = TRUE;
      }
      else if ( ( step == 0 && ! adjusted_min ) ||
		( step == (int) number_steps && ! adjusted_max ) )
      {
	;
      }
      else
*/
      {
        error = draw_tic_label(axis, begin_axis, axis_direction,
			     major_tic_location * axis_direction->x,
			     major_tic_location * axis_direction->y,
			     (labeled_interval * step) + minimum, next_label, 
			     labels_format, old_labels_format, labels_pixel);

	if ( next_label != NULL )
	  next_label = next_label->next;

        if ( (error || toggled) && adjusted_min == FALSE )
          toggle = TRUE;
      }
    }

/*
 *  Draw the major tic marks and grid.
 */
    if ( show_major_grid && show_major_tic )
    {
      X3D_set_line_type(id, major_grid_line_type);
      X3D_set_line_width(id, major_grid_line_width);

      segment[0].x = major_tic_location * axis_direction->x;
      segment[0].y = major_tic_location * axis_direction->y;
      segment[0].z = 0.0;

      if ( axis_direction->x == 1.0 )
      {
        segment[1].x = major_tic_location * axis_direction->x;
        segment[1].y = axis_direction->x;
      }
      else
      {
        segment[1].x = axis_direction->y;
        segment[1].y = major_tic_location * axis_direction->y;
      }
      segment[1].z = 0.0;

      X2D_draw_segments(id, segment, 2, major_grid_color);
    }

    if ( show_tics && show_major_tic )
    {
      X3D_set_line_type(id, KLINE_SOLID);
      X3D_set_line_width(id, KLINE_FINE);

      if ( axis_direction->x == 1.0 )
      {
        segment[0].x = major_tic_location;
        segment[0].y = begin_axis->y + justification_adjustment;

        segment[1].x = major_tic_location;
        segment[1].y = begin_axis->y + major_tic_height;
      }
      else if ( axis_direction->y == 1.0 )
      {
        segment[0].x = begin_axis->x + justification_adjustment;
        segment[0].y = major_tic_location;

        segment[1].x = begin_axis->x + major_tic_height;
        segment[1].y = major_tic_location;
      }
      segment[0].z = 0.0;
      segment[1].z = 0.0;

      X2D_draw_segments(id, segment, 2, tic_color);

      if ( show_box || show_major_grid || show_minor_grid )
      {
        if ( axis_direction->x == 1.0 )
        {
	  if ( begin_axis->y != 1.0 )
	  {
            segment[0].x = major_tic_location;
            segment[0].y = 1.0 - justification_adjustment;
  
            segment[1].x = major_tic_location;
            segment[1].y = 1.0 - major_tic_height;
	    number_segments = 2;
	    i = 2;
	    j = 3;
	  }
	  else
	  {
	    number_segments = 0;
	    i = 0;
	    j = 1;
	  }

	  if ( begin_axis->y != 0.0 )
	  {
            segment[i].x = major_tic_location;
            segment[i].y = justification_adjustment;
  
            segment[j].x = major_tic_location;
            segment[j].y = major_tic_height;
	    number_segments += 2;
	  }
        }
        else if ( axis_direction->y == 1.0 )
        {
	  if ( begin_axis->x != 1.0 )
	  {
            segment[0].x = 1.0 - justification_adjustment;
            segment[0].y = major_tic_location;

            segment[1].x = 1.0 - major_tic_height;
            segment[1].y = major_tic_location;
	    number_segments = 2;
	    i = 2;
	    j = 3;
	  }
	  else
	  {
	    number_segments = 0;
	    i = 0;
	    j = 1;
	  }

	  if ( begin_axis->x != 0.0 )
	  {
            segment[i].x = justification_adjustment;
            segment[i].y = major_tic_location;

            segment[j].x = major_tic_height;
            segment[j].y = major_tic_location;
	    number_segments += 2;
	  }
        }
        segment[0].z = 0.0;
        segment[1].z = 0.0;
        segment[2].z = 0.0;
        segment[3].z = 0.0;

        X2D_draw_segments(id, segment, number_segments, tic_color);
      }
    }

/*
 *  Draw the minor tic marks and grid.
 */
    if ( number_minor_tics != 0 )
    {
      for ( minor_tic = 1 ; minor_tic <= number_minor_tics &&
            (pos = (major_tic_location + minor_tic * minor_tic_spacing)) < 1.0 ;
	    minor_tic++ )
      {
        if ( show_minor_grid )
        {
          X3D_set_line_type(id, minor_grid_line_type);
          X3D_set_line_width(id, minor_grid_line_width);

          segment[0].x = pos * axis_direction->x;
          segment[0].y = pos * axis_direction->y;
          segment[0].z = 0.0;

          if ( axis_direction->x == 1.0 )
          {
	    if ( segment[0].x < begin_axis->x || segment[0].x > end_axis->x )
	    {
	      continue;
            }
            segment[1].x = pos * axis_direction->x;
            segment[1].y = axis_direction->x;
          }
          else
          {
	    if ( segment[0].y < begin_axis->y || segment[0].y > end_axis->y )
	    {
	      continue;
            }
            segment[1].x = axis_direction->y;
            segment[1].y = pos * axis_direction->y;
          }
          segment[1].z = 0.0;

          X2D_draw_segments(id, segment, 2, minor_grid_color);
        }

        X3D_set_line_type(id, KLINE_SOLID);
        X3D_set_line_width(id, KLINE_FINE);

        if ( show_tics )
        {
	  if ( axis_direction->x == 1.0 )
	  {
	    segment[0].x = (major_tic_location + minor_tic_spacing * minor_tic);
	    if ( segment[0].x < begin_axis->x || segment[0].x > end_axis->x )
	    {
	      continue;
	    }
	    segment[0].y = begin_axis->y + justification_adjustment/2.0;

	    segment[1].x = (major_tic_location + minor_tic_spacing * minor_tic);
	    segment[1].y = begin_axis->y + minor_tic_height;
	  }
	  else if ( axis_direction->y == 1.0 )
	  {
	    segment[0].x = begin_axis->x + justification_adjustment/2.0;
	    segment[0].y = (major_tic_location + minor_tic_spacing * minor_tic);
	    if ( segment[0].y < begin_axis->y || segment[0].y > end_axis->y )
	    {
	      continue;
	    }

	    segment[1].x = begin_axis->x + minor_tic_height;
	    segment[1].y = (major_tic_location + minor_tic_spacing * minor_tic);
	  }
	  segment[0].z = 0.0;
	  segment[1].z = 0.0;

	  X2D_draw_segments(id, segment, 2, tic_color);

	  if ( show_minor_grid || show_major_grid || show_box )
	  {
	    if ( axis_direction->x == 1.0 )
	    {
	      if ( begin_axis->y != 1.0 )
	      {
	        segment[0].x = major_tic_location +
			       minor_tic_spacing * minor_tic;
	        segment[0].y = 1.0 - justification_adjustment/2.0;

	        segment[1].x = major_tic_location +
			       minor_tic_spacing * minor_tic;
	        segment[1].y = 1.0 - minor_tic_height;
	        number_segments = 2;
	        i = 2;
	        j = 3;
	      }
	      else
	      {
	        number_segments = 0;
	        i = 0;
	        j = 1;
	      }

	      if ( begin_axis->y != 0.0 )
	      {
	        segment[i].x = major_tic_location +
			       minor_tic_spacing * minor_tic;
	        segment[i].y = justification_adjustment/2.0;

	        segment[j].x = major_tic_location +
			       minor_tic_spacing * minor_tic;
	        segment[j].y = minor_tic_height;
	        number_segments += 2;
	      }
	    }
	    else if ( axis_direction->y == 1.0 )
	    {
	      if ( begin_axis->x != 1.0 )
	      {
	        segment[0].x = 1.0 - justification_adjustment/2.0;
	        segment[0].y = major_tic_location +
			       minor_tic_spacing * minor_tic;

	        segment[1].x = 1.0 - minor_tic_height;
	        segment[1].y = major_tic_location +
			       minor_tic_spacing * minor_tic;
	        number_segments = 2;
	        i = 2;
	        j = 3;
	      }
	      else
	      {
	        number_segments = 0;
	        i = 0;
	        j = 1;
	      }

	      if ( begin_axis->x != 0.0 )
	      {
	        segment[i].x = justification_adjustment/2.0;
	        segment[i].y = major_tic_location +
			       minor_tic_spacing * minor_tic;

	        segment[j].x = minor_tic_height;
	        segment[j].y = major_tic_location +
			       minor_tic_spacing * minor_tic;
	        number_segments += 2;
	      }
	    }
	    segment[0].z = 0.0;
	    segment[1].z = 0.0;
	    segment[2].z = 0.0;
	    segment[3].z = 0.0;

	    X2D_draw_segments(id, segment, number_segments, tic_color);
	  }
        }
      }
    }
  }
}


/*-----------------------------------------------------------
|
|  Routine Name: draw_tics_grid_labels_log10 -
|
|       Purpose: This routine draws the axis tic marks and labels
|		 for a logarithmic plot on the specified axis.
|		 Labels are always chosen to be one-significant-digit
|		 multiples of powers of ten, regardless of
|		 user-specified limits.  Labels are selected to
|		 be as close to user-specified limits as possible.
|
|         Input: axis - axis object to be drawn
|
|        Output: none
|
|       Returns: nothing
|
|    Written By: John M. Salas and Mark Young
|          Date: Jul 20, 1992
| Modifications: Converted from splot originally written by Mike Conley
|
------------------------------------------------------------*/

static void draw_tics_grid_labels_log10(
   XvwAxisGadget axis)
{
  int     id = axis->axis.id;

  Coord   *begin_axis     = &axis->axis.begin_axis,
          *end_axis       = &axis->axis.end_axis,
          *axis_direction = &axis->axis.axis_direction;

  XColor  *axis_color = &axis->axis.axis_color;

  double  labeled_max  = axis->axis.labeled_max,
  	  number_steps = axis->axis.number_steps,
          labeled_min  = axis->axis.labeled_min;

  Boolean show_tics = axis->axis.show_tics;

  char    *labels_format     = axis->axis.tic_labels_format;
  char	  *old_labels_format = axis->axis.old_tic_labels_format;

  int     number_minor_tics = axis->axis.number_minor_tics;
  int     tic_justification = axis->axis.tic_justification;

  Boolean show_box        = axis->axis.show_box;
  Boolean show_major_grid = axis->axis.show_major_grid;
  Boolean show_minor_grid = axis->axis.show_minor_grid;

  int     major_grid_line_type  = axis->axis.major_grid_line_type;
  int     minor_grid_line_type  = axis->axis.minor_grid_line_type;
  int     major_grid_line_width = axis->axis.major_grid_line_width;
  int     minor_grid_line_width = axis->axis.minor_grid_line_width;

  XColor  *major_grid_color = &axis->axis.major_grid_color;
  XColor  *minor_grid_color = &axis->axis.minor_grid_color;

  Boolean show_tic_labels = axis->axis.show_tic_labels;
  Pixel   labels_pixel    = axis->axis.tic_labels_color.pixel;

  XColor  *tic_color;

  Coord segment[4];

  tic_label_list *next_label;

  Boolean show_major_tic;
  int     i, j, minor_tic, start, number_segments;

  double minimum, maximum, scale_factor = 1.0;
  double justification_adjustment,
	 major_tic_spacing,
	 minor_tic_spacing,
	 major_tic_height,
	 minor_tic_height,
	 minor_tic_distance[10],
	 pos,
	 value;


  /*
     Calculates the major_tic_spacing between major tic marks.
  */
  major_tic_spacing = 1.0 / number_steps;

  minimum = labeled_min;
  maximum = labeled_max;

  tic_color = axis_color;

  /*
COMMENTED OUT

     Determine whether a scale factor is required to reduce the size
     of the values to be plotted to a reasonable dimension, and, if so,
     compute it.

  scale_factor = 1.0;
  mindigits = numdigs(fracround(minimum));
  if ((minimum < 1.0 && mindigits + 2 > characters_displayed) ||
      mindigits > characters_displayed)
  {
    if (minimum < 1.0) power = mindigits;
    else
      power = -(mindigits - 2);
    scale_factor = fracround(pow(10.0, power));
  }
  maxdigits = numdigs(fracround(maximum));
  if (maxdigits > mindigits && 
      ((maximum < 1.0 && maxdigits + 2 > characters_displayed) ||
       maxdigits > characters_displayed))
  {
    if (maximum < 1.0) power = maxdigits;
    else
      power = -(maxdigits - 2);
    scale_factor = fracround(pow(10.0, power));
  }
  
  parse_scale_factor(plot_area + 1, axis, (scale_factor != 1.0), 
		     -((int) power));
  */
  next_label = axis->axis.list_head;
/*
 *  Draw leftmost and rightmost labels.
 */

  if ( show_tic_labels &&
       draw_begin_value(begin_axis, axis_direction, 0.0) && 
       first_digit(minimum) != 1 )
  {
    draw_tic_label(axis, begin_axis, axis_direction,
		   begin_axis->x * axis_direction->x,
		   begin_axis->y * axis_direction->y,
		   fracround(minimum * scale_factor), next_label,
		   labels_format, old_labels_format, labels_pixel);
    if ( next_label != NULL )
      next_label = next_label->next;
  }

  if ( show_tic_labels &&
       draw_end_value(end_axis, axis_direction, 1.0) &&
       first_digit(maximum) != 1 )
  {
    draw_tic_label(axis, begin_axis, axis_direction,
                   end_axis->x * axis_direction->x,
                   end_axis->y * axis_direction->y,
                   fracround(maximum * scale_factor), next_label,
                   labels_format, old_labels_format, labels_pixel);
    if ( next_label != NULL )
      next_label = next_label->next;
  }

  if ( tic_justification == KAXIS_CENTERED )
  {
    justification_adjustment = -0.025;
    major_tic_height = 0.025;
    minor_tic_height = 0.0125;
  }
  else if ( tic_justification == KAXIS_INSIDE )
  {
    justification_adjustment = 0.0;
    major_tic_height = 0.025;
    minor_tic_height = 0.0125;
  }
  else if ( tic_justification == KAXIS_OUTSIDE )
  {
    justification_adjustment = 0.0;
    major_tic_height = -0.025;
    minor_tic_height = -0.0125;
  }

/*
 *  Draws major tic marks and grid for plot area.
 *
 *  Locate position of next power of ten.
 */
  if (first_digit(minimum) == 1)
    pos = 0.0;
  else
    pos = (1.0 - log10((double) first_digit(minimum))) * major_tic_spacing;
/*
 *  Compute first power of ten to use as label.
 */
  value = fracround(pow(10.0, ceil(log10(minimum))));
  while (pos <= 1.0)
  {
/*
 *  If the current position is within a cycle of the left side of the
 *  axis, the tolerance for drawing the label is as wide as the 
 *  distance from the left side to the current position.
 */
    show_major_tic = FALSE;
    if ( axis_direction->x == 1.0 )
    {
      if ( pos >= begin_axis->x &&
	   pos <= end_axis->x )
      {
	show_major_tic = TRUE;
      }
    }
    else if ( axis_direction->y == 1.0 )
    {
      if ( pos >= begin_axis->y &&
	   pos <= end_axis->y )
      {
	show_major_tic = TRUE;
      }
    }

    if ( show_tic_labels && show_major_tic )
    {
      draw_tic_label(axis, begin_axis, axis_direction,
		     pos * axis_direction->x,
		     pos * axis_direction->y,
		     value * scale_factor, next_label,
		     labels_format, old_labels_format, labels_pixel);
      if ( next_label != NULL )
        next_label = next_label->next;
    }

    value *= 10.0; /* Next power of ten. */
/*
 *  Return to tic position to draw tic mark or grid line as 
 *  necessary.
 */
    if ( show_major_grid && show_major_tic )
    {
      X3D_set_line_type(id, major_grid_line_type);
      X3D_set_line_width(id, major_grid_line_width);

      segment[0].x = pos * axis_direction->x;
      segment[0].y = pos * axis_direction->y;
      segment[0].z = 0.0;

      if ( axis_direction->x == 1.0 )
      {
        segment[1].x = pos * axis_direction->x;
        segment[1].y = axis_direction->x;
      }
      else
      {
        segment[1].x = axis_direction->y;
        segment[1].y = pos * axis_direction->y;
      }
      segment[1].z = 0.0;

      X2D_draw_segments(id, segment, 2, major_grid_color);
    }

    if ( show_tics && show_major_tic )
    {
      X3D_set_line_type(id, KLINE_SOLID);
      X3D_set_line_width(id, KLINE_FINE);

      if ( axis_direction->x == 1.0 )
      {
        segment[0].x = pos;
        segment[0].y = begin_axis->y + justification_adjustment;

        segment[1].x = pos;
        segment[1].y = begin_axis->y + major_tic_height;
      }
      else if ( axis_direction->y == 1.0 )
      {
        segment[0].x = begin_axis->x + justification_adjustment;
        segment[0].y = pos;

        segment[1].x = begin_axis->x + major_tic_height;
        segment[1].y = pos;
      }
      segment[0].z = 0.0;
      segment[1].z = 0.0;

      X2D_draw_segments(id, segment, 2, tic_color);

      if ( show_box || show_major_grid || show_minor_grid )
      {
        if ( axis_direction->x == 1.0 )
        {
          if ( begin_axis->y != 1.0 )
          {
            segment[0].x = pos;
            segment[0].y = 1.0 - justification_adjustment;

            segment[1].x = pos;
            segment[1].y = 1.0 - major_tic_height;
            number_segments = 2;
            i = 2;
            j = 3;
          }
          else
          {
            number_segments = 0;
            i = 0;
            j = 1;
          }

          if ( begin_axis->y != 0.0 )
          {
            segment[i].x = pos;
            segment[i].y = justification_adjustment;

            segment[j].x = pos;
            segment[j].y = major_tic_height;
            number_segments += 2;
          }
        }
        else if ( axis_direction->y == 1.0 )
        {
          if ( begin_axis->x != 1.0 )
          {
            segment[0].x = 1.0 - justification_adjustment;
            segment[0].y = pos;

            segment[1].x = 1.0 - major_tic_height;
            segment[1].y = pos;
            number_segments = 2;
            i = 2;
            j = 3;
          }
          else
          {
            number_segments = 0;
            i = 0;
            j = 1;
          }

          if ( begin_axis->x != 0.0 )
          {
            segment[i].x = justification_adjustment;
            segment[i].y = pos;

            segment[j].x = major_tic_height;
            segment[j].y = pos;
            number_segments += 2;
          }
        }
        segment[0].z = 0.0;
        segment[1].z = 0.0;
        segment[2].z = 0.0;
        segment[3].z = 0.0;

        X2D_draw_segments(id, segment, number_segments, tic_color);
      }
    }
    pos += major_tic_spacing;
  }
/*
 *  Draw minor tic marks for plot area.
 */
  if ( number_minor_tics != 0 )
  {
/*
 *  Compute minor tic distances.
 */
    for(i = 1; i < 10; i++)
      minor_tic_distance[i] = log10((double) i) * major_tic_spacing;

    minor_tic_distance[0] = major_tic_spacing;

/*
 *  Routine calculates the number of and major_tic_spacing between minor 
 *  tic marks on the axis, and draws the tics or grid lines.
 */
    start = first_digit(minimum);
    pos = minor_tic_distance[start];
    while (pos <= 1.0)
    {
      minor_tic = start;
      minor_tic_spacing = pos;
      do
      {
	if ((minor_tic % 10) != 1 && minor_tic <= (number_minor_tics + 1))
	{
	  if ( show_minor_grid )
	  {
	    X3D_set_line_type(id, minor_grid_line_type);
	    X3D_set_line_width(id, minor_grid_line_width);

	    segment[0].x = minor_tic_spacing * axis_direction->x;
	    segment[0].y = minor_tic_spacing * axis_direction->y;
	    segment[0].z = 0.0;

	    if ( axis_direction->x == 1.0 )
	    {
              if ( segment[0].x < begin_axis->x || segment[0].x > end_axis->x )
              {
	        minor_tic_spacing = pos + minor_tic_distance[++minor_tic % 10];
                continue;
              }
	      segment[1].x = minor_tic_spacing * axis_direction->x;
	      segment[1].y = axis_direction->x;
	    }
	    else
	    {
              if ( segment[0].y < begin_axis->y || segment[0].y > end_axis->y )
              {
	        minor_tic_spacing = pos + minor_tic_distance[++minor_tic % 10];
                continue;
              }
	      segment[1].x = axis_direction->y;
	      segment[1].y = minor_tic_spacing * axis_direction->y;
	    }
	    segment[1].z = 0.0;

	    X2D_draw_segments(id, segment, 2, minor_grid_color);
	  }

          X3D_set_line_type(id, KLINE_SOLID);
          X3D_set_line_width(id, KLINE_FINE);

          if ( axis_direction->x == 1.0 )
          {
            segment[0].x = minor_tic_spacing;
            if ( segment[0].x < begin_axis->x || segment[0].x > end_axis->x )
            {
	      minor_tic_spacing = pos + minor_tic_distance[++minor_tic % 10];
              continue;
            }
            segment[0].y = begin_axis->y + justification_adjustment/2.0;

            segment[1].x = minor_tic_spacing;
            segment[1].y = begin_axis->y + minor_tic_height;
          }
          else if ( axis_direction->y == 1.0 )
          {
            segment[0].x = begin_axis->x + justification_adjustment/2.0;
            segment[0].y = minor_tic_spacing;
            if ( segment[0].y < begin_axis->y || segment[0].y > end_axis->y )
            {
	      minor_tic_spacing = pos + minor_tic_distance[++minor_tic % 10];
              continue;
            }

            segment[1].x = begin_axis->x + minor_tic_height;
            segment[1].y = minor_tic_spacing;
          }
          segment[0].z = 0.0;
          segment[1].z = 0.0;

          X2D_draw_segments(id, segment, 2, tic_color);

        if ( show_major_grid || show_minor_grid || show_box )
        {
          if ( axis_direction->x == 1.0 )
          {
            if ( begin_axis->y != 1.0 )
            {
              segment[0].x = minor_tic_spacing;
              segment[0].y = 1.0 - justification_adjustment/2.0;

              segment[1].x = minor_tic_spacing;
              segment[1].y = 1.0 - minor_tic_height;
              number_segments = 2;
              i = 2;
              j = 3;
            }
            else
            {
              number_segments = 0;
              i = 0;
              j = 1;
            }

            if ( begin_axis->y != 0.0 )
            {
              segment[i].x = minor_tic_spacing;
              segment[i].y = justification_adjustment/2.0;

              segment[j].x = minor_tic_spacing;
              segment[j].y = minor_tic_height;
              number_segments += 2;
            }
          }
          else if ( axis_direction->y == 1.0 )
          {
            if ( begin_axis->x != 1.0 )
            {
              segment[0].x = 1.0 - justification_adjustment/2.0;
              segment[0].y = minor_tic_spacing;

              segment[1].x = 1.0 - minor_tic_height;
              segment[1].y = minor_tic_spacing;
              number_segments = 2;
              i = 2;
              j = 3;
            }
            else
            {
              number_segments = 0;
              i = 0;
              j = 1;
            }

            if ( begin_axis->x != 0.0 )
            {
              segment[i].x = justification_adjustment/2.0;
              segment[i].y = minor_tic_spacing;

              segment[j].x = minor_tic_height;
              segment[j].y = minor_tic_spacing;
              number_segments += 2;
            }
          }
          segment[0].z = 0.0;
          segment[1].z = 0.0;
          segment[2].z = 0.0;
          segment[3].z = 0.0;

          X2D_draw_segments(id, segment, number_segments, tic_color);
        }
	}
	minor_tic_spacing = pos + minor_tic_distance[++minor_tic % 10];

	}
	while (minor_tic < 10 && minor_tic_spacing < 1.0);
/*
 *  When a cycle has been completed, start the next cycle at the
 *  next cycle division.
 */
	start = 1;
	pos += major_tic_spacing;
      }
  }
}


/*-----------------------------------------------------------
|
|  Routine Name: set_labeling_parameters - set the labels according
|					   to the label mode
|
|       Purpose: Sets the labeling parameters (labeled_interval,
|		 number_steps,labeled_min, labeled_max) according
|		 to the labeling mode.  It will change the
|		 minimum and maximum if symmetry is set and the
|		 axis mode is KGRAPHICS_LINEAR on the axis, i.e. it will
|		 make minimum = -maximum and use labeling mode
|		 KAXIS_SET_MAX_MIN.
|
|         Input: axis - axis object to be drawn
|
|        Output: changes the following elements in the axis
|		 object data structure:
|		 actual_min -
|		 actual_max -
|		 number_steps -
|		 labeled_interval -
|		 labeled_min -
|		 labeled_max -
|
|       Returns: nothing
|
|    Written By: Mark Young and John M. Salas
|          Date: Jul 04, 1992
| Modifications: Take form splot
|
------------------------------------------------------------*/

static void set_labeling_parameters(
   XvwAxisGadget axis)
{
  static Boolean symmetry = FALSE;
  static Boolean was_symmetric_max = FALSE;
  static Boolean was_symmetric_min = FALSE;

  int		labeling_mode	  = axis->axis.labeling_mode;
  int		axis_mode	  = axis->axis.axis_mode;
  Boolean	nice_labels	  = axis->axis.nice_labels;
  Boolean	minimum_same	  = axis->axis.minimum_same,
		maximum_same	  = axis->axis.maximum_same;
  double	*actual_min	  = &axis->axis.actual_min,
		*actual_max	  = &axis->axis.actual_max;
  double	*labeled_interval = &axis->axis.labeled_interval,
		*number_steps	  = &axis->axis.number_steps,
		*labeled_min	  = &axis->axis.labeled_min,
		*labeled_max	  = &axis->axis.labeled_max;

/*
 * If the axis mode is linear, then check to see if the maximum and/or
 * minimum labels are not the same and were not the same last time
 * adjust the labeled maximum and/or minimum to reflect the change in
 * the actual maximum and/or minimum.
 * NOTE: If the actual values have not changed the calculation will not
 *       change anything.
 */
  switch(labeling_mode)
  {
    case KAXIS_SET_MAX_MIN:
    case KAXIS_SET_DEFAULT_MODE:
      if ( ! maximum_same && ! axis->axis.maximum_same )
      {
	double actual_diff, labeled_diff;

	actual_diff = axis->axis.actual_max -  axis->axis.actual_min;
	labeled_diff = axis->axis.labeled_max -  axis->axis.labeled_min;
	*labeled_max -= labeled_diff/actual_diff *
			(axis->axis.actual_max - *actual_max);
      }

      if ( ! minimum_same && ! axis->axis.minimum_same )
      {
	double actual_diff, labeled_diff;

	actual_diff = axis->axis.actual_max -  axis->axis.actual_min;
	labeled_diff = axis->axis.labeled_max -  axis->axis.labeled_min;
	*labeled_min -= labeled_diff/actual_diff *
			(axis->axis.actual_min - *actual_min);
      }
      break;
  }

/*
 *  If symmetry was requested over write the minimum or maximum
 *  to meet this specification.
 */
  if(((axis->graphics.symmetric_x && axis->axis.axis_direction.x == 1.0) ||
      (axis->graphics.symmetric_y && axis->axis.axis_direction.y == 1.0) ||
      (axis->graphics.symmetric_z && axis->axis.axis_direction.z == 1.0)) &&
      axis_mode == KGRAPHICS_LINEAR )
  {
    if(kabs(*labeled_min) > *labeled_max)
    {
      *labeled_max = kabs(*labeled_min);
    }
    else
    {
      *labeled_min = -(*labeled_max);
    }
    max_min_linear(labeled_interval, number_steps, *labeled_min, *labeled_max);

    symmetry = TRUE;
/*
 * There is no need to adjust the actual maximum or minumum since symmetry is
 * set by adjusting the world coordinates in the graphics object class which
 * are the actual maximum and minumum.
 */
  }
  else
  {
    if ( symmetry )
    {
      symmetry = FALSE;
      was_symmetric_max = TRUE;
      was_symmetric_min = TRUE;
    }

/*
 * Set the labeling parameters according to the labeling and axis modes.
 */
  switch(labeling_mode)
  {
    case KAXIS_SET_LABELED_INTERVAL:
/*
 * Step-size defined by user.
 */
      switch(axis_mode)
      {
	case KGRAPHICS_LINEAR :
	  step_size_linear(*labeled_interval, number_steps,
			   labeled_min, labeled_max, nice_labels);
	  break;
	case KGRAPHICS_LOG10 :
	  step_size_log(*labeled_interval, number_steps,
			labeled_min, labeled_max);
	  break;
      }
      break;

    case KAXIS_SET_NUMBER_STEPS:
/*
 * Number of steps defined by user.
 */
      switch(axis_mode)
      {
	case KGRAPHICS_LINEAR :
	  number_steps_linear(labeled_interval, *number_steps,
			      labeled_min, labeled_max, nice_labels);
	  break;
	case KGRAPHICS_LOG10 :
/*
 * For now, this is the same as case KAXIS_SET_INTERVAL_STEPS, since step-size 
 * (i.e. log base) is currently fixed at 10 for log plots.
 */
	  number_steps_log(labeled_interval, *number_steps,
			   labeled_min, labeled_max);
	  break;
      }
      break;

    case KAXIS_SET_INTERVAL_STEPS:
/*
 * Both step-size and number of steps defined by user.
 */
      switch(axis_mode)
      {   
	case KGRAPHICS_LINEAR :

	  size_number_linear(*labeled_interval, *number_steps,
			     labeled_min, labeled_max);
	  break;
	case KGRAPHICS_LOG10 :
	  number_steps_log(labeled_interval , *number_steps,
			   labeled_min, labeled_max);
	  break;
      }   
      break;

    case KAXIS_SET_MAX_MIN: 
/*
 * Minimum and maximum defined by user.
 */
      switch(axis_mode)
      {   
	case KGRAPHICS_LINEAR :
	  max_min_linear(labeled_interval, number_steps,
			 *labeled_min, *labeled_max);
	  break;
	case KGRAPHICS_LOG10 :
	  max_min_log(labeled_interval, number_steps,
		      labeled_min, labeled_max);
	  break;
      }
      break;

    case KAXIS_SET_DEFAULT_MODE: 
/*
 * Nothing defined by user (default case).
 */
      switch(axis_mode)
      {   
	case KGRAPHICS_LINEAR :
	  nothing_linear(labeled_interval, number_steps,
			 labeled_min, labeled_max);
	  break;
	case KGRAPHICS_LOG10 :
	  nothing_log(labeled_interval, number_steps,
		      labeled_min, labeled_max);
	  break;
      }
      break;
  }

/*
 * If the axis mode is linear and nice labels are requested adjust the
 * the actual maximum and/or minimum if the labeling mode is either
 * KAXIS_SET_LABELED_INTERVAL or KAXIS_SET_NUMBER_STEPS.  This will adjust the
 * actual values to correspond to the new labeled values calculated
 * above.
 * NOTE: nice_labels has to be set since if not set the labeled maximum
 *	 and minimum will not change so why adjust the actual.
 */
      if ( ! maximum_same &&
	   ( labeling_mode == KAXIS_SET_LABELED_INTERVAL ||
	     labeling_mode == KAXIS_SET_NUMBER_STEPS ||
	     labeling_mode == KAXIS_SET_DEFAULT_MODE ||
	     was_symmetric_max ) )
      {
	double actual_diff, labeled_diff;

	actual_diff = axis->axis.actual_max -  axis->axis.actual_min;
	labeled_diff = axis->axis.labeled_max -  axis->axis.labeled_min;
	*actual_max -= actual_diff/labeled_diff *
		       (axis->axis.labeled_max - *labeled_max);
	was_symmetric_max = FALSE;
      }

      if ( ! minimum_same && 
	   ( labeling_mode == KAXIS_SET_LABELED_INTERVAL ||
	     labeling_mode == KAXIS_SET_NUMBER_STEPS ||
	     labeling_mode == KAXIS_SET_DEFAULT_MODE ||
	     was_symmetric_max ) )
      {
	double actual_diff, labeled_diff;

	actual_diff = axis->axis.actual_max -  axis->axis.actual_min;
	labeled_diff = axis->axis.labeled_max -  axis->axis.labeled_min;
	*actual_min -= actual_diff/labeled_diff *
		       (axis->axis.labeled_min - *labeled_min);
	was_symmetric_min = FALSE;
      }
  }

/*
 * If the actual maximum and/or minimum are the as the labeled maximum
 * and/or minimum set the actual to the labeled.
 */
  if(maximum_same)
  {
    *actual_max = *labeled_max;
  }

  if(minimum_same)
  {
    *actual_min = *labeled_min;
  }
  return;
}


/*-----------------------------------------------------------
|
|  Routine Name: set_label_mode - check for errors for the label mode
|				  specified
|
|       Purpose: To check to make sure that tha label and axis mode's
|		 do not conflict.  Also, checks to see if the labeling
|		 parameters are valid.
|
|         Input: axis_mode	  - KGRAPHICS_LINEAR or KAXIS_LOG
|		 labeling_mode	  - the mode that dicates which labeling
|				    parameter(s) of the 4 below has
|				    priority on how to label the axis.
|                number_steps	  - number of steps to use
|                labeled_interval - the interval of each step
|                labeled_max	  - the labeled maximum
|                labeled_min	  - the labeled minimum
|
|        Output: all the passed in parameters can be modified
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young and John M. Salas
|          Date: Jul 04, 1992
| Modifications: Taken from splot
|
------------------------------------------------------------*/

static Boolean set_label_mode(
   int    *labeling_mode,
   int    *axis_mode,
   double *number_steps,
   double *labeled_interval,
   double *labeled_max,
   double *labeled_min)
{
  double temp_double;

  switch (*labeling_mode)
  {
    case KAXIS_SET_LABELED_INTERVAL:

      if ( *axis_mode != KGRAPHICS_LINEAR )
      {
	*labeling_mode = KAXIS_SET_MAX_MIN;
        kinfo(KFORCE, "Axis Object: Can not set labeled interval unless axis\
 mode is KGRAPHICS_LINEAR\n");
	return(FALSE);
      }

      if ( *labeled_interval <= 0.0 )
      {
	*labeled_interval = ( *labeled_max - *labeled_min ) / *number_steps;
      }

      if ( *labeled_interval <= 0.0 )
      {
	*labeled_interval = ( *labeled_max - *labeled_min ) / *number_steps;
      }

      break;

    case KAXIS_SET_NUMBER_STEPS:

      if ( *number_steps <= 0.0 )
      {
	*number_steps = 5.0;
      }

      break;

    case KAXIS_SET_INTERVAL_STEPS:
      if ( *axis_mode != KGRAPHICS_LINEAR )
      {
	*labeling_mode = KAXIS_SET_MAX_MIN;
	kinfo(KFORCE, "Axis Object: Can not set labeled interval unless axis\
 mode is KGRAPHICS_LINEAR\n");
	return(FALSE);
      }

      if ( *number_steps <= 0.0 )
      {
	*number_steps = 5.0;
      }

      if ( *labeled_interval <= 0.0 )
      {
	*labeled_interval = ( *labeled_max - *labeled_min ) / *number_steps;
      }

      break;

    case KAXIS_SET_MAX_MIN:
      if ( (*labeled_max - *labeled_min) <= 0.0 )
      {
	temp_double = *labeled_min;
	*labeled_min = *labeled_max;
	*labeled_max = temp_double;
      }

      if( *axis_mode != KGRAPHICS_LINEAR && *labeled_min <= 0.0 )
      {
	*axis_mode = KGRAPHICS_LINEAR;
#if 0
/* done in graphics class */
	kinfo(KFORCE, "Axis Object: labeled_min <= 0.0 and non-linear axis mode\
 set.");
#endif
	return(FALSE);
      }

      *number_steps = 5.0;

      break;

    case KAXIS_SET_DEFAULT_MODE:

      if ( (*labeled_max - *labeled_min) <= 0.0 )
      {
	temp_double = *labeled_min;
	*labeled_min = *labeled_max;
	*labeled_max = temp_double;
      }

      if( *axis_mode != KGRAPHICS_LINEAR && *labeled_min <= 0.0 )
      {
	*axis_mode = KGRAPHICS_LINEAR;
#if 0
/* done in graphics class */
	kinfo(KFORCE, "Axis Object: labeled_min <= 0.0 and non-linear axis mode\
 set.");
#endif
	return(FALSE);
      }

      *number_steps = 5.0;

      break;

    default:

      return(FALSE);

  }
  return(TRUE);
}


/*-----------------------------------------------------------
|
|  Routine Name: update_axis_label - update the axis label
|
|       Purpose: Using the direction it determines whether it is
|		 a x or y axis then places the label accordingly.
|		 If the label has not been initialized set the
|		 default value for the string.  Pass the string
|		 to the string widget for display.
|
|         Input: axis_direction - the direction of the specified access
|				  is the be drawn
|                axis_label	- the string widget
|                initialized	- has the axis label been initialized
|		 viewmin		- 
|		 viewmax		- 
|
|        Output: none
|
|       Returns: nothing
|
|    Written By: John M. Salas
|          Date: Jul 04, 1992
| Modifications:
|
------------------------------------------------------------*/

static void update_axis_label(
   XvwAxisGadget xobj)
{
  xvobject axis = xvw_object((Widget) xobj);


  if (xobj->axis.axis_direction.x == 1.0)
  {
      xvw_set_attributes(xobj->axis.axis_label,
	XVW_MAPPED,      xobj->axis.show_axis_label,
	XVW_LEFT_OF,     axis,
	XVW_RIGHT_OF,    axis,
	XVW_BELOW,       axis,
	XVW_ABOVE,       KMANAGER_UNDEFINED,
	XVW_VERT_DIST,   20,
	XVW_HORIZ_DIST,  0,
	XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_CENTER,
	NULL);
  }
  else if (xobj->axis.axis_direction.y == 1.0)
  {
      xvw_set_attributes(xobj->axis.axis_label,
	XVW_LEFT_OF,     axis,
	XVW_ABOVE,       axis,
	XVW_RIGHT_OF,    KMANAGER_UNDEFINED,
	XVW_BELOW,       axis,
	XVW_VERT_DIST,   0,
	XVW_HORIZ_DIST,  20,
	XVW_MAPPED,      xobj->axis.show_axis_label,
	XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_RIGHT,
	NULL);
  }
}


/*-----------------------------------------------------------
|
|  Routine Name: determine_corner - figure out the corner that belongs
|				    to the input value
|
|       Purpose: 
|
|         Input: input_value	- (x,y,z) location
|		 axis_direction - the direction of the specified access
|				  is the be drawn
|                begin		- whether it is a begin corner or not
|
|        Output: none
|
|	Returns: corner of the input value
|
|    Written By: John M. Salas
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

int determine_corner(
   Coord   *input_value,
   Coord   *axis_direction,
   Boolean begin)
{
  Coord	corner;

  corner.x = (Real) floor((double) input_value->x);
  corner.y = (Real) floor((double) input_value->y);
  corner.z = (Real) floor((double) input_value->z);

  if ( ! begin )
  {
    if ( axis_direction->x == 1.0 )
    {
      corner.x = (Real) ceil((double) input_value->x);
    }
    else if ( axis_direction->y == 1.0 )
    {
      corner.y = (Real) ceil((double) input_value->y);
    }
    else if ( axis_direction->z == 1.0 )
    {
      corner.z = (Real) ceil((double) input_value->z);
    }
  }

  if ( corner.x == 0.0 && corner.y == 0.0 && corner.z == 0.0 )
  {
    return(ORIGIN);
  }

  if ( corner.x == 1.0 && corner.y == 0.0 && corner.z == 0.0 )
  {
    return(XCORNER);
  }

  if ( corner.x == 0.0 && corner.y == 1.0 && corner.z == 0.0 )
  {
    return(YCORNER);
  }

  if ( corner.x == 1.0 && corner.y == 1.0 && corner.z == 0.0 )
  {
    return(XYCORNER);
  }

  if ( corner.x == 0.0 && corner.y == 0.0 && corner.z == 1.0 )
  {
    return(ZCORNER);
  }

  if ( corner.x == 1.0 && corner.y == 0.0 && corner.z == 1.0 )
  {
    return(XZCORNER);
  }

  if ( corner.x == 0.0 && corner.y == 1.0 && corner.z == 1.0 )
  {
    return(YZCORNER);
  }

  if ( corner.x == 1.0 && corner.y == 1.0 && corner.z == 1.0 )
  {
    return(XYZCORNER);
  }

  return(NOT_A_CORNER);
}


/*-----------------------------------------------------------
|
|  Routine Name: valid_axis - check to see if the axis specified is valid
|
|       Purpose: 
|
|         Input: begin_axis	- the begin point of the specified access
|                end_axis	- the end point of the specified access
|                axis_direction - the direction of the specified access
|				  is the be drawn
|
|        Output: None
|
|	Returns: TRUE (1) if axis is valid, FALSE (0) otherwise
|
|    Written By: John M. Salas
|          Date: Jul 04, 1992
| Modifications:
|
------------------------------------------------------------*/

static int valid_axis(
   Coord *begin_axis,
   Coord *end_axis,
   Coord *axis_direction)
{
  int begin_corner, end_corner;

  if ( axis_direction->x == 1.0 )
  {
    if ( begin_axis->y != end_axis->y || begin_axis->z != end_axis->z )
    {
      return(FALSE);
    }
  }
  else if ( axis_direction->y == 1.0 )
  {
    if ( begin_axis->x != end_axis->x || begin_axis->z != end_axis->z )
    {
      return(FALSE);
    }
  }
  else if ( axis_direction->z == 1.0 )
  {
    if ( begin_axis->x != end_axis->x || begin_axis->y != end_axis->y )
    {
      return(FALSE);
    }
  }

  begin_corner = determine_corner(begin_axis, axis_direction,
                                  TRUE);
  end_corner = determine_corner(end_axis, axis_direction,
                                FALSE);

  return(begin_corner & end_corner);
}


/*-----------------------------------------------------------
|
|  Routine Name: draw_begin_value - check to see if the minimum axis
|				    label should be drawn
|
|       Purpose:
|
|         Input: begin_axis	- the begin point of the specified access
|		 axis_direction	- the direction of the specified access
|				  is the be drawn
|                value		- the value at which the maximum axis label
|
|        Output: None
|
|	Returns: TRUE (1) if redraw is required, FALSE (0) otherwise
|
|    Written By: John M. Salas
|          Date: Jul 04, 1992
| Modifications:
|
------------------------------------------------------------*/

static Boolean draw_begin_value(
   Coord  *begin_axis,
   Coord  *axis_direction,
   double value)
{
  if ( ( axis_direction->x == 1.0 && value >= begin_axis->x ) ||
       ( axis_direction->y == 1.0 && value >= begin_axis->y ) ||
       ( axis_direction->z == 1.0 && value >= begin_axis->z ) )
  {
    return(TRUE);
  }

  return(FALSE);
}


/*-----------------------------------------------------------
|
|  Routine Name: draw_end_value - check to see if the maximum axis
|				  label should be drawn
|
|       Purpose:
|
|         Input: end_axis	- the end point of the specified access
|                axis_direction - the direction of the specified access
|				  is the be drawn
|                value		- the value at which the maximum axis label
|
|        Output: None
|
|	Returns: TRUE (1) if redraw is required, FALSE (0) otherwise
|
|    Written By: John M. Salas
|          Date: Jul 04, 1992
| Modifications:
|
------------------------------------------------------------*/

static Boolean draw_end_value(
   Coord  *end_axis,
   Coord  *axis_direction,
   double value)
{
  if ( ( axis_direction->x == 1.0 && end_axis->x >= value ) || 
       ( axis_direction->y == 1.0 && end_axis->y >= value ) || 
       ( axis_direction->z == 1.0 && end_axis->z >= value ) )
  {
    return(TRUE);
  }

  return(FALSE);
}


/*-----------------------------------------------------------
|
|  Routine Name: update_tic_label_list - updates the link list for the
|					       tic labels
|
|       Purpose: Will create stringvalue objects or will update
|		 the current list of stringvalue objects.
|
|         Input: axis - the axis object
|
|        Output: none
|
|       Returns: nothing
|
|    Written By: John M. Salas
|          Date: Jul 04, 1992
| Modifications:
|
------------------------------------------------------------*/

static void update_tic_label_list(
   XvwAxisGadget axis)
{
  double number_steps = axis->axis.number_steps;
  tic_label_list *temp_list;

  int i, temp_count = 0;

  if (axis->axis.axis_label_initialized == TRUE) return;

  temp_list = axis->axis.list_head;

/*
 * If new stringvalue widgets need to be created ...
 */
  if ( (int) ceil((double) number_steps + 1.0) >
	     axis->axis.number_stringvalue_widgets )
  {
    temp_count = axis->axis.number_stringvalue_widgets;

    for ( i = 0 ; i < ((int) ceil((double) number_steps + 1.0) -
		       axis->axis.number_stringvalue_widgets) ; i++ )
    {
      /* 
       *  If no stringvalue widgets exist yet create the head of the list ...
       */
      if ( temp_count == 0 )
      {
        axis->axis.list_head = (tic_label_list *)
				kmalloc(sizeof(tic_label_list));
        if ( axis->axis.list_head != NULL )
        {
          axis->axis.list_tail = axis->axis.list_head;
	  ksprintf(axis->axis.list_tail->name, "stringvalue%d", temp_count);
          axis->axis.list_tail->stringvalue =
		xvw_create_stringvalue(xvw_object(axis->object.parent),
				     axis->axis.list_tail->name);
#if 0
		xvw_create_marker(xvw_object(axis->object.parent),
				     axis->axis.list_tail->name);
#endif
	  if ( axis->axis.list_tail->stringvalue == NULL )
	  {
		kinfo(KFORCE, "Axis Object: Could not create a tic label,\
 so do not be surprised if one does not show up 8^(.\n");
	  }
          axis->axis.list_tail->next = NULL;
	  temp_count++;
        }
        else
        {
	  axis->axis.number_stringvalue_widgets = temp_count;
	  return;
        }
      }
      /*
       *  ... add to the list.
       */
      else
      {
        axis->axis.list_tail->next = (tic_label_list *)
				kmalloc(sizeof(tic_label_list));

        if ( axis->axis.list_tail->next != NULL )
        {
          axis->axis.list_tail = axis->axis.list_tail->next;
	  ksprintf(axis->axis.list_tail->name, "stringvalue%d", temp_count);
          axis->axis.list_tail->stringvalue =
		xvw_create_stringvalue(xvw_object(axis->object.parent),
				     axis->axis.list_tail->name);
	  if ( axis->axis.list_tail->stringvalue == NULL )
	  {
		kinfo(KFORCE, "Axis Object: Could not create a tic label,\
 so do not be surprised if one does not show up 8^(.\n");
	  }
          axis->axis.list_tail->next = NULL;
	  temp_count++;
        }
        else
        {
	  axis->axis.number_stringvalue_widgets = temp_count;
	  return;
        }
      }
    }
    axis->axis.number_stringvalue_widgets = temp_count;
  }
/*
 * ... unmap the existing stringvalue widgets so that they will only be
 *     displayed if needed by the redrawn axis system.
 */
  else if ( (int) ceil((double) number_steps + 1.0) <=
		  axis->axis.number_stringvalue_widgets )
  {
    for ( i = 0; i < axis->axis.number_stringvalue_widgets && temp_list != NULL;
	  i++ , temp_list = temp_list->next)
    {
      if ( i > number_steps )
      {
	xvw_set_attributes(temp_list->stringvalue, XVW_MAPPED, FALSE, NULL);
      }
    }
  }
  return;
}
