/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>   		2D Scale Utilities
   >>>>
   >>>>  Private:
   >>>>			_X2D_scale_wc_coords
   >>>>			_X2D_scale_wc_coord
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "graphics.h"


/*-----------------------------------------------------------
|
|  Routine Name: _X2D_scale_wc_coords
|
|       Purpose: Converts a 2D world coordinate to the scale
|		 type desired.
|
|         Input: scale	 -
|		 coords	 -
|		 size	 -
|
|        Output: scoords -
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young & Mike Lang
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

int _X2D_scale_wc_coords(
   Coord scale,
   Coord *coords,
   Coord **scoords,
   int   size)
{
	int	i;
	Coord	*temp;

	if (scale.x == KGRAPHICS_LINEAR && scale.y == KGRAPHICS_LINEAR)
	{
	   *scoords = coords;
	   return(TRUE);
	}

	if ((temp = (Coord *) kmalloc((unsigned) sizeof(Coord) * size)) == NULL)
	{
	   *scoords = coords;
	   return(FALSE);
	}

	for (i = 0; i < size; i++)
	{
	   temp[i].x = _X3D_get_scale_value((int) scale.x, coords[i].x);
	   temp[i].y = _X3D_get_scale_value((int) scale.y, coords[i].y);
	}
	*scoords = temp;
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: _X2D_scale_wc_coord
|
|       Purpose: Converts a 2D world coordinate to the scale
|		 type desired.
|
|         Input: scale	-
|		 coord	-
|
|        Output: scoord -
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young & Mike Lang
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

int	_X2D_scale_wc_coord(
   Coord scale,
   Coord coord,
   Coord *scoord)
{
	Coord	temp;

	temp.x = _X3D_get_scale_value((int) scale.x, coord.x);
	temp.y = _X3D_get_scale_value((int) scale.y, coord.y);
	*scoord = temp;
	return(TRUE);
}
