/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Low level Graphics routines.  All local
   >>>>		       graphics routines and definition.  Many
   >>>>		       thanks to Tait for his good advice and
   >>>>		       comments on creating independent graphics
   >>>>		       routines.
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 18:04
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvgraphics_graphics_h_
#define _xvgraphics_graphics_h_


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

#include "internals.h"

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  The type of output devices  (what language the output device speaks)
 */
#define X11		0
#define POSTSCR 	1

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef struct _graphics_routine
{
  void	(*line)(X3DGraphics *, int, int, int, int);
  void	(*lines)(X3DGraphics *, XPoint *, int, int);
  void	(*segments)(X3DGraphics *, XSegment *, int);
  void	(*rectangle)(X3DGraphics *, int, int, unsigned int, unsigned int);
  void	(*polygon)(X3DGraphics *, XPoint *, int);
  void	(*arc)(X3DGraphics *, int, int, unsigned int, unsigned int, int, int);
  void	(*text)(X3DGraphics *, int, int, char *, char *, int);
  void	(*fill_polygon)(X3DGraphics *, XPoint *, int, int, int);
  void	(*fill_arc)(X3DGraphics *,int,int,unsigned int,unsigned int,int,int);
  void	(*fill_rectangle)(X3DGraphics *, int, int, unsigned int, unsigned int);
  void	(*line_width)(X3DGraphics *, int);
  void	(*line_type)(X3DGraphics *, int);
  void	(*draw_color)(X3DGraphics *, XColor *, int);
  void	(*fill_color)(X3DGraphics *, XColor *, int);
  void	(*close)(X3DGraphics *);

} GraphicsRoutines;

	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* X11.c */
void X11_DrawLine PROTO((X3DGraphics *, int, int, int, int));
void X11_DrawLines PROTO((X3DGraphics *, XPoint *, int, int));
void X11_DrawSegments PROTO((X3DGraphics *, XSegment *, int));
void X11_DrawRectangle PROTO((X3DGraphics *, int, int, unsigned int, unsigned int));
void X11_DrawArc PROTO((X3DGraphics *, int, int, unsigned int, unsigned int, int, int));
void X11_FillPolygon PROTO((X3DGraphics *, XPoint *, int, int, int));
void X11_close_device PROTO((X3DGraphics *));
void X11_set_line_width PROTO((X3DGraphics *, int));
void X11_set_line_type PROTO((X3DGraphics *, int));
void X11_set_draw PROTO((X3DGraphics *, XColor *, int));
void X11_set_fill PROTO((X3DGraphics *, XColor *, int));
void X11_DrawPolygon PROTO((X3DGraphics *, XPoint *, int));
void X11_DrawText PROTO((X3DGraphics *, int, int, char *, char *, int));
void X11_FillArc PROTO((X3DGraphics *, int, int, unsigned int, unsigned int, int, int));
void X11_FillRectangle PROTO((X3DGraphics *, int, int, unsigned int, unsigned int));


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

extern GraphicsRoutines X3D_draw[];

#endif /* _xvgraphics_graphics_h_ */
/* Don't add after this point */
