/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	            GUI Control Routines     		      <<<<
   >>>>                                                       <<<<
   >>>>  Private:					      <<<<
   >>>>                xvf_run_done()                         <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:					      <<<<
   >>>>                xvf_run_form()                         <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/************************************************************
*
*  Routine Name: xvf_run_form - run the GUI of an xvroutine
*
*       Purpose: Runs the GUI of an xvroutine in a loop that is a 
*                modified version of XtMainLoop().  XEvents are waited on
*                and dispatched until the number of toplevel windows
*		 is zero.  The routine then returns to the calling
*		 routine.
*         Input: none
*        Output: none
*	Returns: none
*  Restrictions:
*    Written By: Danielle Argiro and Mark Young
*          Date: Sep 07, 1993
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

void xvf_run_form(void)
{
	xvf_current_form = NULL;
	xvw_busy(NULL, FALSE);

	while (xvw_check_toplevel(NULL))
	{
	   /* this does XtNextEvent/DispatchEvent*/
           xvw_process_event();	
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: xvf_run_done - run the GUI of an xvroutine
|
|       Purpose: This routine is called as a result of the end user
|		 changing the value of a "live" selection, or clicking
|		 on an action button.  This is the actual routine that
|		 then calls the users application code, in order to
|		 return control flow to the application program so that
|		 they may process the request.
|
|         Input: map_busy - whether to map the busy window or not
|        Output: none
|	Returns: none
|          Date: Jan 02, 1995
|    Written By: Danielle Argiro and Mark Young
| Modifications:
|
-------------------------------------------------------------*/

void xvf_run_done(
   int map_busy)
{
	int        busy;
	kform_list *entry;

	if (xvf_current_form)
	{
	   if ((xvf_current_subform &&
	       (entry = kvf_get_entry((kaddr) xvf_current_subform)) != NULL) ||
	       (entry = kvf_get_entry((kaddr) xvf_current_form)) != NULL)
	   {
	      if (entry->routine != NULL)
	      {
		 busy = entry->busy;

		 /*
		  *  When calling the user's routine, we need to see if we
		  *  are suppose to map the busy window or not.
		  */
		 if (map_busy && busy) xvw_busy(NULL, TRUE);
		 (void) entry->routine(xvf_current_form, xvf_current_subform,
					  entry->client_data);

		 /*
		  *  If we mapped the busy window, we better unmap it.
		  */
		 if (map_busy && busy) xvw_busy(NULL, FALSE);
		 xvf_current_form = NULL;
	      }
	      else if (xvf_current_form->quit) 
		    xvf_destroy_form(xvf_current_form);
	   }
	}
}
