/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>                Form  Manipulation Routines            <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>                 xvf_modify_form_from_cmd()            <<<<
   >>>>   Static:                                             <<<<
   >>>>                 update_selections_from_cmd()          <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

#include "internals.h"


static int update_selections_from_cmd PROTO((kselection *, char *));

/*--------------------------------------------------------------
|
|  Routine Name: xvf_modify_form_from_cmd
|
|       Purpose: Modifies the appearance of the form according
|                to the command string
|
|         Input: form - pointer to the form tree
|                cmd  - command line string from which to update form
|
|        Output: none
|       Returns: TRUE if form was updated correctly,
|                FALSE otherwise
|          Date: March 24, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
----------------------------------------------------------------*/
int xvf_modify_form_from_cmd(
    kform *form,
    char  *cmd)
{
	kselection *selection;

	if (!(kvf_modify_form_from_cmd(form, cmd, TRUE)))
	    return(FALSE);

	if (form->subform->guide->pane->back == NULL)
	    return(TRUE);

	selection = form->subform->guide->pane->sel_list;
	return(update_selections_from_cmd(selection, cmd));
}

/*--------------------------------------------------------------
|
|  Routine Name: update_selections_from_cmd
|
|       Purpose: Modifies physical appearance of individual 
|                selections on the form according to changes
|                in values already made by kvf_modify_form_from_cmd().
|
|         Input: sel_list - pointer to the selection list
|        Output: none
|       Returns: TRUE if the selections were updated correctly.
|                FALSE otherwise
|          Date: March 24, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
----------------------------------------------------------------*/
static int update_selections_from_cmd(
    kselection *selection,
    char       *cmd)
{
	int    intval, optsel;
	float  floatval;
	double doubleval;
	char   *stringval, *variable;
	char   tmpvar[KLENGTH];

	while (selection != NULL)
	{
	    switch (selection->type)
	    {
		case KUIS_INPUTFILE:
		case KUIS_OUTPUTFILE:
		     variable = ktoken_to_string(selection->var_token);
		     ksprintf(tmpvar, "-%s ", variable);
		     if (kstrstr(cmd, tmpvar) == NULL)
		         break;
		     kvf_get_attribute(selection->back_kformstruct,
				       KVF_FILE_NAME, &stringval);
		     xvf_set_attribute(selection->back_kformstruct, 
				       XVF_FILE_NAME, stringval);
		     xvf_get_attribute(selection->back_kformstruct,
				       XVF_OPTSEL, &optsel);
		     if (optsel != 2)
		         xvf_set_attribute(selection->back_kformstruct, 
				           XVF_OPTSEL, TRUE);
		     break;

                case KUIS_STDIN:
                case KUIS_STDOUT:
                     variable = ktoken_to_string(selection->var_token);
                     ksprintf(tmpvar, "-%s ", variable);
                     if (kstrstr(cmd, tmpvar) == NULL)
                         break;
                     xvf_set_attribute(selection->back_kformstruct,
                                       XVF_OPTSEL, TRUE);
                     break;

		case KUIS_INTEGER:
		     variable = ktoken_to_string(selection->var_token);
		     ksprintf(tmpvar, "-%s ", variable);
		     if (kstrstr(cmd, tmpvar) == NULL)
		         break;
		     kvf_get_attribute(selection->back_kformstruct,
                                       KVF_INT_VAL, &intval);
		     xvf_set_attribute(selection->back_kformstruct, 
				       XVF_INT_VAL, intval);
		     xvf_get_attribute(selection->back_kformstruct,
				       XVF_OPTSEL, &optsel);
		     if (optsel != 2)
		         xvf_set_attribute(selection->back_kformstruct, 
				       XVF_OPTSEL, TRUE);
                     break;

		case KUIS_DOUBLE:
		     variable = ktoken_to_string(selection->var_token);
		     ksprintf(tmpvar, "-%s ", variable);
		     if (kstrstr(cmd, tmpvar) == NULL)
		         break;
                     kvf_get_attribute(selection->back_kformstruct,
                                       KVF_DOUBLE_VAL, &doubleval);
                     xvf_set_attribute(selection->back_kformstruct,
                                       XVF_DOUBLE_VAL, doubleval);
		     xvf_get_attribute(selection->back_kformstruct,
				       XVF_OPTSEL, &optsel);
		     if (optsel != 2)
		         xvf_set_attribute(selection->back_kformstruct, 
				       XVF_OPTSEL, TRUE);
		     break;

		case KUIS_FLOAT:
		     variable = ktoken_to_string(selection->var_token);
		     ksprintf(tmpvar, "-%s ", variable);
		     if (kstrstr(cmd, tmpvar) == NULL)
		         break;
                     kvf_get_attribute(selection->back_kformstruct,
                                       KVF_FLOAT_VAL, &floatval);
                     xvf_set_attribute(selection->back_kformstruct,
                                       XVF_FLOAT_VAL, floatval);
		     xvf_get_attribute(selection->back_kformstruct,
				       XVF_OPTSEL, &optsel);
		     if (optsel != 2)
		         xvf_set_attribute(selection->back_kformstruct, 
				       XVF_OPTSEL, TRUE);
		     break;

		case KUIS_LOGICAL:
		     variable = ktoken_to_string(selection->var_token);
		     ksprintf(tmpvar, "-%s ", variable);
		     if (kstrstr(cmd, tmpvar) == NULL)
		         break;
                     kvf_get_attribute(selection->back_kformstruct,
                                       KVF_LOGIC_VAL, &intval);
                     xvf_set_attribute(selection->back_kformstruct,
                                       XVF_LOGIC_VAL, intval);
		     xvf_get_attribute(selection->back_kformstruct,
				       XVF_OPTSEL, &optsel);
		     if (optsel != 2)
		         xvf_set_attribute(selection->back_kformstruct, 
				       XVF_OPTSEL, TRUE);
		     break;

		case KUIS_FLAG:
		     variable = ktoken_to_string(selection->var_token);
		     ksprintf(tmpvar, "-%s ", variable);
		     if (kstrstr(cmd, tmpvar) == NULL)
		         break;
		     xvf_set_attribute(selection->back_kformstruct, 
				       XVF_OPTSEL, TRUE);
		     break;

		case KUIS_STRING:
		case KUIS_STRINGLIST:
		     variable = ktoken_to_string(selection->var_token);
		     ksprintf(tmpvar, "-%s ", variable);
		     if (kstrstr(cmd, tmpvar) == NULL)
		         break;
                     kvf_get_attribute(selection->back_kformstruct,
                                       KVF_STRING_VAL, &stringval);
                     xvf_set_attribute(selection->back_kformstruct,
                                       XVF_STRING_VAL, stringval);

		     xvf_get_attribute(selection->back_kformstruct,
				       XVF_OPTSEL, &optsel);
		     if (optsel != 2)
		         xvf_set_attribute(selection->back_kformstruct, 
				       XVF_OPTSEL, TRUE);
		     break;

		case KUIS_CYCLE:
		case KUIS_LIST:
		case KUIS_DISPLAYLIST:
		     variable = ktoken_to_string(selection->var_token);
		     ksprintf(tmpvar, "-%s ", variable);
		     if (kstrstr(cmd, tmpvar) == NULL)
		         break;
                     kvf_get_attribute(selection->back_kformstruct,
                                       KVF_LIST_VAL, &intval);
                     xvf_set_attribute(selection->back_kformstruct,
                                       XVF_LIST_VAL, intval);
		     xvf_get_attribute(selection->back_kformstruct,
				       XVF_OPTSEL, &optsel);
		     if (optsel != 2)
		         xvf_set_attribute(selection->back_kformstruct, 
				       XVF_OPTSEL, TRUE);
                     break;

		case KUIS_MUTEXCL:
		case KUIS_MUTINCL:
		case KUIS_GROUP:
		     if (!(update_selections_from_cmd(
					selection->group_next, cmd)))
		         return(FALSE);
		     break;

	        case KUIS_TOGGLE:
		     variable = ktoken_to_string(selection->var_token);
		     ksprintf(tmpvar, "-%s ", variable);
		     if (kstrstr(cmd, tmpvar) == NULL)
		         break;
                     kvf_get_attribute(selection->back_kformstruct,
                                       KVF_TOGGLE_NUM, &intval);
                     xvf_set_attribute(selection->back_kformstruct,
                                       XVF_TOGGLE_NUM, intval);
		     xvf_get_attribute(selection->back_kformstruct,
				       XVF_OPTSEL, &optsel);
		     if (optsel != 2)
		         xvf_set_attribute(selection->back_kformstruct, 
				       XVF_OPTSEL, TRUE);
                     break;

	    }
	    selection = selection->next;
	}
	return(TRUE);
}

