/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>             Geometry Attribute Actions                <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>                 xvf_get_width()                       <<<<
   >>>>                 xvf_set_width()                       <<<<
   >>>>                 xvf_get_height()                      <<<<
   >>>>                 xvf_set_height()                      <<<<
   >>>>                 xvf_get_x()                           <<<<
   >>>>                 xvf_set_x()                           <<<<
   >>>>                 xvf_get_y()                           <<<<
   >>>>                 xvf_set_y()                           <<<<
   >>>>                 xvf_get_xpos()                        <<<<
   >>>>                 xvf_set_xpos()                        <<<<
   >>>>                                                       <<<<
   >>>>	     		xvf_inform_geometry()		      <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */


#include "internals.h"
#include "attributes.h"


/*-----------------------------------------------------------
|
|       Routine: xvf_get_width
|       Purpose: Gets the width value of the geometry
|                from the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_WIDTH ("xvf_width")
|        Output: calldata    - passes back float width value 
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_width(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	if (!(kvf_get_width(kformstruct, KVF_WIDTH, calldata)))
	    return(FALSE);
	else return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: xvf_set_width
|       Purpose: Sets the width value of the geometry
|                on the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_WIDTH ("xvf_width")
|                calldata    - provides float width value 
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_set_width(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float    *width;

	/* the value to which XVF_WIDTH is to be set */
        width = (float *) calldata;

	if (!(kvf_set_width(kformstruct, KVF_WIDTH, calldata)))
	    return(FALSE);

	/* special case for subform buttons - set width on button */
	if (kformstruct->type == KSUBFORM)
	    xvw_set_attribute(kformstruct->Subformptr->back,
                                   XVW_CHAR_WIDTH, *width);

	/* special case for guide buttons - set width on button */
	else if (kformstruct->flag == KUIS_GUIDEBUTTON)
            xvw_set_attribute(kformstruct->Guideptr->button, 
			      XVW_CHAR_WIDTH, *width);

	/* special case for submenu buttons - set width on button */
	else if (kformstruct->flag == KUIS_STARTSUBMENU)
		xvw_set_attribute(kformstruct->Selptr->label_object,
				  XVW_CHAR_WIDTH, *width);

	/* special case for Panes, Guide Panes, Master Forms - set min width */
	else if ((kformstruct->flag == KUIS_STARTPANE)  ||
            (kformstruct->flag == KUIS_STARTGUIDE) ||
            (kformstruct->flag == KUIS_STARTMASTER))
            xvw_set_attribute(kformstruct->Controlptr->back,
                              XVW_CHAR_WIDTH, *width);

	/* special case for Workspace selections - set width in pixels */
	else if (kformstruct->Selptr->type == KUIS_WORKSPACE)
	     xvw_set_attribute(kformstruct->Selptr->back, 
	 	 	       XVW_WIDTH, ((int) *width));

	/* general case for GUI items - set width on backplane */
	else xvw_set_attribute(kformstruct->Selptr->back, 
                               XVW_CHAR_WIDTH, *width);

	if (kformstruct->callback_list != NULL)
	    xvf_call_gui_callbacks(kformstruct, attribute, calldata);

	return(TRUE);
}


/*-----------------------------------------------------------
|
|       Routine: xvf_get_height
|       Purpose: Gets the height value of the geometry
|                from the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_HEIGHT ("xvf_height")
|        Output: calldata    - passes back float height value 
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_height(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	if (!(kvf_get_height(kformstruct, KVF_HEIGHT, calldata)))
	    return(FALSE);
	else return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: xvf_set_height
|       Purpose: Sets the height value of the geometry
|                on the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_HEIGHT ("xvf_height")
|                calldata    - provides float value for height
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_set_height(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float    *height;
	xvobject object;

	/* the value to which XVF_HEIGHT is to be set */
        height = (float *) calldata;

	if (!(kvf_set_height(kformstruct, KVF_HEIGHT, calldata)))
	    return(FALSE);

	/* special case for subform buttons - set height on button */
	if (kformstruct->type == KSUBFORM)
	    xvw_set_attribute(kformstruct->Subformptr->back,
                              XVW_CHAR_HEIGHT, *height);

	/* special case for guide buttons - set height on button */
	else if (kformstruct->flag == KUIS_GUIDEBUTTON)
            xvw_set_attribute(kformstruct->Guideptr->button, 
			      XVW_CHAR_HEIGHT, *height);

	/* special case for submenu buttons - set height on button */
	else if (kformstruct->flag == KUIS_STARTSUBMENU)
		xvw_set_attribute(kformstruct->Selptr->label_object,
				  XVW_CHAR_HEIGHT, *height);

	/* special case for Panes, Guide Panes, Master Forms - set min height */
	else if ((kformstruct->flag == KUIS_STARTPANE)  ||
            (kformstruct->flag == KUIS_STARTGUIDE) ||
            (kformstruct->flag == KUIS_STARTMASTER))
            xvw_set_attribute(kformstruct->Controlptr->back,
                              XVW_CHAR_HEIGHT, *height);

	/* special case for Workspace selections - set height in pixels */
	else if (kformstruct->Selptr->type == KUIS_WORKSPACE)
	     xvw_set_attribute(kformstruct->Selptr->back, 
	 	 	       XVW_HEIGHT, ((int) *height));

	/* general case for GUI items - set height on backplane */
	else xvw_set_attribute(kformstruct->Selptr->back, 
                               XVW_CHAR_HEIGHT, *height);


	if ((kformstruct->Selptr->type == KUIS_STRING) ||
	    (kformstruct->Selptr->type == KUIS_STRINGLIST))
	{
	    object = xvf_get_xvobject(kformstruct, XVF_BACKPLANE, TRUE);
	    if (kformstruct->Selptr->back_toggle == NULL)
	    {
  	        if (*height > 1.0)
	            xvf_set_attribute(kformstruct, XVF_STRING_MULTILINE, TRUE);
	        else xvf_set_attribute(kformstruct, XVF_STRING_MULTILINE, FALSE);
	    }
	}
	if (kformstruct->callback_list != NULL)
	    xvf_call_gui_callbacks(kformstruct, attribute, calldata);

	return(TRUE);
}


/*-----------------------------------------------------------
|
|       Routine: xvf_get_x
|       Purpose: Gets the x value of the geometry
|                from the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_X ("xvf_x")
|        Output: calldata    - passes back float X value 
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_x(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	if (!(kvf_get_x(kformstruct, KVF_X, calldata)))
	    return(FALSE);
	else return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: xvf_set_x
|       Purpose: Sets the x value of the geometry
|                on the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_X ("xvf_x")
|                calldata    - provides float value for x
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_set_x(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        /* set the pointer to be returned */
        float *x = (float *) calldata;

	if (!(kvf_set_x(kformstruct, KVF_X, calldata)))
	    return(FALSE);

	/* special case for subform buttons - set x position on button */
	if (kformstruct->type == KSUBFORM)
	    xvw_set_attribute(kformstruct->Subformptr->back,
                              XVW_CHAR_XPOS, *x);

	/* special case for guide buttons - set x position on button */
	else if (kformstruct->flag == KUIS_GUIDEBUTTON)
            xvw_set_attribute(kformstruct->Guideptr->button, 
			      XVW_CHAR_XPOS, *x);

	/* special case for submenu buttons - set x position on button */
	else if (kformstruct->flag == KUIS_STARTSUBMENU)
		xvw_set_attribute(kformstruct->Selptr->label_object,
				  XVW_CHAR_XPOS, *x);

	/* general case - set x position on backplane */
        else xvw_set_attribute(kformstruct->Selptr->back, XVW_CHAR_XPOS, *x);

	if (kformstruct->callback_list != NULL)
	    xvf_call_gui_callbacks(kformstruct, attribute, calldata);

	return(TRUE);
}


/*-----------------------------------------------------------
|
|       Routine: xvf_get_y
|       Purpose: Gets the y value of the geometry
|                from the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_Y ("xvf_y")
|        Output: calldata    - passes back float Y value 
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_y(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	if (!(kvf_get_y(kformstruct, KVF_Y, calldata)))
	    return(FALSE);
	else return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: xvf_set_y
|       Purpose: Sets the y value of the geometry
|                on the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_Y ("xvf_y")
|                calldata    - provides float value for y
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_set_y(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	/* the value to which XVF_Y is to be set */
        float *y = (float *) calldata;

	if (!(kvf_set_y(kformstruct, KVF_Y, calldata)))
	    return(FALSE);

	/* special case for subform buttons - set y position on button */
	if (kformstruct->type == KSUBFORM)
	    xvw_set_attribute(kformstruct->Subformptr->back,
                              XVW_CHAR_YPOS, *y);

	/* special case for guide buttons - set y position on button */
	else if (kformstruct->flag == KUIS_GUIDEBUTTON)
            xvw_set_attribute(kformstruct->Guideptr->button, 
			      XVW_CHAR_YPOS, *y);

	/* special case for submenu buttons - set y position on button */
	else if (kformstruct->flag == KUIS_STARTSUBMENU)
		xvw_set_attribute(kformstruct->Selptr->label_object,
				  XVW_CHAR_YPOS, *y);

	/* general case - set y position on backplane */
        else xvw_set_attribute(kformstruct->Selptr->back, XVW_CHAR_YPOS, *y);

	if (kformstruct->callback_list != NULL)
	    xvf_call_gui_callbacks(kformstruct, attribute, calldata);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: xvf_get_buttonwidth
|       Purpose: Gets the value of the width field from the -d UIS line
|                or any other of the button-specific UIS lines 
|               (-g, -m, -n, -a, -R, -H, -Q)
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_BUTTONWIDTH ("xvf_buttonwidth")
|        Output: calldata    - passes back float value of width
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_buttonwidth(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        return (kvf_get_buttonwidth(kformstruct, KVF_BUTTONWIDTH, calldata));
}

/*-----------------------------------------------------------
|
|       Routine: xvf_set_buttonwidth
|       Purpose: Sets the value of the width field from the -d UIS line
|                This routine is specialized for use with subforms, where
|                you can't tell from the kformstruct if they want to set
|                the width of the subform button or of the subform itself.
|                However, it will also work for any of the other button-specific
|                UIS lines (-g, -m, -n, -a, -R, -H, -Q), as it just turns
|                around and calls xvf_set_width().
|
|         Input: kformstruct - generic kformstruct holding ptr to subform
|                attribute   - XVF_BUTTONWIDTH ("xvf_buttonwidth")
|                calldata    - provides float value for width
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_set_buttonwidth(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float    *width;

        if (kformstruct->type != KSUBFORM)
            return(xvf_set_width(kformstruct, KVF_WIDTH, calldata));

        if (!(kvf_set_buttonwidth(kformstruct, KVF_BUTTONWIDTH, calldata)))
            return(FALSE);

        /* the value to which XVF_BUTTONWIDTH is to be set */
        width = (float *) calldata;

        xvw_set_attribute(kformstruct->Subformptr->button,
                          XVW_CHAR_WIDTH, *width);

        if (kformstruct->callback_list != NULL)
            xvf_call_gui_callbacks(kformstruct, attribute, calldata);

        return(TRUE);

}


/*-----------------------------------------------------------
|
|       Routine: xvf_get_buttonheight
|       Purpose: Gets the value of the height field from the -d UIS line
|                or any other of the button-specific UIS lines 
|               (-g, -m, -n, -a, -R, -H, -Q)
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_BUTTONHEIGHT ("xvf_buttonheight")
|        Output: calldata    - passes back float value of height
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_buttonheight(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        return (kvf_get_buttonheight(kformstruct, KVF_BUTTONHEIGHT, calldata));
}

/*-----------------------------------------------------------
|
|       Routine: xvf_set_buttonheight
|       Purpose: Sets the value of the height field from the -d UIS line
|                This routine is specialized for use with subforms, where
|                you can't tell from the kformstruct if they want to set
|                the height of the subform button or of the subform itself.
|                However, it will also work for any of the other button-specific
|                UIS lines (-g, -m, -n, -a, -R, -H, -Q), as it just turns
|                around and calls xvf_set_height().
|
|         Input: kformstruct - generic kformstruct holding ptr to subform
|                attribute   - XVF_BUTTONHEIGHT ("xvf_buttonheight")
|                calldata    - provides float value for height
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_set_buttonheight(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float    *height;

        if (kformstruct->type != KSUBFORM)
            return(xvf_set_height(kformstruct, KVF_HEIGHT, calldata));

        if (!(kvf_set_buttonheight(kformstruct, KVF_BUTTONHEIGHT, calldata)))
            return(FALSE);

        /* the value to which XVF_BUTTONHEIGHT is to be set */
        height = (float *) calldata;

        xvw_set_attribute(kformstruct->Subformptr->button,
                          XVW_CHAR_HEIGHT, *height);

        if (kformstruct->callback_list != NULL)
            xvf_call_gui_callbacks(kformstruct, attribute, calldata);

        return(TRUE);

}



/*-----------------------------------------------------------
|
|       Routine: xvf_get_buttonx
|       Purpose: Gets the value of the x field from the -d UIS line
|                or any other of the button-specific UIS lines 
|               (-g, -m, -n, -a, -R, -H, -Q)
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_BUTTONX ("xvf_buttonx")
|        Output: calldata    - passes back float value of x
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_buttonx(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        return (kvf_get_buttonx(kformstruct, KVF_BUTTONX, calldata));
}

/*-----------------------------------------------------------
|
|       Routine: xvf_set_buttonx
|       Purpose: Sets the value of the x field from the -d UIS line
|                This routine is specialized for use with subforms, where
|                you can't tell from the kformstruct if they want to set
|                the x of the subform button or of the subform itself.
|                However, it will also work for any of the other button-specific
|                UIS lines (-g, -m, -n, -a, -R, -H, -Q), as it just turns
|                around and calls xvf_set_x().
|
|         Input: kformstruct - generic kformstruct holding ptr to subform
|                attribute   - XVF_BUTTONX ("xvf_buttonx")
|                calldata    - provides float value for x
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_set_buttonx(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float    *x;

        if (kformstruct->type != KSUBFORM)
            return(xvf_set_x(kformstruct, KVF_X, calldata));

        if (!(kvf_set_buttonx(kformstruct, KVF_BUTTONX, calldata)))
            return(FALSE);

        /* the value to which XVF_BUTTONX is to be set */
        x = (float *) calldata;

        xvw_set_attribute(kformstruct->Subformptr->button, XVW_CHAR_XPOS, *x);

        if (kformstruct->callback_list != NULL)
            xvf_call_gui_callbacks(kformstruct, attribute, calldata);

        return(TRUE);

}

/*-----------------------------------------------------------
|
|       Routine: xvf_get_buttony
|       Purpose: Gets the value of the y field from the -d UIS line
|                or any other of the button-specific UIS lines 
|               (-g, -m, -n, -a, -R, -H, -Q)
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_BUTTONY ("xvf_buttony")
|        Output: calldata    - passes back float value of y
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_buttony(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        return (kvf_get_buttony(kformstruct, KVF_BUTTONY, calldata));
}


/*-----------------------------------------------------------
|
|       Routine: xvf_set_buttony
|       Purpose: Sets the value of the y field from the -d UIS line
|                This routine is specialized for use with subforms, where
|                you can't tell from the kformstruct if they want to set
|                the y of the subform button or of the subform itself.
|                However, it will also work for any of the other button-specific
|                UIS lines (-g, -m, -n, -a, -R, -H, -Q), as it just turns
|                around and calls xvf_set_y().
|
|         Input: kformstruct - generic kformstruct holding ptr to subform
|                attribute   - XVF_BUTTONY ("xvf_buttony")
|                calldata    - provides float value for y
|
|          Date: November 28, 1994
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_set_buttony(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float    *y;

        if (kformstruct->type != KSUBFORM)
            return(xvf_set_y(kformstruct, KVF_Y, calldata));

        if (!(kvf_set_buttony(kformstruct, KVF_BUTTONY, calldata)))
            return(FALSE);

        /* the value to which XVF_BUTTONX is to be set */
        y = (float *) calldata;

        xvw_set_attribute(kformstruct->Subformptr->button, XVW_CHAR_YPOS, *y);

        if (kformstruct->callback_list != NULL)
            xvf_call_gui_callbacks(kformstruct, attribute, calldata);

        return(TRUE);

}



/*-----------------------------------------------------------
|
|       Routine: xvf_get_xpos
|       Purpose: Gets the xpos value of the geometry
|                from the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_XPOS ("xvf_xpos")
|        Output: calldata    - passes back float x position value
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_xpos(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	if (!(kvf_get_xpos(kformstruct, KVF_XPOS, calldata)))
	    return(FALSE);
	else return(TRUE);
}


/*-----------------------------------------------------------
|
|       Routine: xvf_set_xpos
|       Purpose: Sets the x value of the title offset
|                on the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_XPOS ("xvf_xpos")
|                calldata    - provides float value for xpos
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_set_xpos(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	/* the value to which XVF_XPOS is to be set */
        float *xpos = (float *) calldata;

	if (!(kvf_set_xpos(kformstruct, KVF_XPOS, calldata)))
	    return(FALSE);

	/* for a blank selection, need to move the text */
	if (kformstruct->flag == KUIS_BLANK) 
	    xvw_set_attribute(kformstruct->Selptr->back, XVW_CHAR_XPOS, *xpos);

	/* for titles of panes, guidepanes, masters, need to move the text */
	else if ((kformstruct->flag == KUIS_STARTPANE)  ||
                 (kformstruct->flag == KUIS_STARTGUIDE) ||
	         (kformstruct->flag == KUIS_STARTMASTER))
	{
	    xvw_set_attribute(kformstruct->Controlptr->label_object, 
			      XVW_CHAR_XPOS, *xpos);
	    xvw_update_menu(kformstruct->Controlptr->back);
	}

	/* for titles of subforms, need to move the text */
	else if (kformstruct->type == KSUBFORM)
	{
	    xvw_set_attribute(kformstruct->Subformptr->label_object, 
			      XVW_CHAR_XPOS, *xpos);
	    xvw_update_menu(kformstruct->Subformptr->back);
	}

	/* for toggle, need to move the title */
	else if (kformstruct->flag == KUIS_TOGGLE)
	{
	    xvw_set_attribute(kformstruct->Selptr->label_object, 
			      XVW_CHAR_XPOS, *xpos);
	    xvw_update_menu(kformstruct->Selptr->back);
	}

	if (kformstruct->callback_list != NULL)
	    xvf_call_gui_callbacks(kformstruct, attribute, calldata);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: xvf_get_ypos
|       Purpose: Gets the ypos value of the geometry
|                from the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_YPOS ("xvf_ypos")
|        Output: calldata    - passes back float y position value
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_ypos(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	if (!(kvf_get_ypos(kformstruct, KVF_YPOS, calldata)))
	    return(FALSE);
	else return(TRUE);
}


/*-----------------------------------------------------------
|
|       Routine: xvf_set_ypos
|       Purpose: Sets the y value of the title offset
|                on the UIS line of a GUI item
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_YPOS ("xvf_ypos")
|                calldata    - provides float value for ypos
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_set_ypos(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
        float    *ypos;

	/* the value to which XVF_YPOS is to be set */
        ypos = (float *) calldata;

	if (!(kvf_set_ypos(kformstruct, KVF_YPOS, calldata)))
	    return(FALSE);

	/* for blank selections, need to move the text */
	if (kformstruct->flag == KUIS_BLANK) 
	    xvw_set_attribute(kformstruct->Selptr->back, XVW_CHAR_YPOS, *ypos);

	/* for titles of panes, guidepanes, masters, need to move the text */
	else if ((kformstruct->flag == KUIS_STARTPANE)  ||
                 (kformstruct->flag == KUIS_STARTGUIDE) ||
                 (kformstruct->flag == KUIS_STARTMASTER))
	{
	    xvw_set_attribute(kformstruct->Controlptr->label_object, 
			      XVW_CHAR_YPOS, *ypos);
	    xvw_update_menu(kformstruct->Controlptr->back);
	}

	/* for titles of subforms, need to move the text */
	else if (kformstruct->type == KSUBFORM)
	{
	    xvw_set_attribute(kformstruct->Subformptr->label_object, 
			      XVW_CHAR_YPOS, *ypos);
	    xvw_update_menu(kformstruct->Subformptr->back);
	}

	/* for toggle, need to move the title */
	else if (kformstruct->flag == KUIS_TOGGLE)
	{
	    xvw_set_attribute(kformstruct->Selptr->label_object, 
			      XVW_CHAR_YPOS, *ypos);
	    xvw_update_menu(kformstruct->Selptr->back);
	}

	if (kformstruct->callback_list != NULL)
	    xvf_call_gui_callbacks(kformstruct, attribute, calldata);

	return(TRUE);
}



/*-----------------------------------------------------------
|
|       Routine: xvf_inform_geometry
|
|       Purpose: Called by the xvobject library when a GUI selection
|                is resized, this routine updates the geometry string
|                on the UIS line of the GUI item.
|
|         Input: object      - backplane of the selection
|                client_data - kformstruct associated w/ object
|                calldata    - provides string value of literal
|        Output: none
|
|          Date: Nov 10, 1992
|    Written By: Danielle Argiro 
| Modifications:
|
-------------------------------------------------------------*/
/* ARGSUSED */
void xvf_inform_geometry(
   xvobject backplane,
   char     *client_data,
   kaddr    calldata)
{
	float         x, y, width, height;
	int           pixel_width, pixel_height;
	kform_struct  *kformstruct;
	xvobject      object = *((xvobject *) calldata);

	/* selection that brought up the menu */
        xvw_get_attribute(object, XVW_MENU_CLIENTDATA, &kformstruct);
	if (kformstruct == NULL) return;

	/*
         * workspaces: change width & height in pixels
	 */
	if (kformstruct->flag == KUIS_WORKSPACE)
	{
	    xvw_get_attributes(object, 
			       XVW_CHAR_XPOS,   &x,
			       XVW_CHAR_YPOS,   &y,
			       XVW_WIDTH,       &pixel_width,
			       XVW_HEIGHT,      &pixel_height,
			       NULL);
 
	    /* movement/resize of workspace backplane */
	    xvf_set_attributes(kformstruct,
			       XVF_X,      x,
			       XVF_Y,      y,
			       XVF_WIDTH,  (float) pixel_width,
			       XVF_HEIGHT, (float) pixel_height,
			       NULL);
	}

	/*
	 *  titles of panes, guidepanes, and master forms 
	 */
	else if (((kformstruct->flag == KUIS_STARTPANE)  ||
		   (kformstruct->flag == KUIS_STARTMASTER))  &&
                   (object == kformstruct->Controlptr->label_object))
	{
	    xvw_get_attributes(object,
                               XVW_CHAR_XPOS,   &x,
                               XVW_CHAR_YPOS,   &y,
			       NULL);

	    xvf_set_attributes(kformstruct,
                               XVF_XPOS,      x,
                               XVF_YPOS,      y,
                               NULL);
	}
	else if (kformstruct->flag == KUIS_STARTGUIDE) 
	{
	    xvw_get_attributes(object,
                               XVW_CHAR_XPOS,   &x,
                               XVW_CHAR_YPOS,   &y,
			       NULL);

	    xvf_set_attributes(kformstruct,
                               XVF_XPOS,      x,
                               XVF_YPOS,      y,
			       NULL);
	}

	/*
	 * titles of subforms
	 */
	else if (((kformstruct->flag == KUIS_STARTSUBFORM) ||
		  (kformstruct->flag == KUIS_SUBFORMBUTTON)) &&
                 (object == kformstruct->Subformptr->label_object))
	{
            xvw_get_attributes(object,
                               XVW_CHAR_XPOS,   &x,
                               XVW_CHAR_YPOS,   &y,
                               NULL);

            xvf_set_attributes(kformstruct,
                               XVF_XPOS,      x,
                               XVF_YPOS,      y,
                               NULL);
        }

	/*
	 * titles of toggles
	 */
	else if ((kformstruct->flag == KUIS_TOGGLE) &&
		 (object == kformstruct->Selptr->label_object))
	{
            xvw_get_attributes(object,
                               XVW_CHAR_XPOS,   &x,
                               XVW_CHAR_YPOS,   &y,
                               NULL);

            xvf_set_attributes(kformstruct,
                               XVF_XPOS,      x,
                               XVF_YPOS,      y,
                               NULL);
        }


	/*
	 *  blank selection uses title on back, not label_object
	 */
	else if (kformstruct->flag == KUIS_BLANK)
	{
            xvw_get_attributes(object,
                               XVW_CHAR_XPOS,   &x,
                               XVW_CHAR_YPOS,   &y,
			       NULL);
	    xvf_set_attributes(kformstruct,
                               XVF_XPOS,      x,
                               XVF_YPOS,      y,
                               NULL);
	}

	/*
	 *  general case: get xpos, ypos, width & height
	 */
	else
	{
	    xvw_get_attributes(object, 
			       XVW_CHAR_XPOS,   &x,
			       XVW_CHAR_YPOS,   &y,
			       XVW_CHAR_WIDTH,  &width,
			       XVW_CHAR_HEIGHT, &height,
			       NULL);

	    if ((kformstruct->type == KSUBFORM) &&
	 	(object == kformstruct->Subformptr->button))
                    xvf_set_attributes(kformstruct,
                               XVF_BUTTONX,      x,
                               XVF_BUTTONY,      y,
                               XVF_BUTTONWIDTH,  width,
                               XVF_BUTTONHEIGHT, height,
                               NULL);

	    else xvf_set_attributes(kformstruct,
                                    XVF_X,      x,
                                    XVF_Y,      y,
                                    XVF_WIDTH,  width,
                                    XVF_HEIGHT, height,
                                    NULL);
	}

	if (kformstruct->callback_list != NULL)
	    xvf_call_gui_callbacks(kformstruct, NULL, calldata);

}

