/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	      Routines to Handle GUI Answer Files             <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>            xvf_update_forms_from_answerfile()         <<<<
   >>>>            xvf_update_answerfile_from_forms()         <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */
 
#include "internals.h"


/*-----------------------------------------------------------
|
|  Routine Name: xvf_update_forms_from_answerfile
|
|       Purpose: This is the Action Procedure that is initiated when 
|	 	 the user enters a filename in the Answer Infile
|		 text object and hits <cr>.  It updates the values 
|                in the forms according to the GUI answer file.
|
|         Input: object      - the text object of the live selection
|                client_data - passes the poiter to the selection
|        Output: none
|          Date: Apr 12, 1992
|    Written By: Danielle Argiro
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------*/

/* ARGSUSED */
void xvf_update_forms_from_answerfile(
   xvobject object,
   kaddr    client_data)
{

	kerror("xvforms", "xvf_update_forms_from_answerfile",
	       "Sorry, but GUI answer files are not supported (yet).");
}


/*-----------------------------------------------------------
|
|  Routine Name: xvf_update_answerfile_from_forms
|
|       Purpose: This is the Action Procedure that is initiated when 
|	 	 the user enters a filename in the Answer Outfile 
|		 text object and hits <cr>.  It creates a GUI answer file 
|                based on the values currently found in the forms.
|
|         Input: object      - the text object of the live selection
|                client_data - passes the poiter to the selection
|
|        Output: none
|          Date: Apr 12, 1992
|    Written By: Danielle Argiro
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

/* ARGSUSED */
void xvf_update_answerfile_from_forms(
   xvobject object,
   kaddr    client_data)
{
	kerror("xvforms", "xvf_update_forms_from_answerfile",
	       "Sorry, but GUI answer files are not supported (yet).");

}
