 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kcat
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kcat.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Utility for sequencing of file display in cantata.
|
|       Purpose: main program for kcat
|
|         Input:
|		char *clui_info->i_string; {Input List of Images}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|        Output:
|       Returns:
|
|    Written By: Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	char *outfile, *infile, **files;
	int  i, num = 0, mode = KFILE|KPATH|KLINK;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DESIGN");
	kexit_handler(kcat_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DESIGN", "kcat",
		kcat_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kcat_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	outfile = clui_info->o_file;
	infile  = clui_info->i_string;
	files = karray_dirlist(infile, NULL, NULL, mode, FALSE, &num);
/* -main_before_lib_call_end */

/* -main_library_call */
	for (i = 0; i < num; i++)
	   kcopyfile(files[i], outfile);
/* -main_library_call_end */

/* -main_after_lib_call */
	karray_free(files, num, NULL);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kcat_usage_additions
| 
|       Purpose: Prints usage additions in kcat_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcat
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kcat_usage_additions(void)
{
	kfprintf(kstderr, "\tUtility for sequencing of file display in cantata.\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kcat_free_args
| 
|       Purpose: Frees CLUI struct allocated in kcat_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcat
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kcat_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_string);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
