 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: general #includes, #defines, and structures
   >>>>		       for all xvwidgets
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvwidgets_xvwidgets_h_
#define _xvwidgets_xvwidgets_h_


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

#include <xvwidgets/xvwidgetsP.h>
#include <xvwidgets/attributes.h>

#include <xvwidgets/GenGeometry.h>
#include <xvwidgets/GenCharGeometry.h>
#include <xvwidgets/GenMisc.h>

#include <xvwidgets/Shell.h>
#include <xvwidgets/MenuButton.h>
#include <xvwidgets/List.h>
#include <xvwidgets/Label.h>
#include <xvwidgets/Button.h>
#include <xvwidgets/Scrollbar.h>
#include <xvwidgets/Text.h>


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

/*
 *  Declare a xvclass currently to be the WidgetClass structure defined by Xt.
 */
typedef WidgetClass xvclass;

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

#define XBUFFER_SIZE 3
#define YBUFFER_SIZE 3

	/*-------------------------------------*
	|       macros
	---------------------------------------*/

/************************************************************
*
*  Routine Name: xvw_getextent - get a rectangular extent
*
*       Purpose: Gets a rectangular extent for the given object.  This is
*		 a simplier interface to the xvw_getextent_rectangle()
*		 routine.
*
*         Input: object - the object in which to get extents, if NULL then
*                         from the RootWindow.
*        Output: x - the starting x position
*                y - the starting y position
*                w - the width of the extent
*                h - the height of the extent
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: 
*    Written By: Mark Young
*          Date: Jan 02, 1995
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: xvw_getextent(
*                !   xvobject object,
*                !   int      erase,
*                !   int      *x,
*                !   int      *y,
*                !   int      *w,
*                !   int      *h)
*
*************************************************************/
 
#define xvw_getextent(object, x, y, w, h) \
                xvw_getextent_rectangle(object, TRUE, x, y, w, h)

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* action.c */
void xvw_add_action        PROTO((xvobject, char *, kfunc_void, kaddr, int));
void xvw_remove_action     PROTO((xvobject, char *, kfunc_void, kaddr));
void xvw_destroy_actions   PROTO((xvobject));

/* attributes.c */
int xvw_vset_attributes     PROTO((xvobject, kva_list));
int xvw_vget_attributes     PROTO((xvobject, kva_list));
int xvw_set_attributes      PROTO((xvobject, kvalist));
int xvw_get_attributes      PROTO((xvobject, kvalist));
int xvw_format_attribute    PROTO((xvobject, char *, char *, kvalist));
int xvw_init_attributes     PROTO((xvclass, xvattribute *, int,
				   xvattribute *, int, char *));
int xvw_define_attributes   PROTO((xvclass, kvalist));
int xvw_define_constraints  PROTO((xvclass, kvalist));
int xvw_add_attrcallback    PROTO((xvclass, char *, kfunc_void, kaddr));
int xvw_call_attrcallback   PROTO((xvobject, char *));
int xvw_remove_attrcallback PROTO((xvclass));

/* check.c */
void xvw_busy		 PROTO((xvobject, int));

/* check.c */
int xvw_check_realized   PROTO((xvobject));
int xvw_check_sensitive  PROTO((xvobject));
int xvw_check_mapped     PROTO((xvobject));
int xvw_check_visible    PROTO((xvobject));
int xvw_check_managed    PROTO((xvobject));
int xvw_check_menuactive PROTO((xvobject));
int xvw_check_menuexist  PROTO((xvobject));
int xvw_check_toplevel   PROTO((xvobject));
int xvw_check_localhost  PROTO((xvobject));
int xvw_check_subclass   PROTO((xvobject, xvclass));

/* callback.c */
void xvw_add_callback    PROTO((xvobject, char *, kfunc_void, kaddr));
void xvw_insert_callback PROTO((xvobject, char *, int, kfunc_void, kaddr));
void xvw_remove_callback PROTO((xvobject, char *, kfunc_void, kaddr));
void xvw_define_callback PROTO((char *,   char *, kfunc_void));
void xvw_call_callback   PROTO((xvobject, char *));
void xvw_destroy_callbacks PROTO((xvobject));

/* event.c */
void xvw_insert_event  	   PROTO((xvobject, int, kfunc_void, kaddr, int));
void xvw_add_event    	   PROTO((xvobject, int, kfunc_void, kaddr));
void xvw_remove_event 	   PROTO((xvobject, int, kfunc_void, kaddr));
void xvw_destroy_events	   PROTO((xvobject));

/* fid.c */
void xvw_add_detectfid    PROTO((xvobject, int, kfunc_void, kaddr));
void xvw_remove_detectfid PROTO((xvobject, int, kfunc_void, kaddr));
void xvw_destroy_detectfids  PROTO((xvobject));

/* file.c */
void xvw_add_detectfile    PROTO((xvobject, char *, double, kfunc_int, kaddr));
void xvw_remove_detectfile PROTO((xvobject, char *, kfunc_int, kaddr));
void xvw_destroy_detectfiles PROTO((xvobject));

/* general.c */
Window xvw_rootwindow    PROTO((xvobject));
xvobject xvw_toplevel    PROTO((xvobject));
Visual *xvw_visual       PROTO((xvobject));
Colormap xvw_colormap    PROTO((xvobject));

Widget xvw_widget        PROTO((xvobject));
Window xvw_window        PROTO((xvobject));
char *xvw_name           PROTO((xvobject));
xvclass xvw_class	 PROTO((xvobject));
xvobject xvw_object      PROTO((Widget));
xvobject xvw_create      PROTO((xvobject, int, int, String, xvclass));
int xvw_recreate         PROTO((xvobject, xvclass));
xvobject xvw_duplicate   PROTO((xvobject));
xvobject xvw_parent      PROTO((xvobject));
void xvw_destroy         PROTO((xvobject));
void xvw_place		 PROTO((xvobject, xvobject));
void xvw_unmap           PROTO((xvobject));
void xvw_map             PROTO((xvobject));
void xvw_unmanage        PROTO((xvobject));
void xvw_manage          PROTO((xvobject));
void xvw_raise           PROTO((xvobject));
void xvw_lower           PROTO((xvobject));
void xvw_realize         PROTO((xvobject));
void xvw_unrealize       PROTO((xvobject));
void xvw_sensitive       PROTO((xvobject, int));
void xvw_refresh         PROTO((xvobject));
int xvw_geometry         PROTO((xvobject, int *, int *, unsigned int *,
                                unsigned int *, unsigned int *));
xvobject *xvw_children   PROTO((xvobject, xvclass, int *));
int xvw_numchildren	 PROTO((xvobject, xvclass));
int xvw_translate_coords PROTO((xvobject, int, int, int *, int *));


/* init.c */
Display *xvw_init_display   PROTO((kfunc_void));
Display *xvw_display        PROTO((xvobject));
XtAppContext xvw_appcontext PROTO((xvobject));
Screen *xvw_screen	    PROTO((xvobject));
int xvw_screennum	    PROTO((xvobject));
XFontStruct *xvw_font	    PROTO((xvobject));

/* menu.c */
int xvw_get_menuinfo     PROTO((xvobject, char *, kaddr));
int xvw_set_menuinfo     PROTO((xvobject, char *, kaddr));
void xvw_initinfo_menu   PROTO((kfunc_kaddr, kfunc_int, kfunc_int, kfunc_int));
void xvw_update_menu     PROTO((xvobject));
void xvw_activate_menu   PROTO((xvobject));
void xvw_inactivate_menu PROTO((xvobject));
int xvw_activated_menu   PROTO((xvobject));

/* process.c */
int xvw_fork       PROTO((char *, kfunc_void, kaddr));
int xvw_system     PROTO((char *));

/* resources.c */
void xvw_load_resources PROTO((char *));

/* signal.c */
int        xvw_check_process PROTO((int));
int        xvw_sleep         PROTO((double));
int        xvw_waitpid       PROTO((int, xvobject));

/* timeout.c */
void xvw_add_timeout      PROTO((xvobject, double, kfunc_void, kaddr));
void xvw_remove_timeout   PROTO((xvobject, kfunc_void, kaddr));
void xvw_destroy_timeouts PROTO((xvobject));

/* utilities.c */
void xvw_process_event   PROTO((void));
int  xvw_sync            PROTO((int));
int  xvw_get_chargeom     PROTO((xvobject, char *, kaddr));
int  xvw_set_chargeom     PROTO((xvobject, char *, kaddr));
int  xvw_clean_event_list PROTO((xvobject));
void xvw_add_toplevel    PROTO((xvobject));
void xvw_remove_toplevel PROTO((xvobject));


/* wmprotocol.c */
void xvw_add_protocol    PROTO((xvobject, char *, kfunc_void, kaddr));
void xvw_remove_protocol PROTO((xvobject, char *, kfunc_void, kaddr));

/* {widgetset}_utils.c */
Display *xvw_initialize          PROTO((kfunc_void));
void     xvw_change_list         PROTO((xvobject, char **, int, int));
int	 xvw_get_list_highlight	 PROTO((xvobject, char *, kaddr));
int	 xvw_set_list_highlight	 PROTO((xvobject, char *, kaddr));
int	 xvw_set_list_unhighlight PROTO((xvobject, char *, kaddr));
int	 xvw_get_pixmap_or_label PROTO((xvobject, char *, kaddr));
int	 xvw_set_pixmap_or_label PROTO((xvobject, char *, kaddr));
void	 xvw_update_list_struct	 PROTO((xvobject,char *, kaddr, int *,
					xvw_list_struct *));
void     xvw_reverse_colors      PROTO((xvobject, int));
xvobject xvw_retrieve_menu       PROTO((xvobject));
xvobject xvw_retrieve_list       PROTO((xvobject));

/* extent.c */
XPoint *xvw_getextent_polyline	 PROTO((xvobject, int, int *));
XPoint *xvw_getextent_freehand 	 PROTO((xvobject, int, int *));
int xvw_getextent_line		 PROTO((xvobject, int, int *, int *, int *,
					int *));
int xvw_getextent_circle	 PROTO((xvobject, int, int *, int *,
					unsigned int *));
int xvw_getextent_rectangle	 PROTO((xvobject, int, int *, int *,
					unsigned int *, unsigned int *));
int xvw_getextent_ellipse	 PROTO((xvobject, int, int *, int *,
					unsigned int *, unsigned int *));


/*
 *   Routines to control direct manipulation forms
 */
/* menuform.c */
void xvf_init_menuform PROTO((void));

/* chargeom.c */
int xvw_recompute_charfont PROTO((xvobject, int *, int *));

#endif /* _xvwidgets_xvwidgets_h_ */
/* Don't add after this point */
