 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for TextDisplay object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_TextDisplayP_h_
#define _xvobjects_TextDisplayP_h_


	/*-------------------------------------*
	|       #include
	---------------------------------------*/

#include <xvobjects/TextDisplay.h>
#include <xvobjects/ViewportP.h>


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef struct _XvwTextDisplayWidgetClassPart
{
    XtPointer  extension;
} XvwTextDisplayWidgetClassPart;

typedef struct _XvwTextDisplayWidgetClassRec
{
    CoreClassPart		  core_class;
    CompositeClassPart		  composite_class;
    ConstraintClassPart		  constraint_class;
    XvwManagerWidgetClassPart     manager_class;
    XvwViewportWidgetClassPart    viewport_class;
    XvwTextDisplayWidgetClassPart textdisplay_class;
} XvwTextDisplayWidgetClassRec;


typedef struct _XvwTextDisplayPart
{
    kfile	 *file;
    Dimension    indent;
    Boolean      roff;
    XFontStruct	 *ascii;
    XFontStruct	 *roman;
    XFontStruct	 *bold;
    XFontStruct	 *italic;
    XFontStruct	 *helvetica;
    XFontStruct	 *symbol;
    Pixel	 word_pixel;
    Pixel	 highlight_pixel;
    XtCallbackList textdisplay_callbacks;


    int   width;
    int   height;
    klist **text;
    int   numlines;
    int   maxwidth;
    int	  *words;
    int	  numwords;

    klist *hword;
    int   hword_index;

    GC    bold_gc;
    GC    ascii_gc;
    GC    roman_gc;
    GC    italic_gc;
    GC    helvetica_gc;
    GC    symbol_gc;
    xvobject notifywindow;
} XvwTextDisplayPart;


typedef struct _XvwTextDisplayWidgetRec
{
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    XvwManagerPart	manager;
    XvwViewportPart	viewport;
    XvwTextDisplayPart  textdisplay;
} XvwTextDisplayWidgetRec;

typedef struct {int empty;} XvwTextDisplayConstraintsPart;

typedef struct _XvwTextDisplayWidgetConstraintsRec
{
    XvwManagerConstraintsPart     manager;
    XvwViewportConstraintsPart    viewport;
    XvwTextDisplayConstraintsPart textdisplay;
} XvwTextDisplayWidgetConstraintsRec, *textDisplayConstraints;

typedef struct _XvwTextDisplayWidgetClassRec *XvwTextDisplayWidgetClass;
typedef struct _XvwTextDisplayWidgetRec      *XvwTextDisplayWidget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwTextDisplayWidget
 */
extern XvwTextDisplayWidgetClassRec xvwTextDisplayWidgetClassRec;


#endif /* _xvobjects_TextDisplayP_h_ */
/* Don't add after this point */
