 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private Include for Manager Widget
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_ManagerP_h_
#define _xvobjects_ManagerP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvobjects/Manager.h>


	/*-------------------------------------*
        |       #defines
        ---------------------------------------*/

#define XtInheritLayout		   ((void (*)())_XtInherit)
#define XtInheritChangeSel         ((void (*)())_XtInherit)
#define XtInheritEraseSel          ((void (*)())_XtInherit)
#define XtInheritRefreshSel        ((void (*)())_XtInherit)


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef struct _XvwManagerWidgetClassPart
{
   kfunc_void  layout;
   kfunc_void  change_selection;
   kfunc_void  erase_selection;
   kfunc_void  refresh_selection;

   XtWidgetProc      resize;
   XtGeometryHandler geometry_manager;
} XvwManagerWidgetClassPart;

typedef struct _XvwManagerWidgetClassRec
{
   CoreClassPart       core_class;
   CompositeClassPart  composite_class;
   ConstraintClassPart constraint_class;
   XvwManagerWidgetClassPart   manager_class;
} XvwManagerWidgetClassRec;

extern  XvwManagerWidgetClassRec xvwManagerWidgetClassRec;


typedef struct
{
   Position  horiz_offset;	/* desired horizontal offset		      */
   Position  vert_offset;	/* desired vertical offset		      */
   Dimension xsnap, ysnap;	/* x,y snap position of sub-objs	      */
   int       gridtype;		/* whether a background grid should be visual */
   int       gridsize;		/* size of the grid in which to snap objects  */
   Pixel     grid_pixel;	/* need the grid pixel color...        (sigh) */
   Pixel     foreground_pixel;  /* need the foreground pixel color...  (sigh) */
   Pixel     top_shadow;	/* need the top shadow pixel...        (sigh) */
   Pixel     bottom_shadow;	/* need the bottom shadow pixel...     (sigh) */
   GC        top_shadow_gc;	/* need the top shadow gc...           (sigh) */
   GC        bottom_shadow_gc;	/* need the bottom shadow gc...        (sigh) */
   Boolean   mapped;		/* need to indicate whether we are mapped     */
   Boolean   delayed_layout;	/* whether we should use a delayed layout     */

   Boolean allow_menuing;	/* allow to child to bring up menu  */
   Boolean allow_selecting;	/* allow to child to be grouped     */
   Boolean allow_resizing;	/* allow to child to be resized     */

   Pixmap      grid;
   Boolean     active, editing;
   XFontStruct *font;
   Cursor      cursor;
   XtCallbackList geometry_callback;
   XtCallbackList select_callback;

   /*
    * Resources for specifying minimum, maximum, and preferred width & height
    * of the manager.
    */
   Dimension   buffer_dist;
   Dimension   min_width, min_height;
   Dimension   max_width, max_height;
   Dimension   preferred_width, preferred_height;
   int	       numsels;
   Widget      *widgetsels;
   xvobject    *objectsels;

   Position  xpos, ypos;
   Dimension width, height;

   GC		  gc;
   Visual	  *visual;
   long		  layout_id;
   long		  raise_id;
   xvobject inputonly;		/* input object used for manipulation */
} XvwManagerPart;


typedef struct _XvwManagerWidgetRec
{
   CorePart		core;
   CompositePart	composite;
   ConstraintPart	constraint;
   XvwManagerPart	manager;
} XvwManagerWidgetRec;

typedef struct _XvwManagerConstraintsPart {
   
   Boolean allow_menuing;	/* allow to child to bring up menu  */
   Boolean allow_selecting;	/* allow to child to be grouped     */
   Boolean allow_resizing;	/* allow to child to be resized     */
   
   /*
    * Resources for specifying minimum, maximum, and preferred width & height
    * of an object
    */
   Dimension   min_width, min_height;
   Dimension   max_width, max_height;
   Dimension   preferred_width, preferred_height;

   int	   tacking;		/* flags for tacking		          */
   Widget  left_of;		/* widget to be left of (layout)          */
   Widget  right_of;		/* widget to be right of (layout)         */
   Widget  above;		/* widget to be above (layout)            */
   Widget  below;		/* widget to be below (layout)	          */
   Position horiz_offset;	/* default horizontal offset	          */
   Position vert_offset;	/* default vertical offset	          */

   Position old_x, old_y;       /* used during layout to save old x&y     */
   Dimension old_width, old_height; /* used during layout to save old w&h */
   Boolean layout_state;	/* the layout state		          */
   int     status;		/* layout status in order to avoid        */
   				/* constraint layout loops.	          */
   /*
    *  Resources which are used for translating, resizing, etc.
    */
   char     flags;		/* flags indicating constraints           */
   Position xoffset, yoffset;   /* x,y offset for translating, resizing   */

   /*
    *  Resources for doing grouping
    */
   xvobject *group;
   int	    group_size;
} XvwManagerConstraintsPart;

typedef struct _XvwManagerWidgetConstraintsRec {
   XvwManagerConstraintsPart manager;
} XvwManagerWidgetConstraintsRec, *XvwManagerWidgetConstraints;


typedef struct  _XvwManagerWidgetClassRec  *XvwManagerWidgetClass;
typedef struct  _XvwManagerWidgetRec       *XvwManagerWidget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwManagerWidget
 */
extern XvwManagerWidgetClassRec xvwManagerWidgetClassRec;


        /*-------------------------------------*
        |       macros
        ---------------------------------------*/
/*
 *  Miscelleanous defines for declaration comparisons
#define widgetequal(wid1, wid2)  (!kmemcmp(&wid1, &wid2,  sizeof(wid1)))
#define widgetdefined(wid)  (kmemcmp(&wid, &manager_undefined, sizeof(wid)))
 */
#define widgetequal(wid1, wid2)  ((kaddr) (wid1) == (kaddr) (wid2))
#define widgetdefined(wid)  !widgetequal(wid, KMANAGER_UNDEFINED)


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/* Manager.c */
void ManagerRequestLayout PROTO((Widget, int));

/* ManagerAct.c */
void ManagerRealizeObject    PROTO((WidgetClass, Widget));
int  ManagerCheckSelection   PROTO((xvobject, int, int));
int  ManagerCheckIfSelection PROTO((Widget, Widget));
void ManagerRefreshSelection PROTO((Widget, Widget));
void ManagerEraseSelection   PROTO((Widget, Widget));
void ManagerAddSelection     PROTO((Widget, Widget));
void ManagerDeleteSelection  PROTO((Widget, Widget));
void ManagerAddExtentSelections PROTO((Widget, int, int, int, int));
void ManagerCreateGrid	     PROTO((Widget));
int  ManagerSetSelect	     PROTO((xvobject, char *, kaddr));
int  ManagerGetSelect	     PROTO((xvobject, char *, kaddr));
int  ManagerSetGroup	     PROTO((xvobject, char *, kaddr));
void ManagerActionHandler    PROTO((xvobject, kaddr, XEvent *));
Boolean ManagerGeometry      PROTO((Widget, Position *, Position *, Dimension *,
				    Dimension *, Dimension *));
void ManagerPixelGeometry    PROTO((Widget, XtWidgetGeometry *,
				    XtWidgetGeometry *));
void ManagerWidgetHandler    PROTO((xvobject, kaddr, XEvent *));
void ManagerSelect           PROTO((XvwManagerWidget, int));
void ManagerSetWMColormap    PROTO((XvwManagerWidget));

#endif /* _xvobjects_ManagerP_h_ */
/* Do not add after this line */
