 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for Integer object
   >>>>
   >>>>    Written By: Mark Young and Danielle Argiro
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_IntegerP_h_
#define _xvobjects_IntegerP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvobjects/Integer.h>
#include <xvobjects/ManagerP.h>


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef struct _XvwIntegerWidgetClassPart
{
     XtPointer  extension;
} XvwIntegerWidgetClassPart;

typedef struct _XvwIntegerWidgetClassRec
{
   CoreClassPart		core_class;
   CompositeClassPart		composite_class;
   ConstraintClassPart		constraint_class;
   XvwManagerWidgetClassPart	manager_class;
   XvwIntegerWidgetClassPart	integer_class;
} XvwIntegerWidgetClassRec;

extern  XvwIntegerWidgetClassRec xvwIntegerWidgetClassRec;

typedef struct
{
   int	    value;
   int	    minvalue;
   int	    maxvalue;
   xvobject scrollbar;
   xvobject crlabel;
   xvobject label;
   xvobject text;
   XtCallbackList integer_callback;

} XvwIntegerPart;


typedef struct _XvwIntegerWidgetRec
{
  CorePart		core;
  CompositePart		composite;
  ConstraintPart	constraint;
  XvwManagerPart	manager;
  XvwIntegerPart	integerpart;

} XvwIntegerWidgetRec;

typedef struct {int empty;} XvwIntegerConstraintsPart;

typedef struct _XvwIntegerWidgetConstraintsRec {
    XvwManagerConstraintsPart	manager;
    XvwIntegerConstraintsPart	integerpart;
} XvwIntegerWidgetConstraintsRec, *XvwIntegerWidgetConstraints;

typedef struct  _XvwIntegerWidgetClassRec  *XvwIntegerWidgetClass;
typedef struct  _XvwIntegerWidgetRec       *XvwIntegerWidget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwIntegerWidget
 */
extern XvwIntegerWidgetClassRec xvwIntegerWidgetClassRec;


#endif /* _xvobjects_IntegerP_h_ */
/* Do not add after this line */
