 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of  InputFile Widget
   >>>>
   >>>>    Written By: Mark Young and Danielle Argiro
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_InputFile_h_
#define _xvobjects_InputFile_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	XVW_INPUTFILE_CRLABEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               pixmap object component of the the inputfile object that
|               indicates a "live" selection.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The pixmap object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INPUTFILE_CRLABEL_OBJECT "inputfileCrlabelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_INPUTFILE_BUTTON_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               button object component of the the inputfile object.
|
| Type:        	xvobject
| Default:	NULL
| Legal Values: The button object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INPUTFILE_BUTTON_OBJECT  "inputfileButtonObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_INPUTFILE_TEXT_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               text object component of the the inputfile object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The text object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INPUTFILE_TEXT_OBJECT    "inputfileTextObject"

/*------------------------------------------------------------------------
| Attribute:    XVW_INPUTFILE_BROWSER_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               browser object which is popped up when the user clicks
|		on the button of the inputfile object.
|
| Type:         xvobject 
| Default:      NULL 
| Legal Values: The browser object (read-only). 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INPUTFILE_BROWSER_OBJECT "inputfileBrowserObject"


/*------------------------------------------------------------------------
| Attribute:    XVW_INPUTFILE_FILENAME
|
| Description:  The filename which is currently displayed in the text object.  
|		This attribute can be used to initialize the filename to be 
|		displayed in the inputfile object, or to acquire the filename
|		that has been entered by the user in the text object.
|
| Type:         char *
| Default:      NULL
| Legal Values: any valid input file name
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INPUTFILE_FILENAME		"inputfileTextObject.textString"

/*------------------------------------------------------------------------
| Attribute:    XVW_INPUTFILE_LABEL
|
| Description:  This is the text that will appear in the label object
|               component of the inputfile object.  Provide text appropriate
|               as a title of the inputfile object.
|
| Type:         char *
| Default:      NULL 
| Legal Values: any printable text 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INPUTFILE_LABEL		"inputfileButtonObject.label"

/*------------------------------------------------------------------------
| Attribute:    XVW_INPUTFILE_DISPLAY_BUTTON
|
| Description:  This attribute controls whether the browser button should
|		be displayed (mapped) or not.  If not then the text object
|	        stretches the difference.
|
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	inputfileDisplayButton
------------------------------------------------------------------------*/
#define XVW_INPUTFILE_DISPLAY_BUTTON	"inputfileDisplayButton"

/*------------------------------------------------------------------------
| Attribute:	XVW_INPUTFILE_CALLBACK
|
| Description:  If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback on the inputfile object which will be fired when 
|		the user enters a new filename, either by typing it in and 
|		pressing <cr>, or by using the browser.  
|               When calling \fIxvw_add_callback()\fP, pass this attribute
|               directly, as in
|               .begin code
|               xvw_add_callback(inputfileobj, XVW_INPUTFILE_CALLBACK,
|                                inputfile_cb, client_data);
|               .end code
|		Note that the 
|		current filename of the input file object will be passed to the
|               callback in the \fIcall_data\fP.  The value must be cast
|               to a string before use, as in:
|               .br
|               \f(CWchar *filename = *((char **) call_data);\fP
|               .br
|               Alternatively, the filename may be obtained with
|               .symbol index XVW_INPUTFILE_FILENAME .
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|		.begin code
|		void callback_function
|		   xvobject object,
|		   kaddr client_data,
|		   kaddr call_data)
|		.end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INPUTFILE_CALLBACK		"inputfileCallback"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the InputFile Object by.
 */
#define InputFileWidgetClass	xvwInputFileWidgetClass


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration InputFileWidgetClass
 */
extern   WidgetClass     InputFileWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for InputFile Object
 */
xvobject xvw_create_inputfile PROTO((xvobject, char *));


#endif /* _xvobjects_InputFile_h_ */
/* Do not add after this line */
