 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of Info Object
   >>>>
   >>>>    Written By: Mark Young, Danielle Argiro
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_Info_h_
#define _xvobjects_Info_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	XVW_INFO_LABEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               label object component of the the info object (the
|               object used to display the label).
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The label object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INFO_LABEL_OBJECT   "infoLabelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_INFO_BUTTON_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               the button object component of the info object (the button
|               used to allow the user to acknowledge the message).
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The button object (read-only)
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INFO_BUTTON_OBJECT  "infoButtonObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_INFO_TEXT_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               the text object component of the info object (the text
|               displaying the message).
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The text object (read-only)
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INFO_TEXT_OBJECT    "infoTextObject"


/*------------------------------------------------------------------------
| Attribute:	XVW_INFO_MESSAGE
| Description:  The message to be displayed in the info object. 
| Type: 	char *         
| Default:      NULL 
| Legal Values: any printable text 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INFO_MESSAGE	"infoTextObject.textString"

/*------------------------------------------------------------------------
| Attribute:    XVW_INFO_LABEL
| Description:  The label to be displayed on the info object. 
| Type:         char * 
| Default:      "Info:" 
| Legal Values: any printable text 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INFO_LABEL		"infoLabelObject.label"

/*------------------------------------------------------------------------
| Attribute:    XVW_INFO_BUTTON_LABEL
| Description:  The label of the acknowledgement button on the info object 
| Type:         char * 
| Default:      "Ok" 
| Legal Values: any printable text 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INFO_BUTTON_LABEL	"infoButtonObject.label"

/*------------------------------------------------------------------------
| Attribute:	XVW_INFO_CALLBACK
|
| Description:  If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback on the info object which will be
|               fired when the user clicks on the acknowledgement button.
|               When calling \fIxvw_add_callback()\fP, pass this attribute
|               directly, as in
|               .begin code
|               xvw_add_callback(info_obj, XVW_INFO_CALLBACK,
|                                info_cb, client_data);
|               .end code
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|		.begin code
|		void callback_function
|		   xvobject object,
|		   kaddr client_data,
|		   kaddr call_data)
|		.end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INFO_CALLBACK	"infoCallback"

/*------------------------------------------------------------------------
| Attribute:    XVW_INFO_PIXMAPFILE
|
| Description:  This is the file defining the pixmap that appears at the
|               upper left of the info object.
|
| Type:         char *
| Default:      The info.xpm file in the \fIxvobjects/misc/pixmaps\fP 
|		directory, which defines the "nose knows" pixmap.
| Legal Values: The full path to a valid xpm or xbm file, defining
|               the desired pixmap.  Note that the path may contain
|               $TOOLBOX.
| Resource:     infoPixmapfile
------------------------------------------------------------------------*/
#define XVW_INFO_PIXMAPFILE	"infoPixmapfile"

/*------------------------------------------------------------------------
| Attribute:    XVW_INFO_PIXMAP
|
| Description:  This is the pixmap that appears to the upper
|               left of the info object.  Candidates for the value
|               of this attribute may be created with the use
|               of \fIXCreatePixmap()\fP;  see \fIThe Xlib Reference Manual\fP
|               by O'Reilly and Associates.  Note that this attribute is
|		mutually exclusive with
|		.symbol index XVW_INFO_PIXMAPFILE ;
|		specify one or the other, not both.
|
| Type:         Pixmap
| Default:      The "nose knows" pixmap.
| Legal Values: Valid Pixmap structure
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_INFO_PIXMAP		"infoPixmap"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Info Object by.
 */
#define InfoWidgetClass	xvwInfoWidgetClass


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration InfoWidgetClass
 */
extern   WidgetClass     InfoWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Info Object
 */
xvobject xvw_create_info PROTO((xvobject, char *));


#endif /* _xvobjects_Info_h_ */
/* Do not add after this line */
