 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for Help object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_HelpP_h_
#define _xvobjects_HelpP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvobjects/Help.h>
#include <xvobjects/ManagerP.h>


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef struct _XvwHelpWidgetClassPart
{
     XtPointer  extension;
} XvwHelpWidgetClassPart;

typedef struct _XvwHelpWidgetClassRec
{
   CoreClassPart		core_class;
   CompositeClassPart		composite_class;
   ConstraintClassPart		constraint_class;
   XvwManagerWidgetClassPart	manager_class;
   XvwHelpWidgetClassPart	help_class;
} XvwHelpWidgetClassRec;

extern  XvwHelpWidgetClassRec xvwHelpWidgetClassRec;

typedef struct
{
   Boolean  display_quit;
   Boolean  display_title;
   Boolean  display_menu;
   Boolean  destroy_on_quit;
   Boolean  do_hypertext;
   Boolean  more_files;

   xvobject menubutton;
   xvobject name;
   xvobject quit;
   xvobject title;
   xvobject textdisplay;
   xvobject next;
   xvobject previous;
   char	    *filename;
   char	    **filenames;
   int	    num;

   int	    current;
   int	    numhfiles;
   char	    **hfiles;
   XtCallbackList help_callback;

} XvwHelpPart;


typedef struct _XvwHelpWidgetRec
{
  CorePart		core;
  CompositePart		composite;
  ConstraintPart	constraint;
  XvwManagerPart	manager;
  XvwHelpPart		help;

} XvwHelpWidgetRec;

typedef struct {int empty;} XvwHelpConstraintsPart;

typedef struct _XvwHelpWidgetConstraintsRec {
    XvwManagerConstraintsPart	manager;
    XvwHelpConstraintsPart	help;
} XvwHelpWidgetConstraintsRec, *XvwHelpWidgetConstraints;

typedef struct  _XvwHelpWidgetClassRec  *XvwHelpWidgetClass;
typedef struct  _XvwHelpWidgetRec       *XvwHelpWidget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwHelpWidget
 */
extern XvwHelpWidgetClassRec xvwHelpWidgetClassRec;


#endif /* _xvobjects_HelpP_h_ */
/* Do not add after this line */
