 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of the Float Visual Object
   >>>>
   >>>>    Written By: Mark Young and Danielle Argiro
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_Float_h_
#define _xvobjects_Float_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	XVW_FLOAT_LABEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the 
|		label object component of the the float object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The label object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_FLOAT_LABEL_OBJECT		"floatLabelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_FLOAT_CRLABEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the 
|               pixmap object component of the the float object that
|		indicates a "live" selection.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The pixmap object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_FLOAT_CRLABEL_OBJECT	"floatCrlabelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_FLOAT_SCROLLBAR_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the 
|               scrollbar object component of the the float object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The scrollbar object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_FLOAT_SCROLLBAR_OBJECT	"floatScrollbarObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_FLOAT_TEXT_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the 
|               text object component of the the float object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The text object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_FLOAT_TEXT_OBJECT		"floatTextObject"


/*------------------------------------------------------------------------
| Attribute:    XVW_FLOAT_LABEL
|
| Description:  This is the text that will appear in the label object
|		component of the float object.  Provide text appropriate
|		as a title of the float object.
|
| Type:         char *
| Default:      NULL
| Legal Values: any printable text
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_FLOAT_LABEL		"floatLabelObject.label"

/*------------------------------------------------------------------------
| Attribute:	XVW_FLOAT_VALUE
|
| Description:  The float precision value which is currently displayed in
|		the text object.  This attribute can be used to initialize
|		the float value to be displayed in the text object, or to
|		acquire a float value that has been entered by the user in
|		the text object.
|
| Type:         float
| Default:      0.0
| Legal Values: any float value
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_FLOAT_VALUE		"floatValue"

/*------------------------------------------------------------------------
| Attribute:	XVW_FLOAT_MINVALUE
|
| Description:  The minimum float value allowed. If both
|		.symbol noindex XVW_FLOAT_MINVALUE
|		and
|		.symbol noindex XVW_FLOAT_MAXVALUE
|		are 0.0, the float value is unbounded.
|
| Type:         float
| Default:      0.0
| Legal Values: any float value
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_FLOAT_MINVALUE		"floatMinvalue"

/*------------------------------------------------------------------------
| Attribute:	XVW_FLOAT_MAXVALUE
|
| Description:  The maximum float value allowed. If both
|		.symbol noindex XVW_FLOAT_MINVALUE
|		and
|		.symbol noindex XVW_FLOAT_MAXVALUE
|		are 0.0, the float value is unbounded.
|
| Type:         float
| Default:      1.0
| Legal Values: any float value
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_FLOAT_MAXVALUE		"floatMaxvalue"

/*------------------------------------------------------------------------
| Attribute:	XVW_FLOAT_CALLBACK
|
| Description:  If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback may be installed on the float object which will 
|		be fired when the user enters a new float value, either by 
|		typing it in and pressing <cr>, or by using the scrollbar.  
|               When calling \fIxvw_add_callback()\fP, pass this attribute 
|		directly, as in
|               .begin code
|               xvw_add_callback(floatobj, XVW_FLOAT_CALLBACK,
|                                float_cb, client_data);
|               .end code
|		Note that the current floating
|		point value of the float object will be passed to the
|		callback in the \fIcall_data\fP.  The value must be cast 
|		to a float pointer before use, as in:
|		.br
|		\f(CWfloat *value = (float *) call_data;\fP
|		.br
|		Alternatively, the float value may be obtained with 
|		.symbol index XVW_FLOAT_VALUE .
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|		.begin code
|		void callback_function
|		   xvobject object,
|		   kaddr client_data,
|		   kaddr call_data)
|		.end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_FLOAT_CALLBACK		"floatCallback"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Float Object by.
 */
#define FloatWidgetClass	xvwFloatWidgetClass

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration FloatWidgetClass
 */
extern   WidgetClass     FloatWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Float Object
 */
xvobject xvw_create_float PROTO((xvobject, char *));


#endif /* _xvobjects_Float_h_ */
/* Do not add after this line */
